/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.Struct;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;

public class GetObjectTaggingRequestConsumer
extends ConsumerMap<GetObjectTaggingRequest.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static GetObjectTaggingRequestConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GetObjectTaggingRequestConsumer getInstance() {
        if (instance != null) return instance;
        Class<GetObjectTaggingRequestConsumer> clazz = GetObjectTaggingRequestConsumer.class;
        synchronized (GetObjectTaggingRequestConsumer.class) {
            instance = new GetObjectTaggingRequestConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private GetObjectTaggingRequestConsumer() {
        this.put("key", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"key");
            builder.key(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("versionId", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"versionId");
            builder.versionId(input);
        }, Collections.emptyList()));
    }

    public Struct getObjectTagging(GetObjectTaggingResponse response) {
        Struct struct = new Struct();
        struct.put((Object)"versionId", (Object)response.versionId());
        struct.put((Object)"tags", ((List)Optional.ofNullable(response.tagSet()).orElse(new LinkedList())).stream().map(tag -> {
            Struct tagStruct = new Struct();
            tagStruct.put((Object)"key", (Object)tag.key());
            tagStruct.put((Object)"value", (Object)tag.value());
            return tagStruct;
        }).collect(Collectors.toList()));
        return struct;
    }
}

