/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.request.SubscriptionMetadataRetryPolicyRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.CFBooleanValidator;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import java.util.Collections;

public enum SubscriptionMetadataRetryPolicyRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<SubscriptionMetadataRetryPolicyRequest> consumerMap = new ConsumerMap();

    private SubscriptionMetadataRetryPolicyRequestConsumer() {
        this.consumerMap.put((Object)"enable", new ConsumerValidator((retryPolicyRequest, value) -> retryPolicyRequest.setEnabled(this.cast.getBooleanProperty(value)), Collections.singletonList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"minimumBackoff", new ConsumerValidator((retryPolicyRequest, value) -> retryPolicyRequest.setMinimumBackoff(this.getDurationValue(value, "minimumBackoff")), Collections.emptyList()));
        this.consumerMap.put((Object)"maximumBackoff", new ConsumerValidator((retryPolicyRequest, value) -> retryPolicyRequest.setMaximumBackoff(this.getDurationValue(value, "maximumBackoff")), Collections.emptyList()));
    }

    private Duration getDurationValue(Object value, String fieldName) {
        String val = this.cast.getStringProperty(value);
        if (SubscriptionMetadataRetryPolicyRequestConsumer.isZeroDuration(val)) {
            return Durations.ZERO;
        }
        long seconds = this.cast.getDurationProperty(value, fieldName).getSeconds();
        PubSubServiceUtils.validateDurationRange(seconds, 0L, 600L, "minimumBackoff", (String)value, "0s", "10M");
        return Durations.fromSeconds((long)seconds);
    }

    private static boolean isZeroDuration(String val) {
        return val.equalsIgnoreCase("0m") || val.equalsIgnoreCase("0s") || val.equalsIgnoreCase("0M") || val.equalsIgnoreCase("0h") || val.equalsIgnoreCase("0d");
    }

    public ConsumerMap<SubscriptionMetadataRetryPolicyRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

