/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.consumer.ExecutorProviderRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.PublisherBatchingSettingsConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.RetrySettingsConsumer;
import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.request.ExecutorProviderRequest;
import coldfusion.cloud.gcp.pubsub.request.PublisherBatchingSettingsRequest;
import coldfusion.cloud.gcp.pubsub.request.PublisherSettingsRequest;
import coldfusion.cloud.gcp.pubsub.request.RetrySettingsRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.CFBooleanValidator;
import coldfusion.cloud.validator.CFNonNegativeLongValidator;
import coldfusion.cloud.validator.CFStructValidator;
import coldfusion.runtime.Closure;
import coldfusion.util.RB;
import java.util.Collections;

public enum PublisherSettingsRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<PublisherSettingsRequest> consumerMap = new ConsumerMap();

    private PublisherSettingsRequestConsumer() {
        this.consumerMap.put((Object)"endpoint", new ConsumerValidator((messageMetadataRequest, value) -> messageMetadataRequest.setEndpoint(this.cast.getStringProperty(value)), Collections.emptyList()));
        this.consumerMap.put((Object)"enableMessageOrdering", new ConsumerValidator((messageMetadataRequest, value) -> messageMetadataRequest.setEnableMessageOrdering(this.cast.getBooleanProperty(value)), Collections.singletonList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"enableCompression", new ConsumerValidator((messageMetadataRequest, value) -> messageMetadataRequest.setEnableCompression(this.cast.getBooleanProperty(value)), Collections.singletonList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"compressionBytesThreshold", new ConsumerValidator((messageMetadataRequest, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                messageMetadataRequest.setCompressionBytesThreshold(this.cast.getLongProperty(value));
            }
        }, Collections.singletonList(new CFNonNegativeLongValidator("compressionBytesThreshold"))));
        this.consumerMap.put((Object)"batchingSettings", new ConsumerValidator((messageMetadataRequest, value) -> {
            PublisherBatchingSettingsRequest batchingSettings = new PublisherBatchingSettingsRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)batchingSettings, this.cast.getMapProperty(value, "batchingSettings"), PublisherBatchingSettingsConsumer.INSTANCE.getConsumerMap());
            messageMetadataRequest.setBatchingSettings(batchingSettings);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"retrySettings", new ConsumerValidator((messageMetadataRequest, value) -> {
            RetrySettingsRequest retrySettings = new RetrySettingsRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)retrySettings, this.cast.getMapProperty(value, "retrySettings"), RetrySettingsConsumer.INSTANCE.getConsumerMap());
            messageMetadataRequest.setRetrySettings(retrySettings);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"executorProvider", new ConsumerValidator((messageMetadataRequest, value) -> {
            ExecutorProviderRequest executorProvider = new ExecutorProviderRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)executorProvider, this.cast.getMapProperty(value, "executorProvider"), ExecutorProviderRequestConsumer.INSTANCE.getConsumerMap());
            messageMetadataRequest.setExecutorProvider(executorProvider);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"messageTransformer", new ConsumerValidator((messageMetadataRequest, value) -> {
            if (value != null && !(value instanceof Closure)) {
                throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"PUBLISHER_MESSAGE_TRANSFORMER_MUST_BE_CLOSURE_TYPE", (Object)"messageTransformer"));
            }
            messageMetadataRequest.setMessageTransformer(this.cast.getClosureProperty(value));
        }, Collections.emptyList()));
    }

    public ConsumerMap<PublisherSettingsRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

