/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.request.MessageValidateRequest;
import coldfusion.cloud.gcp.validator.GCPResourceNameValidator;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.GenericEnumValidator;
import coldfusion.cloud.validator.NotNullValidator;
import com.google.pubsub.v1.Encoding;
import java.util.Arrays;
import java.util.Collections;

public enum MessageValidateRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<MessageValidateRequest> consumerMap = new ConsumerMap();

    private MessageValidateRequestConsumer() {
        this.consumerMap.put((Object)"schemaName", new ConsumerValidator((messageValidateRequest, value) -> messageValidateRequest.setSchemaId(this.cast.getStringProperty(value)), Arrays.asList(NotNullValidator.INSTANCE, GCPResourceNameValidator.SCHEMA)));
        this.consumerMap.put((Object)"schemaEncoding", new ConsumerValidator((messageValidateRequest, value) -> {
            String encoding = this.cast.getStringProperty(value);
            Encoding schemaEncoding = Encoding.valueOf((String)encoding.toUpperCase());
            messageValidateRequest.setSchemaEncoding(schemaEncoding);
        }, Arrays.asList(NotNullValidator.INSTANCE, new GenericEnumValidator(Encoding.class, "schemaEncoding"))));
        this.consumerMap.put((Object)"data", new ConsumerValidator((messageValidateRequest, value) -> messageValidateRequest.setData(value), Collections.singletonList(NotNullValidator.INSTANCE)));
    }

    public ConsumerMap<MessageValidateRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

