/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document.pdf;

import coldfusion.document.DocumentMargin;
import coldfusion.document.pdf.PdfBookmark;
import coldfusion.document.spi.Bookmark;
import coldfusion.document.spi.DocumentWriter;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;

public class PdfDocumentWriter
implements DocumentWriter {
    private PdfWriter writer;
    private FontMapper fontMapper;
    private PdfContentByte contentByte;

    public PdfDocumentWriter(PdfWriter writer, FontMapper fontMapper) {
        this.writer = writer;
        this.fontMapper = fontMapper;
        this.contentByte = writer.getDirectContent();
    }

    public PdfWriter getPdfWriter() {
        return this.writer;
    }

    @Override
    public void saveState() {
        this.contentByte.restoreState();
    }

    @Override
    public Graphics2D createGraphics(float pageWidth, float pageHeight, DocumentMargin margin) {
        return this.createGraphics(pageWidth, pageHeight, margin, true);
    }

    @Override
    public Graphics2D createGraphics(float pageWidth, float pageHeight, DocumentMargin margin, boolean externalLinksOn) {
        this.contentByte.saveState();
        return this.contentByte.createGraphics(pageWidth, pageHeight, (float)margin.getTop(), (float)margin.getBottom(), this.fontMapper, externalLinksOn);
    }

    @Override
    public Bookmark addBookmark(String name) {
        return this.addBookmark(name, null);
    }

    @Override
    public Bookmark addBookmark(String name, Bookmark parentBookmark) {
        PdfDestination destination = new PdfDestination(0);
        return this.addBookmark(name, destination, parentBookmark);
    }

    @Override
    public Bookmark addBookmark(String name, float left, float top) {
        return this.addBookmark(name, null, left, top);
    }

    @Override
    public Bookmark addBookmark(String name, Bookmark parentBookmark, float left, float top) {
        PdfDestination destination = new PdfDestination(0, left, top, 0.0f);
        return this.addBookmark(name, destination, parentBookmark);
    }

    private Bookmark addBookmark(String name, PdfDestination destination, Bookmark parentBookmark) {
        PdfOutline parentOutline = parentBookmark == null ? this.contentByte.getRootOutline() : ((PdfBookmark)parentBookmark).getPdfOutline();
        PdfOutline pdfOutline = new PdfOutline(parentOutline, destination, name);
        return new PdfBookmark(pdfOutline);
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

