/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.debugger.CFDebuggerUtils;
import coldfusion.debugger.ClientDebugSession;
import coldfusion.debugger.DebugEventHandler;
import coldfusion.debugger.JVMDebugThreadManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.List;

public class JVMDebugThread {
    private ThreadReference theThread = null;
    private Location lastLocation = null;
    private int lastStepRequest = -1;
    private ClientDebugSession session = null;
    private String threadName = null;
    private Location lastJavaLocation = null;
    private Object[] exceptionTraces = null;
    private String lastExceptionBPAt = null;
    private boolean processingBPException = false;
    private boolean processingBpOrStepEvent = false;

    public ClientDebugSession getSession() {
        return this.session;
    }

    public void setSession(ClientDebugSession session) {
        this.session = session;
        JVMDebugThreadManager.setSessionIdForThread(this.threadName, session == null ? null : session.getSessionId());
    }

    public JVMDebugThread(ThreadReference th) {
        this.theThread = th;
        this.threadName = th.name();
    }

    public Location getLastLocation() {
        return this.lastLocation;
    }

    public void setLastLocation(Location lastLocation) {
        this.lastLocation = lastLocation;
    }

    public int getLastStepRequest() {
        return this.lastStepRequest;
    }

    public void setLastStepRequest(int lastStepRequest) {
        this.lastStepRequest = lastStepRequest;
    }

    public void step(int depth) throws Throwable {
        this.step(depth, true);
    }

    public void step(int depth, boolean setLastStep) throws Throwable {
        this.step(-1, depth, setLastStep);
    }

    public void step(int size, int depth, boolean setLastStep) throws Throwable {
        if (this.theThread == null || !this.theThread.isSuspended()) {
            return;
        }
        this.clearPreviousStep();
        if (depth != 1 && depth != 3 && depth != 2) {
            return;
        }
        StepRequest sr = this.theThread.virtualMachine().eventRequestManager().createStepRequest(this.theThread, size, depth);
        sr.setSuspendPolicy(1);
        sr.enable();
        if (setLastStep) {
            this.setLastStepRequest(depth);
        }
        this.theThread.resume();
    }

    private void clearPreviousStep() {
        EventRequestManager mgr = this.theThread.virtualMachine().eventRequestManager();
        List<StepRequest> requests = mgr.stepRequests();
        for (StepRequest request : requests) {
            if (!request.thread().equals(this.theThread)) continue;
            mgr.deleteEventRequest(request);
            break;
        }
    }

    public ThreadReference getThreadReference() {
        return this.theThread;
    }

    public String getSessionId() throws Throwable {
        if (this.theThread == null) {
            return null;
        }
        return CFDebuggerUtils.getSessionId(this.theThread);
    }

    public void resumeExecution() throws Throwable {
        if (this.theThread != null) {
            this.clearPreviousStep();
            this.theThread.resume();
        }
    }

    public Object[] getJavaStackTrace() throws Throwable {
        return JVMDebugThread.getJavaStackTrace(this.theThread);
    }

    public static Object[] getJavaStackTrace(ThreadReference thr) throws Throwable {
        if (thr == null) {
            return null;
        }
        if (!thr.isSuspended() && !thr.isAtBreakpoint()) {
            return null;
        }
        StringBuffer sTrace = new StringBuffer();
        List<StackFrame> frames = thr.frames();
        ArrayList<String> strFrames = new ArrayList<String>();
        ArrayList<String> cfTrace = new ArrayList<String>();
        for (int i = 0; i < frames.size(); ++i) {
            StackFrame frame = frames.get(i);
            Location loc = frame.location();
            String pathLineNum = null;
            String sourcePath = null;
            try {
                sourcePath = loc.sourcePath().trim();
                if (DebugEventHandler.isCfmlFile(sourcePath)) {
                    int lineNum = DebugEventHandler.getLineNumberForLocation(loc);
                    if (lineNum < 1) {
                        lineNum = loc.lineNumber();
                    }
                    if (lineNum < 1) continue;
                    pathLineNum = sourcePath + ":" + lineNum;
                    cfTrace.add(pathLineNum);
                } else {
                    pathLineNum = sourcePath + ":" + loc.lineNumber();
                }
            }
            catch (AbsentInformationException aie) {
                strFrames.add("Unknown source - " + frame.toString());
            }
            strFrames.add(pathLineNum);
        }
        return new Object[]{strFrames, cfTrace};
    }

    public boolean isInCFParam() throws Throwable {
        if (this.theThread == null) {
            return false;
        }
        if (!this.theThread.isSuspended() && !this.theThread.isAtBreakpoint()) {
            return false;
        }
        List<StackFrame> frames = this.theThread.frames();
        for (int i = 0; i < frames.size(); ++i) {
            StackFrame frame = frames.get(i);
            Location loc = frame.location();
            if (!loc.sourcePath().endsWith("CfJspPage.java") || !loc.method().name().equals("checkSimpleParameter")) continue;
            return true;
        }
        return false;
    }

    public void setCFVariableValue(String varName, Object value) throws Throwable {
        CFDebuggerUtils.setCFVariableValue(this.theThread, varName, value);
    }

    public void onCFRequestEnd() {
        if (this.session != null) {
            this.session.onCFRequestEnd(this.threadName);
            this.session = null;
            JVMDebugThreadManager.setSessionIdForThread(this.threadName, null);
        }
        this.lastJavaLocation = null;
        this.lastLocation = null;
        this.exceptionTraces = null;
        this.lastExceptionBPAt = null;
        this.setProcessingBPException(false);
        this.setProcessingBpOrStepEvent(false);
    }

    public Location getLastJavaLocation() {
        return this.lastJavaLocation;
    }

    public void setLastJavaLocation(Location lastJavaLocation) {
        this.lastJavaLocation = lastJavaLocation;
    }

    public Object[] getExceptionTraces() {
        return this.exceptionTraces;
    }

    public void setExceptionTraces(Object[] exceptionTraces) {
        this.exceptionTraces = exceptionTraces;
        if (exceptionTraces != null && exceptionTraces.length > 1 && exceptionTraces[1] != null) {
            try {
                this.lastExceptionBPAt = (String)((ArrayList)exceptionTraces[1]).get(0);
            }
            catch (Throwable t) {
                this.lastExceptionBPAt = null;
            }
        }
    }

    public String getLastExcpetionBPTrace() {
        return this.lastExceptionBPAt;
    }

    public boolean isProcessingBPException() {
        return this.processingBPException;
    }

    public void setProcessingBPException(boolean processingBPException) {
        this.processingBPException = processingBPException;
    }

    public boolean isProcessingBpOrStepEvent() {
        return this.processingBpOrStepEvent;
    }

    public void setProcessingBpOrStepEvent(boolean processingBpOrStepEvent) {
        this.processingBpOrStepEvent = processingBpOrStepEvent;
    }
}

