/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

public class CFDebuggerExceptions {
    private static CFDebuggerExceptions debuggerExceptions = new CFDebuggerExceptions();

    public static void throwCFDebuggerAttachException(int portNum, Throwable rootException) throws CFDebuggerAttachException {
        String msg = "Could not attach to the VM at port " + portNum + "\n";
        msg = msg + "You must specify this debugger port in the JVM settings of your application server, for example:\n";
        msg = msg + "\t-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + portNum + "\n";
        msg = msg + "You will also need to make sure that another debugger is not currently connected to the CF JVM at the same port (" + portNum + ")\n\n";
        msg = msg + "Root cause -> \n" + rootException.getMessage();
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new CFDebuggerAttachException(msg);
    }

    public static void throwInvalidToolsJarVersionException() {
        String msg = "Could not attach to the VM. Version of tools.jar in lib folder does not match";
        msg = msg + " the version of JRE in which ColdFusion server is running.";
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new CFDebuggerAttachException(msg);
    }

    public static void throwToolsJarNotFoundException() {
        String msg = "Could not find tools.jar in the lib folder of ColdFusion.";
        msg = msg + " Ensure that the version of tools.jar matches";
        msg = msg + " the version of JRE in which ColdFusion server is running.";
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new CFDebuggerAttachException(msg);
    }

    public static void throwCFMLTemplateNotFound(String cfmlPath) throws CFMLTemplateNotFound {
        String msg = "CFML template " + cfmlPath + " could not be found.";
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new CFMLTemplateNotFound(msg);
    }

    public static void throwDebugSessionNotFound(String sessionId) throws DebugSessionNotFound {
        String msg = "Debug session " + sessionId + " could not be found.";
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new DebugSessionNotFound(msg);
    }

    public static void throwBreakPointSetFailedException(String cfmlPath, int lineNum) throws DebugSessionNotFound {
        String msg = "Error setting breakpoint at " + cfmlPath + ", line number " + lineNum;
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new BreakPointSetFailedException(msg, cfmlPath, lineNum);
    }

    public static void throwDebuggerThreadNotFoundException(String threadName) throws DebuggerThreadNotFoundException {
        String msg = "Debugger thread " + threadName + " not found.";
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new DebuggerThreadNotFoundException(msg, threadName);
    }

    public static void throwStepRequestFailedException() throws StepRequestFailedException {
        String msg = "Step command failed";
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new StepRequestFailedException(msg);
    }

    public static void throwThreadNotSuspendedException(String threadName) throws ThreadNotSuspendedException {
        String msg = "Thread " + threadName + " is not suspended for this operation";
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new ThreadNotSuspendedException(msg);
    }

    public static void throwThreadNotBelongToSessionException(String threadName, String sessionId) throws ThreadNotBelongToSessionException {
        String msg = "Thread " + threadName + " does not belong to session " + sessionId;
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new ThreadNotBelongToSessionException(msg);
    }

    public static void throwBreakpointSetByAnotherSessionException(String cfmlPath, int lineNum) throws BreakpointSetByAnotherSessionException {
        String msg = "Cannot set breakpoint at " + cfmlPath + ":" + lineNum + ". Another session has already set a breakpoint there.";
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new BreakpointSetByAnotherSessionException(msg);
    }

    public static void throwBreakpointInInterfaceException(String cfmlPath, int lineNum) throws BreakpointInInterfaceException {
        String msg = "Cannot set breakpoints in CF Interfaces";
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        throw cFDebuggerExceptions.new BreakpointInInterfaceException(msg);
    }

    public static void throwInvalidBreakpointLocationException(String path, int reqLine, int bpLine) throws InvalidBreakpointLocationException {
        throw CFDebuggerExceptions.createInvalidBreakpointLocationException(path, reqLine, bpLine);
    }

    public static InvalidBreakpointLocationException createInvalidBreakpointLocationException(String path, int reqLine, int bpLine) {
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        return cFDebuggerExceptions.new InvalidBreakpointLocationException(path, reqLine, bpLine);
    }

    public static void throwUnresolvedBreakpointLocationException(String path, int reqLine, int bpLine) throws UnresolvedBreakpointLocationException {
        throw CFDebuggerExceptions.createUnresolvedBreakpointLocationException(path, reqLine, bpLine);
    }

    public static UnresolvedBreakpointLocationException createUnresolvedBreakpointLocationException(String path, int reqLine, int bpLine) {
        CFDebuggerExceptions cFDebuggerExceptions = debuggerExceptions;
        cFDebuggerExceptions.getClass();
        return cFDebuggerExceptions.new UnresolvedBreakpointLocationException(path, reqLine, bpLine);
    }

    public static void throwBreakOnExceptionDisabledException() throws BreakOnExceptionDisabledException {
        throw debuggerExceptions.new BreakOnExceptionDisabledException();
    }

    public class BreakOnExceptionDisabledException
    extends CFDebuggerException {
        @Override
        public String getMessage() {
            return "Option 'Break on Exception' is globally disabled";
        }
    }

    public class SetBreakpointFailedException
    extends CFDebuggerException {
        String cfmlPath;
        int requestLineNum;
        int actualBPLineNum;

        public SetBreakpointFailedException(String path, int reqLine, int bpLine) {
            this.cfmlPath = null;
            this.requestLineNum = -1;
            this.actualBPLineNum = -1;
            this.cfmlPath = path;
            this.requestLineNum = reqLine;
            this.actualBPLineNum = bpLine;
        }

        public String getCfmlPath() {
            return this.cfmlPath;
        }

        public int getRequestedLineNum() {
            return this.requestLineNum;
        }

        public int getActualBPLineNumber() {
            return this.actualBPLineNum;
        }
    }

    public class UnresolvedBreakpointLocationException
    extends SetBreakpointFailedException {
        public UnresolvedBreakpointLocationException(String path, int reqLine, int bpLine) {
            super(path, reqLine, bpLine);
        }

        @Override
        public String getMessage() {
            return "Unable to resolve breakpoint at " + this.cfmlPath + ":" + this.requestLineNum;
        }
    }

    public class InvalidBreakpointLocationException
    extends SetBreakpointFailedException {
        public InvalidBreakpointLocationException(String path, int reqLine, int bpLine) {
            super(path, reqLine, bpLine);
        }

        @Override
        public String getMessage() {
            return "Error setting breakpoint at " + this.cfmlPath + ":" + this.requestLineNum;
        }
    }

    public class BreakpointInInterfaceException
    extends CFDebuggerException {
        public BreakpointInInterfaceException(String msg) {
            super(msg);
        }
    }

    public class BreakpointSetByAnotherSessionException
    extends CFDebuggerException {
        public BreakpointSetByAnotherSessionException(String msg) {
            super(msg);
        }
    }

    public class ThreadNotBelongToSessionException
    extends CFDebuggerException {
        public ThreadNotBelongToSessionException(String msg) {
            super(msg);
        }
    }

    public class ThreadNotSuspendedException
    extends CFDebuggerException {
        public ThreadNotSuspendedException(String msg) {
            super(msg);
        }
    }

    public class StepRequestFailedException
    extends CFDebuggerException {
        public StepRequestFailedException(String msg) {
            super(msg);
        }
    }

    public class DebuggerThreadNotFoundException
    extends CFDebuggerException {
        public String threadName;

        public DebuggerThreadNotFoundException(String msg, String threadName) {
            super(msg);
            this.threadName = null;
            this.threadName = threadName;
        }
    }

    public class BreakPointSetFailedException
    extends CFDebuggerException {
        public String cfmlPath;
        public int lineNumber;

        public BreakPointSetFailedException(String msg, String cfmlPath, int linenum) {
            super(msg);
            this.cfmlPath = cfmlPath;
            this.lineNumber = linenum;
        }
    }

    public class DebugSessionNotFound
    extends CFDebuggerException {
        public DebugSessionNotFound(String msg) {
            super(msg);
        }
    }

    public class CFMLTemplateNotFound
    extends CFDebuggerException {
        public CFMLTemplateNotFound(String msg) {
            super(msg);
        }
    }

    public class CFDebuggerAttachException
    extends CFDebuggerException {
        public CFDebuggerAttachException(String msg) {
            super(msg);
        }
    }

    public class CFDebuggerException
    extends RuntimeException {
        public CFDebuggerException() {
        }

        public CFDebuggerException(String msg) {
            super(msg);
        }
    }
}

