/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

public class UtilByteArray {
    public static byte[] allocate(int n2) {
        return UtilByteArray.allocate(n2, 0);
    }

    public static byte[] allocate(int n2, int n3) {
        if (n2 <= 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        UtilByteArray.fill(byArray, n3);
        return byArray;
    }

    public static byte[] duplicate(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static byte[] duplicate(byte[] byArray, int n2) {
        if (byArray == null || n2 < 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n2));
        return byArray2;
    }

    public static byte[] duplicate(byte[] byArray, int n2, int n3) {
        if (byArray == null || n2 < 0 || n3 < 0) {
            return null;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static void fill(byte[] byArray, int n2) {
        if (byArray == null) {
            return;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)n2;
        }
    }

    public static void fill(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return;
        }
        for (int i2 = n2; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)n3;
        }
    }

    public static void fill(byte[] byArray, int n2, int n3, int n4) {
        if (byArray == null) {
            return;
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            byArray[i2] = (byte)n4;
        }
    }

    public static void reverse(byte[] byArray) {
        int n2 = 0;
        int n3 = byArray.length - 1;
        while (n2 < byArray.length / 2) {
            byte by2 = byArray[n2];
            byArray[n2] = byArray[n3];
            byArray[n3] = by2;
            ++n2;
            --n3;
        }
    }
}

