/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.ssp;

import java.io.IOException;
import java.sql.SQLException;
import macromedia.sequelink.ssp.AsciiAttribute;
import macromedia.sequelink.ssp.BinaryAttribute;
import macromedia.sequelink.ssp.IntAttribute;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.sequelink.ssp.SspOutputStream;

abstract class Attribute {
    int id;
    int length;

    Attribute() {
    }

    abstract void encode(SspOutputStream var1) throws IOException;

    abstract void decode(SspInputStream var1) throws IOException;

    static final Attribute ReadAttribute(SspInputStream sspInputStream) throws IOException, SQLException {
        Attribute attribute;
        int n2 = sspInputStream.readSSPFullInt32();
        int n3 = sspInputStream.readSSPFullInt32();
        if (n3 == 0) {
            throw Message.Gen.getSqlException(7428);
        }
        switch (n2) {
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                if (n3 != 4) {
                    throw Message.Gen.getSqlException(7428);
                }
                attribute = new IntAttribute(n2, 0);
                attribute.decode(sspInputStream);
                break;
            }
            case 10: {
                if (n3 < 4) {
                    throw Message.Gen.getSqlException(7428);
                }
                attribute = new AsciiAttribute(n2, "");
                attribute.decode(sspInputStream);
                if (n3 == attribute.length) break;
                throw Message.Gen.getSqlException(7428);
            }
            case 12: {
                if (n3 < 4) {
                    throw Message.Gen.getSqlException(7428);
                }
                attribute = new BinaryAttribute(n2, new byte[0]);
                attribute.decode(sspInputStream);
                if (n3 == attribute.length) break;
                throw Message.Gen.getSqlException(7428);
            }
            default: {
                if (n3 < 0) {
                    throw Message.Gen.getSqlException(7428);
                }
                sspInputStream.skipBytes(n3);
                attribute = null;
            }
        }
        return attribute;
    }
}

