/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import macromedia.sequelink.net.IIOP;
import macromedia.sequelink.net.NetByteOrder;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.util.OutputStreamOnByteArray;

public final class IIOPOctetSequence {
    private static final byte[] ALIGNMENT = new byte[]{0};
    private byte[] octetSequence;
    private byte[] iiopOctetSequence;

    IIOPOctetSequence(byte[] byArray, boolean bl2) throws NetworkException {
        this.octetSequence = byArray;
        this.encodeOctetSequence(bl2);
    }

    IIOPOctetSequence(DataInputStream dataInputStream, boolean bl2) throws NetworkException {
        this.decodeOctetSequence(dataInputStream, bl2);
    }

    public byte[] getIIOPOctetSequence() {
        return this.iiopOctetSequence;
    }

    public byte[] getOctetSequence() {
        return this.octetSequence;
    }

    public static int getLengthIIOPOctetSequence(byte[] byArray) {
        return IIOPOctetSequence.lengthOctetSequence(byArray.length);
    }

    private static int alignmentLengthOctetSequence(int n2) {
        return (n2 / 4 + 1) * 4 - n2;
    }

    private static int lengthOctetSequence(int n2) {
        int n3 = 4;
        int n4 = n2;
        int n5 = IIOPOctetSequence.alignmentLengthOctetSequence(n2);
        return n3 + n4 + n5;
    }

    private void encodeOctetSequence(boolean bl2) throws NetworkException {
        int n2 = this.octetSequence.length;
        int n3 = NetByteOrder.htonl(n2, bl2);
        int n4 = IIOPOctetSequence.lengthOctetSequence(n2);
        int n5 = IIOPOctetSequence.alignmentLengthOctetSequence(n2);
        this.iiopOctetSequence = new byte[n4];
        OutputStreamOnByteArray outputStreamOnByteArray = new OutputStreamOnByteArray(this.iiopOctetSequence);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStreamOnByteArray);
        try {
            dataOutputStream.writeInt(n3);
            outputStreamOnByteArray.write(this.octetSequence, 0, n2);
            for (int i2 = 0; i2 < n5; ++i2) {
                outputStreamOnByteArray.write(ALIGNMENT, 0, 1);
            }
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }

    private void decodeOctetSequence(DataInputStream dataInputStream, boolean bl2) throws NetworkException {
        try {
            int n2 = dataInputStream.readInt();
            int n3 = NetByteOrder.htonl(n2, bl2);
            int n4 = IIOPOctetSequence.alignmentLengthOctetSequence(n3);
            this.octetSequence = new byte[n3];
            dataInputStream.readFully(this.octetSequence, 0, n3);
            dataInputStream.skipBytes(n4);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
    }
}

