/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss;

import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Pack;

final class OTSHashAddress
extends XMSSAddress {
    private static final int TYPE = 0;
    private final int otsAddress;
    private final int chainAddress;
    private final int hashAddress;

    private OTSHashAddress(Builder builder) {
        super(builder);
        this.otsAddress = builder.otsAddress;
        this.chainAddress = builder.chainAddress;
        this.hashAddress = builder.hashAddress;
    }

    @Override
    protected byte[] toByteArray() {
        byte[] byArray = super.toByteArray();
        Pack.intToBigEndian(this.otsAddress, byArray, 16);
        Pack.intToBigEndian(this.chainAddress, byArray, 20);
        Pack.intToBigEndian(this.hashAddress, byArray, 24);
        return byArray;
    }

    protected int getOTSAddress() {
        return this.otsAddress;
    }

    protected int getChainAddress() {
        return this.chainAddress;
    }

    protected int getHashAddress() {
        return this.hashAddress;
    }

    protected static class Builder
    extends XMSSAddress.Builder<Builder> {
        private int otsAddress = 0;
        private int chainAddress = 0;
        private int hashAddress = 0;

        protected Builder() {
            super(0);
        }

        protected Builder withOTSAddress(int n2) {
            this.otsAddress = n2;
            return this;
        }

        protected Builder withChainAddress(int n2) {
            this.chainAddress = n2;
            return this;
        }

        protected Builder withHashAddress(int n2) {
            this.hashAddress = n2;
            return this;
        }

        @Override
        protected XMSSAddress build() {
            return new OTSHashAddress(this);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

