/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.lms.Composer;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.lms.LMSSignature;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Encodable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.io.Streams;

public class HSSSignature
implements Encodable {
    private final int lMinus1;
    private final LMSSignedPubKey[] signedPubKey;
    private final LMSSignature signature;

    public HSSSignature(int n2, LMSSignedPubKey[] lMSSignedPubKeyArray, LMSSignature lMSSignature) {
        this.lMinus1 = n2;
        this.signedPubKey = lMSSignedPubKeyArray;
        this.signature = lMSSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSSignature getInstance(Object object, int n2) throws IOException {
        if (object instanceof HSSSignature) {
            return (HSSSignature)object;
        }
        if (object instanceof DataInputStream) {
            int n3 = ((DataInputStream)object).readInt();
            if (n3 != n2 - 1) {
                throw new IllegalStateException("nspk exceeded maxNspk");
            }
            LMSSignedPubKey[] lMSSignedPubKeyArray = new LMSSignedPubKey[n3];
            if (n3 != 0) {
                for (int i2 = 0; i2 < lMSSignedPubKeyArray.length; ++i2) {
                    lMSSignedPubKeyArray[i2] = new LMSSignedPubKey(LMSSignature.getInstance(object), LMSPublicKeyParameters.getInstance(object));
                }
            }
            LMSSignature lMSSignature = LMSSignature.getInstance(object);
            return new HSSSignature(n3, lMSSignedPubKeyArray, lMSSignature);
        }
        if (object instanceof byte[]) {
            try (InputStream inputStream = null;){
                inputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                HSSSignature hSSSignature = HSSSignature.getInstance(inputStream, n2);
                return hSSSignature;
            }
        }
        if (object instanceof InputStream) {
            return HSSSignature.getInstance(Streams.readAll((InputStream)object), n2);
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public int getlMinus1() {
        return this.lMinus1;
    }

    public LMSSignedPubKey[] getSignedPubKey() {
        return this.signedPubKey;
    }

    public LMSSignature getSignature() {
        return this.signature;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HSSSignature hSSSignature = (HSSSignature)object;
        if (this.lMinus1 != hSSSignature.lMinus1) {
            return false;
        }
        if (this.signedPubKey.length != hSSSignature.signedPubKey.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.signedPubKey.length; ++i2) {
            if (this.signedPubKey[i2].equals(hSSSignature.signedPubKey[i2])) continue;
            return false;
        }
        return this.signature != null ? this.signature.equals(hSSSignature.signature) : hSSSignature.signature == null;
    }

    public int hashCode() {
        int n2 = this.lMinus1;
        n2 = 31 * n2 + Arrays.hashCode(this.signedPubKey);
        n2 = 31 * n2 + (this.signature != null ? this.signature.hashCode() : 0);
        return n2;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        Composer composer = Composer.compose();
        composer.u32str(this.lMinus1);
        if (this.signedPubKey != null) {
            for (LMSSignedPubKey lMSSignedPubKey : this.signedPubKey) {
                composer.bytes(lMSSignedPubKey);
            }
        }
        composer.bytes(this.signature);
        return composer.build();
    }
}

