/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.paddings;

import java.security.SecureRandom;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.InvalidCipherTextException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.paddings.BlockCipherPadding;

public class X923Padding
implements BlockCipherPadding {
    SecureRandom random = null;

    @Override
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
        this.random = secureRandom;
    }

    @Override
    public String getPaddingName() {
        return "X9.23";
    }

    @Override
    public int addPadding(byte[] byArray, int n2) {
        byte by2 = (byte)(byArray.length - n2);
        while (n2 < byArray.length - 1) {
            byArray[n2] = this.random == null ? (byte)0 : (byte)this.random.nextInt();
            ++n2;
        }
        byArray[n2] = by2;
        return by2;
    }

    @Override
    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n2 = byArray[byArray.length - 1] & 0xFF;
        if (n2 > byArray.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n2;
    }
}

