/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.image;

import coldfusion.image.ExifMetaDataHelper;
import coldfusion.image.Image;
import coldfusion.image.core.ImageExceptions;
import coldfusion.log.CFLogs;
import coldfusion.util.IOUtils;
import coldfusion.util.RB;
import coldfusion.vfs.VFSFileFactory;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.w3c.dom.Node;

public class ImageWriter {
    private static final boolean isJVMSecurityEnabled;
    private static Permission[] tempFolderPermission;

    private static void writeJPegOrTiff(RenderedImage im, float quality, OutputStream outputStream, IIOMetadata imageMetadata, String format, Boolean isGrayScaleDone, boolean progressive) {
        block30: {
            ImageWriteParam iwparam = null;
            javax.imageio.ImageWriter writer = null;
            ImageInputStream ios = null;
            try {
                Iterator<javax.imageio.ImageWriter> writers;
                if (format.equals("jpg")) {
                    writers = ImageIO.getImageWritersByFormatName("jpeg");
                    while (writers.hasNext() && !(writer = writers.next()).getClass().getName().startsWith("com.sun.imageio")) {
                    }
                    iwparam = new JPEGImageWriteParam(Locale.getDefault());
                    iwparam.setCompressionMode(2);
                    if (progressive) {
                        iwparam.setProgressiveMode(1);
                    }
                    iwparam.setCompressionQuality(quality);
                    ((JPEGImageWriteParam)iwparam).setOptimizeHuffmanTables(true);
                } else if (format.equals("tiff")) {
                    writers = ImageIO.getImageWritersByFormatName("tiff");
                    while (writers.hasNext() && !(writer = writers.next()).getClass().getName().startsWith("com.sun.media.imageioimpl")) {
                    }
                    iwparam = new ImageWriteParam(Locale.getDefault());
                } else {
                    throw new ImageExceptions.ImageWritingException((Throwable)new Exception(), RB.getString((Object)new ImageWriter(), (String)"FormatNotSupportedForMetadata"));
                }
                if ((format.equals("tiff") || format.equals("tif")) && isGrayScaleDone != null && isGrayScaleDone.booleanValue()) {
                    try {
                        ImageWriter.writeImage(im, format, outputStream);
                        break block30;
                    }
                    catch (IOException x) {
                        throw new ImageExceptions.ImageWritingException((Throwable)x, RB.getString((Object)new ImageWriter(), (String)"ErrorCreatingDestinationFile"));
                    }
                }
                ios = ImageWriter.createImage(outputStream);
                if (ios == null || writer == null) {
                    throw new ImageExceptions.ImageWritingException(null, RB.getString((Object)new ImageWriter(), (String)"ErrorCreatingDestinationFile"));
                }
                writer.setOutput(ios);
                try {
                    writer.write(null, new IIOImage(im, null, imageMetadata), iwparam);
                }
                catch (Exception e) {
                    try {
                        ImageWriter.writeImage(im, format, outputStream);
                    }
                    catch (IOException x) {
                        throw new ImageExceptions.ImageWritingException((Throwable)x, RB.getString((Object)new ImageWriter(), (String)"ErrorCreatingDestinationFile"));
                    }
                }
                ios.flush();
                writer.dispose();
            }
            catch (Exception e) {
                throw new ImageExceptions.ImageWritingException((Throwable)e, RB.getString((Object)new ImageWriter(), (String)"CheckDestinationFile"));
            }
            finally {
                try {
                    if (ios != null) {
                        ios.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeImage(Image img, String formatName, String destination, float quality, String srcFormat, boolean progressive) throws ImageExceptions.ImageWritingException {
        BufferedImage im = img.getCurrentImage();
        ImageWriter.writeImage(im, img, formatName, destination, quality, srcFormat, progressive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IIOMetadata getImageMetadata(Image img, String extFormat) throws IOException {
        ImageReader reader = null;
        ImageInputStream fin = null;
        IIOMetadata imageMetadata = null;
        InputStream is = null;
        try {
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(extFormat);
            while (readers.hasNext()) {
                reader = readers.next();
                if (!extFormat.equals("jpg") || !reader.getClass().getName().startsWith("com.sun.imageio")) continue;
            }
            if (reader == null) {
                IIOMetadata iIOMetadata = null;
                return iIOMetadata;
            }
            is = img.getInputStreamFromSource(null);
            if (is != null) {
                fin = ImageIO.createImageInputStream(is);
            }
            if (fin == null) {
                IIOMetadata iIOMetadata = null;
                return iIOMetadata;
            }
            reader.setInput(fin);
            imageMetadata = reader.getImageMetadata(0);
            String format = "javax_imageio_1.0";
            Node n = imageMetadata.getAsTree(format);
            imageMetadata.setFromTree(format, n);
        }
        catch (Exception e) {
            imageMetadata = null;
        }
        finally {
            try {
                if (reader != null) {
                    reader.dispose();
                }
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error((Object)e.getMessage());
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error((Object)e.getMessage());
            }
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error((Object)e.getMessage());
            }
        }
        return imageMetadata;
    }

    public static void writeImage(RenderedImage im, Image img, String formatName, String destination, float quality, String srcFormat, boolean progressive) throws ImageExceptions.ImageWritingException {
        OutputStream os;
        block12: {
            if (!ImageIO.getImageWritersByFormatName(formatName).hasNext()) {
                throw new ImageExceptions.UnsupportedImageFormatException(formatName);
            }
            if (srcFormat == null) {
                srcFormat = formatName;
            }
            File out = VFSFileFactory.getFileObject((String)destination);
            os = null;
            try {
                IIOMetadata imageMetadata = null;
                boolean isExifSupportedSrcFormat = false;
                if (srcFormat.equals("jpeg") || srcFormat.equals("jpg")) {
                    isExifSupportedSrcFormat = true;
                    imageMetadata = ImageWriter.getImageMetadata(img, "jpg");
                } else if (srcFormat.equals("tiff") || srcFormat.equals("tif")) {
                    isExifSupportedSrcFormat = true;
                    imageMetadata = ImageWriter.getImageMetadata(img, "tiff");
                }
                TiffOutputSet srcOutputSet = null;
                if (isExifSupportedSrcFormat && ImageWriter.isExifFormat(formatName)) {
                    srcOutputSet = ExifMetaDataHelper.getOutputSet(img);
                }
                os = VFSFileFactory.getOutputStream((File)out);
                ImageWriter.writeImagetoStream(formatName, im, img, quality, os, imageMetadata, img.isGrayScaleDone, progressive);
                img.isGrayScaleDone = null;
                if (srcOutputSet == null) break block12;
                IOUtils.closeSilently((Closeable[])new Closeable[]{os});
                TiffOutputSet destOutputSet = ExifMetaDataHelper.getOutputSet(new Image(out.getAbsolutePath(), null));
                TiffOutputSet combinedOutputSet = null;
                if (destOutputSet == null) {
                    destOutputSet = new TiffOutputSet(srcOutputSet.byteOrder);
                }
                if (!(combinedOutputSet = ExifMetaDataHelper.appendMetadata(srcOutputSet, destOutputSet, formatName)).getDirectories().isEmpty()) {
                    ExifMetaDataHelper.copyExifMetadata(combinedOutputSet, out, formatName);
                }
            }
            catch (Exception e) {
                try {
                    throw new ImageExceptions.ImageWritingException((Throwable)e, RB.getString((Object)new ImageWriter(), (String)"CheckDestinationFile"));
                }
                catch (Throwable throwable) {
                    IOUtils.closeSilently((Closeable[])new Closeable[]{os});
                    throw throwable;
                }
            }
        }
        IOUtils.closeSilently((Closeable[])new Closeable[]{os});
    }

    private static boolean isExifFormat(String formatName) {
        return formatName.equals("jpeg") || formatName.equals("jpg") || formatName.equals("tiff") || formatName.equals("tif");
    }

    public static void writeImagetoStream(String formatName, Image img, float quality, OutputStream os, boolean progressive) throws IOException {
        if (img == null) {
            throw new ImageExceptions.ImageWritingException((Throwable)new NullPointerException(), RB.getString((Object)new ImageWriter(), (String)"NullSourceWhileWriting"));
        }
        BufferedImage im = img.getCurrentImage();
        if (im == null) {
            throw new ImageExceptions.ImageWritingException((Throwable)new NullPointerException(), RB.getString((Object)new ImageWriter(), (String)"NullSourceWhileWriting"));
        }
        if (formatName.equals("jpeg") || formatName.equals("jpg")) {
            IIOMetadata imageMetadata = ImageWriter.getImageMetadata(img, "jpg");
            ImageWriter.writeJPegOrTiff(im, quality, os, imageMetadata, "jpg", null, progressive);
        } else if (formatName.equals("tiff") || formatName.equals("tif")) {
            IIOMetadata imageMetadata = ImageWriter.getImageMetadata(img, "tiff");
            ImageWriter.writeJPegOrTiff(im, quality, os, imageMetadata, "tiff", img.isGrayScaleDone, progressive);
            img.isGrayScaleDone = null;
        } else if (formatName.equals("gif") || formatName.equals("png")) {
            BufferedImage bim = im;
            if (bim.getTransparency() != 1) {
                ImageWriter.setTransparencyInImage(bim);
            }
            ImageWriter.writeImage(bim, formatName, os);
        } else {
            ImageWriter.writeImage(im, formatName, os);
        }
    }

    public static void writeImagetoStream(String formatName, RenderedImage im, Image img, float quality, OutputStream os, IIOMetadata imageMetadata, Boolean isGrayScaleDone, boolean progressive) throws IOException {
        if (im == null) {
            throw new ImageExceptions.ImageWritingException((Throwable)new NullPointerException(), RB.getString((Object)new ImageWriter(), (String)"NullSourceWhileWriting"));
        }
        if (formatName.equals("jpeg") || formatName.equals("jpg")) {
            ImageWriter.writeJPegOrTiff(im, quality, os, imageMetadata, "jpg", null, progressive);
        } else if (formatName.equals("tiff") || formatName.equals("tif")) {
            ImageWriter.writeJPegOrTiff(im, quality, os, imageMetadata, "tiff", isGrayScaleDone, progressive);
        } else if (formatName.equals("gif")) {
            BufferedImage bim = (BufferedImage)im;
            if (bim.getTransparency() != 1) {
                ImageWriter.setTransparencyInImage(bim);
            }
            ImageWriter.writeImage(bim, formatName, os);
        } else {
            ImageWriter.writeImage(im, formatName, os);
        }
    }

    private static void writeImage(final RenderedImage im, final String formatName, final OutputStream os) throws IOException {
        if (isJVMSecurityEnabled) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        ImageIO.write(im, formatName, os);
                        return null;
                    }
                }, null, tempFolderPermission);
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof IOException) {
                    throw (IOException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        } else {
            ImageIO.write(im, formatName, os);
        }
    }

    private static ImageOutputStream createImage(final OutputStream os) throws IOException {
        if (isJVMSecurityEnabled) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ImageOutputStream>(){

                    @Override
                    public ImageOutputStream run() throws Exception {
                        return ImageIO.createImageOutputStream(os);
                    }
                }, null, tempFolderPermission);
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof IOException) {
                    throw (IOException)e.getException();
                }
                throw new RuntimeException(e.getException());
            }
        }
        return ImageIO.createImageOutputStream(os);
    }

    private static void setTransparencyInImage(BufferedImage scaledBI) {
        for (int x = 0; x < scaledBI.getWidth(); ++x) {
            for (int y = 0; y < scaledBI.getHeight(); ++y) {
                int rgb = scaledBI.getRGB(x, y);
                int alpha = rgb >> 24 & 0xFF;
                if (alpha == 255) continue;
                scaledBI.setRGB(x, y, -1);
            }
        }
    }

    public static String getWritableFormats() {
        Object[] writeFormats = ImageIO.getWriterFormatNames();
        Arrays.sort(writeFormats);
        String temp = "";
        for (int i = 0; i < writeFormats.length; ++i) {
            if (temp.indexOf(((String)writeFormats[i]).toUpperCase()) != -1) continue;
            temp = temp + ((String)writeFormats[i]).toUpperCase() + ",";
        }
        return temp.substring(0, temp.length() - 1);
    }

    public static String getWritableFormatsForOSX() {
        return "BMP,JPEG,PNG,PNM";
    }

    static {
        boolean bl = isJVMSecurityEnabled = System.getSecurityManager() != null;
        if (isJVMSecurityEnabled) {
            String tmpDir = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.io.tmpdir");
                }
            });
            tempFolderPermission = new Permission[]{new FilePermission(tmpDir + "-", "read,write,delete")};
        } else {
            tempFolderPermission = null;
        }
    }
}

