/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.utils;

import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.gcp.validator.GCPResourceNameValidator;
import coldfusion.util.RB;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.SchemaName;
import com.google.pubsub.v1.SnapshotName;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.TopicName;

public class PubSubResourceNameTransformer {
    private final String projectId;

    public PubSubResourceNameTransformer(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return ProjectName.of((String)this.projectId).toString();
    }

    public String getTopicName(String topicId) {
        if (PubSubServiceUtils.isNullOrEmpty(topicId)) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"TOPIC_NULL_EMPTY"));
        }
        GCPResourceNameValidator.TOPIC.validate((Object)topicId);
        return ResourceNameResolver.TOPICS.getFQRN(this.projectId, topicId);
    }

    public String getSubscriptionName(String subscriptionId) {
        if (PubSubServiceUtils.isNullOrEmpty(subscriptionId)) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SUBSCRIPTION_NULL_EMPTY"));
        }
        GCPResourceNameValidator.SUBSCRIPTION.validate((Object)subscriptionId);
        return ResourceNameResolver.SUBSCRIPTIONS.getFQRN(this.projectId, subscriptionId);
    }

    public String getSnapshotName(String snapshotId) {
        if (PubSubServiceUtils.isNullOrEmpty(snapshotId)) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SNAPSHOT_NULL_EMPTY"));
        }
        GCPResourceNameValidator.SNAPSHOT.validate((Object)snapshotId);
        return ResourceNameResolver.SNAPSHOTS.getFQRN(this.projectId, snapshotId);
    }

    public String getSchemaName(String schemaId) {
        if (PubSubServiceUtils.isNullOrEmpty(schemaId)) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"SCHEMA_NULL_EMPTY"));
        }
        GCPResourceNameValidator.SCHEMA.validate((Object)schemaId);
        return ResourceNameResolver.SCHEMAS.getFQRN(this.projectId, schemaId);
    }

    private static enum ResourceNameResolver {
        TOPICS("topics"),
        SUBSCRIPTIONS("subscriptions"),
        SNAPSHOTS("snapshots"),
        SCHEMAS("schemas");

        private String resourceType;

        private ResourceNameResolver(String resourceType) {
            this.resourceType = resourceType;
        }

        public String getFQRN(String projectId, String resourceName) {
            if (resourceName.contains("projects/") && resourceName.contains(this.resourceType)) {
                return resourceName;
            }
            switch (ResourceNameResolver.valueOf(this.resourceType.toUpperCase())) {
                case TOPICS: {
                    return TopicName.of((String)projectId, (String)resourceName.trim()).toString();
                }
                case SUBSCRIPTIONS: {
                    return SubscriptionName.of((String)projectId, (String)resourceName.trim()).toString();
                }
                case SNAPSHOTS: {
                    return SnapshotName.of((String)projectId, (String)resourceName.trim()).toString();
                }
                case SCHEMAS: {
                    return SchemaName.of((String)projectId, (String)resourceName.trim()).toString();
                }
            }
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"RESOURCE_NAME_RESOLUTION_FAILED", (Object)resourceName));
        }
    }
}

