/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.pmt.utils;

import coldfusion.cloud.gcp.pubsub.pmt.utils.PubSubApis;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.util.RB;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PMTUtilsForGCPPubSub {
    private static Logger logger = CFLogs.SERVER_LOG;

    public static TagAttributeList startGCPPubSubMonitoring(PubSubApis name, TagAttributeList tagAttributeList) {
        RequestMonitorData rmd = RequestMonitorData.getCurrent();
        if (rmd != null && rmd.doMonitor()) {
            RequestMonitorEventProcessor.onFunctionStart((String)name.name(), null, (boolean)true);
            TagAttributeList temp = TagAttributeList.getInstance((TagAttributeList)tagAttributeList);
            return temp;
        }
        return null;
    }

    public static void endGCPPubSubMonitoring(PubSubApis name, TagAttributeList tempAttributeList, Map responseMap) {
        if (tempAttributeList == null) {
            return;
        }
        if (responseMap != null) {
            PMTUtilsForGCPPubSub.updateTagAttributeList(name, tempAttributeList, responseMap);
        }
        RequestMonitorEventProcessor.onFunctionEnd((String)name.name(), null, (List)TagAttributeList.getInstance((TagAttributeList)tempAttributeList).getTagAttributes(), (boolean)true);
    }

    private static void updateTagAttributeList(PubSubApis name, TagAttributeList tempAttributeList, Map responseMap) {
        try {
            if (!Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isCloudServiceMetrics() && !Configuration.INSTANCE.getMonitorSettings().getAdvancedMonitoring().isQueryMetrics()) {
                return;
            }
            if (responseMap.get("action") != null) {
                tempAttributeList.addTagAttribute("action", responseMap.get("action"));
            }
            if (responseMap.get("status_code") != null) {
                tempAttributeList.addTagAttribute("status_code", responseMap.get("status_code"));
            }
            if (responseMap.get("topic") != null) {
                tempAttributeList.addTagAttribute("topic", responseMap.get("topic"));
            }
            if (responseMap.get("subscription") != null) {
                tempAttributeList.addTagAttribute("subscription", responseMap.get("subscription"));
            }
            if (responseMap.get("snapshot") != null) {
                tempAttributeList.addTagAttribute("snapshot", responseMap.get("snapshot"));
            }
        }
        catch (Exception e) {
            logger.info((Object)RB.getString(PMTUtilsForGCPPubSub.class, (String)"Util.PmtMonitoringError"));
        }
    }

    public static Map<String, String> getMonitoringResponseMap(String action, String statusCode) {
        HashMap<String, String> responseMap = new HashMap<String, String>();
        if (action != null) {
            responseMap.put("action", action);
        }
        if (statusCode != null) {
            responseMap.put("status_code", statusCode);
        }
        return responseMap;
    }
}

