/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.consumer.AbstractGCPServiceConfigConsumer;
import coldfusion.cloud.gcp.pubsub.config.PubSubClientServiceConfig;
import coldfusion.cloud.gcp.pubsub.consumer.PublisherSettingsRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.SubscriberSettingsRequestConsumer;
import coldfusion.cloud.gcp.pubsub.exception.MinMaxRangeException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.request.PublisherSettingsRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriberSettingsRequest;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.util.RB;
import java.time.Duration;
import java.util.Collections;

public class PubSubClientServiceConfigConsumer
extends AbstractGCPServiceConfigConsumer<PubSubClientServiceConfig> {
    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public PubSubClientServiceConfigConsumer() {
        this.put("publisherSettings", new ConsumerValidator((pubsubClientServiceConfig, value) -> {
            PublisherSettingsRequest publisherSettings = new PublisherSettingsRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)publisherSettings, this.cast.getMapProperty(value, "publisherSettings"), PublisherSettingsRequestConsumer.INSTANCE.getConsumerMap());
            pubsubClientServiceConfig.setPublisherSettings(publisherSettings);
        }, Collections.emptyList()));
        this.put("subscriberSettings", new ConsumerValidator((pubsubClientServiceConfig, value) -> {
            SubscriberSettingsRequest subscriberSettings = new SubscriberSettingsRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)subscriberSettings, this.cast.getMapProperty(value, "subscriberSettings"), SubscriberSettingsRequestConsumer.INSTANCE.getConsumerMap());
            Duration minDurationPerAckExtensionPeriod = subscriberSettings.getMinDurationPerAckExtensionPeriod();
            Duration maxDurationPerAckExtensionPeriod = subscriberSettings.getMaxDurationPerAckExtensionPeriod();
            Duration maxAckExtensionPeriod = subscriberSettings.getMaxAckExtensionPeriod();
            if (minDurationPerAckExtensionPeriod != null && maxDurationPerAckExtensionPeriod != null && maxDurationPerAckExtensionPeriod.getSeconds() < minDurationPerAckExtensionPeriod.getSeconds()) {
                throw new MinMaxRangeException(RB.getString(PubSubClientImpl.class, (String)"MIN_MAX_VALIDATION_ERROR", (Object)"maxDurationPerAckExtensionPeriod", (Object)"minDurationPerAckExtensionPeriod"));
            }
            if (maxAckExtensionPeriod != null && maxDurationPerAckExtensionPeriod != null && maxAckExtensionPeriod.getSeconds() < maxDurationPerAckExtensionPeriod.getSeconds()) {
                throw new MinMaxRangeException(RB.getString(PubSubClientImpl.class, (String)"MIN_MAX_VALIDATION_ERROR", (Object)"maxAckExtensionPeriod", (Object)"maxDurationPerAckExtensionPeriod"));
            }
            pubsubClientServiceConfig.setSubscriberSettings(subscriberSettings);
        }, Collections.emptyList()));
    }
}

