/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.search;

import coldfusion.log.CFLogs;
import coldfusion.util.RB;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;

public class MSDocument {
    static char dirSep = System.getProperty("file.separator").charAt(0);
    private static final String SUBJECT = "Subject";
    private static final String KEYWORDS = "Keywords";

    public static String uid(File f) {
        return f.getPath().replace(dirSep, '\u0000') + "\u0000" + DateTools.timeToString((long)f.lastModified(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
    }

    public static String uid2url(String uid) {
        String url = uid.replace('\u0000', '/');
        return url.substring(0, url.lastIndexOf(47));
    }

    public static Document getDocument(File f, String url) throws IOException, InterruptedException {
        Document doc = new Document();
        FieldType ft = new FieldType(StringField.TYPE_STORED);
        ft.setOmitNorms(false);
        Field field = new Field("url", url, ft);
        doc.add((IndexableField)field);
        field = new StoredField("key", f.getPath());
        doc.add((IndexableField)field);
        String dt = DateTools.timeToString((long)f.lastModified(), (DateTools.Resolution)DateTools.Resolution.MINUTE);
        doc.add((IndexableField)new Field("modified", dt, ft));
        doc.add((IndexableField)new Field("uid", MSDocument.uid(f), ft));
        String contents = "";
        if (f.getPath().endsWith(".doc") || f.getPath().endsWith(".rtf")) {
            contents = MSDocument.readDoc(f).get("content");
        } else if (f.getPath().endsWith(".ppt")) {
            contents = MSDocument.readPPT(f).get("content");
        } else if (f.getPath().endsWith(".xls")) {
            contents = MSDocument.readXLS(f).get("content");
        }
        doc.add((IndexableField)new Field("contents", contents, TextField.TYPE_STORED));
        String summary = contents.substring(0, Math.min(100, contents.length()));
        doc.add((IndexableField)new Field("summary", summary, ft));
        doc.add((IndexableField)new Field("title", f.getName(), ft));
        return doc;
    }

    public static Map<String, String> readDocx(File docfile) {
        String content = "";
        String author = "";
        String mime = "";
        String title = "";
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            XWPFWordExtractor extractor = new XWPFWordExtractor(OPCPackage.open((InputStream)new FileInputStream(docfile)));
            content = extractor.getText();
            author = extractor.getCoreProperties().getCreator();
            title = extractor.getCoreProperties().getTitle();
            String subject = extractor.getCoreProperties().getSubject();
            String keywords = "";
            metadata.put(SUBJECT, subject != null ? subject : "");
            metadata.put(KEYWORDS, keywords != null ? keywords : "");
            metadata.put("content", content);
            metadata.put("author", author != null ? author : "");
            metadata.put("mime", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            metadata.put("title", title != null ? title : "");
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.warn((Object)RB.getString((Object)new MSDocument(), (String)"Search.LucenePDFDocumentWarn", (Object)docfile.getAbsolutePath(), (Object)e.getMessage()));
        }
        return metadata;
    }

    public static Map<String, String> readPPTX(File pptfile) {
        String content = "";
        String author = "";
        String mime = "";
        String title = "";
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            XSLFPowerPointExtractor extractor = new XSLFPowerPointExtractor(OPCPackage.open((InputStream)new FileInputStream(pptfile)));
            content = extractor.getText();
            author = extractor.getCoreProperties().getCreator();
            title = extractor.getCoreProperties().getTitle();
            String subject = extractor.getCoreProperties().getSubject();
            String keywords = "";
            metadata.put(SUBJECT, subject != null ? subject : "");
            metadata.put(KEYWORDS, keywords != null ? keywords : "");
            metadata.put("content", content);
            metadata.put("author", author != null ? author : "");
            metadata.put("mime", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
            metadata.put("title", title != null ? title : "");
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.warn((Object)RB.getString((Object)new MSDocument(), (String)"Search.LucenePDFDocumentWarn", (Object)pptfile.getAbsolutePath(), (Object)e.getMessage()));
        }
        return metadata;
    }

    public static Map<String, String> readXLSX(File xlsxfile) {
        String content = "";
        String author = "";
        String mime = "";
        String title = "";
        String subject = "";
        String keywords = "";
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            XSSFExcelExtractor extractor = new XSSFExcelExtractor(OPCPackage.open((InputStream)new FileInputStream(xlsxfile)));
            content = extractor.getText();
            author = extractor.getCoreProperties().getCreator();
            title = extractor.getCoreProperties().getTitle();
            subject = extractor.getCoreProperties().getSubject();
            keywords = "";
            metadata.put(SUBJECT, subject != null ? subject : "");
            metadata.put(KEYWORDS, keywords != null ? keywords : "");
            metadata.put("content", content);
            metadata.put("author", author != null ? author : "");
            metadata.put("mime", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            metadata.put("title", title != null ? title : "");
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.warn((Object)RB.getString((Object)new MSDocument(), (String)"Search.LucenePDFDocumentWarn", (Object)xlsxfile.getAbsolutePath(), (Object)e.getMessage()));
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readDoc(File docfile) {
        String content = "";
        String author = "";
        String mime = "";
        String title = "";
        String subject = "";
        String keywords = "";
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            WordExtractor extractor = new WordExtractor((InputStream)new FileInputStream(docfile));
            content = extractor.getText();
            author = extractor.getSummaryInformation().getAuthor();
            title = extractor.getSummaryInformation().getTitle();
            subject = extractor.getSummaryInformation().getSubject();
            keywords = extractor.getSummaryInformation().getKeywords();
            metadata.put(SUBJECT, subject != null ? subject : "");
            metadata.put(KEYWORDS, keywords != null ? keywords : "");
            metadata.put("content", content);
            metadata.put("author", author != null ? author : "");
            metadata.put("mime", "application/msword");
            metadata.put("title", title != null ? title : "");
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.warn((Object)RB.getString((Object)new MSDocument(), (String)"Search.LucenePDFDocumentWarn", (Object)docfile.getAbsolutePath(), (Object)e.getMessage()));
        }
        finally {
            return metadata;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readXLS(File xlsfile) {
        String content = "";
        String author = "";
        String mime = "";
        String title = "";
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            FileInputStream inp = new FileInputStream(xlsfile);
            ExcelExtractor extractor = new ExcelExtractor(new POIFSFileSystem((InputStream)inp));
            content = extractor.getText();
            author = extractor.getSummaryInformation().getAuthor();
            title = extractor.getSummaryInformation().getTitle();
            String subject = extractor.getSummaryInformation().getSubject();
            String keywords = extractor.getSummaryInformation().getKeywords();
            metadata.put(SUBJECT, subject != null ? subject : "");
            metadata.put(KEYWORDS, keywords != null ? keywords : "");
            metadata.put("content", content);
            metadata.put("author", author != null ? author : "");
            metadata.put("mime", "application/vnd.ms-excel");
            metadata.put("title", title != null ? title : "");
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.warn((Object)RB.getString((Object)new MSDocument(), (String)"Search.LucenePDFDocumentWarn", (Object)xlsfile.getAbsolutePath(), (Object)e.getMessage()));
        }
        finally {
            return metadata;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readPPT(File pptfile) {
        String content = "";
        String author = "";
        String mime = "";
        String title = "";
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            PowerPointExtractor extractor = new PowerPointExtractor((InputStream)new FileInputStream(pptfile));
            content = extractor.getText();
            author = extractor.getSummaryInformation().getAuthor();
            title = extractor.getSummaryInformation().getTitle();
            String subject = extractor.getSummaryInformation().getSubject();
            String keywords = extractor.getSummaryInformation().getKeywords();
            metadata.put(SUBJECT, subject != null ? subject : "");
            metadata.put(KEYWORDS, keywords != null ? keywords : "");
            metadata.put("content", content);
            metadata.put("author", author != null ? author : "");
            metadata.put("mime", "application/vnd.ms-powerpoint");
            metadata.put("title", title != null ? title : "");
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.warn((Object)RB.getString((Object)new MSDocument(), (String)"Search.LucenePDFDocumentWarn", (Object)pptfile.getAbsolutePath(), (Object)e.getMessage()));
        }
        finally {
            return metadata;
        }
    }
}

