/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.search;

import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.lucene.SolrServiceImpl;
import coldfusion.runtime.QueryVector;
import coldfusion.runtime.SearchEngineException;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SolrService;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.search.CollectionDoesNotExistException;
import coldfusion.tagext.search.ExtensionMatcher;
import coldfusion.tagext.search.HTMLParser;
import coldfusion.tagext.search.SolrUtils;
import coldfusion.tagext.search.Utils;
import coldfusion.tagext.validation.IllegalAttributeValueException;
import coldfusion.vfs.VFSFileFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;

public class IndexTag
extends GenericTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfindex");
    private String collection = null;
    private String action = null;
    private String type = null;
    private String title = "";
    private String key = "";
    private String body = null;
    private String urlpath = "";
    private String category = "";
    private String categoryTree = "";
    private String extensions = ".htm, .html, .cfm, .cfml, .dbm, .dbml";
    private String query = null;
    private String criteria = null;
    private String prefix = null;
    private boolean recurse = false;
    private String language = null;
    private String collectionnames = null;
    private String fieldboost = null;
    private String docboost = null;
    private String status = null;
    private Struct status_struct = null;
    private boolean autocommit = true;
    private boolean throwonerror = false;
    private static final long TEN_SECONDS = 10000L;
    private static final String DISK_MODE = "disk";
    private static final String MEMORY_MODE = "memory";
    private static final String DOCUMENT_MODE = "document";
    private static final String DEFAULT_MODE = "disk";
    private static boolean deleting = false;
    private String mode = "disk";
    private String solrurl;
    private SolrServiceImpl solrService;
    private static final String DIH = "dih";
    private static final String DATA_CONFIG_PATH = "/conf/data-config.xml";
    private static final String CUSTOM1 = "custom1";
    private static final String CUSTOM2 = "custom2";
    private static final String CUSTOM3 = "custom3";
    private static final String CUSTOM4 = "custom4";
    private static final String INSERTED = "INSERTED";
    private static final String UPDATED = "UPDATED";
    private static final String PROCESSED = "TOTAL_DOCUMENTS_PROCESSED";
    private static final String DELETED = "DELETED";
    private Map<String, String> customFields = new HashMap<String, String>();
    private String datasource;
    private String tables;
    private List<String> tablesList;
    private String dihConfigPath;

    public void setAttributecollection(Map o) {
        Set p = o.entrySet();
        for (Map.Entry entry : p) {
            String key = entry.getKey().toString().toLowerCase();
            String value = entry.getValue().toString();
            if (!key.contains("_")) {
                throw new InvalidCustomFieldException(key);
            }
            if (key.endsWith("_dt")) {
                value = SolrUtils.formatDate(value);
            }
            this.customFields.put(key, value);
        }
    }

    public void release() {
        this.collection = null;
        this.action = null;
        this.type = null;
        this.title = "";
        this.key = "";
        this.body = null;
        this.urlpath = "";
        this.category = "";
        this.categoryTree = "";
        this.extensions = ".htm, .html, .cfm, .cfml, .dbm, .dbml";
        this.criteria = null;
        this.query = null;
        this.prefix = null;
        this.recurse = false;
        this.language = null;
        this.status = null;
        this.status_struct = null;
        this.mode = "disk";
        this.solrService = null;
        super.release();
        this.onTagEnd();
    }

    public int doStartTag() {
        this.onTagStart();
        boolean update = false;
        this.solrService = (SolrServiceImpl)ServiceFactory.getSolrService();
        this.solrurl = SolrUtils.getSolrURL(this.solrService);
        if (SolrUtils.isSolrCore(this.solrurl, this.collection)) {
            if (this.language == null) {
                this.language = "english";
            }
        } else {
            if (SolrUtils.isSolrRunning(this.solrurl)) {
                throw new CollectionDoesNotExistException(this.collection);
            }
            this.language = null;
            throw new SolrNotRunningException(this.solrurl);
        }
        if (this.action.equalsIgnoreCase("optimize") && this.status != null) {
            throw new StatusNotAllowedException();
        }
        if (this.type == null) {
            String string = this.type = this.query != null ? "CUSTOM" : "FILE";
        }
        if (DIH.equalsIgnoreCase(this.type)) {
            this.checkEFR();
            this.doDIHIndexing();
        } else if (this.action.equals("status")) {
            throw new DIHStatusException();
        }
        if (!(this.mode.equals(MEMORY_MODE) || this.mode.equals("disk") || this.mode.equals(DOCUMENT_MODE))) {
            this.mode = "disk";
        }
        if (this.action.equalsIgnoreCase("update")) {
            if (this.query != null) {
                this.doQueryUpdate(true);
            } else {
                this.doUpdate(true);
            }
            update = true;
        } else if (this.action.equalsIgnoreCase("refresh")) {
            this.doPurge();
            if (this.query != null) {
                this.doQueryUpdate(false);
            } else {
                this.doUpdate(false);
            }
            update = true;
        } else if (this.action.equalsIgnoreCase("delete")) {
            if (this.query != null) {
                this.doQueryDelete();
            } else {
                this.doDelete();
            }
        } else if (this.action.equalsIgnoreCase("purge")) {
            this.doPurge();
        } else if (this.action.equalsIgnoreCase("optimize")) {
            try {
                Utils.doCollectionOptimization(this.collection);
            }
            catch (Exception e) {
                throw new IndexProblemException(e);
            }
        } else if (this.action.equalsIgnoreCase("merge")) {
            this.doMerge();
        } else if (this.action.equalsIgnoreCase("commit")) {
            this.doCommit();
        } else {
            if (this.isDIHAction()) {
                return 0;
            }
            throw new IllegalAttributeValueException("cfindex", this.action, "Valid values are: UPDATE, DELETE, PURGE, REFRESH, FULLIMPORT, DELTAIMPORT, STATUS, ABORT.");
        }
        return 0;
    }

    private void doCommit() {
        SolrService service = ServiceFactory.getSolrService();
        String url = SolrUtils.getSolrURL(service);
        SolrClient client = SolrUtils.getSolrClient(url, this.collection);
        SolrUtils.forceCommit(client);
    }

    private void doMerge() {
        this.collection = SolrUtils.fixURL(this.collection);
        SolrUtils.mergeCollections(this.collection, this.collectionnames);
    }

    private boolean isDIHAction() {
        return Arrays.asList("FULL-IMPORT", "DELTA-IMPORT", "STATUS", "ABORT").contains(this.action.toUpperCase());
    }

    private void doDIHIndexing() {
        SolrClient solr = SolrUtils.getHttpsSolrClient(this.collection);
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("qt", new String[]{"/dataimport"});
        if ("fullimport".equalsIgnoreCase(this.action)) {
            this.action = "full-import";
        } else if ("deltaimport".equalsIgnoreCase(this.action)) {
            this.action = "delta-import";
        }
        params.set("command", new String[]{this.action.toLowerCase()});
        if (!this.action.equals("abort")) {
            params.set("commit", new String[]{"true"});
        }
        params.set("wt", new String[]{"json"});
        try {
            QueryResponse response = solr.query((SolrParams)params);
            if (!this.action.equals("abort") && !this.action.equals("status")) {
                solr.commit();
            }
            SolrQuery query = new SolrQuery("*:*");
            QueryResponse results = solr.query((SolrParams)query);
            if (this.status != null) {
                this.setStatusAttributeForDIH(response);
            }
        }
        catch (Exception e) {
            throw new DIHIndexingException(e);
        }
    }

    private void setStatusAttributeForDIH(QueryResponse response) {
        int idx2;
        int idx;
        Struct stat = new Struct();
        SimpleOrderedMap resMap = (SimpleOrderedMap)response.getResponse().get("statusMessages");
        String info = (String)resMap.get("");
        stat.put((Object)"status", response.getResponse().get("status"));
        String insOrUpd = "0";
        String deleted = "0";
        if (null != info && info.contains("Added/Updated")) {
            idx = info.indexOf("Added/Updated");
            idx2 = info.indexOf(" documents.", idx);
            insOrUpd = info.substring(idx + 15, idx2);
        }
        if (null != info && info.contains("Deleted")) {
            idx = info.indexOf("Deleted");
            idx2 = info.indexOf(" documents.", idx);
            deleted = info.substring(idx + 8, idx2);
        }
        if ("delta-import".equals(this.action)) {
            stat.put((Object)PROCESSED, (Object)(insOrUpd + deleted));
        } else if ("full-import".equals(this.action)) {
            stat.put((Object)PROCESSED, (Object)(insOrUpd + deleted));
        } else if ("status".equals(this.action)) {
            stat.put((Object)"TOTAL_ROWS_FETCHED", resMap.get("Total Rows Fetched"));
            stat.put((Object)PROCESSED, resMap.get("Total Documents Processed"));
            stat.put((Object)"TOTAL_DOCUMENTS_SKIPPED", resMap.get("Total Documents Skipped"));
        } else if ("abort".equals(this.action)) {
            stat.put((Object)"status", response.getResponse().get("status"));
            stat.put((Object)"abort", (Object)"success");
        }
        this.pageContext.setAttribute(this.status, (Object)stat);
    }

    private void doUpdate(boolean update) {
        String languagesuffix = "";
        this.collection = SolrUtils.fixURL(this.collection);
        if (!this.language.equalsIgnoreCase("english")) {
            Vector<Map> v = this.solrService.getLanguages();
            languagesuffix = IndexTag.getSolrLanguageSuffix(v, this.language, this.collection);
        }
        Struct indexeddocs = new Struct();
        if (this.status_struct == null) {
            this.status_struct = new Struct();
        }
        this.status_struct.clear();
        SolrClient client = SolrUtils.getSolrClient(this.solrurl, this.collection);
        if ("FILE".equalsIgnoreCase(this.type)) {
            this.urlpath = IndexTag.formatUrlpath(this.urlpath, this.key);
            ArrayList<File> files = new ArrayList<File>();
            files.add(VFSFileFactory.getFileObject((String)this.key));
            indexeddocs = SolrUtils.addDocument(client, this.key, files, this.urlpath, this.title, this.category, this.categoryTree, languagesuffix, this.customFields, this.fieldboost, this.docboost, this.autocommit, this.throwonerror);
        } else if ("PATH".equalsIgnoreCase(this.type)) {
            if (this.urlpath.endsWith("/")) {
                this.urlpath = this.removeLastSeparatorChar(this.urlpath, '/');
            } else if (this.urlpath.endsWith("\\")) {
                this.urlpath = this.removeLastSeparatorChar(this.urlpath, '\\');
            }
            this.key = this.removeLastSeparatorChar(this.key, File.separatorChar);
            File dir = new File(this.key);
            if (!Utils.isDirectory(dir)) {
                throw new KeyIsNotDirectoryException(this.key);
            }
            ArrayList files = this.getFiles(new File(this.key));
            indexeddocs = SolrUtils.addDocument(client, this.key, files, this.urlpath, this.title, this.category, this.categoryTree, languagesuffix, this.customFields, this.fieldboost, this.docboost, this.autocommit, this.throwonerror);
        } else if ("CUSTOM".equalsIgnoreCase(this.type)) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("title", this.title);
            m.put("url", this.urlpath);
            m.put("body", this.body);
            m.put("key", this.key);
            m.put("category", this.category);
            m.put("categorytree", this.categoryTree);
            m.put("customFieldsData", this.customFields);
            m.put("fieldboost", this.fieldboost);
            m.put("docboost", this.docboost);
            ArrayList<HashMap> l = new ArrayList<HashMap>();
            l.add(m);
            indexeddocs = SolrUtils.addDocument(client, l, this.autocommit, this.throwonerror);
        } else {
            throw new IllegalAttributeValueException("cfindex", this.type, "Valid values are: FILE, PATH, CUSTOM, DIH.");
        }
        if (update) {
            this.status_struct.put((Object)UPDATED, indexeddocs.get((Object)"doccount"));
            this.status_struct.put((Object)INSERTED, (Object)0);
        } else {
            this.status_struct.put((Object)INSERTED, indexeddocs.get((Object)"doccount"));
            this.status_struct.put((Object)UPDATED, (Object)0);
        }
        this.status_struct.put((Object)DELETED, (Object)0);
        this.status_struct.put((Object)"ERRORS", indexeddocs.get((Object)"ERRORS"));
        if (this.status != null) {
            this.pageContext.setAttribute(this.status, (Object)this.status_struct);
        }
    }

    private void doQueryUpdate(boolean update) {
        if (this.status_struct == null) {
            this.status_struct = new Struct();
        }
        this.status_struct.clear();
        Object o = this.pageContext.findAttribute(this.query);
        if (o == null) {
            throw new CannotFindSomethingException("Index", "QUERY", this.query);
        }
        if (!(o instanceof QueryTable)) {
            throw new VariableIsNotQueryException(this.query);
        }
        QueryTable queryTable = (QueryTable)o;
        QueryVector queryVector = new QueryVector(queryTable);
        if (this.type.equalsIgnoreCase("custom") && (this.body == null || this.body.length() == 0)) {
            throw new MissingCustomAttributeException("BODY");
        }
        int rowCount = queryTable.getRowCount();
        int keyIndex = IndexTag.findKey(queryTable, this.key);
        if (keyIndex == 0) {
            throw new CannotFindSomethingException("Index", "query table column for", this.key);
        }
        this.collection = SolrUtils.fixURL(this.collection);
        String languagesuffix = "";
        if (!this.language.equalsIgnoreCase("english")) {
            Vector<Map> v = this.solrService.getLanguages();
            languagesuffix = IndexTag.getSolrLanguageSuffix(v, this.language, this.collection);
        }
        Struct indexeddocs = new Struct();
        SolrClient client = SolrUtils.getSolrClient(this.solrurl, this.collection);
        if ("FILE".equalsIgnoreCase(this.type)) {
            indexeddocs = SolrUtils.addDocument(client, queryTable, this.key, this.title, this.urlpath, this.category, this.categoryTree, languagesuffix, this.customFields, this.fieldboost, this.docboost, this.autocommit);
            if (update) {
                this.status_struct.put((Object)INSERTED, (Object)0);
                this.status_struct.put((Object)UPDATED, indexeddocs.get((Object)"doccount"));
            } else {
                this.status_struct.put((Object)UPDATED, (Object)0);
                this.status_struct.put((Object)INSERTED, indexeddocs.get((Object)"doccount"));
            }
            this.status_struct.put((Object)DELETED, (Object)0);
            this.status_struct.put((Object)"ERRORS", indexeddocs.get((Object)"ERRORS"));
        } else if ("PATH".equalsIgnoreCase(this.type)) {
            indexeddocs = SolrUtils.addDocument(client, queryTable, this.key, this.title, this.urlpath, this.category, this.categoryTree, this.extensions, this.prefix, this.recurse, languagesuffix, this.customFields, this.fieldboost, this.docboost, this.autocommit);
            if (update) {
                this.status_struct.put((Object)INSERTED, (Object)0);
                this.status_struct.put((Object)UPDATED, indexeddocs.get((Object)"doccount"));
            } else {
                this.status_struct.put((Object)UPDATED, (Object)0);
                this.status_struct.put((Object)INSERTED, indexeddocs.get((Object)"doccount"));
            }
            this.status_struct.put((Object)"ERRORS", indexeddocs.get((Object)"ERRORS"));
            this.status_struct.put((Object)DELETED, (Object)0);
        } else if (this.type.equalsIgnoreCase("CUSTOM")) {
            ArrayList<Integer> bodyIndexList = new ArrayList<Integer>();
            StringTokenizer tok = new StringTokenizer(this.body, ",");
            while (tok.hasMoreElements()) {
                String column = tok.nextToken();
                int idx = IndexTag.findKey(queryTable, column = column.trim());
                if (idx == 0) {
                    throw new CannotFindSomethingException("Lucene", "query table column for", column);
                }
                bodyIndexList.add(new Integer(idx));
            }
            ArrayList<HashMap> l = new ArrayList<HashMap>();
            for (int row = 1; row <= rowCount; ++row) {
                String keyData = queryVector.getData(row, keyIndex);
                String titleData = IndexTag.getIndexData(queryVector, this.title, row);
                String urlData = IndexTag.getIndexData(queryVector, this.urlpath, row);
                String categoryData = IndexTag.getIndexData(queryVector, this.category, row);
                String categoryTreeData = IndexTag.getIndexData(queryVector, this.categoryTree, row);
                String bodyData = "";
                for (int i = 0; i < bodyIndexList.size(); ++i) {
                    int idx = (Integer)bodyIndexList.get(i);
                    String data = queryVector.getData(row, idx);
                    if (data == null) continue;
                    try {
                        data = new HTMLParser(new StringBuilder(data)).getText();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bodyData = bodyData + data.replace('\u0000', ' ');
                    bodyData = bodyData + ' ';
                }
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("title", titleData);
                m.put("url", urlData);
                m.put("body", bodyData);
                m.put("key", keyData);
                m.put("category", categoryData);
                m.put("categorytree", categoryTreeData);
                m.put("customFieldsData", SolrUtils.getCustomFieldsData(this.customFields, row, queryVector));
                m.put("fieldboost", this.fieldboost);
                m.put("docboost", this.docboost);
                l.add(m);
            }
            indexeddocs = SolrUtils.addDocument(client, l, this.autocommit, this.throwonerror);
            this.status_struct.clear();
            if (update) {
                this.status_struct.put((Object)UPDATED, indexeddocs.get((Object)"doccount"));
                this.status_struct.put((Object)INSERTED, (Object)0);
            } else {
                this.status_struct.put((Object)INSERTED, indexeddocs.get((Object)"doccount"));
                this.status_struct.put((Object)UPDATED, (Object)0);
            }
            this.status_struct.put((Object)"ERRORS", indexeddocs.get((Object)"ERRORS"));
            this.status_struct.put((Object)DELETED, (Object)0);
        } else {
            throw new IllegalAttributeValueException("cfindex", this.type, "Valid values are: FILE, PATH, CUSTOM, DIH.");
        }
        if (this.status != null) {
            this.pageContext.setAttribute(this.status, (Object)this.status_struct);
        }
    }

    private void doDelete() {
        if (this.status_struct == null) {
            this.status_struct = new Struct();
        }
        this.status_struct.clear();
        int count = 0;
        try {
            SolrClient client = SolrUtils.getSolrClient(this.solrurl, this.collection);
            if ("FILE".equalsIgnoreCase(this.type) || "CUSTOM".equalsIgnoreCase(this.type) || "".equalsIgnoreCase(this.type)) {
                if (null != this.key && this.key.length() > 0) {
                    SolrUtils.deleteKey(client, this.key);
                }
                if (null != this.criteria && this.criteria.length() > 0) {
                    SolrUtils.deleteByQuery(client, this.criteria);
                }
            } else if ("PATH".equalsIgnoreCase(this.type)) {
                this.key = this.removeLastSeparatorChar(this.key, File.separatorChar);
                File dir = new File(this.key);
                if (!Utils.isDirectory(dir)) {
                    throw new KeyIsNotDirectoryException(this.key);
                }
                ExtensionMatcher matcher = new ExtensionMatcher(this.extensions);
                ArrayList fileList = new ArrayList();
                matcher.getFiles(fileList, dir, this.recurse);
                if (fileList.size() > 0) {
                    for (int listIndex = 0; listIndex < fileList.size(); ++listIndex) {
                        String filename = ((File)fileList.get(listIndex)).getPath();
                        SolrUtils.deleteKey(client, filename);
                    }
                }
            } else {
                throw new IllegalAttributeValueException("cfindex", this.type, "Valid values are: FILE, PATH, CUSTOM.");
            }
            count = SolrUtils.getSolrDocCount(this.solrurl, this.collection);
            client.commit();
            count -= SolrUtils.getSolrDocCount(this.solrurl, this.collection);
            if (this.status != null) {
                this.status_struct.put((Object)INSERTED, (Object)0);
                this.status_struct.put((Object)UPDATED, (Object)0);
                this.status_struct.put((Object)DELETED, (Object)count);
                this.pageContext.setAttribute(this.status, (Object)this.status_struct);
            }
        }
        catch (Exception e) {
            throw new IndexProblemException(e);
        }
    }

    private void doQueryDelete() {
        Object o;
        this.collection = SolrUtils.fixURL(this.collection);
        if (this.status_struct == null) {
            this.status_struct = new Struct();
        }
        if ((o = this.pageContext.findAttribute(this.query)) == null) {
            throw new CannotFindSomethingException("Solr", "QUERY", this.query);
        }
        if (!(o instanceof QueryTable)) {
            throw new VariableIsNotQueryException(this.query);
        }
        QueryTable queryTable = (QueryTable)o;
        QueryVector queryVector = new QueryVector(queryTable);
        int rowCount = queryTable.getRowCount();
        int keyIndex = IndexTag.findKey(queryTable, this.key);
        if (keyIndex == 0 && this.criteria == null) {
            throw new CannotFindSomethingException("Solr", "query table column for", this.key);
        }
        SolrClient client = SolrUtils.getSolrClient(this.solrurl, this.collection);
        boolean workdone = false;
        int count = 0;
        try {
            if (0 == keyIndex) {
                SolrUtils.deleteByQuery(client, this.criteria);
            } else if ("FILE".equalsIgnoreCase(this.type)) {
                for (int row = 1; row <= rowCount; ++row) {
                    String keyData = queryVector.getData(row, keyIndex);
                    SolrUtils.deleteKey(client, keyData);
                }
                workdone = true;
            } else if (this.type.equalsIgnoreCase("PATH")) {
                ExtensionMatcher matcher = new ExtensionMatcher(this.extensions);
                ArrayList fileList = new ArrayList();
                for (int row = 1; row <= rowCount; ++row) {
                    String keyData = queryVector.getData(row, keyIndex);
                    File dir = new File(keyData);
                    if (!Utils.isDirectory(dir)) {
                        throw new KeyIsNotDirectoryException(keyData);
                    }
                    matcher.getFiles(fileList, dir, this.recurse);
                }
                for (int listIndex = 0; listIndex < fileList.size(); ++listIndex) {
                    String filename = ((File)fileList.get(listIndex)).getPath();
                    SolrUtils.deleteKey(client, filename);
                }
                workdone = true;
            } else if (this.type.equalsIgnoreCase("CUSTOM")) {
                for (int row = 1; row <= rowCount; ++row) {
                    String keyData = queryVector.getData(row, keyIndex);
                    SolrUtils.deleteKey(client, keyData);
                    workdone = true;
                }
            }
            count = SolrUtils.getSolrDocCount(this.solrurl, this.collection);
            client.commit();
            this.status_struct.put((Object)DELETED, (Object)(count -= SolrUtils.getSolrDocCount(this.solrurl, this.collection)));
            this.status_struct.put((Object)INSERTED, (Object)0);
            this.status_struct.put((Object)UPDATED, (Object)0);
        }
        catch (Exception e) {
            throw new IndexProblemException(e);
        }
        if (!workdone) {
            this.status_struct.put((Object)INSERTED, (Object)0);
            this.status_struct.put((Object)UPDATED, (Object)0);
            this.status_struct.put((Object)DELETED, (Object)0);
        }
        if (this.status != null) {
            this.pageContext.setAttribute(this.status, (Object)this.status_struct);
        }
    }

    private void doPurge() {
        String solrurl = SolrUtils.getSolrURL(this.solrService);
        try {
            String collectionname = SolrUtils.fixURL(this.collection);
            SolrClient client = SolrUtils.getSolrClient(solrurl, collectionname);
            int doccount = 0;
            if (this.status != null) {
                doccount = SolrUtils.getSolrDocCount(solrurl, collectionname);
            }
            SolrUtils.purgeCollection(client);
            if (this.status != null) {
                Struct stat = new Struct();
                stat.put((Object)INSERTED, (Object)new Integer(0));
                stat.put((Object)UPDATED, (Object)new Integer(0));
                stat.put((Object)DELETED, (Object)new Long(doccount));
                this.pageContext.setAttribute(this.status, (Object)stat);
            }
        }
        catch (Exception e) {
            throw new IndexProblemException(e);
        }
    }

    protected Permission getPermission() {
        return tp;
    }

    public static int findKey(QueryTable queryTable, String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return 0;
        }
        return queryTable.findColumn(columnName);
    }

    public static String getIndexData(QueryVector queryVector, String columnName, int row) {
        if (columnName == null || columnName.length() == 0) {
            return "";
        }
        String[] splits = columnName.trim().split(",");
        String data = "";
        for (String column : splits) {
            String s;
            int index = queryVector.findColumn(column.trim());
            if (index > 0) {
                s = queryVector.getData(row, index);
                if (null == s) {
                    s = "";
                }
            } else {
                return columnName;
            }
            data = data + s + ",";
        }
        return data.substring(0, data.length() - 1);
    }

    public static String formatUrlpath(String urlpath, String key) {
        try {
            key = new File(key.trim()).getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        urlpath = urlpath.trim();
        String justFilename = key.substring(key.lastIndexOf(File.separator) + 1, key.length());
        if (urlpath.length() > 0) {
            String strUrlSeparator = urlpath.charAt(urlpath.length() - 1) == '/' ? "" : "/";
            urlpath = urlpath + strUrlSeparator + justFilename;
        } else {
            urlpath = justFilename;
        }
        return urlpath;
    }

    private String removeLastSeparatorChar(String text, char sep) {
        if ((text = text.trim()).length() > 0 && text.charAt(text.length() - 1) == sep) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    private ArrayList getFiles(File dir) {
        ExtensionMatcher matcher = new ExtensionMatcher(this.extensions);
        ArrayList fileList = new ArrayList();
        matcher.getFiles(fileList, dir, this.recurse);
        return fileList;
    }

    public static String getSolrLanguageSuffix(Vector<Map> v, String language, String collection) {
        String suffix = "";
        boolean found = false;
        for (Map m : v) {
            String l = (String)m.get("name");
            if (!language.equalsIgnoreCase(l)) continue;
            found = true;
            suffix = (String)m.get("suffix");
            break;
        }
        if (!found) {
            throw new LanguageMismatchException(collection, language, "solr");
        }
        return suffix;
    }

    public void setType(String a) {
        this.type = a;
    }

    public void setAction(String a) {
        this.action = null != a ? a.trim() : null;
    }

    public void setTitle(String a) {
        this.title = a;
    }

    public void setKey(String a) {
        this.key = a;
    }

    public void setBody(String a) {
        this.body = a;
    }

    public void setCustom1(String a) {
        this.customFields.put(CUSTOM1, a);
    }

    public void setCustom2(String a) {
        this.customFields.put(CUSTOM2, a);
    }

    public void setCustom3(String a) {
        this.customFields.put(CUSTOM3, a);
    }

    public void setCustom4(String a) {
        this.customFields.put(CUSTOM4, a);
    }

    public void setUrlpath(String a) {
        this.urlpath = a;
    }

    public void setExtensions(String a) {
        this.extensions = a;
    }

    public void setQuery(String a) {
        this.query = a;
    }

    public void setCriteria(String a) {
        this.criteria = a;
    }

    public void setPrefix(String p) {
        this.prefix = p;
    }

    public void setRecurse(boolean b) {
        this.recurse = b;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setStatus(String s) {
        this.status = s.toUpperCase();
    }

    public void setCategory(String s) {
        this.category = s;
    }

    public void setCategorytree(String s) {
        this.categoryTree = s;
    }

    public void setIndexMode(String m) {
        this.mode = m.toLowerCase();
    }

    public void setLanguage(String language) {
        String lang;
        this.language = lang = language.toLowerCase();
    }

    public void setExternal(boolean ext) {
    }

    public void setDihconfigpath(String dihConfigPath) {
        this.dihConfigPath = dihConfigPath;
    }

    public String getDihConfigPath() {
        return this.dihConfigPath;
    }

    public void setCollectionnames(String name) {
        this.collectionnames = name;
    }

    public String getCollectionnames() {
        return this.collectionnames;
    }

    public void setFieldboost(String name) {
        this.fieldboost = name;
    }

    public String getFieldboost() {
        return this.fieldboost;
    }

    public void setDocboost(String name) {
        this.docboost = name;
    }

    public String getDocboost() {
        return this.docboost;
    }

    public void setAutocommit(boolean b) {
        this.autocommit = b;
    }

    public boolean getAutocommit() {
        return this.autocommit;
    }

    public boolean isThrowonerror() {
        return this.throwonerror;
    }

    public void setThrowonerror(boolean throwonerror) {
        this.throwonerror = throwonerror;
    }

    private void checkEFR() {
        FeatureRouter.getInstance().allowFeature(EFRConstants.solr_enhancements.intValue(), null);
    }

    public static class InvalidCustomFieldException
    extends SearchEngineException {
        public String name;

        public InvalidCustomFieldException(String name) {
            this.name = name;
        }
    }

    public static class LanguageMismatchException
    extends SearchEngineException {
        public String collectionName;
        public String language;
        public String engine;

        public LanguageMismatchException(String collectionName, String language, String engine) {
            this.collectionName = collectionName;
            this.language = language;
            this.engine = engine;
        }
    }

    public static class VariableIsNotQueryException
    extends SearchEngineException {
        public String name;

        public VariableIsNotQueryException(String name) {
            this.name = name;
        }
    }

    public static class SolrNotRunningException
    extends SearchEngineException {
        public String url;

        public SolrNotRunningException(String url) {
            this.url = url;
        }
    }

    public static class IndexDataMissingException
    extends SearchEngineException {
        public String name;

        public IndexDataMissingException(String name) {
            this.name = name;
        }
    }

    public static class StatusNotAllowedException
    extends SearchEngineException {
    }

    public static class DIHIndexingException
    extends SearchEngineException {
        public DIHIndexingException(Exception e) {
            super((Throwable)e);
        }
    }

    public static class RemoteSolrPathNotAllowedException
    extends SearchEngineException {
    }

    public static class MissingCustomAttributeException
    extends SearchEngineException {
        public String attr;

        public MissingCustomAttributeException(String s) {
            this.attr = s;
        }
    }

    public static class IndexErrorException
    extends SearchEngineException {
        public String errors;

        public IndexErrorException(String errors) {
            this.errors = errors;
        }
    }

    public static class KeyIsNotDirectoryException
    extends SearchEngineException {
        public String path;

        public KeyIsNotDirectoryException(String path) {
            this.path = path;
        }
    }

    public static class CannotFindSomethingException
    extends SearchEngineException {
        public String label;
        public String value;
        public String engine;

        public CannotFindSomethingException(String engine, String label, String value) {
            this.engine = engine;
            this.label = label;
            this.value = value;
        }
    }

    public static class IndexInvalidAttributevalueException
    extends SearchEngineException {
        public IndexInvalidAttributevalueException(Throwable e) {
        }
    }

    public static class IndexInvalidAttributeException
    extends SearchEngineException {
        public IndexInvalidAttributeException(Throwable e) {
        }
    }

    public static class DIHStatusException
    extends SearchEngineException {
    }

    public static class IndexProblemException
    extends SearchEngineException {
        public IndexProblemException(Throwable e) {
            super(e);
        }
    }

    private class SearchByteArrayOutputStream
    extends ByteArrayOutputStream {
        public SearchByteArrayOutputStream(int size) {
            super(size);
        }

        @Override
        public synchronized byte[] toByteArray() {
            return this.buf;
        }
    }
}

