/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.search;

import coldfusion.log.CFLogs;
import coldfusion.lucene.SolrServiceImpl;
import coldfusion.runtime.SearchEngineException;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.search.CollectionDoesNotExistException;
import coldfusion.tagext.search.SearchEngineLibraryException;
import coldfusion.tagext.search.SolrUtils;
import coldfusion.tagext.search.Utils;
import coldfusion.tagext.validation.IllegalAttributeValueException;
import coldfusion.util.IPAddressUtils;
import coldfusion.util.RB;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;

public class CollectionTag
extends GenericTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfcollection");
    private static final int NAME = 1;
    private static final int PATH = 2;
    private static final int SIZE = 3;
    private static final int DOCCOUNT = 4;
    private static final int LASTMODIFIED = 5;
    private static final String[] QueryColumns = new String[]{"NAME", "PATH", "SIZE", "DOCCOUNT", "LASTMODIFIED"};
    private static final String[] QueryTypeNames = new String[]{"VARCHAR", "VARCHAR", "VARCHAR", "VARCHAR", "VARCHAR"};
    private static final int[] QueryColumnTypes = new int[]{12, 12, 12, 12, 12};
    private String action = "LIST";
    private String collection = null;
    private String engine = "";
    private String path = null;
    private String name = null;
    private String language = "english";
    private boolean bCategories = false;
    private String solrurl = "";
    private SolrServiceImpl solrService;

    public void release() {
        this.action = "LIST";
        this.collection = null;
        this.path = null;
        this.name = null;
        this.language = "english";
        this.bCategories = false;
        this.solrService = null;
        this.engine = "";
        super.release();
        this.onTagEnd();
    }

    public int doStartTag() {
        this.onTagStart();
        this.engine = "solr";
        this.solrService = (SolrServiceImpl)ServiceFactory.getSolrService();
        if (this.action.equalsIgnoreCase("list")) {
            this.doActionList();
        } else if (this.action.equalsIgnoreCase("create")) {
            this.doActionCreateOrMap(false, this.engine);
        } else if (this.action.equalsIgnoreCase("delete")) {
            this.doActionDelete();
        } else if (this.action.equalsIgnoreCase("optimize")) {
            this.doActionOptimize();
        } else if (this.action.equalsIgnoreCase("categorylist")) {
            this.doCategoryList();
        } else if (this.action.equalsIgnoreCase("reload")) {
            this.doActionReload();
        } else {
            throw new IllegalAttributeValueException("cfcollection", this.action, "Valid values are: CREATE, DELETE, LIST, MAP, OPTIMIZE and REPAIR.");
        }
        return 0;
    }

    private void doActionReload() {
        this.solrurl = SolrUtils.getSolrURL(this.solrService);
        if (!SolrUtils.isSolrCore(this.solrurl, this.collection)) {
            throw new CollectionDoesNotExistException(this.collection);
        }
        SolrUtils.reloadCore(this.solrurl, this.collection);
    }

    private void doActionCreateOrMap(boolean map, String engine) {
        this.solrurl = SolrUtils.getSolrURL(this.solrService);
        if (engine.equalsIgnoreCase("solr") && !SolrUtils.isSolrRunning(this.solrurl)) {
            throw new Utils.UnableToCreateCollectionException(this.collection, (Throwable)((Object)new SolrUtils.UnableToConnectToSolrException()));
        }
        Utils.checkCollectionExists(this.collection);
        if (engine.equalsIgnoreCase("solr")) {
            try {
                this.doActionCreateSolr(map);
            }
            catch (IOException e) {
                throw new Utils.UnableToCreateCollectionException(this.collection, e);
            }
            catch (Utils.UnableToCreateCollectionException e) {
                throw e;
            }
        }
    }

    private void doActionCreateSolr(boolean map) throws IOException {
        boolean islocal = IPAddressUtils.isLocalHost((String)this.solrService.getSolrHost());
        String solrhome = this.solrService.getSolrHome();
        if (!solrhome.endsWith("/") || !solrhome.endsWith("\\")) {
            solrhome = solrhome + "/";
        }
        this.collection = this.collection.trim();
        if (this.collection.contains(" ")) {
            throw new InvalidCollectionException(this.collection);
        }
        String collectionPath = solrhome + "collections/" + this.collection;
        if (islocal) {
            File p = new File(collectionPath);
            this.createCollectionsDirectory(p);
            SolrUtils.createSolrCore(this.solrurl, this.solrService.getSolrHome(), this.collection, p.getCanonicalPath());
        } else {
            SolrUtils.createSolrCore(this.solrurl, this.solrService.getSolrHome(), this.collection, collectionPath);
        }
    }

    private void createCollectionsDirectory(final File p) {
        if (System.getSecurityManager() == null) {
            if (!p.exists()) {
                p.mkdir();
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (!p.exists()) {
                        p.mkdir();
                    }
                    return null;
                }
            });
        }
    }

    private void doActionDelete() {
        SolrClient client;
        this.solrurl = SolrUtils.getSolrURL(this.solrService);
        if (SolrUtils.isSolrCore(this.solrurl, this.collection)) {
            client = SolrUtils.getSolrClient(this.solrurl);
            try {
                SolrUtils.purgeCollection(SolrUtils.getSolrClient(this.solrurl, this.collection));
            }
            catch (Throwable e) {
                CFLogs.APPLICATION_LOG.error(e);
            }
        } else {
            throw new CollectionDoesNotExistException(this.collection);
        }
        SolrUtils.deleteCore(client, this.collection);
    }

    private void doActionList() {
        boolean both = false;
        if (this.name == null || this.name.length() == 0) {
            throw new AttributeRequiredException("NAME", "LIST");
        }
        QueryTable query = new QueryTable(0, QueryColumns, QueryTypeNames, QueryColumnTypes);
        query.setColumnNames(QueryColumns, false);
        try {
            int verityLength = 0;
            if (this.engine.equalsIgnoreCase("")) {
                both = true;
            }
            if (this.engine.equalsIgnoreCase("solr") || both) {
                int i = verityLength;
                this.solrurl = SolrUtils.getSolrURL(this.solrService);
                ArrayList<HashMap<String, String>> cores = SolrUtils.list(this.solrurl);
                query.addRows(cores.size());
                for (HashMap<String, String> map : cores) {
                    String name = map.get("name");
                    String modified = map.get("modified");
                    String path = map.get("path");
                    String size = map.get("size");
                    query.setField(i + 1, 1, (Object)name);
                    query.setField(i + 1, 5, (Object)modified);
                    query.setField(i + 1, 2, (Object)path);
                    query.setField(i + 1, 3, (Object)size);
                    query.setField(i + 1, 4, (Object)map.get("doccount"));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new SearchEngineLibraryException(RB.getString((Object)((Object)this), (String)"Collection.getinfo"), e);
        }
        this.pageContext.setAttribute(this.name, (Object)query);
    }

    private void doActionOptimize() {
        try {
            Utils.doCollectionOptimization(this.collection);
        }
        catch (IOException e) {
            throw new SearchEngineLibraryException(e);
        }
        catch (SolrServerException e) {
            throw new SearchEngineLibraryException((Exception)((Object)e));
        }
    }

    private void doActionRepair() {
    }

    private void doCategoryList() {
        String solrurl = SolrUtils.getSolrURL(this.solrService);
        if (SolrUtils.isSolrCore(solrurl, this.collection)) {
            HashMap<String, Long> m = SolrUtils.getCategories(solrurl, this.collection);
            HashMap<String, Long> cattree = SolrUtils.getCategoryTrees(solrurl, this.collection);
            Struct result = new Struct();
            result.put((Object)"CATEGORIES", m);
            result.put((Object)"CATEGORYTREES", cattree);
            this.pageContext.setAttribute(this.name, (Object)result);
        }
    }

    protected Permission getPermission() {
        return tp;
    }

    public void setAction(String a) {
        this.action = a;
    }

    public void setName(String a) {
        this.name = a;
    }

    public void setCollection(String a) {
        this.collection = a;
    }

    public void setPath(String a) {
        this.path = a;
    }

    public void setLanguage(String language) {
        String lang;
        this.language = lang = language.toLowerCase();
    }

    public void setEngine(String e) {
        this.engine = e;
    }

    public void setCategories(boolean b) {
        this.bCategories = b;
    }

    public static class CategoriesNotEnabledException
    extends SearchEngineException {
        public String name;
        public String error;

        public CategoriesNotEnabledException(String name, String error) {
            this.name = name;
            this.error = error;
        }
    }

    public static class BadCollectionDirectoryException
    extends SearchEngineException {
        public String directory;

        public BadCollectionDirectoryException(String directory) {
            this.directory = directory;
        }
    }

    public static class InvalidCollectionException
    extends SearchEngineException {
        public String collection;

        public InvalidCollectionException(String collection) {
            this.collection = collection;
        }
    }

    public static class AttributeRequiredException
    extends SearchEngineException {
        public String attribute;
        public String action;

        AttributeRequiredException(String attribute, String action) {
            this.attribute = attribute;
            this.action = action;
        }
    }
}

