/*
 * Decompiled with CFR 0.152.
 */
package macromedia.slutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import macromedia.slutil.UtilException;
import macromedia.slutil.UtilTransliterator;

public class UtilTransliteratorForUTF8
extends UtilTransliterator {
    private String encoding = "UTF8";
    private int[] rl;

    public UtilTransliteratorForUTF8() throws UtilException {
        this.setDefaultCacheSize();
    }

    public boolean isFixedBytesPerChar() {
        return false;
    }

    public int getMaxBytesPerChar() {
        return 3;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        byte[] byArray = this.encode(string, this.rl);
        int n2 = this.rl[0];
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n2 = string.length();
        this.setCacheSize(n2);
        string.getChars(0, n2, this.charsCache, 0);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = this.charsCache[i2];
            if (c2 >= '\u0000' && c2 <= '\u007f') {
                this.bytesCache[n3++] = (byte)c2;
                continue;
            }
            if (c2 > '\u07ff') {
                this.bytesCache[n3++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                this.bytesCache[n3++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                this.bytesCache[n3++] = (byte)(0x80 | c2 >> 0 & 0x3F);
                continue;
            }
            this.bytesCache[n3++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
            this.bytesCache[n3++] = (byte)(0x80 | c2 >> 0 & 0x3F);
        }
        nArray[0] = n3;
        return this.bytesCache;
    }

    public void encode(InputStream inputStream, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = inputStream.read(this.bytesCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.charsCache[i2] = (char)(this.bytesCache[i2] & 0xFF);
                }
                outputStreamWriter.write(this.charsCache, 0, n4);
                n2 -= n4;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = reader.read(this.charsCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                outputStreamWriter.write(this.charsCache, 0, n4);
                n2 -= n4;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    private int _decode(byte[] byArray, int n2, int n3, char[] cArray) throws UtilException {
        int n4 = 0;
        int n5 = 0;
        block5: while (n5 < n3 && n4 < cArray.length) {
            int n6 = byArray[n5 + n2] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n5;
                    cArray[n4++] = (char)n6;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n5 += 2) > n3) {
                        throw UtilException.createTransliterationFailedException("invalid UTF8 data");
                    }
                    byte by2 = byArray[n2 + n5 - 1];
                    if ((by2 & 0xC0) != 128) {
                        throw UtilException.createTransliterationFailedException("invalid UTF8 data");
                    }
                    cArray[n4++] = (char)((n6 & 0x1F) << 6 | by2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((n5 += 3) > n3) {
                        throw UtilException.createTransliterationFailedException("invalid UTF8 data");
                    }
                    byte by2 = byArray[n2 + n5 - 2];
                    byte by3 = byArray[n2 + n5 - 1];
                    if ((by2 & 0xC0) != 128 || (by3 & 0xC0) != 128) {
                        throw UtilException.createTransliterationFailedException("invalid UTF8 data");
                    }
                    cArray[n4++] = (char)((n6 & 0xF) << 12 | (by2 & 0x3F) << 6 | (by3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw UtilException.createTransliterationFailedException("invalid UTF8 data");
        }
        return n4;
    }

    public String decode(byte[] byArray, int n2, int n3) throws UtilException {
        if (n3 == 0) {
            return EMPTY_STRING;
        }
        this.setCacheSize(n3);
        int n4 = this._decode(byArray, n2, n3, this.charsCache);
        return new String(this.charsCache, 0, n4);
    }

    public int decode(byte[] byArray, int n2, int n3, char[] cArray) throws UtilException {
        if (n3 == 0) {
            return 0;
        }
        return this._decode(byArray, n2, n3, cArray);
    }

    public String decode(byte[] byArray, int n2, int n3, int n4) throws UtilException {
        int n5;
        int n6 = Math.max(n3, n4);
        this.setCacheSize(n6);
        for (int i2 = n5 = this._decode(byArray, n2, n3, this.charsCache); i2 < n4; ++i2) {
            this.charsCache[i2] = 32;
        }
        return new String(this.charsCache, 0, n4);
    }

    public Reader decodeAsReader(InputStream inputStream) throws UtilException {
        try {
            return new InputStreamReader(inputStream, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, this.encoding);
        }
    }
}

