/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.ssp;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import macromedia.sequelink.net.NetInputStream;
import macromedia.sequelink.net.NetOutputStream;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.net.Session;
import macromedia.sequelink.ssp.CodecChainedPacket;
import macromedia.sequelink.ssp.CodecFreeVariables;
import macromedia.sequelink.ssp.CodecGetDiagnostic;
import macromedia.sequelink.ssp.Diagnostic;
import macromedia.sequelink.ssp.DiagnosticList;
import macromedia.sequelink.ssp.Message;
import macromedia.sequelink.ssp.Ssp;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.sequelink.ssp.SspOutputStream;
import macromedia.sequelink.util.UnSyncVector;
import macromedia.slutil.UtilException;

public class Chain {
    int version;
    int sspError;
    Session netSession;
    SspOutputStream sos;
    SspInputStream sis;
    UnSyncVector codecs = new UnSyncVector();
    DiagnosticList diagnosticList;
    Ssp ssp;
    private boolean pendingRequest;
    private static final boolean ERROR = true;
    private static final boolean WARNING = false;

    Chain(Ssp ssp, int n2) {
        this.netSession = ssp.getNetworkSession();
        this.sis = ssp.getSspInputStream();
        this.sos = ssp.getSspOutputStream();
        this.ssp = ssp;
        this.version = n2;
    }

    public final void add(CodecChainedPacket codecChainedPacket) {
        this.codecs.addElement(codecChainedPacket);
    }

    public final void removeAllCodecs() {
        this.codecs.removeAllElements();
    }

    public final void flush(DiagnosticList diagnosticList) throws SQLException {
        if (!this.codecs.isEmpty()) {
            this.send(diagnosticList);
        }
    }

    public void send(DiagnosticList diagnosticList) throws SQLException {
        if (this.pendingRequest) {
            throw new SQLException("Connection is busy processing data");
        }
        this.diagnosticList = diagnosticList;
        boolean bl2 = false;
        NetInputStream netInputStream = null;
        try {
            try {
                bl2 = false;
                NetOutputStream netOutputStream = this.netSession.getNetOutputStream();
                this.sos.setOutputStream(netOutputStream);
                this.encode();
                this.netSession.request(netOutputStream);
                bl2 = true;
                netInputStream = this.netSession.reply();
                this.sis.setInputStream(netInputStream);
                this.decode();
            }
            catch (IOException iOException) {
                if (bl2) {
                    throw Diagnostic.ClientCoreError(7365);
                }
                throw Diagnostic.ClientCoreError(7364);
            }
            catch (NetworkException networkException) {
                throw networkException.toSqlException();
            }
            catch (UtilException utilException) {
                SQLException sQLException = Message.Gen.getSqlException(7452);
                Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
                throw sQLException;
            }
            Object var7_8 = null;
            this.codecs.removeAllElements();
            if (netInputStream != null) {
                netInputStream.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.codecs.removeAllElements();
            if (netInputStream != null) {
                netInputStream.close();
            }
            throw throwable;
        }
    }

    public void encodeAndSend(DiagnosticList diagnosticList) throws SQLException {
        this.diagnosticList = diagnosticList;
        try {
            NetOutputStream netOutputStream = this.netSession.getNetOutputStream();
            this.sos.setOutputStream(netOutputStream);
            this.encode();
            this.netSession.request(netOutputStream);
            this.pendingRequest = true;
        }
        catch (IOException iOException) {
            throw Diagnostic.ClientCoreError(7364);
        }
        catch (NetworkException networkException) {
            throw networkException.toSqlException();
        }
        catch (UtilException utilException) {
            SQLException sQLException = Message.Gen.getSqlException(7452);
            Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
            throw sQLException;
        }
    }

    public void receiveAndDecode(DiagnosticList diagnosticList) throws SQLException {
        this.diagnosticList = diagnosticList;
        NetInputStream netInputStream = null;
        try {
            try {
                netInputStream = this.netSession.reply();
                this.sis.setInputStream(netInputStream);
                this.decode();
            }
            catch (IOException iOException) {
                throw Diagnostic.ClientCoreError(7365);
            }
            catch (NetworkException networkException) {
                throw networkException.toSqlException();
            }
            catch (UtilException utilException) {
                SQLException sQLException = Message.Gen.getSqlException(7452);
                Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
                throw sQLException;
            }
            Object var6_3 = null;
            this.codecs.removeAllElements();
            if (netInputStream != null) {
                netInputStream.close();
            }
            this.pendingRequest = false;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.codecs.removeAllElements();
            if (netInputStream != null) {
                netInputStream.close();
            }
            this.pendingRequest = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardPending() {
        NetInputStream netInputStream = null;
        try {
            try {
                netInputStream = this.netSession.reply();
            }
            catch (NetworkException networkException) {
                Object var4_3 = null;
                if (netInputStream != null) {
                    netInputStream.close();
                }
                this.pendingRequest = false;
            }
            Object var4_2 = null;
            if (netInputStream != null) {
                netInputStream.close();
            }
            this.pendingRequest = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (netInputStream != null) {
                netInputStream.close();
            }
            this.pendingRequest = false;
            throw throwable;
        }
    }

    public boolean isLastCodecFreeVariables(int n2) {
        if (this.codecs.isEmpty()) {
            return false;
        }
        CodecChainedPacket codecChainedPacket = (CodecChainedPacket)this.codecs.lastElement();
        return codecChainedPacket instanceof CodecFreeVariables && ((CodecFreeVariables)codecChainedPacket).kind == n2;
    }

    private void encode() throws IOException, SQLException, UtilException {
        this.sos.writeSSPFullInt32(this.version);
        this.sos.writeSSPFullInt32(2);
        if (this.codecs == null || this.codecs.isEmpty()) {
            throw new IOException();
        }
        int n2 = this.codecs.size();
        this.sos.writeSSPFullInt32(n2);
        CodecChainedPacket codecChainedPacket = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            codecChainedPacket = (CodecChainedPacket)this.codecs.elementAt(i2);
            codecChainedPacket.sos = this.sos;
            codecChainedPacket.encode();
            this.sos.writeSSPEnum(-52);
        }
    }

    private void decode() throws IOException, SQLException, UtilException {
        this.version = this.sis.readSSPFullInt32();
        if (this.version < 6) {
            throw Diagnostic.ClientCoreError(7361);
        }
        this.sspError = this.sis.readSSPFullInt32();
        switch (this.sspError) {
            case 0: 
            case 1: 
            case 2: {
                this.decodeBody();
                break;
            }
            case 3: {
                String string = this.sis.readSSPString();
                throw Diagnostic.ClientCoreError(7363, string);
            }
            case 4: {
                throw Diagnostic.ClientCoreError(7362);
            }
            default: {
                throw Diagnostic.ClientCoreError(7366);
            }
        }
    }

    private void decodeBody() throws IOException, SQLException, UtilException {
        int n2;
        try {
            n2 = this.sis.readSSPFullInt32();
        }
        catch (IOException iOException) {
            return;
        }
        if (n2 < 1) {
            throw Diagnostic.ClientCoreError(7366);
        }
        int n3 = this.sis.readSSPFullInt32();
        if (this.sspError == 2 && (n3 < 0 || n3 > n2)) {
            throw Diagnostic.ClientCoreError(7366);
        }
        block5: for (int i2 = 1; i2 <= n2; ++i2) {
            int n4 = this.sspError == 2 && i2 == n3 ? this.sspError : 0;
            int n5 = this.sis.readSSPUInt32();
            switch (n5) {
                default: {
                    CodecChainedPacket codecChainedPacket = (CodecChainedPacket)this.codecs.elementAt(0);
                    if (codecChainedPacket.sspCall != n5) {
                        throw Diagnostic.ClientCoreError(7366);
                    }
                    codecChainedPacket.sspError = n4;
                    codecChainedPacket.sis = this.sis;
                    codecChainedPacket.decode();
                    this.codecs.removeElementAt(0);
                    if (n4 != 2) continue block5;
                    n5 = this.sis.readSSPUInt32();
                    if (n5 != 11) {
                        throw Diagnostic.ClientCoreError(7366);
                    }
                    this.decodeDiagnostic(true);
                    continue block5;
                }
                case 11: {
                    this.decodeDiagnostic(false);
                }
            }
        }
    }

    private void decodeDiagnostic(boolean bl2) throws IOException, SQLException, UtilException {
        CodecGetDiagnostic codecGetDiagnostic = new CodecGetDiagnostic();
        codecGetDiagnostic.sspError = 0;
        codecGetDiagnostic.sis = this.sis;
        codecGetDiagnostic.decode();
        if (bl2) {
            throw this.cnvDiagnostics(codecGetDiagnostic.getDiagnostics(), true);
        }
        this.addWarningDiagnostics(codecGetDiagnostic.getDiagnostics());
    }

    private void addWarningDiagnostics(Diagnostic[] diagnosticArray) {
        for (int i2 = 0; i2 < diagnosticArray.length; ++i2) {
            this.diagnosticList.add(diagnosticArray[i2]);
        }
    }

    private SQLException cnvDiagnostics(Diagnostic[] diagnosticArray, boolean bl2) throws SQLException {
        int n2 = diagnosticArray.length;
        if (n2 == 0) {
            throw Diagnostic.ClientCoreError(7370);
        }
        SQLException sQLException = null;
        SQLException sQLException2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            SQLException sQLException3;
            if (!bl2) {
                sQLException3 = diagnosticArray[i2].toSQLWarning();
                if (i2 == 0) {
                    sQLException = sQLException3;
                } else {
                    ((SQLWarning)sQLException2).setNextWarning((SQLWarning)sQLException3);
                }
                sQLException2 = sQLException3;
                continue;
            }
            sQLException3 = diagnosticArray[i2].toSQLException();
            if (i2 == 0) {
                sQLException = sQLException3;
            } else {
                sQLException2.setNextException(sQLException3);
            }
            sQLException2 = sQLException3;
        }
        return sQLException;
    }
}

