/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.OutputStream;
import macromedia.sequelink.net.NetMessage;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.net.SPDUEncoder;

public class SPDU {
    public static final int kCONNECT = 1;
    public static final int kACCEPT = 2;
    public static final int kREFUSE = 3;
    public static final int kSINGLE = 4;
    public static final int kBEGIN = 5;
    public static final int kMIDDLE = 6;
    public static final int kEND = 7;
    public static final int kGT = 8;
    public static final int kND = 9;
    public static final int kSINGLE_GDT = 10;
    public static final int kEND_GDT = 11;
    public static final int kUABORT = 12;
    public static final int kPABORT = 13;
    public static final int kABORTACC = 14;
    public static final int kFINISH = 15;
    public static final int kDISC = 16;
    public static final int kNOTFIN = 17;
    public static final int kPT = 18;
    public static final int kEXPDATA = 19;
    public static final int kTYPEDATA = 20;
    public static final int kEXCDATA = 21;
    public static final int kEXCRPT = 22;
    public static final int kFUREQ_HALFDUPLEX = 1;
    public static final int kFUREQ_FULLDUPLEX = 2;
    public static final int kFUREQ_EXPEDITED = 4;
    public static final int kFUREQ_NEGOTIATED = 8;
    public static final int kFUREQ_EXCEPTION = 16;
    public static final int kFUREQ_TYPEDATA = 32;
    public static final int kFUREQ_DEFAULT = 53;
    public static final int kPROTO_NOOPT = 0;
    public static final int kPROTO_TRANSPORT = 2;
    public static final int kPROTO_INTERRUPT = 4;
    public static final int kPROTO_DEAD = 8;
    public static final int kPROTO_DEFAULT = 14;
    private static final int kSELECTORLEN = 6;
    private byte[] sessionKey;
    private int sessionKeyLen;
    private int spduType;

    SPDU(int n2) throws NetworkException {
        this.validateSpduType(n2);
        this.spduType = n2;
        this.sessionKey = new byte[0];
        this.sessionKeyLen = 0;
    }

    SPDU(int n2, byte[] byArray) throws NetworkException {
        this.validateSpduType(n2);
        this.spduType = n2;
        this.sessionKey = byArray;
        this.sessionKeyLen = byArray.length;
    }

    public int getSpduType() {
        return this.spduType;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public int encode(OutputStream outputStream) throws NetworkException {
        SPDUEncoder sPDUEncoder = new SPDUEncoder(outputStream, this);
        return sPDUEncoder.size();
    }

    public String getTokenString() {
        switch (this.spduType) {
            case 1: {
                return "CONNECT";
            }
            case 2: {
                return "ACCEPT";
            }
            case 3: {
                return "REFUSE";
            }
            case 4: {
                return "SINGLE";
            }
            case 5: {
                return "BEGIN";
            }
            case 6: {
                return "MIDDLE";
            }
            case 7: {
                return "END";
            }
            case 8: {
                return "GT";
            }
            case 9: {
                return "ND";
            }
            case 10: {
                return "SINGLE_GDT";
            }
            case 11: {
                return "END_GDT";
            }
            case 12: {
                return "UABORT";
            }
            case 13: {
                return "PABORT";
            }
            case 14: {
                return "ABORTACC";
            }
            case 15: {
                return "FINISH";
            }
            case 16: {
                return "DISC";
            }
            case 17: {
                return "NOTFIN";
            }
            case 18: {
                return "PT";
            }
            case 19: {
                return "EXPDATA";
            }
            case 20: {
                return "TYPEDATA";
            }
            case 21: {
                return "EXCDATA";
            }
            case 22: {
                return "EXCRPT";
            }
        }
        return "UNKNOWN TOKEN";
    }

    private void validateSpduType(int n2) throws NetworkException {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            default: {
                throw SPDU.getException(7571);
            }
        }
    }

    protected void validateSelector(byte[] byArray) throws NetworkException {
        if (byArray.length != 6 && byArray.length != 0) {
            throw SPDU.getException(7572);
        }
    }

    public static NetworkException getException(int n2) {
        return NetMessage.Message.getNetworkException(n2);
    }

    public static NetworkException getException(int n2, String string) {
        return NetMessage.Message.getNetworkException(n2, string);
    }
}

