/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.jdbc;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import macromedia.sequelink.ctxt.CtxtAttributes;
import macromedia.sequelink.net.EndPointUtilities;
import macromedia.sequelink.ssp.AttribList;
import macromedia.sequelink.ssp.Message;

public final class ConnectAttributes
implements CtxtAttributes {
    public static final String CIPHERSUITES = "CIPHERSUITES";
    public static final String CERTIFICATECHECKER = "CERTIFICATECHECKER";
    public static final String SEQUELINKLOGFILE = "SEQUELINKLOGFILE";
    public static final String IIOPOBJECTKEY = "IIOPOBJECTKEY";
    public static final String IIOPOPERATIONTARGET = "IIOPOPERATIONTARGET";
    public static final String ENCRYPTED = "ENCRYPTED";
    public static final String JBM_MINBUFFERSIZE = "JBM_MINBUFFERSIZE";
    public static final String JBM_SIZEINCREMENT = "JBM_SIZEINCREMENT";
    public static final String JBM_INITIALPOOLSIZE = "JBM_INITIALPOOLSIZE";
    public static final String JBM_MAXPOOLSIZE = "JBM_MAXPOOLSIZE";
    private Properties attributes = new Properties();
    private String url;
    private Properties info;

    public ConnectAttributes() {
    }

    public ConnectAttributes(String string, Properties properties) throws SQLException {
        this.url = string;
        this.info = properties;
        this.decodeURL();
        this.overrideWithParamProperties();
    }

    public String getUrl() {
        return this.url;
    }

    public DriverPropertyInfo[] getPropertyInfo() throws SQLException {
        if (this.getServerName() != null && this.getPortNumber() != null) {
            return new DriverPropertyInfo[0];
        }
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[24];
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("DATABASENAME", this.getDatabaseName());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.databaseName");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[0] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("PASSWORD", this.getPassword());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.password");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[1] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("PORTNUMBER", this.getPortNumber());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.portNumber");
        driverPropertyInfo.required = true;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[2] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("SERVERNAME", this.getServerName());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.serverName");
        driverPropertyInfo.required = true;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[3] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("USER", this.getUser());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.user");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[4] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("DBUSER", this.getDBUser());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.DBUser");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[5] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("DBPASSWORD", this.getDBPassword());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.DBPassword");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[6] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("SERVERDATASOURCE", this.getServerDataSource());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.serverDataSource");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[7] = driverPropertyInfo;
        Integer n2 = this.getBlockFetchForUpdate();
        driverPropertyInfo = n2 == null ? new DriverPropertyInfo("BLOCKFETCHFORUPDATE", null) : new DriverPropertyInfo("BLOCKFETCHFORUPDATE", n2.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.blockFetchForUpdate");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[8] = driverPropertyInfo;
        n2 = this.getAllowPrefetch();
        driverPropertyInfo = n2 == null ? new DriverPropertyInfo("ALLOWPREFETCH", null) : new DriverPropertyInfo("ALLOWPREFETCH", n2.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.allowPrefetch");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[9] = driverPropertyInfo;
        n2 = this.getSLKStaticCursorLongColBuffLen();
        driverPropertyInfo = n2 == null ? new DriverPropertyInfo("SLKSTATICCURSORLONGCOLBUFFLEN", null) : new DriverPropertyInfo("SLKSTATICCURSORLONGCOLBUFFLEN", n2.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.SLKStaticCursorLongColBuffLen");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[10] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("HUSER", this.getHUser());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.HUser");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[11] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("HPASSWORD", this.getHPassword());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.HPassword");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[12] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("NEWPASSWORD", this.getNewPassword());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.newPassword");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[13] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("NETWORKPROTOCOL", this.getNetworkProtocol());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.networkProtocol");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[14] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo(CIPHERSUITES, this.getCipherSuites());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.cipherSuites");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[15] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo(CERTIFICATECHECKER, this.getCertificateCheck());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.certificateChecker");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[16] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo(IIOPOBJECTKEY, this.getIIOPObjectKey());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.IIOPObjectKey");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[17] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo(IIOPOPERATIONTARGET, this.getIIOPOperationTarget());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.IIOPOperationTarget");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[18] = driverPropertyInfo;
        n2 = this.getORANumber0IsNumeric();
        driverPropertyInfo = n2 == null ? new DriverPropertyInfo("ORANUMBER0ISNUMERIC", null) : new DriverPropertyInfo("ORANUMBER0ISNUMERIC", n2.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.ORANumber0IsNumeric");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[19] = driverPropertyInfo;
        n2 = this.getMSSMapLongToDecimal();
        driverPropertyInfo = n2 == null ? new DriverPropertyInfo("MSSMAPLONGTODECIMAL", null) : new DriverPropertyInfo("MSSMAPLONGTODECIMAL", n2.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.MSSMapLongToDecimal");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[20] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("APPLICATIONNAME", this.getApplicationName());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.applicationName");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[21] = driverPropertyInfo;
        n2 = this.getTransliterationWorkaroundServer();
        driverPropertyInfo = n2 == null ? new DriverPropertyInfo("TRANSLITERATIONWASERVER", null) : new DriverPropertyInfo("TRANSLITERATIONWASERVER", n2.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.transliterationWorkaroundServer");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[22] = driverPropertyInfo;
        n2 = this.getEncrypted();
        driverPropertyInfo = n2 == null ? new DriverPropertyInfo(ENCRYPTED, null) : new DriverPropertyInfo(ENCRYPTED, n2.toString());
        driverPropertyInfo.description = Message.Gen.getMessage("msg.srvc.encrypted");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = null;
        driverPropertyInfoArray[23] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    public AttribList getSDSAttributes() {
        AttribList attribList = new AttribList();
        if (this.getDatabaseName() == null) {
            attribList.addInteger(1, 36);
        }
        if (this.getBlockFetchForUpdate() == null) {
            attribList.addInteger(1, 72);
        }
        if (this.getSLKStaticCursorLongColBuffLen() == null) {
            attribList.addInteger(1, 70);
        }
        if (this.getORANumber0IsNumeric() == null) {
            attribList.addInteger(1, 173);
        }
        if (this.getMSSMapLongToDecimal() == null) {
            attribList.addInteger(1, 174);
        }
        return attribList;
    }

    public AttribList getSDSAttributes54(AttribList attribList) {
        if (this.getAllowPrefetch() == null) {
            attribList.addInteger(1, 245);
        }
        attribList.addInteger(1, 237);
        return attribList;
    }

    public AttribList getSDSAttributes54Only(AttribList attribList) {
        attribList.addInteger(1, 239);
        return attribList;
    }

    public void setSDSAttributes(AttribList attribList) {
        String string = attribList.getStringValue(36);
        if (this.getDatabaseName() == null && string != null && string.length() != 0) {
            this.setDatabaseName(string);
        }
        Integer n2 = attribList.getIntegerValue(72);
        if (this.getBlockFetchForUpdate() == null && n2 != null) {
            this.setBlockFetchForUpdate(n2);
        }
        n2 = attribList.getIntegerValue(70);
        if (this.getSLKStaticCursorLongColBuffLen() == null && n2 != null) {
            this.setSLKStaticCursorLongColBuffLen(n2);
        }
        n2 = attribList.getIntegerValue(173);
        if (this.getORANumber0IsNumeric() == null && n2 != null) {
            this.setORANumber0IsNumeric(n2);
        }
        n2 = attribList.getIntegerValue(174);
        if (this.getMSSMapLongToDecimal() == null && n2 != null) {
            this.setMSSMapLongToDecimal(n2);
        }
    }

    public void setSDSAttributes54(AttribList attribList) {
        Integer n2;
        Boolean bl2 = attribList.getBooleanValue(245);
        if (this.getAllowPrefetch() == null && bl2 != null) {
            n2 = new Integer(bl2 != false ? 1 : 0);
            this.setAllowPrefetch(n2);
        }
        if ((n2 = attribList.getIntegerValue(237)) != null) {
            this.setTransliterationWorkaroundServer(n2);
        }
    }

    public void setSDSAttributes54Only(AttribList attribList) {
        Integer n2 = attribList.getIntegerValue(239);
        if (n2 != null) {
            this.setWABadDescribeParam54(n2);
        }
    }

    public String getDatabaseName() {
        return this.getAttribute("DATABASENAME");
    }

    public void setDatabaseName(String string) {
        this.setAttribute("DATABASENAME", string);
    }

    public String getNetworkProtocol() {
        String string = this.getAttribute("NETWORKPROTOCOL");
        if (string == null) {
            string = "socket";
        }
        return string;
    }

    public void setNetworkProtocol(String string) {
        this.setAttribute("NETWORKPROTOCOL", string);
    }

    public String getPassword() {
        return this.getAttribute("PASSWORD");
    }

    public void setPassword(String string) {
        this.setAttribute("PASSWORD", string);
    }

    public String getPortNumber() {
        return this.getAttribute("PORTNUMBER");
    }

    public int getPortNumberAsInt() {
        String string = this.getAttribute("PORTNUMBER");
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public void setPortNumber(String string) {
        this.setAttribute("PORTNUMBER", string);
    }

    public String getServerName() {
        return this.getAttribute("SERVERNAME");
    }

    public void setServerName(String string) {
        this.setAttribute("SERVERNAME", string);
    }

    public String getUser() {
        return this.getAttribute("USER");
    }

    public void setUser(String string) {
        this.setAttribute("USER", string);
    }

    public String getServerDataSource() {
        return this.getAttribute("SERVERDATASOURCE");
    }

    public void setServerDataSource(String string) {
        this.setAttribute("SERVERDATASOURCE", string);
    }

    public Integer getBlockFetchForUpdate() {
        return this.getIntegerAttribute("BLOCKFETCHFORUPDATE");
    }

    public void setBlockFetchForUpdate(Integer n2) {
        this.setIntegerAttribute("BLOCKFETCHFORUPDATE", n2);
    }

    public Integer getAllowPrefetch() {
        return this.getIntegerAttribute("ALLOWPREFETCH");
    }

    public void setAllowPrefetch(Integer n2) {
        this.setIntegerAttribute("ALLOWPREFETCH", n2);
    }

    public Integer getSLKStaticCursorLongColBuffLen() {
        return this.getIntegerAttribute("SLKSTATICCURSORLONGCOLBUFFLEN");
    }

    public void setSLKStaticCursorLongColBuffLen(Integer n2) {
        this.setIntegerAttribute("SLKSTATICCURSORLONGCOLBUFFLEN", n2);
    }

    public Integer getORANumber0IsNumeric() {
        return this.getIntegerAttribute("ORANUMBER0ISNUMERIC");
    }

    public void setORANumber0IsNumeric(Integer n2) {
        this.setIntegerAttribute("ORANUMBER0ISNUMERIC", n2);
    }

    public Integer getMSSMapLongToDecimal() {
        return this.getIntegerAttribute("MSSMAPLONGTODECIMAL");
    }

    public void setMSSMapLongToDecimal(Integer n2) {
        this.setIntegerAttribute("MSSMAPLONGTODECIMAL", n2);
    }

    public String getApplicationName() {
        return this.getAttribute("APPLICATIONNAME");
    }

    public Integer getTransliterationWorkaroundServer() {
        return this.getIntegerAttribute("TRANSLITERATIONWASERVER");
    }

    public void setTransliterationWorkaroundServer(Integer n2) {
        this.setIntegerAttribute("TRANSLITERATIONWASERVER", n2);
    }

    public Integer getWABadDescribeParam54() {
        return this.getIntegerAttribute("WABADDESCRIBEPARAM54");
    }

    public void setWABadDescribeParam54(Integer n2) {
        this.setIntegerAttribute("WABADDESCRIBEPARAM54", n2);
    }

    public String getDBUser() {
        return this.getAttribute("DBUSER");
    }

    public void setDBUser(String string) {
        this.setAttribute("DBUSER", string);
    }

    public String getDBPassword() {
        return this.getAttribute("DBPASSWORD");
    }

    public void setDBPassword(String string) {
        this.setAttribute("DBPASSWORD", string);
    }

    public String getHUser() {
        return this.getAttribute("HUSER");
    }

    public void setHUser(String string) {
        this.setAttribute("HUSER", string);
    }

    public String getHPassword() {
        return this.getAttribute("HPASSWORD");
    }

    public void setHPassword(String string) {
        this.setAttribute("HPASSWORD", string);
    }

    public String getNewPassword() {
        return this.getAttribute("NEWPASSWORD");
    }

    public void setNewPassword(String string) {
        this.setAttribute("NEWPASSWORD", string);
    }

    public String getCipherSuites() {
        return this.attributes.getProperty(CIPHERSUITES);
    }

    public void setCipherSuites(String string) {
        this.setAttribute(CIPHERSUITES, string);
    }

    public String getCertificateCheck() {
        return this.attributes.getProperty(CERTIFICATECHECKER);
    }

    public void setCertificateCheck(String string) {
        this.setAttribute(CERTIFICATECHECKER, string);
    }

    public String getSequeLinkLogFile() {
        return this.attributes.getProperty(SEQUELINKLOGFILE);
    }

    public void setSequeLinkLogFile(String string) {
        this.setAttribute(SEQUELINKLOGFILE, string);
    }

    public String getIIOPObjectKey() {
        return this.attributes.getProperty(IIOPOBJECTKEY);
    }

    public void setIIOPObjectKey(String string) {
        this.setAttribute(IIOPOBJECTKEY, string);
    }

    public String getIIOPOperationTarget() {
        return this.attributes.getProperty(IIOPOPERATIONTARGET);
    }

    public void setIIOPOperationTarget(String string) {
        this.setAttribute(IIOPOPERATIONTARGET, string);
    }

    public String getSSLDebug() {
        return null;
    }

    public String getSSLVersions() {
        return null;
    }

    public Integer getEncrypted() {
        return this.getIntegerAttribute(ENCRYPTED);
    }

    public void setEncrypted() {
        this.setNetworkProtocol("SSL");
        String string = "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5,SSL_DH_anon_WITH_RC4_128_MD5,SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA,SSL_DH_anon_WITH_DES_CBC_SHA,SSL_DH_anon_WITH_3DES_EDE_CBC_SHA,TLS_DH_anon_WITH_AES_128_CBC_SHA,TLS_DH_anon_WITH_AES_256_CBC_SHA";
        this.setCipherSuites(string);
        this.setCertificateCheck(null);
    }

    public int getJBM_MinBufferSize() {
        return this.getIntAttribute(JBM_MINBUFFERSIZE);
    }

    public void setJBM_MinBufferSize(int n2) {
        this.setIntegerAttribute(JBM_MINBUFFERSIZE, n2);
    }

    public int getJBM_SizeIncrement() {
        return this.getIntAttribute(JBM_SIZEINCREMENT);
    }

    public void setJBM_SizeIncrement(int n2) {
        this.setIntegerAttribute(JBM_SIZEINCREMENT, n2);
    }

    public int getInitialPoolSize() {
        return this.getIntAttribute(JBM_INITIALPOOLSIZE);
    }

    public void setInitialPoolSize(int n2) {
        this.setIntegerAttribute(JBM_INITIALPOOLSIZE, n2);
    }

    public int getJBM_MaxPoolSize() {
        return this.getIntAttribute(JBM_MAXPOOLSIZE);
    }

    public void setJBM_MaxPoolSize(int n2) {
        this.setIntegerAttribute(JBM_MAXPOOLSIZE, n2);
    }

    public String getAttribute(String string) {
        return this.attributes.getProperty(string);
    }

    public void setAttribute(String string, String string2) {
        if (ENCRYPTED.equals(string) && "1".equals(string2)) {
            this.setEncrypted();
            return;
        }
        if (string2 != null) {
            this.attributes.put(string.toUpperCase(), string2);
        }
    }

    public int getIntAttribute(String string) {
        String string2 = this.getAttribute(string);
        if (string2 == null) {
            return 0;
        }
        return Integer.parseInt(this.getAttribute(string));
    }

    public Integer getIntegerAttribute(String string) {
        String string2 = this.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        return new Integer(string2);
    }

    private void setIntegerAttribute(String string, int n2) {
        this.setAttribute(string, new Integer(n2).toString());
    }

    private void setIntegerAttribute(String string, Integer n2) {
        this.setAttribute(string, n2.toString());
    }

    private void setBooleanAttribute(String string, Boolean bl2) {
        this.setAttribute(string, bl2.toString());
    }

    public Boolean getBooleanAttribute(String string) {
        String string2 = this.getAttribute(string);
        if (string2 == null) {
            return null;
        }
        return "true".equalsIgnoreCase(string2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public void checkComplete() throws SQLException {
        if (this.getServerName() == null || this.getPortNumber() == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getServerName() == null) {
                stringBuffer.append("SERVERNAME");
                stringBuffer.append(" ");
            }
            if (this.getPortNumber() == null) {
                stringBuffer.append("PORTNUMBER");
            }
            throw Message.Gen.getSqlException(7397, stringBuffer.toString());
        }
    }

    private void decodeURL() throws SQLException {
        String string;
        int n2;
        String string2 = "jdbc:sequelink:";
        int n3 = string2.length();
        if (!string2.regionMatches(0, this.url, 0, n3)) {
            throw this.urlNotAccepted();
        }
        String string3 = this.url.substring(n3);
        if ("".equals(string3)) {
            return;
        }
        if (!string3.startsWith("//")) {
            n2 = string3.indexOf(58);
            if (n2 == -1) {
                throw this.urlNotAccepted();
            }
            string = string3.substring(0, n2);
            if (!EndPointUtilities.IsNetworkName(string)) {
                throw this.urlNotAccepted();
            }
            this.attributes.put("NETWORKPROTOCOL", string);
            string3 = string3.substring(n2 + 1);
        }
        if (!string3.startsWith("//")) {
            throw this.urlNotAccepted();
        }
        n2 = string3.indexOf(58);
        if (n2 == -1) {
            throw this.urlNotAccepted();
        }
        this.setServerName(string3.substring(2, n2));
        string3 = string3.substring(n2 + 1);
        if ("".equals(string3)) {
            return;
        }
        n2 = string3.indexOf(";");
        if (n2 == -1) {
            this.setPortNumber(string3);
            return;
        }
        this.setPortNumber(string3.substring(0, n2));
        string3 = string3.substring(n2 + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            n2 = string.indexOf(61);
            if (n2 == -1) continue;
            String string4 = string.substring(0, n2);
            String string5 = string.substring(n2 + 1, string.length());
            this.setAttribute(string4.toUpperCase(), string5);
        }
    }

    private void overrideWithParamProperties() {
        if (this.info != null) {
            Enumeration<?> enumeration = this.info.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = this.info.getProperty(string);
                this.setAttribute(string.toUpperCase(), string2);
            }
        }
    }

    private SQLException urlNotAccepted() {
        return Message.Gen.getSqlException(7396, this.url);
    }
}

