/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.legacy.crypto.qtesla;

import java.security.SecureRandom;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.KeyGenerationParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAKeyGenerationParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAPrivateKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.legacy.crypto.qtesla.QTESLAPublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.legacy.crypto.qtesla.QTESLASecurityCategory;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.legacy.crypto.qtesla.QTesla1p;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.legacy.crypto.qtesla.QTesla3p;

public final class QTESLAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private int securityCategory;
    private SecureRandom secureRandom;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        QTESLAKeyGenerationParameters qTESLAKeyGenerationParameters = (QTESLAKeyGenerationParameters)keyGenerationParameters;
        this.secureRandom = qTESLAKeyGenerationParameters.getRandom();
        this.securityCategory = qTESLAKeyGenerationParameters.getSecurityCategory();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        byte[] byArray = this.allocatePrivate(this.securityCategory);
        byte[] byArray2 = this.allocatePublic(this.securityCategory);
        switch (this.securityCategory) {
            case 5: {
                QTesla1p.generateKeyPair(byArray2, byArray, this.secureRandom);
                break;
            }
            case 6: {
                QTesla3p.generateKeyPair(byArray2, byArray, this.secureRandom);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.securityCategory);
            }
        }
        return new AsymmetricCipherKeyPair(new QTESLAPublicKeyParameters(this.securityCategory, byArray2), new QTESLAPrivateKeyParameters(this.securityCategory, byArray));
    }

    private byte[] allocatePrivate(int n2) {
        return new byte[QTESLASecurityCategory.getPrivateSize(n2)];
    }

    private byte[] allocatePublic(int n2) {
        return new byte[QTESLASecurityCategory.getPublicSize(n2)];
    }
}

