/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.jcajce.provider.saber;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Set;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.jcajce.interfaces.SABERKey;
import macromedia.jdbc.oracle.externals.org.bouncycastle.pqc.jcajce.spec.SABERParameterSpec;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;

public class BCSABERPrivateKey
implements SABERKey,
PrivateKey {
    private static final long serialVersionUID = 1L;
    private transient SABERPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSABERPrivateKey(SABERPrivateKeyParameters sABERPrivateKeyParameters) {
        this.params = sABERPrivateKeyParameters;
    }

    public BCSABERPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (SABERPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSABERPrivateKey) {
            BCSABERPrivateKey bCSABERPrivateKey = (BCSABERPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSABERPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "SABER";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public SABERParameterSpec getParameterSpec() {
        return SABERParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    SABERPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

