/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec;

import java.math.BigInteger;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECConstants;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECCurve;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECFieldElement;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.SimpleBigDecimal;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ZTauElement;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.BigIntegers;

class Tnaf {
    private static final BigInteger MINUS_ONE = ECConstants.ONE.negate();
    private static final BigInteger MINUS_TWO = ECConstants.TWO.negate();
    private static final BigInteger MINUS_THREE = ECConstants.THREE.negate();
    public static final byte WIDTH = 4;
    public static final ZTauElement[] alpha0 = new ZTauElement[]{null, new ZTauElement(ECConstants.ONE, ECConstants.ZERO), null, new ZTauElement(MINUS_THREE, MINUS_ONE), null, new ZTauElement(MINUS_ONE, MINUS_ONE), null, new ZTauElement(ECConstants.ONE, MINUS_ONE), null, new ZTauElement(MINUS_ONE, ECConstants.ONE), null, new ZTauElement(ECConstants.ONE, ECConstants.ONE), null, new ZTauElement(ECConstants.THREE, ECConstants.ONE), null, new ZTauElement(MINUS_ONE, ECConstants.ZERO)};
    public static final byte[][] alpha0Tnaf = new byte[][]{null, {1}, null, {-1, 0, 1}, null, {1, 0, 1}, null, {-1, 0, 0, 1}};
    public static final ZTauElement[] alpha1 = new ZTauElement[]{null, new ZTauElement(ECConstants.ONE, ECConstants.ZERO), null, new ZTauElement(MINUS_THREE, ECConstants.ONE), null, new ZTauElement(MINUS_ONE, ECConstants.ONE), null, new ZTauElement(ECConstants.ONE, ECConstants.ONE), null, new ZTauElement(MINUS_ONE, MINUS_ONE), null, new ZTauElement(ECConstants.ONE, MINUS_ONE), null, new ZTauElement(ECConstants.THREE, MINUS_ONE), null, new ZTauElement(MINUS_ONE, ECConstants.ZERO)};
    public static final byte[][] alpha1Tnaf = new byte[][]{null, {1}, null, {-1, 0, 1}, null, {1, 0, 1}, null, {-1, 0, 0, -1}};

    Tnaf() {
    }

    public static BigInteger norm(byte by2, ZTauElement zTauElement) {
        BigInteger bigInteger = zTauElement.u.multiply(zTauElement.u);
        if (by2 == 1) {
            return zTauElement.v.shiftLeft(1).add(zTauElement.u).multiply(zTauElement.v).add(bigInteger);
        }
        if (by2 == -1) {
            return zTauElement.v.shiftLeft(1).subtract(zTauElement.u).multiply(zTauElement.v).add(bigInteger);
        }
        throw new IllegalArgumentException("mu must be 1 or -1");
    }

    public static SimpleBigDecimal norm(byte by2, SimpleBigDecimal simpleBigDecimal, SimpleBigDecimal simpleBigDecimal2) {
        SimpleBigDecimal simpleBigDecimal3;
        SimpleBigDecimal simpleBigDecimal4 = simpleBigDecimal.multiply(simpleBigDecimal);
        SimpleBigDecimal simpleBigDecimal5 = simpleBigDecimal.multiply(simpleBigDecimal2);
        SimpleBigDecimal simpleBigDecimal6 = simpleBigDecimal2.multiply(simpleBigDecimal2).shiftLeft(1);
        if (by2 == 1) {
            simpleBigDecimal3 = simpleBigDecimal4.add(simpleBigDecimal5).add(simpleBigDecimal6);
        } else if (by2 == -1) {
            simpleBigDecimal3 = simpleBigDecimal4.subtract(simpleBigDecimal5).add(simpleBigDecimal6);
        } else {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        return simpleBigDecimal3;
    }

    public static ZTauElement round(SimpleBigDecimal simpleBigDecimal, SimpleBigDecimal simpleBigDecimal2, byte by2) {
        SimpleBigDecimal simpleBigDecimal3;
        SimpleBigDecimal simpleBigDecimal4;
        int n2 = simpleBigDecimal.getScale();
        if (simpleBigDecimal2.getScale() != n2) {
            throw new IllegalArgumentException("lambda0 and lambda1 do not have same scale");
        }
        if (by2 != 1 && by2 != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigInteger bigInteger = simpleBigDecimal.round();
        BigInteger bigInteger2 = simpleBigDecimal2.round();
        SimpleBigDecimal simpleBigDecimal5 = simpleBigDecimal.subtract(bigInteger);
        SimpleBigDecimal simpleBigDecimal6 = simpleBigDecimal2.subtract(bigInteger2);
        SimpleBigDecimal simpleBigDecimal7 = simpleBigDecimal5.add(simpleBigDecimal5);
        simpleBigDecimal7 = by2 == 1 ? simpleBigDecimal7.add(simpleBigDecimal6) : simpleBigDecimal7.subtract(simpleBigDecimal6);
        SimpleBigDecimal simpleBigDecimal8 = simpleBigDecimal6.add(simpleBigDecimal6).add(simpleBigDecimal6);
        SimpleBigDecimal simpleBigDecimal9 = simpleBigDecimal8.add(simpleBigDecimal6);
        if (by2 == 1) {
            simpleBigDecimal4 = simpleBigDecimal5.subtract(simpleBigDecimal8);
            simpleBigDecimal3 = simpleBigDecimal5.add(simpleBigDecimal9);
        } else {
            simpleBigDecimal4 = simpleBigDecimal5.add(simpleBigDecimal8);
            simpleBigDecimal3 = simpleBigDecimal5.subtract(simpleBigDecimal9);
        }
        int n3 = 0;
        byte by3 = 0;
        if (simpleBigDecimal7.compareTo(ECConstants.ONE) >= 0) {
            if (simpleBigDecimal4.compareTo(MINUS_ONE) < 0) {
                by3 = by2;
            } else {
                n3 = 1;
            }
        } else if (simpleBigDecimal3.compareTo(ECConstants.TWO) >= 0) {
            by3 = by2;
        }
        if (simpleBigDecimal7.compareTo(MINUS_ONE) < 0) {
            if (simpleBigDecimal4.compareTo(ECConstants.ONE) >= 0) {
                by3 = -by2;
            } else {
                n3 = -1;
            }
        } else if (simpleBigDecimal3.compareTo(MINUS_TWO) < 0) {
            by3 = -by2;
        }
        BigInteger bigInteger3 = bigInteger.add(BigInteger.valueOf(n3));
        BigInteger bigInteger4 = bigInteger2.add(BigInteger.valueOf(by3));
        return new ZTauElement(bigInteger3, bigInteger4);
    }

    public static SimpleBigDecimal approximateDivisionByN(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte by2, int n2, int n3) {
        int n4 = (n2 + 5) / 2 + n3;
        BigInteger bigInteger4 = bigInteger.shiftRight(n2 - n4 - 2 + by2);
        BigInteger bigInteger5 = bigInteger2.multiply(bigInteger4);
        BigInteger bigInteger6 = bigInteger5.shiftRight(n2);
        BigInteger bigInteger7 = bigInteger3.multiply(bigInteger6);
        BigInteger bigInteger8 = bigInteger5.add(bigInteger7);
        BigInteger bigInteger9 = bigInteger8.shiftRight(n4 - n3);
        if (bigInteger8.testBit(n4 - n3 - 1)) {
            bigInteger9 = bigInteger9.add(ECConstants.ONE);
        }
        return new SimpleBigDecimal(bigInteger9, n3);
    }

    public static byte[] tauAdicNaf(byte by2, ZTauElement zTauElement) {
        Object object;
        if (by2 != 1 && by2 != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigInteger bigInteger = Tnaf.norm(by2, zTauElement);
        int n2 = bigInteger.bitLength();
        int n3 = n2 > 30 ? n2 + 4 : 34;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        BigInteger bigInteger2 = zTauElement.u;
        BigInteger bigInteger3 = zTauElement.v;
        while (!bigInteger2.equals(ECConstants.ZERO) || !bigInteger3.equals(ECConstants.ZERO)) {
            if (bigInteger2.testBit(0)) {
                byArray[n4] = (byte)ECConstants.TWO.subtract(bigInteger2.subtract(bigInteger3.shiftLeft(1)).mod(ECConstants.FOUR)).intValue();
                bigInteger2 = byArray[n4] == 1 ? bigInteger2.clearBit(0) : bigInteger2.add(ECConstants.ONE);
                n5 = n4;
            } else {
                byArray[n4] = 0;
            }
            object = bigInteger2;
            BigInteger bigInteger4 = bigInteger2.shiftRight(1);
            bigInteger2 = by2 == 1 ? bigInteger3.add(bigInteger4) : bigInteger3.subtract(bigInteger4);
            bigInteger3 = ((BigInteger)object).shiftRight(1).negate();
            ++n4;
        }
        object = new byte[++n5];
        System.arraycopy(byArray, 0, object, 0, n5);
        return object;
    }

    public static ECPoint.AbstractF2m tau(ECPoint.AbstractF2m abstractF2m) {
        return abstractF2m.tau();
    }

    public static byte getMu(ECCurve.AbstractF2m abstractF2m) {
        if (!abstractF2m.isKoblitz()) {
            throw new IllegalArgumentException("No Koblitz curve (ABC), TNAF multiplication not possible");
        }
        if (abstractF2m.getA().isZero()) {
            return -1;
        }
        return 1;
    }

    public static byte getMu(ECFieldElement eCFieldElement) {
        return (byte)(eCFieldElement.isZero() ? -1 : 1);
    }

    public static byte getMu(int n2) {
        return (byte)(n2 == 0 ? -1 : 1);
    }

    public static BigInteger[] getLucas(byte by2, int n2, boolean bl2) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (by2 != 1 && by2 != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        if (bl2) {
            bigInteger2 = ECConstants.TWO;
            bigInteger = BigInteger.valueOf(by2);
        } else {
            bigInteger2 = ECConstants.ZERO;
            bigInteger = ECConstants.ONE;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            BigInteger bigInteger3 = bigInteger;
            if (by2 < 0) {
                bigInteger3 = bigInteger3.negate();
            }
            BigInteger bigInteger4 = bigInteger3.subtract(bigInteger2.shiftLeft(1));
            bigInteger2 = bigInteger;
            bigInteger = bigInteger4;
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    public static BigInteger getTw(byte by2, int n2) {
        if (n2 == 4) {
            if (by2 == 1) {
                return BigInteger.valueOf(6L);
            }
            return BigInteger.valueOf(10L);
        }
        BigInteger[] bigIntegerArray = Tnaf.getLucas(by2, n2, false);
        BigInteger bigInteger = ECConstants.ZERO.setBit(n2);
        BigInteger bigInteger2 = bigIntegerArray[1].modInverse(bigInteger);
        return bigIntegerArray[0].shiftLeft(1).multiply(bigInteger2).mod(bigInteger);
    }

    public static BigInteger[] getSi(ECCurve.AbstractF2m abstractF2m) {
        if (!abstractF2m.isKoblitz()) {
            throw new IllegalArgumentException("si is defined for Koblitz curves only");
        }
        return Tnaf.getSi(abstractF2m.getFieldSize(), abstractF2m.getA().toBigInteger().intValue(), abstractF2m.getCofactor());
    }

    public static BigInteger[] getSi(int n2, int n3, BigInteger bigInteger) {
        byte by2 = Tnaf.getMu(n3);
        int n4 = Tnaf.getShiftsForCofactor(bigInteger);
        int n5 = n2 + 3 - n3;
        BigInteger[] bigIntegerArray = Tnaf.getLucas(by2, n5, false);
        if (by2 == 1) {
            bigIntegerArray[0] = bigIntegerArray[0].negate();
            bigIntegerArray[1] = bigIntegerArray[1].negate();
        }
        BigInteger bigInteger2 = ECConstants.ONE.add(bigIntegerArray[1]).shiftRight(n4);
        BigInteger bigInteger3 = ECConstants.ONE.add(bigIntegerArray[0]).shiftRight(n4).negate();
        return new BigInteger[]{bigInteger2, bigInteger3};
    }

    protected static int getShiftsForCofactor(BigInteger bigInteger) {
        if (bigInteger != null) {
            if (bigInteger.equals(ECConstants.TWO)) {
                return 1;
            }
            if (bigInteger.equals(ECConstants.FOUR)) {
                return 2;
            }
        }
        throw new IllegalArgumentException("h (Cofactor) must be 2 or 4");
    }

    public static ZTauElement partModReduction(ECCurve.AbstractF2m abstractF2m, BigInteger bigInteger, byte by2, byte by3, byte by4) {
        Object object;
        BigInteger bigInteger2;
        int n2 = abstractF2m.getFieldSize();
        BigInteger[] bigIntegerArray = abstractF2m.getSi();
        BigInteger bigInteger3 = by3 == 1 ? bigIntegerArray[0].add(bigIntegerArray[1]) : bigIntegerArray[0].subtract(bigIntegerArray[1]);
        if (abstractF2m.isKoblitz()) {
            bigInteger2 = ECConstants.ONE.shiftLeft(n2).add(ECConstants.ONE).subtract(abstractF2m.getOrder().multiply(abstractF2m.getCofactor()));
        } else {
            object = Tnaf.getLucas(by3, n2, true);
            bigInteger2 = object[1];
        }
        object = Tnaf.approximateDivisionByN(bigInteger, bigIntegerArray[0], bigInteger2, by2, n2, by4);
        SimpleBigDecimal simpleBigDecimal = Tnaf.approximateDivisionByN(bigInteger, bigIntegerArray[1], bigInteger2, by2, n2, by4);
        ZTauElement zTauElement = Tnaf.round((SimpleBigDecimal)object, simpleBigDecimal, by3);
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger3.multiply(zTauElement.u)).subtract(bigIntegerArray[1].multiply(zTauElement.v).shiftLeft(1));
        BigInteger bigInteger5 = bigIntegerArray[1].multiply(zTauElement.u).subtract(bigIntegerArray[0].multiply(zTauElement.v));
        return new ZTauElement(bigInteger4, bigInteger5);
    }

    public static ECPoint.AbstractF2m multiplyRTnaf(ECPoint.AbstractF2m abstractF2m, BigInteger bigInteger) {
        ECCurve.AbstractF2m abstractF2m2 = (ECCurve.AbstractF2m)abstractF2m.getCurve();
        int n2 = abstractF2m2.getA().toBigInteger().intValue();
        byte by2 = Tnaf.getMu(n2);
        ZTauElement zTauElement = Tnaf.partModReduction(abstractF2m2, bigInteger, (byte)n2, by2, (byte)10);
        return Tnaf.multiplyTnaf(abstractF2m, zTauElement);
    }

    public static ECPoint.AbstractF2m multiplyTnaf(ECPoint.AbstractF2m abstractF2m, ZTauElement zTauElement) {
        ECCurve.AbstractF2m abstractF2m2 = (ECCurve.AbstractF2m)abstractF2m.getCurve();
        ECPoint.AbstractF2m abstractF2m3 = (ECPoint.AbstractF2m)abstractF2m.negate();
        byte by2 = Tnaf.getMu(abstractF2m2.getA());
        byte[] byArray = Tnaf.tauAdicNaf(by2, zTauElement);
        return Tnaf.multiplyFromTnaf(abstractF2m, abstractF2m3, byArray);
    }

    public static ECPoint.AbstractF2m multiplyFromTnaf(ECPoint.AbstractF2m abstractF2m, ECPoint.AbstractF2m abstractF2m2, byte[] byArray) {
        ECCurve eCCurve = abstractF2m.getCurve();
        ECPoint.AbstractF2m abstractF2m3 = (ECPoint.AbstractF2m)eCCurve.getInfinity();
        int n2 = 0;
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            ++n2;
            byte by2 = byArray[i2];
            if (by2 == 0) continue;
            abstractF2m3 = abstractF2m3.tauPow(n2);
            n2 = 0;
            ECPoint.AbstractF2m abstractF2m4 = by2 > 0 ? abstractF2m : abstractF2m2;
            abstractF2m3 = (ECPoint.AbstractF2m)abstractF2m3.add(abstractF2m4);
        }
        if (n2 > 0) {
            abstractF2m3 = abstractF2m3.tauPow(n2);
        }
        return abstractF2m3;
    }

    public static byte[] tauAdicWNaf(byte by2, ZTauElement zTauElement, int n2, int n3, ZTauElement[] zTauElementArray) {
        if (by2 != 1 && by2 != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigInteger bigInteger = Tnaf.norm(by2, zTauElement);
        int n4 = bigInteger.bitLength();
        int n5 = n4 > 30 ? n4 + 4 + n2 : 34 + n2;
        byte[] byArray = new byte[n5];
        int n6 = 1 << n2;
        int n7 = n6 - 1;
        int n8 = 32 - n2;
        BigInteger bigInteger2 = zTauElement.u;
        BigInteger bigInteger3 = zTauElement.v;
        int n9 = 0;
        while (bigInteger2.bitLength() > 62 || bigInteger3.bitLength() > 62) {
            if (bigInteger2.testBit(0)) {
                int n10 = bigInteger2.intValue() + bigInteger3.intValue() * n3;
                int n11 = n10 & n7;
                byArray[n9] = (byte)(n10 << n8 >> n8);
                bigInteger2 = bigInteger2.subtract(zTauElementArray[n11].u);
                bigInteger3 = bigInteger3.subtract(zTauElementArray[n11].v);
            }
            ++n9;
            BigInteger bigInteger4 = bigInteger2.shiftRight(1);
            bigInteger2 = by2 == 1 ? bigInteger3.add(bigInteger4) : bigInteger3.subtract(bigInteger4);
            bigInteger3 = bigInteger4.negate();
        }
        long l2 = BigIntegers.longValueExact(bigInteger2);
        long l3 = BigIntegers.longValueExact(bigInteger3);
        while ((l2 | l3) != 0L) {
            if ((l2 & 1L) != 0L) {
                int n12 = (int)l2 + (int)l3 * n3;
                int n13 = n12 & n7;
                byArray[n9] = (byte)(n12 << n8 >> n8);
                l2 -= (long)zTauElementArray[n13].u.intValue();
                l3 -= (long)zTauElementArray[n13].v.intValue();
            }
            ++n9;
            long l4 = l2 >> 1;
            l2 = by2 == 1 ? l3 + l4 : l3 - l4;
            l3 = -l4;
        }
        return byArray;
    }

    public static ECPoint.AbstractF2m[] getPreComp(ECPoint.AbstractF2m abstractF2m, byte by2) {
        ECPoint.AbstractF2m abstractF2m2 = (ECPoint.AbstractF2m)abstractF2m.negate();
        byte[][] byArray = by2 == 0 ? alpha0Tnaf : alpha1Tnaf;
        ECPoint[] eCPointArray = new ECPoint.AbstractF2m[byArray.length + 1 >>> 1];
        eCPointArray[0] = abstractF2m;
        int n2 = byArray.length;
        for (int i2 = 3; i2 < n2; i2 += 2) {
            eCPointArray[i2 >>> 1] = Tnaf.multiplyFromTnaf(abstractF2m, abstractF2m2, byArray[i2]);
        }
        abstractF2m.getCurve().normalizeAll(eCPointArray);
        return eCPointArray;
    }
}

