/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.asymmetric.dsa;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.Hashtable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.digests.SHA256Digest;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.generators.DSAParametersGenerator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.DSAParameterGenerationParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.DSAParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPrivateKey;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPublicKey;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import macromedia.jdbc.oracle.externals.org.bouncycastle.jce.provider.BouncyCastleProvider;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Integers;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Properties;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Hashtable params = new Hashtable();
    private static Object lock = new Object();
    DSAKeyGenerationParameters param;
    DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
    int strength = 2048;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DSA");
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 512 || n2 > 4096 || n2 < 1024 && n2 % 64 != 0 || n2 >= 1024 && n2 % 1024 != 0) {
            throw new InvalidParameterException("strength must be from 512 - 4096 and a multiple of 1024 above 1024");
        }
        DSAParameterSpec dSAParameterSpec = BouncyCastleProvider.CONFIGURATION.getDSADefaultParameters(n2);
        if (dSAParameterSpec != null) {
            this.param = new DSAKeyGenerationParameters(secureRandom, new DSAParameters(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG()));
            this.engine.init(this.param);
            this.initialised = true;
        } else {
            this.strength = n2;
            this.random = secureRandom;
            this.initialised = false;
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
        this.param = new DSAKeyGenerationParameters(secureRandom, new DSAParameters(dSAParameterSpec.getP(), dSAParameterSpec.getQ(), dSAParameterSpec.getG()));
        this.engine.init(this.param);
        this.initialised = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        Object object3;
        if (!this.initialised) {
            object3 = Integers.valueOf(this.strength);
            if (params.containsKey(object3)) {
                this.param = (DSAKeyGenerationParameters)params.get(object3);
            } else {
                object2 = lock;
                synchronized (object2) {
                    if (params.containsKey(object3)) {
                        this.param = (DSAKeyGenerationParameters)params.get(object3);
                    } else {
                        int n2 = PrimeCertaintyCalculator.getDefaultCertainty(this.strength);
                        if (this.strength == 1024) {
                            object = new DSAParametersGenerator();
                            if (Properties.isOverrideSet("org.bouncycastle.dsa.FIPS186-2for1024bits")) {
                                ((DSAParametersGenerator)object).init(this.strength, n2, this.random);
                            } else {
                                DSAParameterGenerationParameters dSAParameterGenerationParameters = new DSAParameterGenerationParameters(1024, 160, n2, this.random);
                                ((DSAParametersGenerator)object).init(dSAParameterGenerationParameters);
                            }
                        } else if (this.strength > 1024) {
                            DSAParameterGenerationParameters dSAParameterGenerationParameters = new DSAParameterGenerationParameters(this.strength, 256, n2, this.random);
                            object = new DSAParametersGenerator(SHA256Digest.newInstance());
                            ((DSAParametersGenerator)object).init(dSAParameterGenerationParameters);
                        } else {
                            object = new DSAParametersGenerator();
                            ((DSAParametersGenerator)object).init(this.strength, n2, this.random);
                        }
                        this.param = new DSAKeyGenerationParameters(this.random, ((DSAParametersGenerator)object).generateParameters());
                        params.put(object3, this.param);
                    }
                }
            }
            this.engine.init(this.param);
            this.initialised = true;
        }
        object3 = this.engine.generateKeyPair();
        object2 = (DSAPublicKeyParameters)((AsymmetricCipherKeyPair)object3).getPublic();
        object = (DSAPrivateKeyParameters)((AsymmetricCipherKeyPair)object3).getPrivate();
        return new KeyPair(new BCDSAPublicKey((DSAPublicKeyParameters)object2), new BCDSAPrivateKey((DSAPrivateKeyParameters)object));
    }
}

