/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CipherParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.CryptoServicesRegistrar;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.Digest;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.agreement.Utils;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ECDomainParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import macromedia.jdbc.oracle.externals.org.bouncycastle.crypto.params.ParametersWithUKM;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECAlgorithms;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;

public class ECVKOAgreement {
    private final Digest digest;
    private ECPrivateKeyParameters key;
    private BigInteger ukm;

    public ECVKOAgreement(Digest digest) {
        this.digest = digest;
    }

    public void init(CipherParameters cipherParameters) {
        ParametersWithUKM parametersWithUKM = (ParametersWithUKM)cipherParameters;
        this.key = (ECPrivateKeyParameters)parametersWithUKM.getParameters();
        this.ukm = new BigInteger(1, Arrays.reverse(parametersWithUKM.getUKM()));
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties("ECVKO", this.key));
    }

    public int getAgreementSize() {
        return this.digest.getDigestSize();
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters cipherParameters) {
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)cipherParameters;
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        if (!eCDomainParameters.equals(eCPublicKeyParameters.getParameters())) {
            throw new IllegalStateException("ECVKO public key has wrong domain parameters");
        }
        BigInteger bigInteger = eCDomainParameters.getH().multiply(this.ukm).multiply(this.key.getD()).mod(eCDomainParameters.getN());
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPublicKeyParameters.getQ());
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECVKO");
        }
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger).normalize();
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECVKO");
        }
        byte[] byArray = eCPoint2.getEncoded(false);
        int n2 = byArray.length;
        int n3 = n2 / 2;
        Arrays.reverseInPlace(byArray, n2 - n3 * 2, n3);
        Arrays.reverseInPlace(byArray, n2 - n3, n3);
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.update(byArray, n2 - n3 * 2, n3 * 2);
        this.digest.doFinal(byArray2, 0);
        return byArray2;
    }
}

