/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.asn1;

import java.io.IOException;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Encodable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1OutputStream;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1Primitive;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1String;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1TaggedObject;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.ASN1UniversalType;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.DERGeneralString;
import macromedia.jdbc.oracle.externals.org.bouncycastle.asn1.DEROctetString;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Arrays;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.Strings;

public abstract class ASN1GeneralString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1GeneralString.class, 27){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1GeneralString.createPrimitive(dEROctetString.getOctets());
        }
    };
    final byte[] contents;

    public static ASN1GeneralString getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof ASN1GeneralString) {
            return (ASN1GeneralString)object;
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1GeneralString) {
            return (ASN1GeneralString)aSN1Primitive;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1GeneralString)TYPE.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1GeneralString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return (ASN1GeneralString)TYPE.getContextInstance(aSN1TaggedObject, bl2);
    }

    ASN1GeneralString(String string) {
        this.contents = Strings.toByteArray(string);
    }

    ASN1GeneralString(byte[] byArray, boolean bl2) {
        this.contents = bl2 ? Arrays.clone(byArray) : byArray;
    }

    @Override
    public final String getString() {
        return Strings.fromByteArray(this.contents);
    }

    public String toString() {
        return this.getString();
    }

    public final byte[] getOctets() {
        return Arrays.clone(this.contents);
    }

    @Override
    final boolean encodeConstructed() {
        return false;
    }

    @Override
    final int encodedLength(boolean bl2) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl2, this.contents.length);
    }

    @Override
    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl2) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl2, 27, this.contents);
    }

    @Override
    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1GeneralString)) {
            return false;
        }
        ASN1GeneralString aSN1GeneralString = (ASN1GeneralString)aSN1Primitive;
        return Arrays.areEqual(this.contents, aSN1GeneralString.contents);
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static ASN1GeneralString createPrimitive(byte[] byArray) {
        return new DERGeneralString(byArray, false);
    }
}

