/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling.mod;

import coldfusion.cfc.CFCProxy;
import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.Array;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CFDateTimeParser;
import coldfusion.runtime.Cast;
import coldfusion.runtime.MetadataUtils;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.scheduling.mod.CronServiceImpl;
import coldfusion.scheduling.mod.CronTask;
import coldfusion.scheduling.mod.CronUtil;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.lang.ScheduleTag;
import coldfusion.tagext.net.HttpTag;
import coldfusion.util.CaseInsensitiveHashtable;
import coldfusion.util.DateUtils;
import coldfusion.util.PasswordUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.quartz.CronScheduleBuilder;
import org.quartz.DailyTimeIntervalScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.TimeOfDay;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.calendar.AnnualCalendar;

public class ScheduleTagData
extends ConfigMap {
    private static final long serialVersionUID = 1L;
    public static final Map MISFIREMAP = new CaseInsensitiveHashtable();
    private String onexception;
    private String chianedtasks;
    private String eventhandler;
    private String eventhandlerrp;
    private String port;
    private String username;
    private String password;
    private String proxyport;
    private String proxyuser;
    private String reqtimeout;
    private String proxypassword;
    private String proxyserver;
    private boolean resolveUrl;
    private String seed;
    private String file;
    private String path;
    private String task;
    private String group = "DEFAULT";
    private Object exclude;
    private String retrycount = "3";
    protected boolean _logFlag = false;
    private JobDetail jobdetail;
    private Trigger trigger;
    private Date starttime;
    private Date endtime = null;
    private String repeat = "-1";
    private String interval;
    private String crontime;
    private String misfire = "";
    private String priority = "5";
    private String appname = CronUtil.getServerName();
    private Date startdate;
    private Date enddate;
    private boolean clustered = false;
    private boolean chained = false;
    private boolean overwrite = true;
    private boolean publish;
    private boolean isValidPublishPath;
    private String url;
    private String remainingCount;
    private Date lastfire;
    private Date nextfire;
    private String mode = "server";
    private boolean encrypted = false;
    private boolean proxypasswordencrypted = false;
    private transient CFCProxy cfcProxy;
    public static final String NOT_STARTED = "0";
    public static final String PAUSED = "Paused";
    public static final String FINISHED = "Expired";
    public static final String RESUMED = "Resumed";
    public static final String ACTIVE = "Running";
    private static final String REPEAT = "repeat";
    private static final String ONMISFIRE = "misfire";
    private static final String ONCOMPLETE = "oncomplete";
    private static final String RETRYCOUNT = "retrycount";
    private static final String STATUS = "status";
    private static final String APPNAME = "appname";
    private static final String MODE = "mode";
    private String status = "0";
    public boolean shouldNotMisfire = false;

    public JobDetail getJobdetail() {
        return this.jobdetail;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setShouldNotMisfire(boolean b) {
        this.shouldNotMisfire = b;
    }

    public Date getStarttime() {
        return this.starttime;
    }

    public void setStarttime(Date starttime) {
        this.starttime = starttime;
        SimpleDateFormat formatter = null;
        String fout = null;
        if (starttime != null) {
            formatter = new SimpleDateFormat("h:mm:ss a", Locale.getDefault(Locale.Category.DISPLAY));
            fout = formatter.format(starttime);
            this.put("start_time", fout);
        }
    }

    public Date getEndtime() {
        return this.endtime;
    }

    public void setEndtime(Date endtime) {
        this.endtime = endtime;
        SimpleDateFormat formatter = null;
        String fout = null;
        if (endtime != null) {
            formatter = new SimpleDateFormat("h:mm:ss a", Locale.getDefault(Locale.Category.DISPLAY));
            fout = formatter.format(endtime);
            this.put("end_time", fout);
        }
    }

    public Date getStartdate() {
        return this.startdate;
    }

    public void setStartdate(Date startdate) {
        this.startdate = startdate;
        SimpleDateFormat formatter = null;
        String fout = null;
        if (startdate != null) {
            formatter = new SimpleDateFormat("M/d/yyyy");
            fout = formatter.format(startdate);
            this.put("start_date", fout);
        }
    }

    public Date getEnddate() {
        return this.enddate;
    }

    public void setEnddate(Date enddate) {
        this.enddate = enddate;
        SimpleDateFormat formatter = null;
        String fout = null;
        if (enddate != null) {
            formatter = new SimpleDateFormat("M/d/yyyy");
            fout = formatter.format(enddate);
            this.put("end_date", fout);
        }
    }

    public ScheduleTagData(Map tmap, boolean logFlag, String seed) throws ServiceException {
        this._logFlag = logFlag;
        this.seed = seed;
        this.setAttributes(tmap);
        String groupname = CronUtil.stringNullCheck(this.group) ? "DEFAULT" : this.group;
        String fullgrpname = this.appname + CronUtil.getTasknameDelimiter() + groupname;
        this.createJob();
        this.createTrigger();
    }

    public ScheduleTagData() {
    }

    private void createTrigger() throws ServiceException {
        if (this.chained || null == this.startdate && null == this.starttime && CronUtil.stringNullCheck(this.crontime)) {
            this.setChained(true);
            return;
        }
        this.setChained(false);
        if (this.startdate != null && this.starttime == null) {
            this.setStarttime(new Date());
        }
        if (this.startdate == null && this.starttime != null) {
            this.setStartdate(new Date());
        }
        String groupname = CronUtil.stringNullCheck(this.group) ? "DEFAULT" : this.group;
        String fullgrpname = this.appname + CronUtil.getTasknameDelimiter() + groupname;
        String inter = this.interval;
        if (CronUtil.stringNullCheck(this.crontime) && this.starttime != null && this.startdate != null) {
            this.handleInterval();
        }
        Date edate = null;
        if (null != this.enddate) {
            edate = CronUtil.getMergedTime(this.enddate, this.endtime);
        }
        if (this.starttime == null) {
            this.setStarttime(new Date(System.currentTimeMillis()));
        }
        TriggerBuilder triggerbuilder = TriggerBuilder.newTrigger().endAt(edate);
        if (null == this.startdate || null == CronUtil.getMergedTime(this.startdate, this.starttime)) {
            triggerbuilder.startAt(new Date());
        } else {
            triggerbuilder.startAt(CronUtil.getMergedTime(this.startdate, this.starttime));
        }
        if (!CronUtil.stringNullCheck(this.crontime) && this.crontime.length() > 0) {
            this.createCronTriggerBuilder((TriggerBuilder<Trigger>)triggerbuilder, fullgrpname);
        } else if ("once".equalsIgnoreCase(inter)) {
            this.createNonDailyTriggerBuilder((TriggerBuilder<Trigger>)triggerbuilder, fullgrpname, inter);
        } else {
            if (null == this.starttime || null == this.interval) {
                this.setChained(true);
                return;
            }
            if (this.startdate == null) {
                throw new ScheduleTag.InvalidStartdateException();
            }
            this.createDailyTriggerBuilder((TriggerBuilder<Trigger>)triggerbuilder, fullgrpname);
        }
        this.setPriority(triggerbuilder);
        this.excludeDates(triggerbuilder);
        if (!CronUtil.stringNullCheck(this.misfire)) {
            // empty if block
        }
        this.trigger = triggerbuilder.build();
        if (this.startdate == null) {
            this.setStartdate(this.trigger.getStartTime());
        }
    }

    private void createCronTriggerBuilder(TriggerBuilder<Trigger> triggerbuilder, String fullgrpname) throws ServiceException {
        CronScheduleBuilder schedule = CronScheduleBuilder.cronSchedule((String)this.crontime);
        if ("FIRENOW".equals(this.misfire)) {
            schedule.withMisfireHandlingInstructionFireAndProceed();
        } else {
            schedule.withMisfireHandlingInstructionDoNothing();
        }
        triggerbuilder.withIdentity(CronUtil.getTriggername(this.task), fullgrpname.toUpperCase()).forJob(CronUtil.getJobname(this.task), fullgrpname.toUpperCase()).withSchedule((ScheduleBuilder)schedule);
    }

    private void createNonDailyTriggerBuilder(TriggerBuilder<Trigger> triggerbuilder, String fullgrpname, String inter) {
        if (null != this.enddate && null != this.endtime && !"once".equalsIgnoreCase(inter) && Integer.valueOf(this.repeat) <= 0) {
            this.repeat = "-1";
        }
        if ("once".equalsIgnoreCase(inter)) {
            this.setRepeat(NOT_STARTED);
            this.interval = NOT_STARTED;
        }
        SimpleScheduleBuilder schedule = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(Integer.valueOf(this.interval).intValue()).withRepeatCount(Integer.valueOf(this.repeat).intValue()).withMisfireHandlingInstructionNextWithRemainingCount();
        if ("FIRENOW".equals(this.misfire)) {
            schedule.withMisfireHandlingInstructionFireNow();
        } else if ("NEXT_EXISTING".equals(this.misfire)) {
            schedule.withMisfireHandlingInstructionNextWithExistingCount();
        } else if ("NEXT_REMAINING".equals(this.misfire)) {
            schedule.withMisfireHandlingInstructionNextWithRemainingCount();
        } else if ("NOW_EXISTING".equals(this.misfire)) {
            schedule.withMisfireHandlingInstructionNowWithExistingCount();
        } else if ("NOW_REMAINING".equals(this.misfire)) {
            schedule.withMisfireHandlingInstructionNowWithRemainingCount();
        }
        triggerbuilder.withIdentity(CronUtil.getTriggername(this.task), fullgrpname.toUpperCase()).forJob(CronUtil.getJobname(this.task), fullgrpname.toUpperCase()).withSchedule((ScheduleBuilder)schedule);
        if (null == CronUtil.getMergedTime(this.startdate, this.starttime)) {
            triggerbuilder.startAt(new Date());
        }
    }

    private void createDailyTriggerBuilder(TriggerBuilder<Trigger> triggerbuilder, String fullgrpname) {
        TimeOfDay stime = new TimeOfDay(this.starttime.getHours(), this.starttime.getMinutes(), this.starttime.getSeconds());
        TimeOfDay etime = null;
        if (null != this.endtime) {
            etime = new TimeOfDay(this.endtime.getHours(), this.endtime.getMinutes(), this.endtime.getSeconds());
        }
        DailyTimeIntervalScheduleBuilder schedBuilder = DailyTimeIntervalScheduleBuilder.dailyTimeIntervalSchedule().withIntervalInSeconds(Integer.valueOf(this.interval).intValue()).startingDailyAt(stime);
        if ("FIRENOW".equals(this.misfire)) {
            schedBuilder.withMisfireHandlingInstructionFireAndProceed();
        } else {
            schedBuilder.withMisfireHandlingInstructionDoNothing();
        }
        if (null != etime) {
            schedBuilder.endingDailyAt(etime);
        }
        if (Integer.valueOf(this.repeat) != -1) {
            schedBuilder.endingDailyAfterCount(Integer.valueOf(this.repeat) + 1);
        }
        triggerbuilder.withIdentity(CronUtil.getTriggername(this.task), fullgrpname.toUpperCase()).forJob(CronUtil.getJobname(this.task), fullgrpname.toUpperCase()).withSchedule((ScheduleBuilder)schedBuilder);
    }

    private void setPriority(TriggerBuilder triggerbuilder) {
        triggerbuilder.withPriority(Integer.valueOf(this.priority).intValue());
    }

    private void handleInterval() {
        if (null == this.interval) {
            return;
        }
        int seconds = this.starttime.getSeconds();
        int minutes = this.starttime.getMinutes();
        int hours = this.starttime.getHours();
        int dayofweek = this.startdate.getDay();
        int month = this.startdate.getMonth();
        int dayofmonth = this.startdate.getDate();
        if (CronUtil.stringNullCheck(this.interval)) {
            return;
        }
        if (this.interval.equalsIgnoreCase("weekly")) {
            this.crontime = seconds + " " + minutes + " " + hours + " ? * " + dayofweek;
        } else if (this.interval.equalsIgnoreCase("daily")) {
            this.crontime = seconds + " " + minutes + " " + hours + " * * ?";
        } else if (this.interval.equalsIgnoreCase("monthly")) {
            this.crontime = seconds + " " + minutes + " " + hours + " " + dayofmonth + " * ?";
        } else if (this.interval.equalsIgnoreCase("once")) {
            this.setRepeat(NOT_STARTED);
            this.interval = NOT_STARTED;
        }
    }

    private void excludeDates(TriggerBuilder triggerbuilder) {
        if (null == this.exclude) {
            return;
        }
        if (this.exclude instanceof String && !((String)this.exclude).trim().equals("") || this.exclude instanceof Array && ((Array)this.exclude).size() > 0) {
            FeatureRouter.getInstance().allowFeature(EFRConstants.scheduler_new_features.intValue(), null);
        }
        String excludelist = "";
        try {
            ArrayList<Calendar> calendarlist = new ArrayList<Calendar>();
            if (this.exclude instanceof String) {
                String excludestr = ((String)this.exclude).toLowerCase();
                if (CronUtil.stringNullCheck(excludestr)) {
                    return;
                }
                for (String date : excludestr.split(",")) {
                    if (date.toLowerCase().contains(" to ")) {
                        int startendindex = date.indexOf(" to ");
                        String startdate = date.substring(0, startendindex).trim();
                        String enddate = date.substring(startendindex + 4).trim();
                        OleDateTime parsedstartdate = CFDateTimeParser.parseDateTime((String)startdate);
                        OleDateTime parsedenddate = CFDateTimeParser.parseDateTime((String)enddate);
                        Calendar cal = Calendar.getInstance();
                        cal.setTime((Date)parsedstartdate);
                        Calendar cal2 = Calendar.getInstance();
                        cal2.setTime((Date)parsedenddate);
                        calendarlist.add(cal);
                        Calendar callatest = cal;
                        while (!callatest.after(cal2)) {
                            Calendar cal3 = Calendar.getInstance();
                            cal3.setTime(callatest.getTime());
                            cal3.add(5, 1);
                            calendarlist.add(cal3);
                            callatest = cal3;
                        }
                        continue;
                    }
                    OleDateTime parseddate = CFDateTimeParser.parseDateTime((String)date.trim());
                    Calendar cal = Calendar.getInstance();
                    cal.setTime((Date)parseddate);
                    calendarlist.add(cal);
                }
            } else if (this.exclude instanceof Array) {
                Array ary = (Array)this.exclude;
                ListIterator iter = ary.listIterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    String date = "";
                    Date parseddate = null;
                    if (obj instanceof String) {
                        date = obj.toString().trim();
                        excludelist = excludelist + date + ",";
                        parseddate = CFDateTimeParser.parseDateTime((String)date);
                    } else if (obj instanceof Date) {
                        parseddate = (Date)obj;
                        excludelist = excludelist + parseddate.toString() + ",";
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(parseddate);
                    calendarlist.add(cal);
                }
            }
            if (excludelist.length() > 0) {
                excludelist = excludelist.substring(0, excludelist.length() - 1);
                this.setExclude(excludelist);
            }
            AnnualCalendar excludedates = new AnnualCalendar();
            excludedates.setDaysExcluded(calendarlist);
            try {
                CronServiceImpl.getSchedulerInstance(this.clustered).addCalendar(CronUtil.getJobname(this.task) + "_" + CronUtil.getFullGroupName(this.group, this.mode) + "_holidays", (org.quartz.Calendar)excludedates, true, true);
                triggerbuilder.modifiedByCalendar(CronUtil.getJobname(this.task) + "_" + CronUtil.getFullGroupName(this.group, this.mode) + "_holidays");
            }
            catch (SchedulerException ex) {
                CFLogs.SCHEDULER_LOG.error((Throwable)ex);
            }
        }
        catch (Exception ex) {
            CFLogs.SCHEDULER_LOG.error((Throwable)ex);
            throw new ScheduleTag.InvalidExcludedateException();
        }
    }

    private int getMisfireInst(String misfire) {
        if (!CronUtil.stringNullCheck(this.crontime) && !"FIRENOW".equalsIgnoreCase(misfire)) {
            return 2;
        }
        return (Integer)MISFIREMAP.get(misfire);
    }

    public String getFullGroupName() {
        String fullname = "";
        try {
            fullname = CronUtil.stringNullCheck(this.appname) ? CronUtil.getFullGroupName(this.group, this.mode) : CronUtil.getFullGroupName(this.group, this.appname);
        }
        catch (Exception e) {
            fullname = this.appname + CronUtil.getTasknameDelimiter() + this.getGroupName();
        }
        return fullname.toUpperCase();
    }

    public String getGroup() {
        return this.group;
    }

    public String getGroupName() {
        return this.group == null ? "DEFAULT" : this.group;
    }

    public void setGroup(String group) {
        if (null == group) {
            group = "DEFAULT";
        }
        this.put("group", group);
        this.group = group;
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String task) {
        this.put("task", task);
        this.task = task;
    }

    public String getChianedtasks() {
        return this.chianedtasks;
    }

    public void setChianedtasks(String onexecute) {
        this.put(ONCOMPLETE, onexecute);
        this.chianedtasks = onexecute;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String httpport) {
        this.port = httpport;
        if (httpport != null) {
            this.put("http_port", httpport);
        }
    }

    public String getSeed() {
        return this.seed;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.put("file", file);
        this.file = file;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.put("path", path);
        this.path = path;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (username != null) {
            this.put("username", username);
        }
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password != null) {
            this.put("password", password);
        }
        this.password = password;
    }

    public String getProxyport() {
        return this.proxyport;
    }

    public void setProxyport(String httpproxyport) {
        if (httpproxyport != null) {
            this.put("http_proxy_port", httpproxyport);
        }
        this.proxyport = httpproxyport;
    }

    public String getProxyuser() {
        return this.proxyuser;
    }

    public void setProxyuser(String proxyUser) {
        if (proxyUser != null) {
            this.put("proxy_user", proxyUser);
        }
        this.proxyuser = proxyUser;
    }

    public String getProxypassword() {
        return this.proxypassword;
    }

    public void setProxypassword(String proxyPassword) {
        if (proxyPassword != null) {
            this.put("proxy_password", proxyPassword);
        }
        this.proxypassword = proxyPassword;
    }

    public String getProxyserver() {
        return this.proxyserver;
    }

    public void setProxyserver(String proxyserver) {
        if (proxyserver != null) {
            this.put("proxy_server", proxyserver);
        }
        this.proxyserver = proxyserver;
    }

    public String getReqtimeout() {
        return this.reqtimeout;
    }

    public void setReqtimeout(String requesttimeout) {
        if (requesttimeout != null) {
            this.put("request_time_out", requesttimeout);
        }
        this.reqtimeout = requesttimeout;
    }

    public boolean isResolveUrl() {
        return this.resolveUrl;
    }

    public void setResolveUrl(boolean resolveurl) {
        this.resolveUrl = resolveurl;
        this.put("resolveurl", resolveurl);
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setPublish(boolean publish) {
        this.put("publish", publish);
        this.publish = publish;
    }

    public boolean isValidPublishPath() {
        return this.isValidPublishPath;
    }

    public void setValidPublishPath(boolean isValidPublishPath) {
        this.put("isValidPublishPath", isValidPublishPath);
        this.isValidPublishPath = isValidPublishPath;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.put("url", url);
        this.url = url;
    }

    public String getOnexception() {
        return this.onexception;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
        this.put(MODE, mode);
    }

    public void setOnexception(String onexception) {
        this.put("onexception", onexception);
        this.onexception = onexception;
    }

    public String getEventhandler() {
        return this.eventhandler;
    }

    public void setEventhandler(String eventhandler) {
        this.put("eventhandler", eventhandler);
        this.eventhandler = eventhandler;
    }

    public String getEventhandlerrp() {
        return this.eventhandlerrp;
    }

    public void setEventhandlerrp(String eventhandlerrp) {
        this.put("eventhandlerrp", eventhandlerrp);
        this.eventhandlerrp = eventhandlerrp;
    }

    public void setAttributes(Map map) {
        this.task = (String)map.get("task");
        this.put("task", this.task);
        this.url = (String)map.get("url");
        this.put("url", this.url);
        this.file = (String)map.get("file");
        this.put("file", this.file);
        this.path = (String)map.get("path");
        this.put("path", this.path);
        this.publish = Cast._boolean(map.get("publish"));
        this.put("publish", this.publish);
        if (map.get("isValidPublishPath") != null) {
            this.isValidPublishPath = Cast._boolean(map.get("isValidPublishPath"));
            this.put("isValidPublishPath", this.isValidPublishPath);
        }
        this.put("start_date", map.get("start_date"));
        String str = (String)map.get("end_date");
        if (str != null) {
            this.put("end_date", str);
        }
        this.put("start_time", map.get("start_time"));
        str = (String)map.get("end_time");
        if (str != null) {
            this.put("end_time", str);
        }
        this.interval = (String)map.get("interval");
        this.put("interval", this.interval);
        this.reqtimeout = (String)map.get("request_time_out");
        if (this.reqtimeout != null) {
            this.put("request_time_out", this.reqtimeout);
        }
        this.password = (String)map.get("password");
        if (this.password != null) {
            this.put("password", this.password);
        }
        this.username = (String)map.get("username");
        if (this.username != null) {
            this.put("username", this.username);
        }
        this.proxyserver = (String)map.get("proxy_server");
        if (this.proxyserver != null) {
            this.put("proxy_server", this.proxyserver);
        }
        this.proxyuser = (String)map.get("proxy_user");
        if (this.proxyuser != null) {
            this.put("proxy_user", this.proxyuser);
        }
        this.proxypassword = (String)map.get("proxy_password");
        if (this.proxypassword != null) {
            this.put("proxy_password", this.proxypassword);
        }
        if (null != map.get("resolveurl")) {
            this.resolveUrl = Cast._boolean(map.get("resolveurl"));
        }
        this.put("resolveurl", this.resolveUrl);
        if (map.get("chained") != null) {
            this.chained = Cast._boolean(map.get("chained"));
        }
        this.put("chained", this.chained);
        if (map.get("clustered") != null) {
            this.clustered = Cast._boolean(map.get("clustered"));
        }
        this.put("clustered", this.clustered);
        this.overwrite = null == map.get("overwrite") ? true : Cast._boolean(map.get("overwrite"));
        this.put("overwrite", this.overwrite);
        this.port = (String)map.get("http_port");
        if (this.port != null) {
            this.put("http_port", this.port);
        }
        this.proxyport = (String)map.get("http_proxy_port");
        if (this.proxyport != null) {
            this.put("http_proxy_port", this.proxyport);
        }
        if ((str = (String)map.get("last_run")) != null) {
            this.put("last_run", str);
        }
        if ((str = (String)map.get("lastfire")) != null) {
            this.put("lastfire", str);
        }
        this.put("disabled", map.get("disabled") == null ? Boolean.FALSE : map.get("disabled"));
        String group = (String)map.get("group");
        if (!CronUtil.stringNullCheck(group)) {
            this.group = group;
        }
        this.put("group", group);
        this.group = (String)map.get("group");
        if (!CronUtil.stringNullCheck((String)map.get(ONMISFIRE))) {
            this.misfire = (String)map.get(ONMISFIRE);
        }
        this.setMisfire(this.misfire);
        this.put("onexception", map.get("onexception"));
        this.onexception = (String)map.get("onexception");
        this.put(ONCOMPLETE, map.get(ONCOMPLETE));
        this.chianedtasks = (String)map.get(ONCOMPLETE);
        if (!CronUtil.stringNullCheck((String)map.get(REPEAT))) {
            this.repeat = (String)map.get(REPEAT);
        }
        this.put(REPEAT, this.repeat);
        this.put("crontime", map.get("crontime"));
        this.crontime = (String)map.get("crontime");
        if (!CronUtil.stringNullCheck((String)map.get(RETRYCOUNT))) {
            this.retrycount = (String)map.get(RETRYCOUNT);
        }
        this.put(RETRYCOUNT, this.retrycount);
        this.put("eventhandler", map.get("eventhandler"));
        this.eventhandler = (String)map.get("eventhandler");
        this.put("eventhandlerrp", map.get("eventhandlerrp"));
        this.eventhandlerrp = (String)map.get("eventhandlerrp");
        if (!CronUtil.stringNullCheck((String)map.get("priority"))) {
            this.priority = (String)map.get("priority");
        }
        this.put("priority", this.priority);
        if (!CronUtil.stringNullCheck((String)map.get(STATUS))) {
            this.status = (String)map.get(STATUS);
        }
        this.put(STATUS, this.status);
        this.put("exclude", map.get("exclude"));
        this.exclude = map.get("exclude");
        if (!CronUtil.stringNullCheck((String)map.get(MODE))) {
            this.mode = (String)map.get(MODE);
        }
        this.put(MODE, this.mode);
        if (!CronUtil.stringNullCheck((String)map.get(APPNAME))) {
            this.appname = (String)map.get(APPNAME);
            this.put(APPNAME, this.appname);
        } else if (this.mode.equalsIgnoreCase("application")) {
            this.appname = "";
            this.put(APPNAME, "");
        }
        this.setup();
    }

    public Object getExclude() {
        return this.exclude;
    }

    public void setExclude(Object exclude) {
        this.exclude = exclude;
        this.put("exclude", exclude);
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.put(REPEAT, repeat);
        this.repeat = repeat;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        if (this.crontime != null && this.crontime.length() > 0) {
            return;
        }
        this.put("interval", interval);
        this.interval = interval;
    }

    public String getCrontime() {
        return this.crontime;
    }

    public void setCrontime(String crontime) {
        this.put("crontime", crontime);
        this.crontime = crontime;
        if (crontime != null && crontime.length() > 0) {
            this.setInterval("");
        }
    }

    public String getMisfire() {
        return this.misfire;
    }

    public void setMisfire(String misfire) {
        if ("fire_now".equalsIgnoreCase(misfire)) {
            misfire = "FIRENOW";
        }
        this.put(ONMISFIRE, misfire);
        this.misfire = misfire.toUpperCase();
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.put("priority", priority);
        this.priority = priority;
    }

    public void setup() {
        String str = null;
        if (this.get("end_date") instanceof Date) {
            this.enddate = (Date)this.get("end_date");
        } else {
            str = (String)this.get("end_date");
            if (str != null) {
                this.enddate = DateUtils.parseDateTime((String)str);
            }
        }
        if (this.get("end_time") instanceof Date) {
            this.endtime = (Date)this.get("end_time");
        } else {
            str = (String)this.get("end_time");
            if (str != null) {
                this.endtime = DateUtils.parseDateTime((String)str);
            }
        }
        if (this.get("start_date") instanceof Date) {
            this.startdate = (Date)this.get("start_date");
        } else {
            str = (String)this.get("start_date");
            if (!CronUtil.stringNullCheck(str)) {
                try {
                    this.startdate = DateUtils.parseDateTime((String)str);
                }
                catch (Exception e) {
                    this.startdate = DateUtils.parseDateTime((String)str, (Locale)Locale.getDefault());
                }
            }
        }
        if (this.get("start_time") instanceof Date) {
            this.starttime = (Date)this.get("start_time");
        } else {
            str = (String)this.get("start_time");
            if (!CronUtil.stringNullCheck(str)) {
                try {
                    this.starttime = DateUtils.parseDateTime((String)str);
                }
                catch (Exception e) {
                    this.starttime = DateUtils.parseDateTime((String)str, (Locale)Locale.getDefault());
                }
            }
        }
        str = this.get("interval") + "";
        if (str.equalsIgnoreCase("once")) {
            // empty if block
        }
        if (!str.equalsIgnoreCase("null") && str.length() > 0 && this.startdate == null && this.starttime == null) {
            this.startdate = new Date();
            this.starttime = new Date();
            this.setStartdate(this.startdate);
            this.setStarttime(this.starttime);
        }
        this.publish = (Boolean)this.get("publish");
    }

    public HttpTag getHttpTag() {
        String url = this.url;
        if (url == null || "".equals(url)) {
            return null;
        }
        HttpTag http = new HttpTag(url);
        http.setResolveurl(this.resolveUrl);
        http.setUseragent("CFSCHEDULE");
        if (!this.isEmpty(this.port)) {
            http.setPort(Integer.parseInt(this.port));
        }
        if (!this.isEmpty(this.username)) {
            http.setUsername(this.username);
        }
        if (!this.isEmpty(this.password)) {
            String p = PasswordUtils.decryptPassword((String)this.password, (String)((CronServiceImpl)ServiceFactory.getCronService()).getSeed());
            http.setPassword(p);
        }
        if (!this.isEmpty(this.proxyport)) {
            http.setProxyport(Integer.parseInt(this.proxyport));
        }
        if (!this.isEmpty(this.proxyserver)) {
            http.setProxyserver(this.proxyserver);
        }
        if (!this.isEmpty(this.reqtimeout)) {
            http.setTimeout(Cast._int((String)this.reqtimeout));
        }
        http.disableDeflate();
        return http;
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public void setRetrycount(String retrycount) {
        this.put(RETRYCOUNT, retrycount);
        this.retrycount = retrycount;
    }

    public String getRetrycount() {
        return this.retrycount;
    }

    public void setStatus(String status) {
        this.status = status;
        this.put(STATUS, status + "");
    }

    public String getStatus() {
        return this.status;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
        this.put("clustered", clustered + "");
    }

    public void setChained(boolean chained) {
        this.chained = chained;
        this.put("chained", chained + "");
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public boolean isChained() {
        return this.chained;
    }

    public void setAppname(String appname) {
        this.appname = appname;
        this.put(APPNAME, appname + "");
    }

    public String getAppname() {
        return this.appname;
    }

    public void init() throws ServiceException {
        this.init(true);
    }

    public void init(boolean validateEventHandler) throws ServiceException {
        String appname = CronUtil.getApplicationName();
        if (null == appname || "server".equalsIgnoreCase(this.mode)) {
            appname = CronUtil.getServerName();
        }
        this.appname = appname;
        this.put(APPNAME, appname);
        this.setup();
        this.validateEventhandler(!validateEventHandler);
        try {
            if (this.eventhandler != null && this.eventhandler.length() > 0) {
                this.cfcProxy = new CFCProxy(this.eventhandler, false);
            }
        }
        catch (Throwable ex) {
            CFLogs.SCHEDULER_LOG.error(ex);
        }
        this.setStatus(ACTIVE);
        this.createJob();
        this.createTrigger();
    }

    private void createJob() {
        this.jobdetail = CronUtil.stringNullCheck(this.appname) ? JobBuilder.newJob(CronTask.class).withIdentity(CronUtil.getJobname(this.task), CronUtil.getFullGroupName(this.group, this.mode)).storeDurably(true).requestRecovery(true).build() : JobBuilder.newJob(CronTask.class).withIdentity(CronUtil.getJobname(this.task), CronUtil.getFullGroupName(this.group, this.appname)).storeDurably(true).requestRecovery(true).build();
    }

    public void validateEventhandler(boolean ignoreError) {
        Object extendsObj;
        if (null == this.eventhandler || "".equals(this.eventhandler)) {
            return;
        }
        this.setEventhandlerrp(this.eventhandler);
        FusionContext fusionContext = FusionContext.getCurrent();
        NeoPageContext pageContext = fusionContext.pageContext;
        AttributeCollection metaData = null;
        String cfc = this.eventhandler;
        try {
            File cfcFile = new File(this.eventhandler);
            if (!cfcFile.exists()) {
                cfcFile = TemplateProxyFactory.getResolvedFile((String)this.eventhandler, (NeoPageContext)pageContext);
            }
            this.eventhandler = cfcFile.getAbsolutePath();
            this.setEventhandler(this.eventhandler);
            metaData = (AttributeCollection)MetadataUtils.getComponentMetadata((File)new File(this.eventhandler), (NeoPageContext)pageContext, (String)this.eventhandler, (boolean)true);
        }
        catch (Throwable t) {
            if (!ignoreError) {
                throw new ScheduleTag.SchedulingEventhandlerNofileException(t.getMessage());
            }
            return;
        }
        boolean isImplemented = false;
        Object implement = metaData.get((Object)"IMPLEMENTS");
        isImplemented = this.checkImplemented(implement);
        if (!isImplemented && null != (extendsObj = metaData.get((Object)"EXTENDS")) && extendsObj instanceof AttributeCollection) {
            implement = ((AttributeCollection)extendsObj).get((Object)"IMPLEMENTS");
            isImplemented = this.checkImplemented(implement);
        }
    }

    private boolean checkImplemented(Object implement) {
        if (null != implement) {
            if (implement instanceof String) {
                if (((String)implement).toLowerCase().indexOf("cfide.scheduler.ITaskEventHandler".toLowerCase()) >= 0) {
                    return true;
                }
            } else if (implement instanceof AttributeCollection) {
                return ((AttributeCollection)implement).containsKey((Object)"cfide.scheduler.ITaskEventHandler");
            }
        }
        return false;
    }

    public void setLastfire(Date lastfire) {
        this.lastfire = lastfire;
        SimpleDateFormat formatter = null;
        String fout = null;
        if (lastfire != null) {
            formatter = new SimpleDateFormat("M/d/yyyy h:mm:ss a");
            fout = formatter.format(lastfire);
            this.put("lastfire", fout);
        }
    }

    public Date getLastfire() {
        return this.lastfire;
    }

    public void setNextfire(Date nextfire) {
        this.nextfire = nextfire;
        SimpleDateFormat formatter = null;
        String fout = null;
        if (nextfire != null) {
            formatter = new SimpleDateFormat("M/d/yyyy h:mm:ss a");
            fout = formatter.format(nextfire);
            this.put("nextfire", fout);
        } else {
            this.remove("nextfire");
        }
    }

    public Date getNextfire() {
        return this.nextfire;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isProxypasswordencrypted() {
        return this.proxypasswordencrypted;
    }

    public void setProxypasswordencrypted(boolean proxypasswordencrypted) {
        this.proxypasswordencrypted = proxypasswordencrypted;
    }

    public void setRemainingCount(String remainingCount) {
        this.remainingCount = remainingCount;
        this.put("remainingCount", remainingCount);
    }

    public String getRemainingCount() {
        return this.remainingCount;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        this.put("overwrite", overwrite + "");
    }

    public Boolean getOverwrite() {
        return this.overwrite;
    }

    public CFCProxy getCfcProxy() {
        return this.cfcProxy;
    }

    public void setCfcProxy(CFCProxy cfcProxy) {
        this.cfcProxy = cfcProxy;
    }

    static {
        MISFIREMAP.put("FIRE_NOW", 1);
        MISFIREMAP.put("FIRENOW", 1);
        MISFIREMAP.put("invokehandler", 4);
    }
}

