/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import net.lingala.zip4j.core.HeaderReader;
import net.lingala.zip4j.core.HeaderWriter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.SplitOutputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.Zip4jUtil;

public class ArchiveMaintainer {
    public HashMap removeZipFile(final ZipModel zipModel, final FileHeader fileHeader, final ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (runInThread) {
            Thread thread = new Thread("Zip4j"){

                @Override
                public void run() {
                    try {
                        ArchiveMaintainer.this.initRemoveZipFile(zipModel, fileHeader, progressMonitor);
                        progressMonitor.endProgressMonitorSuccess();
                    }
                    catch (ZipException zipException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
            return null;
        }
        HashMap retMap = this.initRemoveZipFile(zipModel, fileHeader, progressMonitor);
        progressMonitor.endProgressMonitorSuccess();
        return retMap;
    }

    public HashMap initRemoveZipFile(ZipModel zipModel, FileHeader fileHeader, ProgressMonitor progressMonitor) throws ZipException {
        return this.initRemoveZipFile(zipModel, fileHeader, progressMonitor, Long.parseLong("-1"));
    }

    public void copyLeftOverStream(ZipModel zipModel, FileHeader fileHeader, ProgressMonitor progressMonitor, OutputStream outputStream, Long offsetInputStream) throws ZipException {
        RandomAccessFile inputStream = null;
        try {
            try {
                inputStream = this.createFileHandler(zipModel, "r");
                long offsetStartCentralDir = zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir();
                if (zipModel.isZip64Format() && zipModel.getZip64EndCentralDirRecord() != null) {
                    offsetStartCentralDir = zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo();
                }
                this.copyFile(inputStream, outputStream, offsetInputStream, offsetStartCentralDir, progressMonitor);
            }
            catch (ZipException e) {
                progressMonitor.endProgressMonitorError(e);
                throw e;
            }
            catch (Exception e) {
                progressMonitor.endProgressMonitorError(e);
                throw new ZipException(e);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new ZipException("cannot close input stream or output stream when trying to delete a file from zip file");
            }
        }
    }

    public HashMap initRemoveZipFile(ZipModel zipModel, FileHeader fileHeader, ProgressMonitor progressMonitor, Long offsetInputStream) throws ZipException {
        long offsetEndOfCompressedFile;
        long offsetLocalFileHeader;
        int indexOfFileHeader;
        OutputStream outputStream;
        String tmpZipFileName;
        boolean singleFile;
        boolean successFlag;
        File zipFile;
        HashMap<String, String> retMap;
        RandomAccessFile inputStream;
        block52: {
            ArrayList fileHeaderList;
            HeaderReader headerReader;
            LocalFileHeader localFileHeader;
            if (fileHeader == null || zipModel == null) {
                throw new ZipException("input parameters is null in maintain zip file, cannot remove file from archive");
            }
            inputStream = null;
            retMap = new HashMap<String, String>();
            zipFile = null;
            successFlag = false;
            singleFile = false;
            tmpZipFileName = null;
            outputStream = null;
            indexOfFileHeader = Zip4jUtil.getIndexOfFileHeader(zipModel, fileHeader);
            if (indexOfFileHeader < 0) {
                throw new ZipException("file header not found in zip model, cannot remove file");
            }
            if (zipModel.isSplitArchive()) {
                throw new ZipException("This is a split archive. Zip file format does not allow updating split/spanned files");
            }
            if (offsetInputStream == -1L) {
                singleFile = true;
                long currTime = System.currentTimeMillis();
                tmpZipFileName = String.valueOf(zipModel.getZipFileObj().getPath()) + currTime % 1000L;
                File tmpFile = Zip4jUtil.getFileObj(zipModel.getZipFileObj(), tmpZipFileName);
                while (tmpFile.exists()) {
                    currTime = System.currentTimeMillis();
                    tmpZipFileName = String.valueOf(zipModel.getZipFileObj().getPath()) + currTime % 1000L;
                    tmpFile = Zip4jUtil.getFileObj(zipModel.getZipFileObj(), tmpZipFileName);
                }
                try {
                    outputStream = new SplitOutputStream(Zip4jUtil.getFileObj(zipModel.getZipFileObj(), tmpZipFileName));
                }
                catch (FileNotFoundException e1) {
                    throw new ZipException(e1);
                }
                zipFile = zipModel.getZipFileObj();
            }
            if ((localFileHeader = (headerReader = new HeaderReader(inputStream = this.createFileHandler(zipModel, "r"))).readLocalFileHeader(fileHeader)) == null) {
                throw new ZipException("invalid local file header, cannot remove file from archive");
            }
            offsetLocalFileHeader = fileHeader.getOffsetLocalHeader();
            if (fileHeader.getZip64ExtendedInfo() != null && fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
                offsetLocalFileHeader = fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader();
            }
            offsetEndOfCompressedFile = -1L;
            long offsetStartCentralDir = zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir();
            if (zipModel.isZip64Format() && zipModel.getZip64EndCentralDirRecord() != null) {
                offsetStartCentralDir = zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo();
            }
            if (indexOfFileHeader == (fileHeaderList = zipModel.getCentralDirectory().getFileHeaders()).size() - 1) {
                offsetEndOfCompressedFile = offsetStartCentralDir - 1L;
            } else {
                FileHeader nextFileHeader = (FileHeader)fileHeaderList.get(indexOfFileHeader + 1);
                if (nextFileHeader != null) {
                    offsetEndOfCompressedFile = nextFileHeader.getOffsetLocalHeader() - 1L;
                    if (nextFileHeader.getZip64ExtendedInfo() != null && nextFileHeader.getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
                        offsetEndOfCompressedFile = nextFileHeader.getZip64ExtendedInfo().getOffsetLocalHeader() - 1L;
                    }
                }
            }
            if (offsetLocalFileHeader < 0L || offsetEndOfCompressedFile < 0L) {
                throw new ZipException("invalid offset for start and end of local file, cannot remove file");
            }
            if (singleFile) {
                if (indexOfFileHeader == 0) {
                    if (zipModel.getCentralDirectory().getFileHeaders().size() > 1) {
                        this.copyFile(inputStream, outputStream, offsetEndOfCompressedFile + 1L, offsetStartCentralDir, progressMonitor);
                    }
                } else if (indexOfFileHeader == fileHeaderList.size() - 1) {
                    this.copyFile(inputStream, outputStream, offsetInputStream, offsetLocalFileHeader, progressMonitor);
                } else {
                    this.copyFile(inputStream, outputStream, offsetInputStream, offsetLocalFileHeader, progressMonitor);
                    this.copyFile(inputStream, outputStream, offsetEndOfCompressedFile + 1L, offsetStartCentralDir, progressMonitor);
                }
            }
            if (!progressMonitor.isCancelAllTasks()) break block52;
            progressMonitor.setResult(3);
            progressMonitor.setState(0);
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (singleFile && outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new ZipException("cannot close input stream or output stream when trying to delete a file from zip file");
            }
            if (singleFile) {
                if (successFlag) {
                    ArchiveMaintainer.restoreFileName(zipFile, tmpZipFileName);
                } else {
                    File newZipFile = Zip4jUtil.getFileObj(zipModel.getZipFileObj(), tmpZipFileName);
                    newZipFile.delete();
                }
            }
            return null;
        }
        try {
            try {
                if (singleFile) {
                    zipModel.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(((SplitOutputStream)outputStream).getFilePointer());
                    zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDir(zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDir() - 1);
                    zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDirOnThisDisk() - 1);
                    zipModel.getCentralDirectory().getFileHeaders().remove(indexOfFileHeader);
                    int i = indexOfFileHeader;
                    while (i < zipModel.getCentralDirectory().getFileHeaders().size()) {
                        long offsetLocalHdr = ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getOffsetLocalHeader();
                        if (((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getZip64ExtendedInfo() != null && ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getZip64ExtendedInfo().getOffsetLocalHeader() != -1L) {
                            offsetLocalHdr = ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getZip64ExtendedInfo().getOffsetLocalHeader();
                        }
                        ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).setOffsetLocalHeader(offsetLocalHdr - (offsetEndOfCompressedFile - offsetLocalFileHeader) - 1L);
                        ++i;
                    }
                    HeaderWriter headerWriter = new HeaderWriter();
                    headerWriter.finalizeZipFile(zipModel, outputStream);
                    successFlag = true;
                    retMap.put("offsetCentralDir", Long.toString(zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir()));
                } else {
                    retMap.put("offsetEndOfCompressedFile", Long.toString(offsetEndOfCompressedFile));
                    retMap.put("offsetLocalFileHeader", Long.toString(offsetLocalFileHeader));
                }
            }
            catch (ZipException e) {
                progressMonitor.endProgressMonitorError(e);
                throw e;
            }
            catch (Exception e) {
                progressMonitor.endProgressMonitorError(e);
                throw new ZipException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (singleFile && outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new ZipException("cannot close input stream or output stream when trying to delete a file from zip file");
            }
            if (singleFile) {
                if (successFlag) {
                    ArchiveMaintainer.restoreFileName(zipFile, tmpZipFileName);
                } else {
                    File newZipFile = Zip4jUtil.getFileObj(zipModel.getZipFileObj(), tmpZipFileName);
                    newZipFile.delete();
                }
            }
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            if (singleFile && outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new ZipException("cannot close input stream or output stream when trying to delete a file from zip file");
        }
        if (singleFile) {
            if (successFlag) {
                ArchiveMaintainer.restoreFileName(zipFile, tmpZipFileName);
            } else {
                File newZipFile = Zip4jUtil.getFileObj(zipModel.getZipFileObj(), tmpZipFileName);
                newZipFile.delete();
            }
        }
        return retMap;
    }

    public static void restoreFileName(File zipFile, String tmpZipFileName) throws ZipException {
        if (zipFile.delete()) {
            File newZipFile = Zip4jUtil.getFileObj(zipFile, tmpZipFileName);
            if (!newZipFile.renameTo(zipFile)) {
                throw new ZipException("cannot rename modified zip file");
            }
        } else {
            throw new ZipException("cannot delete old zip file");
        }
    }

    public void copyFile(RandomAccessFile inputStream, OutputStream outputStream, long start, long end, ProgressMonitor progressMonitor) throws ZipException {
        if (inputStream == null || outputStream == null) {
            throw new ZipException("input or output stream is null, cannot copy file");
        }
        if (start < 0L) {
            throw new ZipException("starting offset is negative, cannot copy file");
        }
        if (end < 0L) {
            throw new ZipException("end offset is negative, cannot copy file");
        }
        if (start > end) {
            throw new ZipException("start offset is greater than end offset, cannot copy file");
        }
        if (start == end) {
            return;
        }
        if (progressMonitor.isCancelAllTasks()) {
            progressMonitor.setResult(3);
            progressMonitor.setState(0);
            return;
        }
        try {
            inputStream.seek(start);
            int readLen = -2;
            long bytesRead = 0L;
            long bytesToRead = end - start;
            byte[] buff = end - start < 4096L ? new byte[(int)(end - start)] : new byte[4096];
            while ((readLen = inputStream.read(buff)) != -1) {
                outputStream.write(buff, 0, readLen);
                progressMonitor.updateWorkCompleted(readLen);
                if (progressMonitor.isCancelAllTasks()) {
                    progressMonitor.setResult(3);
                    return;
                }
                if ((bytesRead += (long)readLen) != bytesToRead) {
                    if (bytesRead + (long)buff.length <= bytesToRead) continue;
                    buff = new byte[(int)(bytesToRead - bytesRead)];
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    public RandomAccessFile createFileHandler(ZipModel zipModel, String mode) throws ZipException {
        if (zipModel == null || !Zip4jUtil.isStringNotNullAndNotEmpty(zipModel.getZipFileObj().getPath())) {
            throw new ZipException("input parameter is null in getFilePointer, cannot create file handler to remove file");
        }
        try {
            return Zip4jUtil.getRandomAccess(zipModel.getZipFileObj(), mode);
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
    }

    public void mergeSplitZipFiles(final ZipModel zipModel, final File outputZipFile, final ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (runInThread) {
            Thread thread = new Thread("Zip4j"){

                @Override
                public void run() {
                    try {
                        ArchiveMaintainer.this.initMergeSplitZipFile(zipModel, outputZipFile, progressMonitor);
                    }
                    catch (ZipException zipException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        } else {
            this.initMergeSplitZipFile(zipModel, outputZipFile, progressMonitor);
        }
    }

    /*
     * Exception decompiling
     */
    private void initMergeSplitZipFile(ZipModel zipModel, File outputZipFile, ProgressMonitor progressMonitor) throws ZipException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[WHILELOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RandomAccessFile createSplitZipFileHandler(ZipModel zipModel, int partNumber) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot create split file handler");
        }
        if (partNumber < 0) {
            throw new ZipException("invlaid part number, cannot create split file handler");
        }
        try {
            String curZipFile = zipModel.getZipFileObj().getPath();
            String partFile = null;
            partFile = partNumber == zipModel.getEndCentralDirRecord().getNoOfThisDisk() ? zipModel.getZipFileObj().getPath() : (partNumber >= 9 ? String.valueOf(curZipFile.substring(0, curZipFile.lastIndexOf("."))) + ".z" + (partNumber + 1) : String.valueOf(curZipFile.substring(0, curZipFile.lastIndexOf("."))) + ".z0" + (partNumber + 1));
            File tmpFile = Zip4jUtil.getFileObj(zipModel.getZipFileObj(), partFile);
            if (!Zip4jUtil.checkFileExists(tmpFile)) {
                throw new ZipException("split file does not exist: " + partFile);
            }
            return Zip4jUtil.getRandomAccess(tmpFile, "r");
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private OutputStream prepareOutputStreamForMerge(File outFile) throws ZipException {
        if (outFile == null) {
            throw new ZipException("outFile is null, cannot create outputstream");
        }
        try {
            return new FileOutputStream(outFile);
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private void updateSplitZipModel(ZipModel zipModel, ArrayList fileSizeList, boolean splitSigRemoved) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split zip model");
        }
        zipModel.setSplitArchive(false);
        this.updateSplitFileHeader(zipModel, fileSizeList, splitSigRemoved);
        this.updateSplitEndCentralDirectory(zipModel);
        if (zipModel.isZip64Format()) {
            this.updateSplitZip64EndCentralDirLocator(zipModel, fileSizeList);
            this.updateSplitZip64EndCentralDirRec(zipModel, fileSizeList);
        }
    }

    private void updateSplitFileHeader(ZipModel zipModel, ArrayList fileSizeList, boolean splitSigRemoved) throws ZipException {
        try {
            if (zipModel.getCentralDirectory() == null) {
                throw new ZipException("corrupt zip model - getCentralDirectory, cannot update split zip model");
            }
            int fileHeaderCount = zipModel.getCentralDirectory().getFileHeaders().size();
            int splitSigOverhead = 0;
            if (splitSigRemoved) {
                splitSigOverhead = 4;
            }
            int i = 0;
            while (i < fileHeaderCount) {
                long offsetLHToAdd = 0L;
                int j = 0;
                while (j < ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getDiskNumberStart()) {
                    offsetLHToAdd += ((Long)fileSizeList.get(j)).longValue();
                    ++j;
                }
                ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).setOffsetLocalHeader(((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).getOffsetLocalHeader() + offsetLHToAdd - (long)splitSigOverhead);
                ((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i)).setDiskNumberStart(0);
                ++i;
            }
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private void updateSplitEndCentralDirectory(ZipModel zipModel) throws ZipException {
        try {
            if (zipModel == null) {
                throw new ZipException("zip model is null - cannot update end of central directory for split zip model");
            }
            if (zipModel.getCentralDirectory() == null) {
                throw new ZipException("corrupt zip model - getCentralDirectory, cannot update split zip model");
            }
            zipModel.getEndCentralDirRecord().setNoOfThisDisk(0);
            zipModel.getEndCentralDirRecord().setNoOfThisDiskStartOfCentralDir(0);
            zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDir(zipModel.getCentralDirectory().getFileHeaders().size());
            zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(zipModel.getCentralDirectory().getFileHeaders().size());
        }
        catch (ZipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZipException(e);
        }
    }

    private void updateSplitZip64EndCentralDirLocator(ZipModel zipModel, ArrayList fileSizeList) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split Zip64 end of central directory locator");
        }
        if (zipModel.getZip64EndCentralDirLocator() == null) {
            return;
        }
        zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(0);
        long offsetZip64EndCentralDirRec = 0L;
        int i = 0;
        while (i < fileSizeList.size()) {
            offsetZip64EndCentralDirRec += ((Long)fileSizeList.get(i)).longValue();
            ++i;
        }
        zipModel.getZip64EndCentralDirLocator().setOffsetZip64EndOfCentralDirRec(zipModel.getZip64EndCentralDirLocator().getOffsetZip64EndOfCentralDirRec() + offsetZip64EndCentralDirRec);
        zipModel.getZip64EndCentralDirLocator().setTotNumberOfDiscs(1);
    }

    private void updateSplitZip64EndCentralDirRec(ZipModel zipModel, ArrayList fileSizeList) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot update split Zip64 end of central directory record");
        }
        if (zipModel.getZip64EndCentralDirRecord() == null) {
            return;
        }
        zipModel.getZip64EndCentralDirRecord().setNoOfThisDisk(0);
        zipModel.getZip64EndCentralDirRecord().setNoOfThisDiskStartOfCentralDir(0);
        zipModel.getZip64EndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDir());
        long offsetStartCenDirWRTStartDiskNo = 0L;
        int i = 0;
        while (i < fileSizeList.size()) {
            offsetStartCenDirWRTStartDiskNo += ((Long)fileSizeList.get(i)).longValue();
            ++i;
        }
        zipModel.getZip64EndCentralDirRecord().setOffsetStartCenDirWRTStartDiskNo(zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo() + offsetStartCenDirWRTStartDiskNo);
    }

    public void setComment(ZipModel zipModel, String comment) throws ZipException {
        if (comment == null) {
            throw new ZipException("comment is null, cannot update Zip file with comment");
        }
        if (zipModel == null) {
            throw new ZipException("zipModel is null, cannot update Zip file with comment");
        }
        String encodedComment = comment;
        byte[] commentBytes = comment.getBytes();
        int commentLength = comment.length();
        if (Zip4jUtil.isSupportedCharset("windows-1254")) {
            try {
                encodedComment = new String(comment.getBytes("windows-1254"), "windows-1254");
                commentBytes = encodedComment.getBytes("windows-1254");
                commentLength = encodedComment.length();
            }
            catch (UnsupportedEncodingException e) {
                encodedComment = comment;
                commentBytes = comment.getBytes();
                commentLength = comment.length();
            }
        }
        if (commentLength > 65535) {
            throw new ZipException("comment length exceeds maximum length");
        }
        zipModel.getEndCentralDirRecord().setComment(encodedComment);
        zipModel.getEndCentralDirRecord().setCommentBytes(commentBytes);
        zipModel.getEndCentralDirRecord().setCommentLength(commentLength);
        SplitOutputStream outputStream = null;
        try {
            try {
                HeaderWriter headerWriter = new HeaderWriter();
                outputStream = new SplitOutputStream(zipModel.getZipFileObj());
                if (zipModel.isZip64Format()) {
                    outputStream.seek(zipModel.getZip64EndCentralDirRecord().getOffsetStartCenDirWRTStartDiskNo());
                } else {
                    outputStream.seek(zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
                }
                headerWriter.finalizeZipFileWithoutValidations(zipModel, outputStream);
            }
            catch (FileNotFoundException e) {
                throw new ZipException(e);
            }
            catch (IOException e) {
                throw new ZipException(e);
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void initProgressMonitorForRemoveOp(ZipModel zipModel, FileHeader fileHeader, ProgressMonitor progressMonitor) throws ZipException {
        ArrayList<FileHeader> fileHeaderList = new ArrayList<FileHeader>();
        fileHeaderList.add(fileHeader);
        this.initProgressMonitorForRemoveOp(zipModel, fileHeaderList, progressMonitor);
    }

    public void initProgressMonitorForRemoveOp(ZipModel zipModel, ArrayList fileHeaderList, ProgressMonitor progressMonitor) throws ZipException {
        if (zipModel == null || fileHeaderList == null || fileHeaderList.size() <= 0 || progressMonitor == null) {
            throw new ZipException("one of the input parameters is null, cannot calculate total work");
        }
        progressMonitor.setCurrentOperation(2);
        progressMonitor.setFileName(((FileHeader)fileHeaderList.get(0)).getFileName());
        progressMonitor.setTotalWork(this.calculateTotalWorkForRemoveOp(zipModel, fileHeaderList));
        progressMonitor.setState(1);
    }

    private long calculateTotalWorkForRemoveOp(ZipModel zipModel, FileHeader fileHeader) throws ZipException {
        return Zip4jUtil.getFileLengh(zipModel.getZipFileObj()) - fileHeader.getCompressedSize();
    }

    private long calculateTotalWorkForRemoveOp(ZipModel zipModel, ArrayList fileHeaderList) throws ZipException {
        long totalWorkForRemoveOp = 0L;
        int i = 0;
        while (i < fileHeaderList.size()) {
            FileHeader fileHeader = (FileHeader)fileHeaderList.get(i);
            totalWorkForRemoveOp += this.calculateTotalWorkForRemoveOp(zipModel, fileHeader);
            ++i;
        }
        return totalWorkForRemoveOp;
    }

    public void initProgressMonitorForMergeOp(ZipModel zipModel, ProgressMonitor progressMonitor) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot calculate total work for merge op");
        }
        progressMonitor.setCurrentOperation(4);
        progressMonitor.setFileName(zipModel.getZipFileObj().getPath());
        progressMonitor.setTotalWork(this.calculateTotalWorkForMergeOp(zipModel));
        progressMonitor.setState(1);
    }

    private long calculateTotalWorkForMergeOp(ZipModel zipModel) throws ZipException {
        long totSize = 0L;
        if (zipModel.isSplitArchive()) {
            int totNoOfSplitFiles = zipModel.getEndCentralDirRecord().getNoOfThisDisk();
            String partFile = null;
            String curZipFile = zipModel.getZipFileObj().getPath();
            int partNumber = 0;
            int i = 0;
            while (i <= totNoOfSplitFiles) {
                partFile = partNumber == zipModel.getEndCentralDirRecord().getNoOfThisDisk() ? zipModel.getZipFileObj().getPath() : (partNumber >= 9 ? String.valueOf(curZipFile.substring(0, curZipFile.lastIndexOf("."))) + ".z" + (partNumber + 1) : String.valueOf(curZipFile.substring(0, curZipFile.lastIndexOf("."))) + ".z0" + (partNumber + 1));
                totSize += Zip4jUtil.getFileLengh(Zip4jUtil.getFileObj(zipModel.getZipFileObj(), partFile));
                ++i;
            }
        }
        return totSize;
    }
}

