/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import net.lingala.zip4j.io.VFile;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class RandomAccessVFile
extends RandomAccessFile {
    private RandomAccessContent randomAccessContent = null;

    private static File createTempFile() throws IOException {
        return File.createTempFile("zip4j", "");
    }

    private void deleteTempFile(File tempFile) {
        try {
            try {
                super.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            tempFile.delete();
        }
    }

    public RandomAccessVFile(VFile file, String mode) throws IOException {
        this(file, mode, RandomAccessVFile.createTempFile());
    }

    public RandomAccessVFile(VFile file, String mode, File tempFile) throws IOException {
        super(tempFile, mode);
        this.deleteTempFile(tempFile);
        RandomAccessMode randomAccessMode = null;
        if (mode != null) {
            if (mode.equalsIgnoreCase("r")) {
                randomAccessMode = RandomAccessMode.READ;
            } else if (mode.equalsIgnoreCase("rw")) {
                randomAccessMode = RandomAccessMode.READWRITE;
            }
        }
        this.randomAccessContent = ((AbstractFileObject)file.getFileObject()).getRandomAccessContent(randomAccessMode);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.randomAccessContent.getFilePointer();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.randomAccessContent.seek(pos);
    }

    @Override
    public long length() throws IOException {
        return this.randomAccessContent.length();
    }

    @Override
    public void close() throws IOException {
        this.randomAccessContent.close();
    }

    public InputStream getInputStream() throws IOException {
        return this.randomAccessContent.getInputStream();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.randomAccessContent.write(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            this.randomAccessContent.readFully(b, off, len);
        }
        catch (EOFException e) {
            return -1;
        }
        return len;
    }
}

