/*
 * Decompiled with CFR 0.152.
 */
package macromedia.resource.jdbcmysql.spi;

import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.sql.ConnectionEvent;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import macromedia.mysqlutil.ddd;
import macromedia.mysqlutil.ddo;
import macromedia.resource.jdbc.spi.JCAManagedConnectionFactory;
import macromedia.resource.jdbcmysql.JCAClassUtility;
import macromedia.resource.jdbcmysql.JCAConnection;
import macromedia.resource.jdbcmysql.spi.JCAExceptions;
import macromedia.resource.jdbcmysql.spi.JCALocalTransaction;
import macromedia.resource.jdbcmysql.spi.JCALogger;
import macromedia.resource.jdbcmysql.spi.JCAManagedConnectionFactoryCommon;
import macromedia.resource.jdbcmysql.spi.JCAManagedConnectionMetaData;

public class JCAManagedConnection
implements ManagedConnection,
javax.sql.ConnectionEventListener {
    private static String footprint = "$Revision$";
    private PooledConnection physConnection;
    private Connection physConnectionHandle;
    private JCALocalTransaction localTransaction;
    private JCAManagedConnectionMetaData metaData;
    private String username;
    private char[] encryptedPassword;
    private JCAManagedConnectionFactoryCommon ownerFactory;
    private Vector jcaConnections;
    private Vector connectionEventListeners;
    protected JCALogger logger;
    private JCAExceptions exceptions;
    private ddd cipher = new ddd();

    public JCAManagedConnection(PooledConnection pooledConnection, String string, String string2, JCAManagedConnectionFactoryCommon jCAManagedConnectionFactoryCommon, JCALogger jCALogger, JCAExceptions jCAExceptions) {
        ddo.a("connection can not be null", pooledConnection != null);
        ddo.a("ownerFactory can not be null", jCAManagedConnectionFactoryCommon != null);
        ddo.a("exceptions can not be null", jCAExceptions != null);
        this.physConnection = pooledConnection;
        this.username = string;
        this.encryptedPassword = this.cipher.c(string2);
        this.ownerFactory = jCAManagedConnectionFactoryCommon;
        this.logger = jCALogger;
        this.exceptions = jCAExceptions;
        this.jcaConnections = new Vector();
        this.connectionEventListeners = new Vector();
        this.physConnectionHandle = null;
        this.localTransaction = null;
        this.metaData = null;
    }

    protected void finalize() throws Throwable {
        this.commonDestroy();
    }

    public synchronized Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnection.getConnection(Subject subject, ConnectionRequestInfo connectInfo)");
            this.logger.println("subject = " + subject);
            this.logger.println("connectInfo = " + connectionRequestInfo);
        }
        this.validatePhysicalConnection();
        if (!this.ownerFactory.matchAuthenticationInfo(this, subject, connectionRequestInfo)) {
            throw this.exceptions.getException(4305, 2);
        }
        JCAManagedConnection jCAManagedConnection = this;
        JCAConnection jCAConnection = JCAClassUtility.a(jCAManagedConnection, jCAManagedConnection.logger, this.exceptions);
        this.jcaConnections.add(new WeakReference<JCAConnection>(jCAConnection));
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnection.getConnection", jCAConnection);
        }
        return jCAConnection;
    }

    public synchronized void destroy() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnection.destroy()");
        }
        this.commonCleanup();
        this.commonDestroy();
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnection.destroy");
        }
    }

    public synchronized void cleanup() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnection.cleanup()");
        }
        this.commonCleanup();
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnection.cleanup");
        }
    }

    public synchronized void associateConnection(Object object) throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnection.associateConnection(Object connectionHandle)");
            this.logger.println("connectionHandle = " + object);
        }
        this.validatePhysicalConnection();
        if (!(object instanceof JCAConnection)) {
            throw this.exceptions.getException(4306, 2);
        }
        ((JCAConnection)object).a(this);
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnection.associateConnection");
        }
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnection.addConnectionEventListener(ConnectionEventListener listener)");
            this.logger.println("listener = " + connectionEventListener);
        }
        this.connectionEventListeners.add(connectionEventListener);
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnection.addConnectionEventListener");
        }
        this.physConnection.addConnectionEventListener(this);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnection.removeConnectionEventListener(ConnectionEventListener listener)");
            this.logger.println("listener = " + connectionEventListener);
        }
        this.connectionEventListeners.remove(connectionEventListener);
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnection.removeConnectionEventListener");
        }
    }

    public synchronized XAResource getXAResource() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnection.getXAResource()");
        }
        this.validatePhysicalConnection();
        if (!(this.physConnection instanceof XAConnection)) {
            throw this.exceptions.getException(4312, 0);
        }
        try {
            XAResource xAResource = ((XAConnection)this.physConnection).getXAResource();
            if (this.logger.getLogWriter() != null) {
                this.logger.printExit("ManagedConnection.getXAResource", xAResource);
            }
            return xAResource;
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException(sQLException, 1);
        }
    }

    public synchronized LocalTransaction getLocalTransaction() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnection.getLocalTransaction()");
        }
        this.validatePhysicalConnection();
        if (this.localTransaction == null) {
            this.localTransaction = new JCALocalTransaction(this);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnection.getLocalTransaction", this.localTransaction);
        }
        return this.localTransaction;
    }

    public synchronized ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ManagedConnection.getMetaData()");
        }
        this.validatePhysicalConnection();
        if (this.metaData == null) {
            this.metaData = new JCAManagedConnectionMetaData(this.getPhysicalConnectionHandle(), this.logger, this.exceptions);
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnection.getMetaData", this.metaData);
        }
        return this.metaData;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (this.logger != null) {
            if (this.logger.getLogWriter() != null) {
                this.logger.printEnter("ManagedConnection.setLogWriter(PrintWriter logWriter)");
                this.logger.println("logWriter = " + printWriter);
            }
            this.logger.cleanup();
        }
        this.logger = new JCALogger(printWriter);
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ManagedConnection.setLogWriter");
        }
    }

    public synchronized PrintWriter getLogWriter() throws ResourceException {
        PrintWriter printWriter = this.logger.getLogWriter();
        if (printWriter != null) {
            this.logger.printEnter("ManagedConnection.getLogWriter()");
            this.logger.printExit("ManagedConnection.getLogWriter", printWriter);
        }
        return printWriter;
    }

    public synchronized void connectionHandleClosed(JCAConnection jCAConnection) throws ResourceException {
        this.validatePhysicalConnection();
        this.jcaConnections.remove(jCAConnection);
        this.fireConnectionClosed(jCAConnection);
    }

    public synchronized JCAManagedConnectionFactory getOwnerFactory() {
        return this.ownerFactory;
    }

    public synchronized String getUsername() {
        return this.username;
    }

    public synchronized String getPassword() {
        return this.cipher.a(this.encryptedPassword);
    }

    public synchronized Connection getPhysicalConnectionHandle() throws ResourceException {
        if (this.physConnectionHandle == null) {
            try {
                this.physConnectionHandle = this.physConnection.getConnection();
            }
            catch (SQLException sQLException) {
                throw this.exceptions.getException(sQLException, 1);
            }
        }
        return this.physConnectionHandle;
    }

    final synchronized JCAExceptions getExceptions() {
        return this.exceptions;
    }

    final synchronized JCALogger getLogger() {
        return this.logger;
    }

    final synchronized void fireConnectionClosed(JCAConnection jCAConnection) {
        int n2 = this.connectionEventListeners.size();
        ConnectionEventListener connectionEventListener = null;
        javax.resource.spi.ConnectionEvent connectionEvent = new javax.resource.spi.ConnectionEvent((ManagedConnection)this, 1);
        connectionEvent.setConnectionHandle((Object)jCAConnection);
        for (int i2 = 0; i2 < n2; ++i2) {
            connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.get(i2);
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    final synchronized void fireLocalTransactionStarted() {
        int n2 = this.connectionEventListeners.size();
        ConnectionEventListener connectionEventListener = null;
        javax.resource.spi.ConnectionEvent connectionEvent = new javax.resource.spi.ConnectionEvent((ManagedConnection)this, 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.get(i2);
            connectionEventListener.localTransactionStarted(connectionEvent);
        }
    }

    final synchronized void fireLocalTransactionCommitted() {
        int n2 = this.connectionEventListeners.size();
        ConnectionEventListener connectionEventListener = null;
        javax.resource.spi.ConnectionEvent connectionEvent = new javax.resource.spi.ConnectionEvent((ManagedConnection)this, 3);
        for (int i2 = 0; i2 < n2; ++i2) {
            connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.get(i2);
            connectionEventListener.localTransactionCommitted(connectionEvent);
        }
    }

    final synchronized void fireLocalTransactionRolledBack() {
        int n2 = this.connectionEventListeners.size();
        ConnectionEventListener connectionEventListener = null;
        javax.resource.spi.ConnectionEvent connectionEvent = new javax.resource.spi.ConnectionEvent((ManagedConnection)this, 4);
        for (int i2 = 0; i2 < n2; ++i2) {
            connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.get(i2);
            connectionEventListener.localTransactionRolledback(connectionEvent);
        }
    }

    public synchronized void fireConnectionErrorOccurred(ResourceException resourceException) {
        int n2 = this.connectionEventListeners.size();
        ConnectionEventListener connectionEventListener = null;
        javax.resource.spi.ConnectionEvent connectionEvent = new javax.resource.spi.ConnectionEvent((ManagedConnection)this, 5, (Exception)((Object)resourceException));
        for (int i2 = 0; i2 < n2; ++i2) {
            connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.get(i2);
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    private final void validatePhysicalConnection() throws ResourceException {
        if (this.physConnection == null) {
            throw this.exceptions.getException(4304, 2);
        }
    }

    private final void commonCleanup() throws ResourceException {
        try {
            this.cleanupJCAConnections();
            if (this.physConnectionHandle != null) {
                this.physConnectionHandle.close();
            }
            this.physConnectionHandle = null;
            this.localTransaction = null;
            this.metaData = null;
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException(sQLException, 1);
        }
    }

    private final void commonDestroy() throws ResourceException {
        if (this.physConnection != null) {
            try {
                this.physConnection.close();
                this.physConnection = null;
            }
            catch (SQLException sQLException) {
                throw this.exceptions.getException(sQLException, 1);
            }
        }
    }

    private final void cleanupJCAConnections() {
        int n2 = this.jcaConnections.size();
        WeakReference weakReference = null;
        JCAConnection jCAConnection = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            weakReference = (WeakReference)this.jcaConnections.get(i2);
            jCAConnection = (JCAConnection)weakReference.get();
            if (jCAConnection == null) continue;
            jCAConnection.c();
        }
        this.jcaConnections.removeAllElements();
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        SQLException sQLException = connectionEvent.getSQLException();
        ResourceException resourceException = new ResourceException("Connection Error occured.  See cause for details");
        resourceException.initCause((Throwable)sQLException);
        this.fireConnectionErrorOccurred(resourceException);
    }
}

