/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webservice;

import coldfusion.exchange.ExchangeAbstractObject;
import coldfusion.exchange.ExchangeAppointment;
import coldfusion.exchange.ExchangeContact;
import coldfusion.exchange.ExchangeMessage;
import coldfusion.exchange.ExchangeTask;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webservice.SOAPMessage;
import coldfusion.exchange.webservice.XMLElement;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HttpURL;

public class Exchange2007WebServiceHelper {
    public static String createGetItemRequest(String itemId, String changeKey, String encoding) throws Exception {
        SOAPMessage msg = new SOAPMessage(encoding);
        XMLElement getItemElm = new XMLElement("<GetItem xmlns=\"http://schemas.microsoft.com/exchange/services/2006/messages\" xmlns:t=\"http://schemas.microsoft.com/exchange/services/2006/types\">", "</GetItem>", null);
        XMLElement itemShapeElm = new XMLElement("<ItemShape>", "</ItemShape>", null, getItemElm);
        XMLElement baseShapeElm = new XMLElement("<t:BaseShape>", "</t:BaseShape>", "Default", itemShapeElm);
        XMLElement mimeContentElm = new XMLElement("<t:IncludeMimeContent>", "</t:IncludeMimeContent>", "false", itemShapeElm);
        XMLElement itemIdsElm = new XMLElement("<ItemIds>", "</ItemIds>", null, getItemElm);
        XMLElement idElm = new XMLElement("<t:ItemId Id=\"" + itemId + "\" ChangeKey=\"" + changeKey + "\" />", null, null, itemIdsElm);
        msg.addMessageElement(getItemElm);
        return msg.toString();
    }

    public static String createGetAttachmentRequest(String atchId, String encoding) throws Exception {
        SOAPMessage msg = new SOAPMessage(encoding);
        XMLElement getAtchElm = new XMLElement("<GetAttachment xmlns=\"http://schemas.microsoft.com/exchange/services/2006/messages\" xmlns:t=\"http://schemas.microsoft.com/exchange/services/2006/types\">", "</GetAttachment>", null);
        XMLElement atchShapeElm = new XMLElement("<AttachmentShape/>", null, null, getAtchElm);
        XMLElement atchIdsElm = new XMLElement("<AttachmentIds>", "</AttachmentIds>", null, getAtchElm);
        XMLElement idElm = new XMLElement("<t:AttachmentId Id=\"" + atchId + "\" />", null, null, atchIdsElm);
        msg.addMessageElement(getAtchElm);
        return msg.toString();
    }

    public static String createFindFolderRequest(String folderName, String rootFolder, String parentId, String parentChangeKey, String encoding) throws Exception {
        SOAPMessage msg = new SOAPMessage(encoding);
        XMLElement findFolderElm = new XMLElement("<FindFolder  Traversal=\"Shallow\" xmlns=\"http://schemas.microsoft.com/exchange/services/2006/messages\" xmlns:t=\"http://schemas.microsoft.com/exchange/services/2006/types\">", "</FindFolder>", null);
        XMLElement folderShapeElm = new XMLElement("<FolderShape>", "</FolderShape>", null, findFolderElm);
        XMLElement baseSElement = new XMLElement("<t:BaseShape>", "</t:BaseShape>", "Default", folderShapeElm);
        XMLElement restrictionElm = Exchange2007WebServiceHelper.createEqualToRestriction("folder:DisplayName", folderName, findFolderElm);
        XMLElement parentFolderElm = new XMLElement("<ParentFolderIds>", "</ParentFolderIds>", null, findFolderElm);
        if (parentId == null) {
            XMLElement xMLElement = new XMLElement("<t:DistinguishedFolderId Id=\"" + rootFolder + "\"/>", null, null, parentFolderElm);
        } else {
            XMLElement xMLElement = new XMLElement("<t:FolderId Id=\"" + parentId + "\" ChangeKey=\"" + parentChangeKey + "\"/>", null, null, parentFolderElm);
        }
        msg.addMessageElement(findFolderElm);
        return msg.toString();
    }

    private static XMLElement createEqualToRestriction(String field, String value, XMLElement parent) throws Exception {
        XMLElement restrictionElm = new XMLElement("<Restriction>", "</Restriction>", null, parent);
        XMLElement equalToElm = Exchange2007WebServiceHelper.createEqualToElement(field, value, restrictionElm);
        return restrictionElm;
    }

    private static XMLElement createEqualToElement(String field, String value, XMLElement parent) throws Exception {
        XMLElement equalToElm = new XMLElement("<ns5:IsEqualTo xmlns:ns5=\"http://schemas.microsoft.com/exchange/services/2006/types\">", "</ns5:IsEqualTo>", null, parent);
        XMLElement fieldURIElm = new XMLElement("<ns5:FieldURI FieldURI=\"" + field + "\"/>", null, null, equalToElm);
        XMLElement uriOrContelm = new XMLElement("<ns5:FieldURIOrConstant>", "</ns5:FieldURIOrConstant>", null, equalToElm);
        XMLElement constElm = new XMLElement("<ns5:Constant Value=\"" + value + "\" />", null, null, uriOrContelm);
        return equalToElm;
    }

    public static XMLElement createCalendarRestriction(ExchangeAppointment apt, XMLElement parent) throws Exception {
        String subject;
        StringBuffer xmlBuf = new StringBuffer("<Restriction>\n");
        xmlBuf.append("<And xmlns=\"http://schemas.microsoft.com/exchange/services/2006/types\">\n");
        xmlBuf.append(Exchange2007WebServiceHelper.createEqualToElement("item:HasAttachments", "true", null).toString());
        XMLElement tmpElm = Exchange2007WebServiceHelper.createEqualToElement("calendar:Start", Utils.localToLongExchangeDate(apt.getStartTime(), true), null);
        xmlBuf.append(tmpElm.toString() + "\n");
        if (apt.getEndTime() != null) {
            tmpElm = Exchange2007WebServiceHelper.createEqualToElement("calendar:End", Utils.localToLongExchangeDate(apt.getEndTime(), true), null);
            xmlBuf.append(tmpElm.toString() + "\n");
        }
        if ((subject = apt.getSubject()) != null && subject.length() > 0) {
            tmpElm = Exchange2007WebServiceHelper.createEqualToElement("item:Subject", subject, null);
            xmlBuf.append(tmpElm.toString() + "\n");
        }
        xmlBuf.append("</And>\n</Restriction>");
        return new XMLElement(xmlBuf.toString(), parent);
    }

    public static String createFindItemRequest(ExchangeAbstractObject exchObj, String folderName, String parentFolderId, String parentFolderChangeKey, String encoding) throws Exception {
        SOAPMessage msg = new SOAPMessage(encoding);
        XMLElement findItemElm = new XMLElement("<FindItem Traversal=\"Shallow\" xmlns=\"http://schemas.microsoft.com/exchange/services/2006/messages\">", "</FindItem>", null);
        XMLElement itemShapeElm = new XMLElement("<ItemShape>", "</ItemShape>", null, findItemElm);
        XMLElement baseShapeElm = new XMLElement("<ns2:BaseShape xmlns:ns2=\"http://schemas.microsoft.com/exchange/services/2006/types\">", "</ns2:BaseShape>", "AllProperties", itemShapeElm);
        XMLElement restrictionElm = null;
        if (exchObj instanceof ExchangeAppointment) {
            restrictionElm = Exchange2007WebServiceHelper.createCalendarRestriction((ExchangeAppointment)exchObj, findItemElm);
        } else if (exchObj instanceof ExchangeContact) {
            restrictionElm = Exchange2007WebServiceHelper.createContactRestriction((ExchangeContact)exchObj, findItemElm);
        } else if (exchObj instanceof ExchangeTask) {
            restrictionElm = Exchange2007WebServiceHelper.createTaskRestriction((ExchangeTask)exchObj, findItemElm);
        } else if (exchObj instanceof ExchangeMessage) {
            restrictionElm = Exchange2007WebServiceHelper.createMessageRestriction((ExchangeMessage)exchObj, findItemElm);
        }
        XMLElement parentFolderElm = new XMLElement("<ParentFolderIds>", "</ParentFolderIds>", null, findItemElm);
        if (parentFolderId == null) {
            XMLElement xMLElement = new XMLElement("<ns3:DistinguishedFolderId Id=\"" + folderName + "\" xmlns:ns3=\"http://schemas.microsoft.com/exchange/services/2006/types\"/>", null, null, parentFolderElm);
        } else {
            XMLElement xMLElement = new XMLElement("<t:FolderId Id=\"" + parentFolderId + "\" ChangeKey=\"" + parentFolderChangeKey + "\"  xmlns:t=\"http://schemas.microsoft.com/exchange/services/2006/types\"/>", null, null, parentFolderElm);
        }
        msg.addMessageElement(findItemElm);
        return msg.toString();
    }

    private static XMLElement createContactRestriction(ExchangeContact contact, XMLElement parent) throws Exception {
        XMLElement tmpElm;
        StringBuffer xmlBuf = new StringBuffer("<Restriction>\n");
        xmlBuf.append("<And xmlns=\"http://schemas.microsoft.com/exchange/services/2006/types\">\n");
        xmlBuf.append(Exchange2007WebServiceHelper.createEqualToElement("item:HasAttachments", "true", null).toString());
        if (contact.getFirstName() != null) {
            tmpElm = Exchange2007WebServiceHelper.createEqualToElement("contacts:GivenName", contact.getFirstName(), null);
            xmlBuf.append(tmpElm.toString() + "\n");
        }
        if (contact.getMiddleName() != null) {
            tmpElm = Exchange2007WebServiceHelper.createEqualToElement("contacts:MiddleName", contact.getMiddleName(), null);
            xmlBuf.append(tmpElm.toString() + "\n");
        }
        if (contact.getLastName() != null) {
            tmpElm = Exchange2007WebServiceHelper.createEqualToElement("contacts:Surname", contact.getLastName(), null);
            xmlBuf.append(tmpElm.toString() + "\n");
        }
        if (contact.getCompany() != null) {
            tmpElm = Exchange2007WebServiceHelper.createEqualToElement("contacts:CompanyName", contact.getCompany(), null);
            xmlBuf.append(tmpElm.toString() + "\n");
        }
        xmlBuf.append("</And>\n</Restriction>");
        return new XMLElement(xmlBuf.toString(), parent);
    }

    private static XMLElement createMessageRestriction(ExchangeMessage msg, XMLElement parent) throws Exception {
        StringBuffer xmlBuf = new StringBuffer("<Restriction>\n");
        xmlBuf.append("<And xmlns=\"http://schemas.microsoft.com/exchange/services/2006/types\">\n");
        xmlBuf.append(Exchange2007WebServiceHelper.createEqualToElement("item:HasAttachments", "true", null).toString());
        XMLElement containsElm = new XMLElement("<ns5:Contains ContainmentComparison=\"IgnoreCase\" ContainmentMode=\"Substring\" xmlns:ns5=\"http://schemas.microsoft.com/exchange/services/2006/types\">", "</ns5:Contains>", null, null);
        XMLElement fieldURIElm = new XMLElement("<ns5:FieldURI FieldURI=\"message:InternetMessageId\"/>", null, null, containsElm);
        XMLElement constElm = new XMLElement("<ns5:Constant Value=\"" + Exchange2007WebServiceHelper.getEncodedHref(msg.getId()) + "\" />", null, null, containsElm);
        xmlBuf.append(containsElm.toString());
        xmlBuf.append("</And>\n</Restriction>");
        return new XMLElement(xmlBuf.toString(), parent);
    }

    private static XMLElement createTaskRestriction(ExchangeTask tsk, XMLElement parent) throws Exception {
        StringBuffer xmlBuf = new StringBuffer("<Restriction>\n");
        if (tsk.getSubject() != null) {
            xmlBuf.append("<And xmlns=\"http://schemas.microsoft.com/exchange/services/2006/types\">\n");
        }
        xmlBuf.append(Exchange2007WebServiceHelper.createEqualToElement("item:HasAttachments", "true", null).toString());
        if (tsk.getSubject() != null) {
            XMLElement tmpElm = Exchange2007WebServiceHelper.createEqualToElement("item:Subject", tsk.getSubject(), null);
            xmlBuf.append(tmpElm.toString() + "\n");
        }
        if (tsk.getSubject() != null) {
            xmlBuf.append("</And>\n");
        }
        xmlBuf.append("</Restriction>");
        return new XMLElement(xmlBuf.toString(), parent);
    }

    private static String getEncodedHref(String href) {
        if (href == null) {
            return "";
        }
        try {
            HttpURL url = new HttpURL(href);
            String strUrl = url.getEscapedURI();
            int index = href.indexOf(35);
            if (index >= 0 && strUrl.indexOf(35) == -1) {
                String str1 = href.substring(index + 1);
                StringTokenizer tkn = new StringTokenizer(str1, "#");
                while (tkn.hasMoreTokens()) {
                    strUrl = strUrl + "#" + new HttpURL(tkn.nextToken()).getEscapedURI();
                }
            }
            return strUrl;
        }
        catch (Exception e) {
            return "";
        }
    }
}

