/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange;

import java.util.Map;

public abstract class ExchangeLoginInfo {
    public static final String _2007 = "2007";
    public static final String _2010 = "2010";
    public static final String _2010_SP1 = "2010_SP1";
    public static final String _2010_SP2 = "2010_SP2";
    public static final String _2003 = "2003";
    public static final String _2013 = "2013";
    public static final String _2016 = "2016";
    public static final String _2019 = "2019";
    private String mailId;
    private String exchangeHost;
    private String userPassword;
    private String domainName;
    private String proxyHost;
    private int proxyPort = -1;
    private String protocol = "http";
    private int port = -1;
    private String mailBoxName = null;
    private String exchangeServerLanguage = "english";
    private boolean formBasedAuthentication = false;
    private String exchangeAppName = "exchange";
    private String formBasedAuthenticationUrl = null;
    private Map folderNameMapping = null;
    private String exchangeVersion = "2007";

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExchangeLoginInfo)) {
            return false;
        }
        ExchangeLoginInfo info = (ExchangeLoginInfo)obj;
        if (!info.getDomainName().equalsIgnoreCase(this.getDomainName())) {
            return false;
        }
        if (!info.getExchangeHost().equalsIgnoreCase(this.getExchangeHost())) {
            return false;
        }
        if (!info.getMailId().equalsIgnoreCase(this.getMailId())) {
            return false;
        }
        if (!info.getUserPassword().equalsIgnoreCase(this.getUserPassword())) {
            return false;
        }
        return info.getMailBoxName().equalsIgnoreCase(this.getMailBoxName());
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getExchangeHost() {
        return this.exchangeHost;
    }

    public void setExchangeHost(String exchangeHost) {
        this.exchangeHost = exchangeHost;
    }

    public String getMailId() {
        return this.mailId;
    }

    public void setMailId(String mailId) {
        this.mailId = mailId;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public String getExchangeUrl() {
        StringBuffer buf = new StringBuffer(this.protocol);
        buf.append("://");
        buf.append(this.exchangeHost);
        if (this.port != -1) {
            buf.append(":" + this.port);
        }
        buf.append("/" + this.getExchangeAppName() + "/");
        buf.append(this.getMailBoxName());
        return buf.toString();
    }

    public String getUrlForFormedBasedAuthentication() {
        if (this.getFormBasedAuthenticationUrl() != null) {
            return this.getFormBasedAuthenticationUrl();
        }
        StringBuffer buf = new StringBuffer(this.protocol);
        buf.append("://");
        buf.append(this.exchangeHost);
        if (this.port != -1) {
            buf.append(":" + this.port);
        }
        buf.append("/exchweb/bin/auth/owaauth.dll");
        return buf.toString();
    }

    public String getMailBoxName() {
        if (this.mailBoxName == null) {
            this.mailBoxName = this.mailId;
            int index = -1;
            index = this.mailBoxName.indexOf(92);
            if (index >= 0) {
                this.mailBoxName = this.mailBoxName.substring(index + 1);
            }
        }
        return this.mailBoxName;
    }

    public void setMailBoxName(String mailBoxName) {
        this.mailBoxName = mailBoxName;
    }

    public String getExchangeServerLanguage() {
        return this.exchangeServerLanguage;
    }

    public void setExchangeServerLanguage(String exchangeServerLanguage) {
        if (exchangeServerLanguage != null) {
            this.exchangeServerLanguage = exchangeServerLanguage.trim();
        }
    }

    public Map getFolderNameMapping() {
        return this.folderNameMapping;
    }

    public void setFolderNameMapping(Map folderNameMapping) {
        this.folderNameMapping = folderNameMapping;
    }

    public boolean isEnglishExchangeServer() {
        return this.getExchangeServerLanguage().equalsIgnoreCase("english");
    }

    public boolean isFormBasedAuthentication() {
        return this.formBasedAuthentication;
    }

    public void setFormBasedAuthentication(boolean formBasedAuthentication) {
        this.formBasedAuthentication = formBasedAuthentication;
    }

    public String getExchangeAppName() {
        return this.exchangeAppName;
    }

    public void setExchangeAppName(String excahngeAppName) {
        this.exchangeAppName = excahngeAppName;
    }

    public String getFormBasedAuthenticationUrl() {
        return this.formBasedAuthenticationUrl;
    }

    public void setFormBasedAuthenticationUrl(String formBasedAuthenticationUrl) {
        this.formBasedAuthenticationUrl = formBasedAuthenticationUrl;
    }

    public void setExchangeVersion(String exchangeVersion) {
        this.exchangeVersion = exchangeVersion;
    }

    public String getExchangeVersion() {
        return this.exchangeVersion;
    }
}

