/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleCache<T>
extends Single<T>
implements SingleObserver<T> {
    static final CacheDisposable[] EMPTY = new CacheDisposable[0];
    static final CacheDisposable[] TERMINATED = new CacheDisposable[0];
    final SingleSource<? extends T> source;
    final AtomicInteger wip;
    final AtomicReference<CacheDisposable<T>[]> observers;
    T value;
    Throwable error;

    public SingleCache(SingleSource<? extends T> source2) {
        this.source = source2;
        this.wip = new AtomicInteger();
        this.observers = new AtomicReference<CacheDisposable[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        CacheDisposable<T> d = new CacheDisposable<T>(observer, this);
        observer.onSubscribe(d);
        if (this.add(d)) {
            if (d.isDisposed()) {
                this.remove(d);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                observer.onError(ex);
            } else {
                observer.onSuccess(this.value);
            }
            return;
        }
        if (this.wip.getAndIncrement() == 0) {
            this.source.subscribe(this);
        }
    }

    boolean add(CacheDisposable<T> observer) {
        CacheDisposable[] b;
        CacheDisposable<T>[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new CacheDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = observer;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(CacheDisposable<T> observer) {
        CacheDisposable[] b;
        CacheDisposable<T>[] a;
        do {
            int n;
            if ((n = (a = this.observers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != observer) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new CacheDisposable[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.observers.compareAndSet(a, b));
    }

    @Override
    public void onSubscribe(Disposable d) {
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        for (CacheDisposable d : this.observers.getAndSet(TERMINATED)) {
            if (d.isDisposed()) continue;
            d.downstream.onSuccess(value);
        }
    }

    @Override
    public void onError(Throwable e) {
        this.error = e;
        for (CacheDisposable d : this.observers.getAndSet(TERMINATED)) {
            if (d.isDisposed()) continue;
            d.downstream.onError(e);
        }
    }

    static final class CacheDisposable<T>
    extends AtomicBoolean
    implements Disposable {
        private static final long serialVersionUID = 7514387411091976596L;
        final SingleObserver<? super T> downstream;
        final SingleCache<T> parent;

        CacheDisposable(SingleObserver<? super T> actual, SingleCache<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.parent.remove(this);
            }
        }
    }
}

