/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.api.GraphqlFragment;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.internal.ApolloLogger;
import com.apollographql.apollo.api.internal.ResolveDelegate;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.OptimisticNormalizedCache;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.cache.normalized.internal.CacheFieldValueResolver;
import com.apollographql.apollo.cache.normalized.internal.CacheKeyBuilder;
import com.apollographql.apollo.cache.normalized.internal.ReadableStore;
import com.apollographql.apollo.cache.normalized.internal.RealCacheKeyBuilder;
import com.apollographql.apollo.cache.normalized.internal.ResponseNormalizer;
import com.apollographql.apollo.cache.normalized.internal.Transaction;
import com.apollographql.apollo.cache.normalized.internal.WriteableStore;
import com.apollographql.apollo.internal.response.RealResponseReader;
import com.apollographql.apollo.internal.response.RealResponseWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RealApolloStore
implements ApolloStore,
ReadableStore,
WriteableStore {
    final OptimisticNormalizedCache optimisticCache;
    final CacheKeyResolver cacheKeyResolver;
    final ScalarTypeAdapters scalarTypeAdapters;
    private final ReadWriteLock lock;
    private final Set<ApolloStore.RecordChangeSubscriber> subscribers;
    private final Executor dispatcher;
    private final CacheKeyBuilder cacheKeyBuilder;
    final ApolloLogger logger;

    public RealApolloStore(@NotNull NormalizedCache normalizedCache, @NotNull CacheKeyResolver cacheKeyResolver, @NotNull ScalarTypeAdapters scalarTypeAdapters, @NotNull Executor dispatcher, @NotNull ApolloLogger logger) {
        Utils.checkNotNull(normalizedCache, "cacheStore == null");
        this.optimisticCache = (OptimisticNormalizedCache)new OptimisticNormalizedCache().chain(normalizedCache);
        this.cacheKeyResolver = Utils.checkNotNull(cacheKeyResolver, "cacheKeyResolver == null");
        this.scalarTypeAdapters = Utils.checkNotNull(scalarTypeAdapters, "scalarTypeAdapters == null");
        this.dispatcher = Utils.checkNotNull(dispatcher, "dispatcher == null");
        this.logger = Utils.checkNotNull(logger, "logger == null");
        this.lock = new ReentrantReadWriteLock();
        this.subscribers = Collections.newSetFromMap(new WeakHashMap());
        this.cacheKeyBuilder = new RealCacheKeyBuilder();
    }

    @Override
    public ResponseNormalizer<Map<String, Object>> networkResponseNormalizer() {
        return new ResponseNormalizer<Map<String, Object>>(){

            @Override
            @NotNull
            public CacheKey resolveCacheKey(@NotNull ResponseField field, @NotNull Map<String, Object> record) {
                return RealApolloStore.this.cacheKeyResolver.fromFieldRecordSet(field, record);
            }

            @Override
            @NotNull
            public CacheKeyBuilder cacheKeyBuilder() {
                return RealApolloStore.this.cacheKeyBuilder;
            }
        };
    }

    @Override
    public ResponseNormalizer<Record> cacheResponseNormalizer() {
        return new ResponseNormalizer<Record>(){

            @Override
            @NotNull
            public CacheKey resolveCacheKey(@NotNull ResponseField field, @NotNull Record record) {
                return new CacheKey(record.key());
            }

            @Override
            @NotNull
            public CacheKeyBuilder cacheKeyBuilder() {
                return RealApolloStore.this.cacheKeyBuilder;
            }
        };
    }

    @Override
    public synchronized void subscribe(ApolloStore.RecordChangeSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    @Override
    public synchronized void unsubscribe(ApolloStore.RecordChangeSubscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(@NotNull Set<String> changedKeys) {
        LinkedHashSet<ApolloStore.RecordChangeSubscriber> iterableSubscribers;
        Utils.checkNotNull(changedKeys, "changedKeys == null");
        if (changedKeys.isEmpty()) {
            return;
        }
        RealApolloStore realApolloStore = this;
        synchronized (realApolloStore) {
            iterableSubscribers = new LinkedHashSet<ApolloStore.RecordChangeSubscriber>(this.subscribers);
        }
        RuntimeException firstException = null;
        for (ApolloStore.RecordChangeSubscriber subscriber : iterableSubscribers) {
            try {
                subscriber.onCacheRecordsChanged(changedKeys);
            }
            catch (RuntimeException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    @Override
    @NotNull
    public ApolloStoreOperation<Boolean> clearAll() {
        return new ApolloStoreOperation<Boolean>(this.dispatcher){

            @Override
            public Boolean perform() {
                return RealApolloStore.this.writeTransaction(new Transaction<WriteableStore, Boolean>(){

                    @Override
                    public Boolean execute(WriteableStore cache) {
                        RealApolloStore.this.optimisticCache.clearAll();
                        return Boolean.TRUE;
                    }
                });
            }
        };
    }

    @Override
    @NotNull
    public ApolloStoreOperation<Boolean> remove(@NotNull CacheKey cacheKey) {
        return this.remove(cacheKey, false);
    }

    @Override
    @NotNull
    public ApolloStoreOperation<Boolean> remove(final @NotNull CacheKey cacheKey, final boolean cascade) {
        Utils.checkNotNull(cacheKey, "cacheKey == null");
        return new ApolloStoreOperation<Boolean>(this.dispatcher){

            @Override
            protected Boolean perform() {
                return RealApolloStore.this.writeTransaction(new Transaction<WriteableStore, Boolean>(){

                    @Override
                    public Boolean execute(WriteableStore cache) {
                        return RealApolloStore.this.optimisticCache.remove(cacheKey, cascade);
                    }
                });
            }
        };
    }

    @Override
    @NotNull
    public ApolloStoreOperation<Integer> remove(final @NotNull List<CacheKey> cacheKeys) {
        Utils.checkNotNull(cacheKeys, "cacheKey == null");
        return new ApolloStoreOperation<Integer>(this.dispatcher){

            @Override
            protected Integer perform() {
                return RealApolloStore.this.writeTransaction(new Transaction<WriteableStore, Integer>(){

                    @Override
                    public Integer execute(WriteableStore cache) {
                        int count = 0;
                        for (CacheKey cacheKey : cacheKeys) {
                            if (!RealApolloStore.this.optimisticCache.remove(cacheKey)) continue;
                            ++count;
                        }
                        return count;
                    }
                });
            }
        };
    }

    @Override
    public <R> R readTransaction(Transaction<ReadableStore, R> transaction) {
        this.lock.readLock().lock();
        try {
            R r = transaction.execute(this);
            return r;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <R> R writeTransaction(Transaction<WriteableStore, R> transaction) {
        this.lock.writeLock().lock();
        try {
            R r = transaction.execute(this);
            return r;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public NormalizedCache normalizedCache() {
        return this.optimisticCache;
    }

    @Override
    @Nullable
    public Record read(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        return this.optimisticCache.loadRecord(Utils.checkNotNull(key, "key == null"), cacheHeaders);
    }

    @Override
    @NotNull
    public Collection<Record> read(@NotNull Collection<String> keys2, @NotNull CacheHeaders cacheHeaders) {
        return this.optimisticCache.loadRecords(Utils.checkNotNull(keys2, "keys == null"), cacheHeaders);
    }

    @Override
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> recordSet, @NotNull CacheHeaders cacheHeaders) {
        return this.optimisticCache.merge(Utils.checkNotNull(recordSet, "recordSet == null"), cacheHeaders);
    }

    @Override
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        return this.optimisticCache.merge(Utils.checkNotNull(record, "record == null"), cacheHeaders);
    }

    @Override
    public CacheKeyResolver cacheKeyResolver() {
        return this.cacheKeyResolver;
    }

    @Override
    @NotNull
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloStoreOperation<T> read(final @NotNull Operation<D, T, V> operation) {
        Utils.checkNotNull(operation, "operation == null");
        return new ApolloStoreOperation<T>(this.dispatcher){

            @Override
            protected T perform() {
                return RealApolloStore.this.doRead(operation);
            }
        };
    }

    @Override
    @NotNull
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloStoreOperation<Response<T>> read(final @NotNull Operation<D, T, V> operation, final @NotNull ResponseFieldMapper<D> responseFieldMapper, final @NotNull ResponseNormalizer<Record> responseNormalizer, final @NotNull CacheHeaders cacheHeaders) {
        Utils.checkNotNull(operation, "operation == null");
        Utils.checkNotNull(responseNormalizer, "responseNormalizer == null");
        return new ApolloStoreOperation<Response<T>>(this.dispatcher){

            @Override
            protected Response<T> perform() {
                return RealApolloStore.this.doRead(operation, responseFieldMapper, responseNormalizer, cacheHeaders);
            }
        };
    }

    @Override
    @NotNull
    public <F extends GraphqlFragment> ApolloStoreOperation<F> read(final @NotNull ResponseFieldMapper<F> responseFieldMapper, final @NotNull CacheKey cacheKey, final @NotNull Operation.Variables variables) {
        Utils.checkNotNull(responseFieldMapper, "responseFieldMapper == null");
        Utils.checkNotNull(cacheKey, "cacheKey == null");
        Utils.checkNotNull(variables, "variables == null");
        return new ApolloStoreOperation<F>(this.dispatcher){

            @Override
            protected F perform() {
                return RealApolloStore.this.doRead(responseFieldMapper, cacheKey, variables);
            }
        };
    }

    @Override
    @NotNull
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloStoreOperation<Set<String>> write(final @NotNull Operation<D, T, V> operation, final @NotNull D operationData) {
        Utils.checkNotNull(operation, "operation == null");
        Utils.checkNotNull(operationData, "operationData == null");
        return new ApolloStoreOperation<Set<String>>(this.dispatcher){

            @Override
            protected Set<String> perform() {
                return RealApolloStore.this.doWrite(operation, operationData, false, null);
            }
        };
    }

    @Override
    @NotNull
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloStoreOperation<Boolean> writeAndPublish(final @NotNull Operation<D, T, V> operation, final @NotNull D operationData) {
        return new ApolloStoreOperation<Boolean>(this.dispatcher){

            @Override
            protected Boolean perform() {
                Set<String> changedKeys = RealApolloStore.this.doWrite(operation, operationData, false, null);
                RealApolloStore.this.publish(changedKeys);
                return Boolean.TRUE;
            }
        };
    }

    @Override
    @NotNull
    public ApolloStoreOperation<Set<String>> write(final @NotNull GraphqlFragment fragment, final @NotNull CacheKey cacheKey, final @NotNull Operation.Variables variables) {
        Utils.checkNotNull(fragment, "fragment == null");
        Utils.checkNotNull(cacheKey, "cacheKey == null");
        Utils.checkNotNull(variables, "operation == null");
        if (cacheKey.equals(CacheKey.NO_KEY)) {
            throw new IllegalArgumentException("undefined cache key");
        }
        return new ApolloStoreOperation<Set<String>>(this.dispatcher){

            @Override
            protected Set<String> perform() {
                return RealApolloStore.this.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

                    @Override
                    public Set<String> execute(WriteableStore cache) {
                        return RealApolloStore.this.doWrite(fragment, cacheKey, variables);
                    }
                });
            }
        };
    }

    @Override
    @NotNull
    public ApolloStoreOperation<Boolean> writeAndPublish(final @NotNull GraphqlFragment fragment, final @NotNull CacheKey cacheKey, final @NotNull Operation.Variables variables) {
        return new ApolloStoreOperation<Boolean>(this.dispatcher){

            @Override
            protected Boolean perform() {
                Set<String> changedKeys = RealApolloStore.this.doWrite(fragment, cacheKey, variables);
                RealApolloStore.this.publish(changedKeys);
                return Boolean.TRUE;
            }
        };
    }

    @Override
    @NotNull
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloStoreOperation<Set<String>> writeOptimisticUpdates(final @NotNull Operation<D, T, V> operation, final @NotNull D operationData, final @NotNull UUID mutationId) {
        return new ApolloStoreOperation<Set<String>>(this.dispatcher){

            @Override
            protected Set<String> perform() {
                return RealApolloStore.this.doWrite(operation, operationData, true, mutationId);
            }
        };
    }

    @Override
    @NotNull
    public <D extends Operation.Data, T, V extends Operation.Variables> ApolloStoreOperation<Boolean> writeOptimisticUpdatesAndPublish(final @NotNull Operation<D, T, V> operation, final @NotNull D operationData, final @NotNull UUID mutationId) {
        return new ApolloStoreOperation<Boolean>(this.dispatcher){

            @Override
            protected Boolean perform() {
                Set<String> changedKeys = RealApolloStore.this.doWrite(operation, operationData, true, mutationId);
                RealApolloStore.this.publish(changedKeys);
                return Boolean.TRUE;
            }
        };
    }

    @Override
    @NotNull
    public ApolloStoreOperation<Set<String>> rollbackOptimisticUpdates(final @NotNull UUID mutationId) {
        return new ApolloStoreOperation<Set<String>>(this.dispatcher){

            @Override
            protected Set<String> perform() {
                return RealApolloStore.this.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

                    @Override
                    public Set<String> execute(WriteableStore cache) {
                        return RealApolloStore.this.optimisticCache.removeOptimisticUpdates(mutationId);
                    }
                });
            }
        };
    }

    @Override
    @NotNull
    public ApolloStoreOperation<Boolean> rollbackOptimisticUpdatesAndPublish(final @NotNull UUID mutationId) {
        return new ApolloStoreOperation<Boolean>(this.dispatcher){

            @Override
            protected Boolean perform() {
                Set<String> changedKeys = RealApolloStore.this.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

                    @Override
                    public Set<String> execute(WriteableStore cache) {
                        return RealApolloStore.this.optimisticCache.removeOptimisticUpdates(mutationId);
                    }
                });
                RealApolloStore.this.publish(changedKeys);
                return Boolean.TRUE;
            }
        };
    }

    <D extends Operation.Data, T, V extends Operation.Variables> T doRead(final Operation<D, T, V> operation) {
        return (T)this.readTransaction(new Transaction<ReadableStore, T>(){

            @Override
            @Nullable
            public T execute(ReadableStore cache) {
                Record rootRecord = cache.read(CacheKeyResolver.rootKeyForOperation(operation).key(), CacheHeaders.NONE);
                if (rootRecord == null) {
                    return null;
                }
                ResponseFieldMapper responseFieldMapper = operation.responseFieldMapper();
                CacheFieldValueResolver fieldValueResolver = new CacheFieldValueResolver(cache, (Operation.Variables)operation.variables(), RealApolloStore.this.cacheKeyResolver(), CacheHeaders.NONE, RealApolloStore.this.cacheKeyBuilder);
                RealResponseReader<Record> responseReader = new RealResponseReader<Record>((Operation.Variables)operation.variables(), rootRecord, fieldValueResolver, RealApolloStore.this.scalarTypeAdapters, (ResolveDelegate<Record>)ResponseNormalizer.NO_OP_NORMALIZER);
                return operation.wrapData((Operation.Data)responseFieldMapper.map(responseReader));
            }
        });
    }

    <D extends Operation.Data, T, V extends Operation.Variables> Response<T> doRead(final Operation<D, T, V> operation, final ResponseFieldMapper<D> responseFieldMapper, final ResponseNormalizer<Record> responseNormalizer, final CacheHeaders cacheHeaders) {
        return (Response)this.readTransaction(new Transaction<ReadableStore, Response<T>>(){

            @Override
            @NotNull
            public Response<T> execute(ReadableStore cache) {
                Record rootRecord = cache.read(CacheKeyResolver.rootKeyForOperation(operation).key(), cacheHeaders);
                if (rootRecord == null) {
                    return Response.builder(operation).fromCache(true).build();
                }
                CacheFieldValueResolver fieldValueResolver = new CacheFieldValueResolver(cache, (Operation.Variables)operation.variables(), RealApolloStore.this.cacheKeyResolver(), cacheHeaders, RealApolloStore.this.cacheKeyBuilder);
                RealResponseReader<Record> responseReader = new RealResponseReader<Record>((Operation.Variables)operation.variables(), rootRecord, fieldValueResolver, RealApolloStore.this.scalarTypeAdapters, responseNormalizer);
                try {
                    responseNormalizer.willResolveRootQuery(operation);
                    Object data = operation.wrapData((Operation.Data)responseFieldMapper.map(responseReader));
                    return Response.builder(operation).data(data).fromCache(true).dependentKeys(responseNormalizer.dependentKeys()).build();
                }
                catch (Exception e) {
                    RealApolloStore.this.logger.e(e, "Failed to read cache response", new Object[0]);
                    return Response.builder(operation).fromCache(true).build();
                }
            }
        });
    }

    <F extends GraphqlFragment> F doRead(final ResponseFieldMapper<F> responseFieldMapper, final CacheKey cacheKey, final Operation.Variables variables) {
        return (F)((GraphqlFragment)this.readTransaction(new Transaction<ReadableStore, F>(){

            @Override
            @Nullable
            public F execute(ReadableStore cache) {
                Record rootRecord = cache.read(cacheKey.key(), CacheHeaders.NONE);
                if (rootRecord == null) {
                    return null;
                }
                CacheFieldValueResolver fieldValueResolver = new CacheFieldValueResolver(cache, variables, RealApolloStore.this.cacheKeyResolver(), CacheHeaders.NONE, RealApolloStore.this.cacheKeyBuilder);
                RealResponseReader<Record> responseReader = new RealResponseReader<Record>(variables, rootRecord, fieldValueResolver, RealApolloStore.this.scalarTypeAdapters, ResponseNormalizer.NO_OP_NORMALIZER);
                return (GraphqlFragment)responseFieldMapper.map(responseReader);
            }
        }));
    }

    <D extends Operation.Data, T, V extends Operation.Variables> Set<String> doWrite(final Operation<D, T, V> operation, final D operationData, final boolean optimistic, final UUID mutationId) {
        return this.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

            @Override
            public Set<String> execute(WriteableStore cache) {
                RealResponseWriter responseWriter = new RealResponseWriter((Operation.Variables)operation.variables(), RealApolloStore.this.scalarTypeAdapters);
                operationData.marshaller().marshal(responseWriter);
                ResponseNormalizer<Map<String, Object>> responseNormalizer = RealApolloStore.this.networkResponseNormalizer();
                responseNormalizer.willResolveRootQuery(operation);
                responseWriter.resolveFields(responseNormalizer);
                if (optimistic) {
                    ArrayList<Record> updatedRecords = new ArrayList<Record>();
                    for (Record record : responseNormalizer.records()) {
                        updatedRecords.add(record.toBuilder().mutationId(mutationId).build());
                    }
                    return RealApolloStore.this.optimisticCache.mergeOptimisticUpdates(updatedRecords);
                }
                return RealApolloStore.this.optimisticCache.merge(responseNormalizer.records(), CacheHeaders.NONE);
            }
        });
    }

    Set<String> doWrite(final GraphqlFragment fragment, final CacheKey cacheKey, final Operation.Variables variables) {
        return this.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

            @Override
            public Set<String> execute(WriteableStore cache) {
                RealResponseWriter responseWriter = new RealResponseWriter(variables, RealApolloStore.this.scalarTypeAdapters);
                fragment.marshaller().marshal(responseWriter);
                ResponseNormalizer<Map<String, Object>> responseNormalizer = RealApolloStore.this.networkResponseNormalizer();
                responseNormalizer.willResolveRecord(cacheKey);
                responseWriter.resolveFields(responseNormalizer);
                return RealApolloStore.this.merge(responseNormalizer.records(), CacheHeaders.NONE);
            }
        });
    }
}

