/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.cache.normalized.Record;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u0013\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/apollographql/apollo/cache/normalized/RecordSet;", "", "()V", "recordMap", "", "", "Lcom/apollographql/apollo/cache/normalized/Record;", "allRecords", "", "get", "key", "merge", "", "apolloRecord", "apollo-normalized-cache-api"})
public final class RecordSet {
    @NotNull
    private final Map<String, Record> recordMap;

    public RecordSet() {
        boolean bl = false;
        this.recordMap = new LinkedHashMap();
    }

    @Nullable
    public final Record get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        return this.recordMap.get(key);
    }

    @NotNull
    public final Set<String> merge(@NotNull Record apolloRecord) {
        Set<String> set;
        Intrinsics.checkParameterIsNotNull(apolloRecord, "apolloRecord");
        Record oldRecord = this.recordMap.get(apolloRecord.getKey());
        if (oldRecord == null) {
            Map<String, Record> map = this.recordMap;
            String string = apolloRecord.getKey();
            boolean bl = false;
            map.put(string, apolloRecord);
            set = SetsKt.emptySet();
        } else {
            set = oldRecord.mergeWith(apolloRecord);
        }
        return set;
    }

    @NotNull
    public final Collection<Record> allRecords() {
        return CollectionsKt.toList((Iterable)this.recordMap.values());
    }
}

