/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal.json;

import com.apollographql.apollo.api.internal.json.JsonDataException;
import com.apollographql.apollo.api.internal.json.JsonEncodingException;
import com.apollographql.apollo.api.internal.json.JsonReader;
import com.apollographql.apollo.api.internal.json.JsonScope;
import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 L2\u00020\u0001:\u0001LB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001e\u001a\u00020\u0001H\u0016J\b\u0010\u001f\u001a\u00020\u0001H\u0016J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020\u0017H\u0002J\b\u0010$\u001a\u00020\u0001H\u0016J\b\u0010%\u001a\u00020\u0001H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016J\t\u0010'\u001a\u00020\bH\u0096\u0002J\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020\bH\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0017H\u0016J\b\u0010/\u001a\u00020\u0019H\u0016J\b\u00100\u001a\u00020\u0014H\u0016J\u0010\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\bH\u0002J\u0015\u00103\u001a\u0004\u0018\u0001H4\"\u0004\b\u0000\u00104H\u0016\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u000208H\u0002J\n\u00109\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010:\u001a\u00020\u0014H\u0002J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\u0017H\u0002J\b\u0010>\u001a\u00020\u0017H\u0002J\b\u0010?\u001a\u00020!H\u0016J\u0010\u0010@\u001a\u00020!2\u0006\u0010A\u001a\u00020\u0017H\u0002J\b\u0010B\u001a\u00020*H\u0002J\u0010\u0010C\u001a\u00020!2\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010D\u001a\u00020\b2\u0006\u0010E\u001a\u00020\u0014H\u0002J\b\u0010F\u001a\u00020!H\u0002J\b\u0010G\u001a\u00020!H\u0002J\b\u0010H\u001a\u00020!H\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/apollographql/apollo/api/internal/json/BufferedSourceJsonReader;", "Lcom/apollographql/apollo/api/internal/json/JsonReader;", "source", "Lokio/BufferedSource;", "(Lokio/BufferedSource;)V", "buffer", "Lokio/Buffer;", "failOnUnknown", "", "getFailOnUnknown", "()Z", "setFailOnUnknown", "(Z)V", "lenient", "getLenient", "setLenient", "pathIndices", "", "pathNames", "", "", "[Ljava/lang/String;", "peeked", "", "peekedLong", "", "peekedNumberLength", "peekedString", "stack", "stackSize", "beginArray", "beginObject", "checkLenient", "", "close", "doPeek", "endArray", "endObject", "getPath", "hasNext", "isLiteral", "c", "", "nextBoolean", "nextDouble", "", "nextInt", "nextLong", "nextName", "nextNonWhitespace", "throwOnEof", "nextNull", "T", "()Ljava/lang/Object;", "nextQuotedValue", "runTerminator", "Lokio/ByteString;", "nextString", "nextUnquotedValue", "peek", "Lcom/apollographql/apollo/api/internal/json/JsonReader$Token;", "peekKeyword", "peekNumber", "promoteNameToValue", "push", "newTop", "readEscapeCharacter", "skipQuotedValue", "skipTo", "toFind", "skipToEndOfLine", "skipUnquotedValue", "skipValue", "syntaxError", "Lcom/apollographql/apollo/api/internal/json/JsonEncodingException;", "message", "Companion", "apollo-api"})
public final class BufferedSourceJsonReader
implements JsonReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final Buffer buffer;
    private int peeked;
    private long peekedLong;
    private int peekedNumberLength;
    @Nullable
    private String peekedString;
    @NotNull
    private final int[] stack;
    private int stackSize;
    @NotNull
    private final String[] pathNames;
    @NotNull
    private final int[] pathIndices;
    private boolean lenient;
    private boolean failOnUnknown;
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    @NotNull
    private static final ByteString SINGLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("'\\");
    @NotNull
    private static final ByteString DOUBLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("\"\\");
    @NotNull
    private static final ByteString UNQUOTED_STRING_TERMINALS = ByteString.Companion.encodeUtf8("{}[]:, \n\t\r/\\;#=");
    @NotNull
    private static final ByteString LINEFEED_OR_CARRIAGE_RETURN = ByteString.Companion.encodeUtf8("\n\r");
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    public static final int MAX_STACK_SIZE = 256;

    public BufferedSourceJsonReader(@NotNull BufferedSource source2) {
        Intrinsics.checkParameterIsNotNull(source2, "source");
        this.source = source2;
        this.buffer = this.source.getBuffer();
        int[] nArray = new int[256];
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray2 = nArray;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl3 = false;
        $this$stack_u24lambda_u2d0[0] = 6;
        Unit unit = Unit.INSTANCE;
        bufferedSourceJsonReader.stack = nArray;
        this.stackSize = 1;
        this.pathNames = new String[256];
        this.pathIndices = new int[256];
    }

    @Override
    public boolean getLenient() {
        return this.lenient;
    }

    @Override
    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    @Override
    public boolean getFailOnUnknown() {
        return this.failOnUnknown;
    }

    @Override
    public void setFailOnUnknown(boolean bl) {
        this.failOnUnknown = bl;
    }

    @Override
    @NotNull
    public JsonReader beginArray() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$beginArray_u24lambda_u2d2 = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$beginArray_u24lambda_u2d2.peeked;
        boolean bl4 = false;
        boolean bl5 = false;
        int it = ((Number)n).intValue();
        boolean bl6 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 == null ? $this$beginArray_u24lambda_u2d2.doPeek() : n2.intValue();
        if (p != 3) {
            throw new JsonDataException("Expected BEGIN_ARRAY but was " + (Object)((Object)$this$beginArray_u24lambda_u2d2.peek()) + " at path " + $this$beginArray_u24lambda_u2d2.getPath());
        }
        $this$beginArray_u24lambda_u2d2.push(1);
        $this$beginArray_u24lambda_u2d2.pathIndices[$this$beginArray_u24lambda_u2d2.stackSize - 1] = 0;
        $this$beginArray_u24lambda_u2d2.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader endArray() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$endArray_u24lambda_u2d4 = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$endArray_u24lambda_u2d4.peeked;
        boolean n2 = false;
        boolean bl4 = false;
        int it = ((Number)n).intValue();
        boolean bl5 = false;
        Object object = !(it == 0) ? n : null;
        int n3 = p = object == null ? $this$endArray_u24lambda_u2d4.doPeek() : ((Integer)object).intValue();
        if (p != 4) {
            throw new JsonDataException("Expected END_ARRAY but was " + (Object)((Object)$this$endArray_u24lambda_u2d4.peek()) + " at path " + $this$endArray_u24lambda_u2d4.getPath());
        }
        object = $this$endArray_u24lambda_u2d4;
        int n4 = ((BufferedSourceJsonReader)object).stackSize;
        ((BufferedSourceJsonReader)object).stackSize = n4 + -1;
        object = $this$endArray_u24lambda_u2d4.pathIndices;
        n4 = $this$endArray_u24lambda_u2d4.stackSize - 1;
        Object object2 = object[n4];
        object[n4] = object2 + true;
        $this$endArray_u24lambda_u2d4.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader beginObject() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$beginObject_u24lambda_u2d6 = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$beginObject_u24lambda_u2d6.peeked;
        boolean bl4 = false;
        boolean bl5 = false;
        int it = ((Number)n).intValue();
        boolean bl6 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 == null ? $this$beginObject_u24lambda_u2d6.doPeek() : n2.intValue();
        if (p != 1) {
            throw new JsonDataException("Expected BEGIN_OBJECT but was " + (Object)((Object)$this$beginObject_u24lambda_u2d6.peek()) + " at path " + $this$beginObject_u24lambda_u2d6.getPath());
        }
        $this$beginObject_u24lambda_u2d6.push(3);
        $this$beginObject_u24lambda_u2d6.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader endObject() throws IOException {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        boolean bl2 = false;
        BufferedSourceJsonReader $this$endObject_u24lambda_u2d8 = bufferedSourceJsonReader;
        boolean bl3 = false;
        Integer n = $this$endObject_u24lambda_u2d8.peeked;
        boolean n2 = false;
        boolean bl4 = false;
        int it = ((Number)n).intValue();
        boolean bl5 = false;
        Object object = !(it == 0) ? n : null;
        int n3 = p = object == null ? $this$endObject_u24lambda_u2d8.doPeek() : ((Integer)object).intValue();
        if (p != 2) {
            throw new JsonDataException("Expected END_OBJECT but was " + (Object)((Object)$this$endObject_u24lambda_u2d8.peek()) + " at path " + $this$endObject_u24lambda_u2d8.getPath());
        }
        object = $this$endObject_u24lambda_u2d8;
        int n4 = ((BufferedSourceJsonReader)object).stackSize;
        ((BufferedSourceJsonReader)object).stackSize = n4 + -1;
        $this$endObject_u24lambda_u2d8.pathNames[$this$endObject_u24lambda_u2d8.stackSize] = null;
        object = $this$endObject_u24lambda_u2d8.pathIndices;
        n4 = $this$endObject_u24lambda_u2d8.stackSize - 1;
        Object object2 = object[n4];
        object[n4] = object2 + true;
        $this$endObject_u24lambda_u2d8.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    public boolean hasNext() throws IOException {
        Integer n = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !(it == 0) ? n : null;
        int p = n2 == null ? this.doPeek() : n2.intValue();
        return p != 2 && p != 4;
    }

    @Override
    @NotNull
    public JsonReader.Token peek() throws IOException {
        JsonReader.Token token;
        Integer n = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = n2 == null ? this.doPeek() : n2.intValue();
        switch (n3) {
            case 1: {
                token = JsonReader.Token.BEGIN_OBJECT;
                break;
            }
            case 2: {
                token = JsonReader.Token.END_OBJECT;
                break;
            }
            case 3: {
                token = JsonReader.Token.BEGIN_ARRAY;
                break;
            }
            case 4: {
                token = JsonReader.Token.END_ARRAY;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                token = JsonReader.Token.NAME;
                break;
            }
            case 5: 
            case 6: {
                token = JsonReader.Token.BOOLEAN;
                break;
            }
            case 7: {
                token = JsonReader.Token.NULL;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                token = JsonReader.Token.STRING;
                break;
            }
            case 15: {
                token = JsonReader.Token.LONG;
                break;
            }
            case 16: {
                token = JsonReader.Token.NUMBER;
                break;
            }
            case 17: {
                token = JsonReader.Token.END_DOCUMENT;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int doPeek() throws IOException {
        boolean bl;
        char c;
        int c2;
        int peekStack;
        int n = peekStack = this.stack[this.stackSize - 1];
        switch (n) {
            case 1: {
                this.stack[this.stackSize - 1] = 2;
                break;
            }
            case 2: {
                c2 = this.nextNonWhitespace(true);
                this.buffer.readByte();
                c = (char)c2;
                if (c == ']') {
                    int n2 = 4;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int it = n2;
                    boolean bl4 = false;
                    this.peeked = it;
                    return n2;
                }
                if (c == ';') {
                    this.checkLenient();
                    break;
                }
                if (c == ',') break;
                throw this.syntaxError("Unterminated array");
            }
            case 3: 
            case 5: {
                int n3;
                char c3;
                int c4;
                this.stack[this.stackSize - 1] = 4;
                if (peekStack == 5) {
                    c4 = this.nextNonWhitespace(true);
                    this.buffer.readByte();
                    c3 = (char)c4;
                    if (c3 == '}') {
                        int n4 = 2;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        int it = n4;
                        boolean bl7 = false;
                        this.peeked = it;
                        return n4;
                    }
                    if (c3 == ';') {
                        this.checkLenient();
                    } else if (c3 != ',') {
                        throw this.syntaxError("Unterminated object");
                    }
                }
                if ((c3 = (char)(c4 = this.nextNonWhitespace(true))) == '\"') {
                    this.buffer.readByte();
                    int n5 = 13;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    int it = n5;
                    boolean bl10 = false;
                    this.peeked = it;
                    n3 = n5;
                    return n3;
                } else if (c3 == '\'') {
                    this.buffer.readByte();
                    this.checkLenient();
                    int n6 = 12;
                    boolean bl11 = false;
                    boolean bl12 = false;
                    int it = n6;
                    boolean bl13 = false;
                    this.peeked = it;
                    n3 = n6;
                    return n3;
                } else if (c3 == '}') {
                    if (peekStack == 5) throw this.syntaxError("Expected name");
                    this.buffer.readByte();
                    int n7 = 2;
                    boolean bl14 = false;
                    boolean bl15 = false;
                    int it = n7;
                    boolean bl16 = false;
                    this.peeked = it;
                    n3 = n7;
                    return n3;
                } else {
                    this.checkLenient();
                    if (!this.isLiteral((char)c4)) throw this.syntaxError("Expected name");
                    int n8 = 14;
                    boolean bl17 = false;
                    boolean bl18 = false;
                    int it = n8;
                    boolean bl19 = false;
                    this.peeked = it;
                    n3 = n8;
                }
                return n3;
            }
            case 4: {
                this.stack[this.stackSize - 1] = 5;
                c2 = this.nextNonWhitespace(true);
                this.buffer.readByte();
                c = (char)c2;
                if (c == ':') break;
                if (c != '=') throw this.syntaxError("Expected ':'");
                this.checkLenient();
                if (!this.source.request(1L) || this.buffer.getByte(0L) != 62) break;
                this.buffer.readByte();
                break;
            }
            case 6: {
                this.stack[this.stackSize - 1] = 7;
                break;
            }
            case 7: {
                c2 = this.nextNonWhitespace(false);
                if (c2 == -1) {
                    int n9 = 17;
                    boolean bl20 = false;
                    boolean bl21 = false;
                    int it = n9;
                    boolean bl22 = false;
                    this.peeked = it;
                    return n9;
                }
                this.checkLenient();
                break;
            }
            default: {
                c2 = peekStack != 8 ? 1 : 0;
                c = '\u0000';
                bl = false;
                if (c2 != 0) break;
                boolean bl23 = false;
                String string = "JsonReader is closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        int c5 = this.nextNonWhitespace(true);
        c2 = (char)c5;
        if (c2 == 93) {
            if (peekStack == 1) {
                this.buffer.readByte();
                c = (char)4;
                bl = false;
                boolean bl24 = false;
                char it = c;
                boolean bl25 = false;
                this.peeked = it;
                return c;
            }
            if (peekStack != 1 && peekStack != 2) {
                throw this.syntaxError("Unexpected value");
            }
            this.checkLenient();
            c = (char)7;
            bl = false;
            boolean bl26 = false;
            char it = c;
            boolean bl27 = false;
            this.peeked = it;
            return c;
        }
        if (c2 == 59 ? true : c2 == 44) {
            if (peekStack != 1 && peekStack != 2) {
                throw this.syntaxError("Unexpected value");
            }
            this.checkLenient();
            c = (char)7;
            bl = false;
            boolean bl28 = false;
            char it = c;
            boolean bl29 = false;
            this.peeked = it;
            return c;
        }
        if (c2 == 39) {
            this.checkLenient();
            this.buffer.readByte();
            c = (char)8;
            bl = false;
            boolean bl30 = false;
            char it = c;
            boolean bl31 = false;
            this.peeked = it;
            return c;
        }
        if (c2 == 34) {
            this.buffer.readByte();
            c = (char)9;
            bl = false;
            boolean bl32 = false;
            char it = c;
            boolean bl33 = false;
            this.peeked = it;
            return c;
        }
        if (c2 == 91) {
            this.buffer.readByte();
            c = (char)3;
            bl = false;
            boolean bl34 = false;
            char it = c;
            boolean bl35 = false;
            this.peeked = it;
            return c;
        }
        if (c2 == 123) {
            this.buffer.readByte();
            c = '\u0001';
            bl = false;
            boolean bl36 = false;
            char it = c;
            boolean bl37 = false;
            this.peeked = it;
            return c;
        }
        int result = this.peekKeyword();
        if (result != 0) {
            return result;
        }
        result = this.peekNumber();
        if (result != 0) {
            return result;
        }
        if (!this.isLiteral((char)this.buffer.getByte(0L))) {
            throw this.syntaxError("Expected value");
        }
        this.checkLenient();
        c = (char)10;
        bl = false;
        boolean bl38 = false;
        char it = c;
        boolean bl39 = false;
        this.peeked = it;
        return c;
    }

    private final int peekKeyword() throws IOException {
        String keyword = null;
        String keywordUpper = null;
        int peeking = 0;
        byte by = this.buffer.getByte(0L);
        if (by == 116 ? true : by == 84) {
            keyword = "true";
            keywordUpper = "TRUE";
            peeking = 5;
        } else if (by == 102 ? true : by == 70) {
            keyword = "false";
            keywordUpper = "FALSE";
            peeking = 6;
        } else if (by == 110 ? true : by == 78) {
            keyword = "null";
            keywordUpper = "NULL";
            peeking = 7;
        } else {
            return 0;
        }
        int length = keyword.length();
        int n = 1;
        if (n < length) {
            do {
                int i;
                if (!this.source.request((long)(i = n++) + 1L)) {
                    return 0;
                }
                byte c = this.buffer.getByte(i);
                if (c == (byte)keyword.charAt(i) || c == (byte)keywordUpper.charAt(i)) continue;
                return 0;
            } while (n < length);
        }
        if (this.source.request((long)length + 1L) && this.isLiteral((char)this.buffer.getByte(length))) {
            return 0;
        }
        this.buffer.skip(length);
        n = peeking;
        boolean bl = false;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        this.peeked = it;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int peekNumber() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        long value = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i = 0;
        while (this.source.request((long)i + 1L)) {
            block24: {
                byte c;
                block23: {
                    c = this.buffer.getByte(i);
                    n4 = c;
                    if (n4 != 45) break block23;
                    n3 = last;
                    switch (n3) {
                        case 0: {
                            negative = true;
                            last = 1;
                            break block24;
                        }
                        case 5: {
                            last = 6;
                            break block24;
                        }
                        default: {
                            return 0;
                        }
                    }
                }
                if (n4 == 43) {
                    if (last != 5) return 0;
                    last = 6;
                } else if (n4 == 101 ? true : n4 == 69) {
                    if (last != 2) {
                        if (last != 4) return 0;
                    }
                    last = 5;
                } else if (n4 == 46) {
                    if (last != 2) return 0;
                    last = 3;
                } else {
                    if (c < 48 || c > 57) {
                        if (this.isLiteral((char)c)) return 0;
                        break;
                    }
                    n3 = last;
                    switch (n3) {
                        case 0: 
                        case 1: {
                            value = -((long)(c - 48));
                            last = 2;
                            break;
                        }
                        case 2: {
                            if (value == 0L) {
                                return 0;
                            }
                            long newValue = value * (long)10 - (long)(c - 48);
                            fitsInLong = fitsInLong & value > -922337203685477580L || value == -922337203685477580L && newValue < value;
                            value = newValue;
                            break;
                        }
                        case 3: {
                            last = 4;
                            break;
                        }
                        case 5: 
                        case 6: {
                            last = 7;
                        }
                    }
                }
            }
            n4 = i;
            i = n4 + 1;
        }
        if (last == 2 && fitsInLong && (value != Long.MIN_VALUE || negative)) {
            this.peekedLong = negative ? value : -value;
            this.buffer.skip(i);
            n2 = 15;
            n4 = 0;
            n3 = 0;
            int it = n2;
            boolean bl = false;
            this.peeked = it;
            n = n2;
            return n;
        } else {
            if (last != 2 && last != 4) {
                if (last != 7) return 0;
            }
            this.peekedNumberLength = i;
            n2 = 16;
            n4 = 0;
            n3 = 0;
            int it = n2;
            boolean bl = false;
            this.peeked = it;
            n = n2;
        }
        return n;
    }

    private final boolean isLiteral(char c) throws IOException {
        boolean bl;
        char c2 = c;
        if ((((c2 == '/' ? true : c2 == '\\') ? true : c2 == ';') ? true : c2 == '#') ? true : c2 == '=') {
            this.checkLenient();
            bl = false;
        } else {
            bl = !(((((((((c2 == '{' ? true : c2 == '}') ? true : c2 == '[') ? true : c2 == ']') ? true : c2 == ':') ? true : c2 == ',') ? true : c2 == ' ') ? true : c2 == '\t') ? true : c2 == '\r') ? true : c2 == '\n');
        }
        return bl;
    }

    @Override
    @NotNull
    public String nextName() throws IOException {
        String string;
        Integer n = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = n2 == null ? this.doPeek() : n2.intValue();
        switch (n3) {
            case 14: {
                string = this.nextUnquotedValue();
                break;
            }
            case 13: {
                string = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 12: {
                string = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            default: {
                throw new JsonDataException("Expected a name but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
        }
        String result = string;
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result;
        return result;
    }

    @Override
    @Nullable
    public String nextString() throws IOException {
        Object object;
        Object object2 = this.peeked;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)object2).intValue();
        boolean bl3 = false;
        Object object3 = !(it == 0) ? object2 : null;
        int n = object3 == null ? this.doPeek() : ((Integer)object3).intValue();
        switch (n) {
            case 10: {
                object = this.nextUnquotedValue();
                break;
            }
            case 9: {
                object = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 8: {
                object = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            case 11: {
                object3 = this.peekedString;
                if (object3 == null) {
                    object = null;
                    break;
                }
                object2 = object3;
                bl = false;
                bl2 = false;
                Object it2 = object2;
                boolean bl4 = false;
                this.peekedString = null;
                object = object2;
                break;
            }
            case 15: {
                object = String.valueOf(this.peekedLong);
                break;
            }
            case 16: {
                object = this.buffer.readUtf8(this.peekedNumberLength);
                break;
            }
            default: {
                throw new JsonDataException("Expected a string but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
        }
        String result = object;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n2 = this.stackSize - 1;
        int n3 = nArray[n2];
        nArray[n2] = n3 + 1;
        return result;
    }

    @Override
    public boolean nextBoolean() throws IOException {
        boolean bl;
        Integer n = this.peeked;
        boolean n2 = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Object object = !(it == 0) ? n : null;
        int n3 = object == null ? this.doPeek() : ((Integer)object).intValue();
        switch (n3) {
            case 5: {
                this.peeked = 0;
                object = this.pathIndices;
                int n4 = this.stackSize - 1;
                Object object2 = object[n4];
                object[n4] = object2 + true;
                bl = true;
                break;
            }
            case 6: {
                this.peeked = 0;
                object = this.pathIndices;
                int n5 = this.stackSize - 1;
                Object object3 = object[n5];
                object[n5] = object3 + true;
                bl = false;
                break;
            }
            default: {
                throw new JsonDataException("Expected a boolean but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public <T> T nextNull() throws IOException {
        int n;
        Integer n2 = this.peeked;
        boolean n3 = false;
        boolean bl = false;
        int it = ((Number)n2).intValue();
        boolean bl2 = false;
        Object object = !(it == 0) ? n2 : null;
        int n4 = n = object == null ? this.doPeek() : ((Integer)object).intValue();
        if (n != 7) {
            throw new JsonDataException("Expected null but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 0;
        object = this.pathIndices;
        int n5 = this.stackSize - 1;
        Object object2 = object[n5];
        object[n5] = object2 + true;
        return null;
    }

    @Override
    public double nextDouble() throws IOException {
        int n;
        double result;
        int n2;
        block16: {
            block17: {
                double d;
                Integer n3 = this.peeked;
                boolean n4 = false;
                n2 = 0;
                int it = ((Number)n3).intValue();
                boolean bl = false;
                Object object = !(it == 0) ? n3 : null;
                int p = object == null ? this.doPeek() : ((Integer)object).intValue();
                if (p == 15) {
                    this.peeked = 0;
                    object = this.pathIndices;
                    int n5 = this.stackSize - 1;
                    Object string = object[n5];
                    object[n5] = string + true;
                    return this.peekedLong;
                }
                if (p == 16) {
                    this.peekedString = this.buffer.readUtf8(this.peekedNumberLength);
                } else if (p == 9) {
                    this.peekedString = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                } else if (p == 8) {
                    this.peekedString = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                } else if (p == 10) {
                    this.peekedString = this.nextUnquotedValue();
                } else if (p != 11) {
                    throw new JsonDataException("Expected a double but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
                }
                this.peeked = 11;
                try {
                    String d2 = this.peekedString;
                    if (d2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String nArray = d2;
                    n2 = 0;
                    d = Double.parseDouble(nArray);
                }
                catch (NumberFormatException e) {
                    throw new JsonDataException("Expected a double but was " + this.peekedString + " at path " + this.getPath());
                }
                result = d;
                if (this.getLenient()) break block16;
                d = result;
                n = 0;
                if (Double.isNaN(d)) break block17;
                d = result;
                n = 0;
                if (!Double.isInfinite(d)) break block16;
            }
            throw new JsonEncodingException("JSON forbids NaN and infinities: " + result + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        n2 = this.stackSize - 1;
        n = nArray[n2];
        nArray[n2] = n + 1;
        return result;
    }

    @Override
    public long nextLong() throws IOException {
        double d;
        Integer n = this.peeked;
        boolean n2 = false;
        int n3 = 0;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Object object = !(it == 0) ? n : null;
        int p = object == null ? this.doPeek() : ((Integer)object).intValue();
        if (p == 15) {
            this.peeked = 0;
            object = this.pathIndices;
            int n4 = this.stackSize - 1;
            Object object2 = object[n4];
            object[n4] = object2 + true;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8(this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                String string = this.peekedString;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String d2 = string;
                n3 = 0;
                long result = Long.parseLong(d2);
                this.peeked = 0;
                int[] nArray = this.pathIndices;
                n3 = this.stackSize - 1;
                it = nArray[n3];
                nArray[n3] = it + 1;
                return result;
            }
            catch (NumberFormatException result) {}
        } else if (p != 11) {
            throw new JsonDataException("Expected a long but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = string;
            n3 = 0;
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPath());
        }
        double asDouble = d;
        long l = (long)asDouble;
        if (!((double)l == asDouble)) {
            throw new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n4 = this.stackSize - 1;
        int n5 = nArray[n4];
        nArray[n4] = n5 + 1;
        return l;
    }

    private final String nextQuotedValue(ByteString runTerminator) throws IOException {
        String string;
        long index;
        StringBuilder builder = null;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                throw this.syntaxError("Unterminated string");
            }
            if (this.buffer.getByte(index) != 92) break;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            builder.append(this.readEscapeCharacter());
        }
        if (builder == null) {
            String result = this.buffer.readUtf8(index);
            this.buffer.readByte();
            string = result;
        } else {
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            String string2 = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "{\n        builder.append(buffer.readUtf8(index))\n        buffer.readByte() // Consume the quote character.\n        builder.toString()\n      }");
            string = string2;
        }
        return string;
    }

    private final String nextUnquotedValue() throws IOException {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        return i != -1L ? this.buffer.readUtf8(i) : this.buffer.readUtf8();
    }

    private final void skipQuotedValue(ByteString runTerminator) throws IOException {
        long index;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                throw this.syntaxError("Unterminated string");
            }
            if (this.buffer.getByte(index) != 92) break;
            this.buffer.skip(index + 1L);
            this.readEscapeCharacter();
        }
        this.buffer.skip(index + 1L);
    }

    private final void skipUnquotedValue() throws IOException {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        this.buffer.skip(i != -1L ? i : this.buffer.size());
    }

    @Override
    public int nextInt() throws IOException {
        double d;
        Object object = this.peeked;
        int n = 0;
        boolean n2 = false;
        int it = ((Number)object).intValue();
        boolean bl = false;
        Integer n3 = !(it == 0) ? object : null;
        int p = n3 == null ? this.doPeek() : n3.intValue();
        if (p == 15) {
            int result = (int)this.peekedLong;
            if (this.peekedLong != (long)result) {
                throw new JsonDataException("Expected an int but was " + this.peekedLong + " at path " + this.getPath());
            }
            this.peeked = 0;
            object = this.pathIndices;
            n = this.stackSize - 1;
            Object nArray = object[n];
            object[n] = nArray + true;
            return result;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8(this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                object = this.peekedString;
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                n = 0;
                int result = Integer.parseInt((String)object);
                this.peeked = 0;
                object = this.pathIndices;
                n = this.stackSize - 1;
                Object object2 = object[n];
                object[n] = object2 + true;
                return result;
            }
            catch (NumberFormatException result) {}
        } else if (p != 11) {
            throw new JsonDataException("Expected an int but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            boolean bl2 = false;
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPath());
        }
        double asDouble = d;
        int result = (int)asDouble;
        if (!((double)result == asDouble)) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPath());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n4 = this.stackSize - 1;
        int n5 = nArray[n4];
        nArray[n4] = n5 + 1;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.buffer.clear();
        this.source.close();
    }

    @Override
    public void skipValue() throws IOException {
        if (this.getFailOnUnknown()) {
            throw new JsonDataException("Cannot skip unexpected " + (Object)((Object)this.peek()) + " at " + this.getPath());
        }
        int count = 0;
        do {
            Integer n = this.peeked;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            Object object = !(it == 0) ? n : null;
            int n2 = object == null ? this.doPeek() : ((Integer)object).intValue();
            switch (n2) {
                case 3: {
                    this.push(1);
                    int n3 = count;
                    count = n3 + 1;
                    break;
                }
                case 1: {
                    this.push(3);
                    int n4 = count;
                    count = n4 + 1;
                    break;
                }
                case 4: {
                    object = this;
                    int n5 = ((BufferedSourceJsonReader)object).stackSize;
                    ((BufferedSourceJsonReader)object).stackSize = n5 + -1;
                    int n6 = count;
                    count = n6 + -1;
                    break;
                }
                case 2: {
                    object = this;
                    int n7 = ((BufferedSourceJsonReader)object).stackSize;
                    ((BufferedSourceJsonReader)object).stackSize = n7 + -1;
                    int n8 = count;
                    count = n8 + -1;
                    break;
                }
                case 10: 
                case 14: {
                    this.skipUnquotedValue();
                    break;
                }
                case 9: 
                case 13: {
                    this.skipQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                    break;
                }
                case 8: 
                case 12: {
                    this.skipQuotedValue(SINGLE_QUOTE_OR_SLASH);
                    break;
                }
                case 16: {
                    this.buffer.skip(this.peekedNumberLength);
                }
            }
            this.peeked = 0;
        } while (count != 0);
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n9 = nArray[n];
        nArray[n] = n9 + 1;
        this.pathNames[this.stackSize - 1] = "null";
    }

    private final void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            throw new JsonDataException(Intrinsics.stringPlus("Nesting too deep at ", this.getPath()));
        }
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        int n = bufferedSourceJsonReader.stackSize;
        bufferedSourceJsonReader.stackSize = n + 1;
        this.stack[n] = newTop;
    }

    private final int nextNonWhitespace(boolean throwOnEof) throws IOException {
        int p = 0;
        block4: while (this.source.request((long)p + 1L)) {
            int n = p;
            p = n + 1;
            byte c = this.buffer.getByte(n);
            if (c == 10 || c == 32 || c == 13 || c == 9) continue;
            this.buffer.skip((long)p - 1L);
            switch (c) {
                case 47: {
                    if (!this.source.request(2L)) {
                        return c;
                    }
                    this.checkLenient();
                    byte peek = this.buffer.getByte(1L);
                    char c2 = (char)peek;
                    if (c2 == '*') {
                        this.buffer.readByte();
                        this.buffer.readByte();
                        if (!this.skipTo("*/")) {
                            throw this.syntaxError("Unterminated comment");
                        }
                        this.buffer.readByte();
                        this.buffer.readByte();
                        p = 0;
                        continue block4;
                    }
                    if (c2 == '/') {
                        this.buffer.readByte();
                        this.buffer.readByte();
                        this.skipToEndOfLine();
                        p = 0;
                        continue block4;
                    }
                    return c;
                }
                case 35: {
                    this.checkLenient();
                    this.skipToEndOfLine();
                    p = 0;
                    continue block4;
                }
            }
            return c;
        }
        if (throwOnEof) {
            throw new EOFException("End of input");
        }
        return -1;
    }

    private final void checkLenient() throws IOException {
        if (!this.getLenient()) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private final void skipToEndOfLine() throws IOException {
        long index = this.source.indexOfElement(LINEFEED_OR_CARRIAGE_RETURN);
        this.buffer.skip(index != -1L ? index + 1L : this.buffer.size());
    }

    private final boolean skipTo(String toFind) throws IOException {
        block0: while (this.source.request(toFind.length())) {
            int n = 0;
            int n2 = toFind.length() + -1;
            if (n <= n2) {
                do {
                    int c;
                    if (this.buffer.getByte(c = n++) == (byte)toFind.charAt(c)) continue;
                    this.buffer.readByte();
                    continue block0;
                } while (n <= n2);
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getPath() {
        return JsonScope.INSTANCE.getPath(this.stackSize, this.stack, this.pathNames, this.pathIndices);
    }

    /*
     * WARNING - void declaration
     */
    private final char readEscapeCharacter() throws IOException {
        int n;
        if (!this.source.request(1L)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char escaped = (char)this.buffer.readByte();
        if (escaped == 'u') {
            void var2_2;
            if (!this.source.request(4L)) {
                throw new EOFException(Intrinsics.stringPlus("Unterminated escape sequence at path ", this.getPath()));
            }
            int result = 0;
            int i = 0;
            int end = i + 4;
            while (i < end) {
                int n2;
                byte c = this.buffer.getByte(i);
                result = (char)(result << 4);
                if (c >= 48 && c <= 57) {
                    n2 = c - 48;
                } else if (c >= 97 && c <= 102) {
                    n2 = c - 97 + 10;
                } else if (c >= 65 && c <= 70) {
                    n2 = c - 65 + 10;
                } else {
                    throw this.syntaxError(Intrinsics.stringPlus("\\u", this.buffer.readUtf8(4L)));
                }
                result = (char)(result + n2);
                int n3 = i;
                i = n3 + 1;
            }
            this.buffer.skip(4L);
            n = var2_2;
        } else if (escaped == 't') {
            n = 9;
        } else if (escaped == 'b') {
            n = 8;
        } else if (escaped == 'n') {
            n = 10;
        } else if (escaped == 'r') {
            n = 13;
        } else if (escaped == 'f') {
            n = 12;
        } else if ((((escaped == '\n' ? true : escaped == '\'') ? true : escaped == '\"') ? true : escaped == '\\') ? true : escaped == '/') {
            n = escaped;
        } else {
            void var1_1;
            if (!this.getLenient()) {
                throw this.syntaxError(Intrinsics.stringPlus("Invalid escape sequence: \\", Character.valueOf(escaped)));
            }
            n = var1_1;
        }
        return (char)n;
    }

    private final JsonEncodingException syntaxError(String message) {
        return new JsonEncodingException(message + " at path " + this.getPath());
    }

    @Override
    public void promoteNameToValue() throws IOException {
        if (this.hasNext()) {
            this.peekedString = this.nextName();
            this.peeked = 11;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u001d\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/apollographql/apollo/api/internal/json/BufferedSourceJsonReader$Companion;", "", "()V", "DOUBLE_QUOTE_OR_SLASH", "Lokio/ByteString;", "LINEFEED_OR_CARRIAGE_RETURN", "MAX_STACK_SIZE", "", "MIN_INCOMPLETE_INTEGER", "", "NUMBER_CHAR_DECIMAL", "NUMBER_CHAR_DIGIT", "NUMBER_CHAR_EXP_DIGIT", "NUMBER_CHAR_EXP_E", "NUMBER_CHAR_EXP_SIGN", "NUMBER_CHAR_FRACTION_DIGIT", "NUMBER_CHAR_NONE", "NUMBER_CHAR_SIGN", "PEEKED_BEGIN_ARRAY", "PEEKED_BEGIN_OBJECT", "PEEKED_BUFFERED", "PEEKED_DOUBLE_QUOTED", "PEEKED_DOUBLE_QUOTED_NAME", "PEEKED_END_ARRAY", "PEEKED_END_OBJECT", "PEEKED_EOF", "PEEKED_FALSE", "PEEKED_LONG", "PEEKED_NONE", "PEEKED_NULL", "PEEKED_NUMBER", "PEEKED_SINGLE_QUOTED", "PEEKED_SINGLE_QUOTED_NAME", "PEEKED_TRUE", "PEEKED_UNQUOTED", "PEEKED_UNQUOTED_NAME", "SINGLE_QUOTE_OR_SLASH", "UNQUOTED_STRING_TERMINALS", "apollo-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

