/*
 * Decompiled with CFR 0.152.
 */
package ice.util.awt;

import ice.debug.Debug;
import ice.util.awt.AwtQueueKit;
import ice.util.awt.QueueElem;
import java.lang.reflect.InvocationTargetException;

public class TimedAWTExecutor {
    private final AwtQueueKit awtKit = AwtQueueKit.newInstance();
    private final Object queueMonitor = new Object();
    private volatile Thread scheduleThread = new Thread("Timer queue for AWT thread"){

        public void run() {
            TimedAWTExecutor.this.runScheduler();
        }
    };
    private QueueElem queueFirst;
    private QueueElem queueLast;
    private long prev_sys_time = 0L;
    private long time_to_add = 0L;

    public TimedAWTExecutor() {
        this.scheduleThread.setDaemon(true);
        this.scheduleThread.start();
    }

    public boolean isEventThread() {
        return this.awtKit.isDispatchThread();
    }

    private long currentTimeMillis() {
        long time = System.currentTimeMillis();
        if (time < this.prev_sys_time) {
            if (Debug.trace) {
                Debug.trace("TIME BUG, diff=" + (time - this.prev_sys_time));
            }
            long diff_ms = this.prev_sys_time - time;
            this.time_to_add += diff_ms;
        }
        this.prev_sys_time = time;
        return this.time_to_add + time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.queueMonitor;
        synchronized (object) {
            if (this.scheduleThread != null) {
                this.scheduleThread = null;
                QueueElem cursor = this.queueFirst;
                this.queueFirst = null;
                this.queueLast = null;
                while (cursor != null) {
                    QueueElem next = cursor.next;
                    cursor.prev = null;
                    cursor.next = null;
                    cursor = next;
                }
                this.queueMonitor.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Runnable code, long delay) throws InterruptedException, InvocationTargetException {
        if (AwtQueueKit.trace_awt_queue) {
            AwtQueueKit.trace_add_to_stack_trace(code, delay);
        }
        if (this.scheduleThread != null) {
            if (delay == 0L) {
                this.awtKit.invokeAndWait(code);
            } else {
                QueueElem _queueElement = new QueueElem();
                _queueElement.code = code;
                Object object = this.queueMonitor;
                synchronized (object) {
                    _queueElement.deliveryTime = this.currentTimeMillis() + delay;
                    this.insertElem(_queueElement);
                    this.queueMonitor.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable code, long delay_ms) {
        if (AwtQueueKit.trace_awt_queue) {
            AwtQueueKit.trace_add_to_stack_trace(code, delay_ms);
        }
        if (this.scheduleThread != null) {
            if (delay_ms == 0L) {
                this.awtKit.invokeLater(code);
            } else {
                QueueElem elem = new QueueElem();
                elem.code = code;
                Object object = this.queueMonitor;
                synchronized (object) {
                    elem.deliveryTime = this.currentTimeMillis() + delay_ms;
                    this.insertElem(elem);
                    this.queueMonitor.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QueueElem nextElem() {
        Object object = this.queueMonitor;
        synchronized (object) {
            while (this.scheduleThread != null) {
                QueueElem min_time_elem = this.getEarliestElem();
                if (min_time_elem == null) {
                    if (this.scheduleThread == null) {
                        return null;
                    }
                    try {
                        this.queueMonitor.wait();
                    }
                    catch (InterruptedException ex) {}
                    continue;
                }
                long time = this.currentTimeMillis();
                long delay = min_time_elem.deliveryTime - time;
                if (delay <= 0L) {
                    return this.removeEarliestElem();
                }
                try {
                    this.queueMonitor.wait(delay);
                }
                catch (InterruptedException ex) {}
            }
            return null;
        }
    }

    void runScheduler() {
        QueueElem elem;
        while (this.scheduleThread != null && (elem = this.nextElem()) != null) {
            this.awtKit.invokeLater(elem.code);
        }
    }

    private void insertElem(QueueElem x) {
        QueueElem last = this.queueLast;
        if (last == null) {
            this.queueLast = x;
            this.queueFirst = x;
        } else {
            long deliveryTime = x.deliveryTime;
            if (last.deliveryTime <= deliveryTime) {
                x.prev = last;
                last.next = x;
                this.queueLast = x;
            } else {
                QueueElem cursor = last.prev;
                while (cursor != null && cursor.deliveryTime > deliveryTime) {
                    cursor = cursor.prev;
                }
                if (cursor != null) {
                    x.next = cursor.next;
                    x.prev = cursor;
                    cursor.next.prev = x;
                    cursor.next = x;
                } else {
                    x.next = this.queueFirst;
                    this.queueFirst.prev = x;
                    this.queueFirst = x;
                }
            }
        }
    }

    private QueueElem getEarliestElem() {
        return this.queueFirst;
    }

    private QueueElem removeEarliestElem() {
        QueueElem result = this.queueFirst;
        if (result != null) {
            this.queueFirst = result.next;
            if (this.queueFirst == null) {
                this.queueLast = null;
            } else {
                this.queueFirst.prev = null;
            }
            result.prev = null;
            result.next = null;
        }
        return result;
    }
}

