/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSManager;
import ice.pilots.html4.CSSMatcher;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.ComponentFactory;
import ice.pilots.html4.CoordsList;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DNodeListeners;
import ice.pilots.html4.DOM;
import ice.pilots.html4.DOMBuilder;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.DefaultActionHandler;
import ice.pilots.html4.DefaultEventHandler;
import ice.pilots.html4.DocAction;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.FramesDivider;
import ice.pilots.html4.FramesetData;
import ice.pilots.html4.Lex2;
import ice.pilots.html4.ObjectPool;
import ice.pilots.html4.OnresizeListener;
import ice.pilots.html4.RefreshItem;
import ice.pilots.html4.Search;
import ice.pilots.html4.StormData;
import ice.pilots.html4.ThePrinter;
import ice.pilots.html4.TheView;
import ice.scripters.WindowObj;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Pilot;
import ice.storm.Scripter;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.ICEException;
import ice.util.JavaVersion;
import ice.util.alg.CharKit;
import ice.util.alg.HashArray;
import ice.util.io.IOKit;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventListener;

public class ThePilot
extends Pilot {
    private Object clearContextLock = new Object();
    private boolean contextCleared = false;
    private boolean wasDisposed;
    StormData sdata;
    boolean isFromHistory = false;
    boolean isLoadedSynchronously = false;
    private DDocument doc;
    private CSSLayout cssLayout;
    ObjectPool objectPool;
    private ComponentFactory componentFactory;
    FramesetData framesetData;
    private boolean loadSingleOnly = false;
    public static final boolean viewNoframes = Defs.booleanProperty("ice.pilots.html4.view_noframes");
    private static final boolean REFRESH_ENABLED = Defs.booleanProperty("ice.pilots.html4.metaEquivHttpRefreshEnabled", true);
    private static final boolean DOCUMENT_FOCUS_OUTLINE = Defs.sysPropertyBoolean("ice.pilots.html4.documentFocusOutline", JavaVersion.isV14orGreater());
    private String defaultEncoding = null;
    private String encoding = null;
    private boolean lockedEncoding = false;
    Object[] persistentDomListeners;
    DefaultEventHandler defaultEventHandler;
    private Lex2 currentLexer;
    private boolean lexerShouldFinishOnScriptEnd;
    private boolean allowedToLoadImages = true;
    volatile int noLayoutUpdate;
    HashArray tmpBodyEventHandlers;
    private static final int Field_DOMImplementation = 1;
    private static final int Field_event = 2;
    private static final int Field_pageXOffset = 3;
    private static final int Field_pageYOffset = 4;
    private static final int Method_ActiveXObject = -1;
    private static final int Method_Option = -2;
    private static final int Method_XMLHttpObject = -3;

    public void init(String componentToolkitName) {
        block5: {
            super.init(componentToolkitName);
            this.sdata = StormData.get(this.getStorm());
            this.loadSingleOnly = this.sdata.getLoadSingleOnly();
            if (!"none".equalsIgnoreCase(componentToolkitName)) {
                try {
                    this.componentFactory = (ComponentFactory)Class.forName("ice.pilots.html4." + componentToolkitName + ".TheFactory").newInstance();
                }
                catch (Exception ex) {
                    if (!Debug.ex) break block5;
                    Debug.ex(ex);
                }
            }
        }
        this.defaultEncoding = Defs.sysProperty("ice.pilots.html4.defaultEncoding");
        this.doc = DOM.getInstance(this.sdata).createDDocument(this, true);
        this.objectPool = new ObjectPool(this);
        String media = this.componentFactory == null ? "none" : this.componentFactory.getMedia();
        this.cssLayout = this.createCSSLayout(media, this.doc);
        if ("swing".equalsIgnoreCase(componentToolkitName)) {
            this.cssLayout.setDocumentFocusOutline(DOCUMENT_FOCUS_OUTLINE);
        } else {
            this.cssLayout.setDocumentFocusOutline(false);
        }
        this.defaultEventHandler = new DefaultActionHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDisposed() {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            return this.wasDisposed;
        }
    }

    public void beforeUnload() {
        DElement unloadSource = !this.doc.isFrameset ? this.doc.getDBody() : ThePilot.search_unload_frameset_r(this.doc.getDocumentDElement());
        this.doc.processEvent(14, unloadSource);
    }

    private static DElement search_unload_frameset_r(DElement parent) {
        DElement found = null;
        DNode n = parent.getLastDChild();
        while (n != null) {
            if (n.getNameId() == 34) {
                DElement frameset = (DElement)n;
                found = ThePilot.search_unload_frameset_r(frameset);
                if (found != null) break;
                String onunloadValue = frameset.getAttribute("onunload");
                if (onunloadValue != null) {
                    found = frameset;
                    break;
                }
            }
            n = n.prev;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            if (this.wasDisposed) {
                if (Debug.trace) {
                    Debug.traceStack("Double dispose, please report this to ICEsoft");
                }
                return;
            }
            this.wasDisposed = true;
        }
        FramesetData fd = this.framesetData;
        if (fd != null) {
            fd.dispose();
        }
        this.framesetData = null;
        this.persistentDomListeners = null;
        this.defaultEventHandler = null;
        if (this.componentFactory != null) {
            this.componentFactory.dispose();
        }
        this.cssLayout.clear();
        this.objectPool.dispose();
        this.doc.clear();
        super.dispose();
    }

    protected CSSLayout createCSSLayout(String media, DDocument doc) {
        CSSMatcher m = new CSSMatcher(media, this.sdata, doc);
        CSSLayout layout = null;
        if (media.equals("screen") || media.equals("none")) {
            layout = new CSSLayout(this.sdata, doc, m);
            layout.setFontCache(this.sdata.fontCache);
        } else if (media.equals("print")) {
            layout = new ThePrinter(this.sdata, doc, m).getCSSLayout();
        } else {
            throw new IllegalArgumentException();
        }
        return layout;
    }

    public Dimension getDocumentDimension(Dimension rv) {
        rv.width = this.cssLayout.getWidth();
        rv.height = this.cssLayout.getHeight();
        return rv;
    }

    public Dimension getViewDimension(Dimension rv) {
        if (this.cssLayout.docPane != null) {
            rv.width = this.cssLayout.docPane.getPaneWidth();
            rv.height = this.cssLayout.docPane.getPaneHeight();
        }
        return rv;
    }

    public void setEncoding(String enc) {
        this.defaultEncoding = enc;
    }

    public String getEncoding() {
        return this.defaultEncoding;
    }

    public String getPageInfo(String name) {
        return this.doc.getHttpProperty("_http_" + name);
    }

    public Component createComponent() {
        DocPaneXml docPane;
        String enc = (String)this.getViewportProperty("encoding");
        if (enc != null) {
            this.defaultEncoding = enc;
        }
        if (this.componentFactory != null && (docPane = this.componentFactory.createDocPane()) != null) {
            int scrollMode = 0;
            String t1 = (String)this.getViewportProperty("scrolling");
            if (t1 != null) {
                if (t1.equalsIgnoreCase("yes")) {
                    scrollMode = 1;
                } else if (t1.equalsIgnoreCase("no")) {
                    scrollMode = 2;
                }
            }
            docPane.init(scrollMode);
            docPane.bind(this, this.cssLayout);
            return docPane.getPaneComponent();
        }
        return null;
    }

    public StormPrinter createPrinter() {
        CSSLayout tmp = this.createCSSLayout("print", this.doc);
        return new ThePrinter(tmp, this.getPilotViewport());
    }

    void putBaseUrl(String url) {
        this.getPilotViewport().setBaseUrl(url);
    }

    public boolean refExists(String ref) {
        return this.cssLayout.refExists(ref);
    }

    public void gotoRef(String ref) {
        DocPaneXml docPane = this.cssLayout.docPane;
        if (docPane == null) {
            return;
        }
        DNode eventNode = null;
        if (ref == null) {
            docPane.setScrollPosition(0, 0);
            eventNode = this.doc.getDBody();
        } else {
            int y = this.cssLayout.getRefPos(ref);
            if (y >= 0) {
                docPane.setScrollPosition(0, y);
                eventNode = ref != null ? this.cssLayout.getRefNode(ref) : this.doc.getDBody();
            } else if ("top".equalsIgnoreCase(ref)) {
                docPane.setScrollPosition(0, 0);
                eventNode = this.doc.getDBody();
            }
        }
        if (eventNode != null) {
            this.doc.processEvent(30, eventNode);
        }
    }

    public final Document getDocument() {
        return this.getDDocument();
    }

    public DDocument getDDocument() {
        return this.doc;
    }

    final CSSLayout getCSSLayout() {
        return this.cssLayout;
    }

    public TheView getView() {
        return this.cssLayout.theView;
    }

    public DocPane getDocPane() {
        return this.cssLayout.docPane;
    }

    public String getSelectedText() {
        return this.cssLayout.getSelectedText();
    }

    public boolean isSelectionActive() {
        return this.cssLayout.isSelection();
    }

    public void clearSelection() {
        this.cssLayout.clearSelection();
    }

    public Search getSearch() {
        return new Search(this.doc, this.cssLayout);
    }

    Object doScriptEval(String language, String scriptText, String scriptUrl, int startLine) {
        if (scriptText == null || scriptText.length() == 0) {
            return null;
        }
        Scripter theScripter = this.getStorm().getScripter(language);
        if (theScripter == null) {
            return null;
        }
        return theScripter.eval(this.getPilotViewport(), scriptText, scriptUrl, startLine);
    }

    private boolean doScriptHandlerEval(String scripterName, Object handler, DynamicObject event, DynamicObject handlerThis) {
        Scripter theScripter = this.getStorm().getScripter(scripterName);
        if (theScripter == null) {
            return true;
        }
        return theScripter.evalEventHandler(this.getPilotViewport(), handlerThis, handler, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void do_document_write(String str) {
        boolean doStart = false;
        if (this.currentLexer == null) {
            Viewport _viewport = this.getPilotViewport();
            Viewport _contextViewport = _viewport.getContextViewport();
            String _baseUrl = null;
            if (_contextViewport != null) {
                _baseUrl = _contextViewport.getBaseUrl();
            }
            this.getStorm().clearViewportContent("text/html", _viewport);
            if (_viewport == _contextViewport) {
                Object object = this.clearContextLock;
                synchronized (object) {
                    this.contextCleared = true;
                }
            }
            _viewport.setLocationUrl(_baseUrl);
            DOMBuilder b = new DOMBuilder(this.doc, this);
            this.currentLexer = new Lex2(b);
            this.lexerShouldFinishOnScriptEnd = true;
            doStart = true;
        }
        this.currentLexer.appendGeneratedContent(str);
        try {
            this.currentLexer.parse(doStart, false);
        }
        catch (IOException exception) {
            Debug.ex(exception);
        }
    }

    void do_document_close() {
        if (this.currentLexer != null && this.lexerShouldFinishOnScriptEnd) {
            block3: {
                this.lexerShouldFinishOnScriptEnd = false;
                try {
                    this.currentLexer.parse(false, true);
                }
                catch (IOException ex) {
                    if (!Debug.ex) break block3;
                    Debug.ex(ex);
                }
            }
            this.currentLexer = null;
            this.finalize_parsing(null);
        }
    }

    private void checkLayoutProperties() {
        this.cssLayout.doImageAnimation = Defs.sysPropertyBoolean("ice.pilots.html4.imageAnimation", true);
        try {
            int i;
            String aa = Defs.sysProperty("ice.pilots.html4.minFontSize");
            if (aa != null && (i = CSSUtil.parseInt(aa, -1)) >= 4) {
                this.sdata.fontCache.setMinFontSize(i);
                this.sdata.printerFontCache.setMinFontSize(i);
            }
            if ((aa = Defs.sysProperty("ice.pilots.html4.baseFontSize")) != null && (i = CSSUtil.parseInt(aa, -1)) >= 4) {
                this.sdata.fontCache.setBaseFontSize(i);
                this.sdata.printerFontCache.setBaseFontSize(i);
            }
            if ((aa = Defs.sysProperty("ice.pilots.html4.baseFontFamily")) != null) {
                this.sdata.fontCache.setBaseFontFamily(aa);
                this.sdata.printerFontCache.setBaseFontFamily(aa);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void refresh() {
        this.checkLayoutProperties();
        this.doc.mutate();
        this.cssLayout.validateLayout();
    }

    protected void setZoom(int z) {
        this.cssLayout.setLayoutZoom(z);
    }

    public void suspend() {
        if (this.cssLayout != null) {
            this.cssLayout.clear();
        }
    }

    public void resume() {
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String contentType) {
        ThePilot thePilot;
        ThePilot thePilot2 = this;
        synchronized (thePilot2) {
            ++this.noLayoutUpdate;
        }
        try {
            this.do_clear(contentType);
            Object var5_4 = null;
            thePilot = this;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ThePilot thePilot3 = this;
            synchronized (thePilot3) {
                --this.noLayoutUpdate;
            }
            throw throwable;
        }
        synchronized (thePilot) {
            --this.noLayoutUpdate;
        }
    }

    private void do_clear(String contentType) {
        this.allowedToLoadImages = true;
        FramesetData fd = this.framesetData;
        if (fd != null) {
            fd.dispose();
        }
        this.framesetData = null;
        this.cssLayout.clear();
        this.objectPool.dispose();
        this.objectPool = new ObjectPool(this);
        this.doc.clear();
        if (CSSLayout.forceGC) {
            System.gc();
        }
        String tmp = contentType.toLowerCase();
        if (Debug.trace) {
            Debug.trace("contentType ==" + contentType + " tmp == " + tmp);
        }
        if (tmp.indexOf("xml") >= 0) {
            this.doc.setHtmlMode(false);
        } else {
            this.doc.setHtmlMode(true);
        }
        this.encoding = this.defaultEncoding;
        int a = tmp.indexOf("charset");
        if (a > 0 && (a = contentType.indexOf(61, a)) > 0) {
            this.encoding = contentType.substring(a + 1).trim();
        }
        this.lockedEncoding = false;
        this.checkLayoutProperties();
        this.firePropertyChange("title", null, "");
    }

    public void stopImageAnimation() {
        this.cssLayout.doImageAnimation = false;
    }

    public void stopLoading() {
        this.allowedToLoadImages = false;
        this.objectPool.stopImageLoading();
    }

    public void onLowMemory() {
        this.stopLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistentDOMEventListener(String type, EventListener listener, boolean useCapture) {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            this.persistentDomListeners = DNodeListeners.addEventListener(this.persistentDomListeners, type, useCapture, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePersistentDOMEventListener(String type, EventListener listener, boolean useCapture) {
        ThePilot thePilot = this;
        synchronized (thePilot) {
            this.persistentDomListeners = DNodeListeners.removeEventListener(this.persistentDomListeners, type, useCapture, listener);
        }
    }

    public DefaultEventHandler getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public void setDefaultEventHandler(DefaultEventHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        this.defaultEventHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ContentLoader cl) throws IOException {
        ThePilot thePilot;
        this.isFromHistory = cl.isFromHistory();
        ThePilot thePilot2 = this;
        synchronized (thePilot2) {
            ++this.noLayoutUpdate;
        }
        try {
            this.setCursor(3);
            this.do_parse(cl);
            Object var5_4 = null;
            thePilot = this;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ThePilot thePilot3 = this;
            synchronized (thePilot3) {
                --this.noLayoutUpdate;
            }
            throw throwable;
        }
        synchronized (thePilot) {
            --this.noLayoutUpdate;
        }
        if (!this.getPilotViewport().isStopRequested()) {
            this.finalize_parsing(cl.getLocation());
        }
        this.setCursor(0);
    }

    private void setCursor(int cursor) {
        DocPane pane = this.getDocPane();
        if (pane == null) {
            return;
        }
        pane.setCursor(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_parse(ContentLoader cl) throws IOException {
        Lex2 l;
        DOMBuilder b = new DOMBuilder(this.doc, this);
        this.currentLexer = l = new Lex2(b);
        this.doc.cookieSet = cl.getCookieSet();
        if (this.doc.cookieSet == null) {
            this.doc.cookieSet = this.sdata.getCookieSet();
        }
        try {
            String charset = this.extractCharset(cl.getContentType());
            if (charset != null) {
                this.encoding = charset;
                this.lockedEncoding = true;
            }
            int i = 1;
            while (true) {
                String key = cl.getHeaderFieldKey(i);
                String val = cl.getHeaderField(i);
                if (key == null || val == null) break;
                if (key.equalsIgnoreCase("set-cookie")) {
                    this.doc.setCookie(val);
                } else {
                    String useCharset = Defs.sysProperty("http.useCharset");
                    if (useCharset != null && useCharset.equalsIgnoreCase("true") && !this.lockedEncoding && key.equalsIgnoreCase("content-type") && (charset = this.extractCharset(val)) != null) {
                        this.encoding = charset;
                    }
                    this.doc.setHttpProperty("_http_" + key.toLowerCase(), val);
                }
                ++i;
            }
            try {
                String tmp = cl.getRequestProperty("referer");
                if (tmp != null) {
                    this.doc.setHttpProperty("_http_referer", tmp);
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
            InputStream in = cl.getInputStream();
            if (in == null) {
                throw new IOException("Could not connect to: " + cl.getLocation());
            }
            String url = cl.getLocation();
            if (url != null) {
                this.firePropertyChange("location", null, url);
            }
            this.doc.setDefaultCharset(this.encoding);
            l.setInputStream(in, this.encoding);
            l.setLockedEncoding(this.lockedEncoding);
            try {
                l.parse();
                if (Debug.trace && this.doc == null) {
                    Debug.trace("do_parse: Document is null");
                }
                if (this.doc != null) {
                    this.doc.setDefaultCharset(l.getEncoding());
                }
            }
            catch (OutOfMemoryError ex) {
                throw new ICEException(1, 3, 2);
            }
            catch (RuntimeException ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
                if (Debug.trace) {
                    Debug.trace("Do not be scared - this exception is caught!");
                }
                throw new IOException("Parsing problem");
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                in.close();
            }
        }
        finally {
            this.currentLexer = null;
        }
    }

    private String extractCharset(String contentType) {
        String charset = null;
        int pos = contentType.toLowerCase().indexOf("charset");
        if (pos != -1 && (pos = contentType.indexOf(61, pos)) != -1 && pos != contentType.length() - 1) {
            charset = contentType.substring(++pos).trim();
        }
        return charset;
    }

    public void parsingDone() {
        if (this.doc != null && this.doc.isFrameset) {
            this.firePropertyChange("contentRendering", null, "end");
            this.firePropertyChange("outstandingImages", null, "0");
        } else if (this.doc != null) {
            this.cssLayout.refresh(true);
        }
    }

    private void finalize_parsing(String url) {
        if (Debug.trace && this.doc == null) {
            Debug.trace("finalize_parsing: Document is null");
        }
        if (this.doc == null) {
            return;
        }
        if (this.doc.isFrameset && !viewNoframes && !this.loadSingleOnly) {
            this.processFrameset();
        } else {
            DElement body;
            int tmp;
            if (url != null && (tmp = url.indexOf(35) + 1) > 0 && tmp < url.length()) {
                String ref = url.substring(tmp);
                this.cssLayout.setWaitForRef(ref);
            }
            String t1 = (String)this.getViewportProperty("marginwidth");
            String t2 = (String)this.getViewportProperty("marginheight");
            if ((t1 != null || t2 != null) && (body = this.doc.getDBody()) != null) {
                if (t1 != null) {
                    body.setAttribute(58, t1);
                }
                if (t2 != null) {
                    body.setAttribute(57, t2);
                }
                this.doc.mutate();
            }
        }
        DElement head = this.doc.getHead();
        if (head != null) {
            DNode m = head.getFirstDChild();
            while (m != null) {
                DElement me;
                String tmp;
                if (m.getNameId() == 57 && (tmp = (me = (DElement)m).getAttribute(49)) != null && tmp.equalsIgnoreCase("refresh") && REFRESH_ENABLED && (tmp = me.getAttribute(31)) != null) {
                    this.setupRefresh(tmp);
                }
                m = m.next;
            }
        }
    }

    void onLayoutEnd() {
        DElement body;
        this.firePropertyChange("contentRendering", null, "end");
        if (this.currentLexer == null && (body = this.doc.getDBody()) != null && this.cssLayout.docPane != null) {
            this.cssLayout.docPane.updateScrollbars(this.doc.isRTL());
        }
    }

    public void onLoadingDone() {
        this.firePropertyChange("contentRendering", null, "finished");
        this.objectPool.fireOutstandingImagesEvent();
        DElement body = this.doc.getDBody();
        if (body != null) {
            this.doc.processEvent(this.doc.createDOMEvent(13, body));
        } else {
            FramesetData fd = this.framesetData;
            if (fd != null) {
                fd.sendFramesetOnload();
            }
        }
    }

    boolean canLoadImages() {
        return this.allowedToLoadImages;
    }

    void updateFrameset(DElement e) {
        if (e != null) {
            int[] rowTypes;
            int[] rowValues;
            int[] colTypes;
            int[] colValues;
            FramesetData fd = this.framesetData;
            if (fd == null) {
                return;
            }
            String str_cols = e.getAttribute(28);
            String str_rows = e.getAttribute(92);
            if (str_cols != null) {
                CoordsList cl = new CoordsList(str_cols);
                colValues = cl.getListOfValues();
                colTypes = cl.getListOfTypes();
            } else {
                colValues = new int[]{100};
                colTypes = new int[]{1};
            }
            if (str_rows != null) {
                CoordsList cl = new CoordsList(str_rows);
                rowValues = cl.getListOfValues();
                rowTypes = cl.getListOfTypes();
            } else {
                rowValues = new int[]{100};
                rowTypes = new int[]{1};
            }
            fd.updateFramesetInfo(e, colValues, colTypes, rowValues, rowTypes);
        }
    }

    protected void processFrameset() {
        int i;
        Viewport v;
        Object cl;
        DNode top;
        NodeList nl = this.doc.getElementsByTagName("frameset");
        if (nl.getLength() == 0) {
            return;
        }
        FramesetData fd = this.framesetData;
        if (fd != null) {
            fd.dispose();
        }
        fd = new FramesetData(this);
        StormBase storm = this.getStorm();
        Vector<String> locs = new Vector<String>();
        Vector<Viewport> viewports = new Vector<Viewport>();
        DNode n = top = (DNode)nl.item(0);
        boolean isFirstframset = true;
        do {
            DElement e = (DElement)n;
            if (e.tagId == 34) {
                int[] rowTypes;
                int[] rowValues;
                int[] colTypes;
                int[] colValues;
                String tmp = e.getAttribute(123);
                if (tmp != null) {
                    this.getViewportContainer().addComponentListener(new OnresizeListener(e, this.doc));
                }
                String str_cols = e.getAttribute(28);
                String str_rows = e.getAttribute(92);
                if (str_cols != null) {
                    cl = new CoordsList(str_cols);
                    colValues = ((CoordsList)cl).getListOfValues();
                    colTypes = ((CoordsList)cl).getListOfTypes();
                } else {
                    colValues = new int[1];
                    colTypes = new int[1];
                    colValues[0] = 100;
                    colTypes[0] = 1;
                }
                if (str_rows != null) {
                    CoordsList cl2 = new CoordsList(str_rows);
                    rowValues = cl2.getListOfValues();
                    rowTypes = cl2.getListOfTypes();
                } else {
                    rowValues = new int[1];
                    rowTypes = new int[1];
                    rowValues[0] = 100;
                    rowTypes[0] = 1;
                }
                FramesDivider framesDivider = null;
                if (isFirstframset) {
                    isFirstframset = false;
                } else {
                    DElement fs;
                    Component cp = this.cssLayout.docPane.createFramesDividerComponent();
                    framesDivider = new FramesDivider(cp);
                    String st = e.getAttribute(65);
                    if (cp != null && (st == null || st.equalsIgnoreCase("false"))) {
                        cp.addMouseListener(framesDivider);
                        cp.addMouseMotionListener(framesDivider);
                    }
                    if ((st = (fs = (DElement)e.getDParent()).getAttribute(43)) != null) {
                        framesDivider.setProperty("frameborder", st);
                    }
                    if ((st = fs.getAttribute(13)) != null) {
                        framesDivider.setProperty("border", st);
                    }
                }
                Viewport view = this.getPilotViewport();
                fd.beginFrameset(e, colValues, colTypes, rowValues, rowTypes, framesDivider, view.getName());
            } else if (e.tagId == 33) {
                String loc = e.getAttribute(102);
                String name = e.getAttribute(63);
                if (loc == null) {
                    loc = "";
                }
                if (loc.length() > 0) {
                    loc = this.doc.resolveUrl(loc);
                }
                if (name != null && name.length() == 0) {
                    name = null;
                }
                v = new Viewport(this.getStorm(), name);
                v.setFrameArrayMember();
                Component comp = this.cssLayout.docPane.createFramesDividerComponent();
                FramesDivider framesDivider = new FramesDivider(comp);
                if (fd.addFramesetChild(v, framesDivider)) {
                    DElement fs;
                    viewports.addElement(v);
                    locs.addElement(loc);
                    String t = e.getAttribute(97);
                    if (t != null) {
                        v.setProperty("scrolling", t);
                    }
                    if ((t = e.getAttribute(58)) != null) {
                        v.setProperty("marginwidth", t);
                    }
                    if ((t = e.getAttribute(57)) != null) {
                        v.setProperty("marginheight", t);
                    }
                    if ((t = (fs = (DElement)e.getDParent()).getAttribute(43)) != null) {
                        framesDivider.setProperty("frameborder", t);
                    }
                    if ((t = fs.getAttribute(13)) != null) {
                        framesDivider.setProperty("border", t);
                    }
                    t = e.getAttribute(65);
                    if (comp != null && (t == null || t.equalsIgnoreCase("false"))) {
                        comp.addMouseListener(framesDivider);
                        comp.addMouseMotionListener(framesDivider);
                    }
                }
            }
            if (e.tagId != 34 || n.getFirstDChild() == null) {
                while (n != top && n.next == null) {
                    n = n.parent;
                    if (n.getNameId() != 34) continue;
                    fd.endFrameset();
                }
                if (n == top) continue;
                n = n.next;
                continue;
            }
            n = n.getFirstDChild();
        } while (n != top);
        Viewport view = this.getPilotViewport();
        view.removePilotComponent();
        int N = viewports.size();
        for (i = 0; i != N; ++i) {
            v = (Viewport)viewports.elementAt(i);
            v.setContainer(view.getContainer());
            view.addChild(v);
        }
        this.framesetData = fd;
        N = viewports.size();
        for (i = 0; i != N; ++i) {
            v = (Viewport)viewports.elementAt(i);
            String loc = (String)locs.elementAt(i);
            storm.clearViewportContent("text/html", v);
            if (loc.length() == 0 || this.isFromHistory) continue;
            Scripter scripter = this.getStorm().getScripterForCodeLocation(loc);
            if (scripter != null) {
                scripter.evalCodeLocation(v, loc);
                return;
            }
            cl = storm.getContentLoaderFactory().createContentLoader(loc, null);
            ((ContentLoader)cl).setReferer(this.doc.getBaseUrl());
            if (this.isLoadedSynchronously) {
                storm.renderViewportContentFully((ContentLoader)cl, v);
                continue;
            }
            storm.renderViewportContent((ContentLoader)cl, v);
        }
        if (this.isFromHistory) {
            this.firePropertyChange("viewport", null, "childrenReady");
        }
    }

    protected boolean allowedToRunHandler(DOMEvent de, DNode node) {
        switch (de.getTypeId()) {
            case 19: {
                if (!(node instanceof DFormElement) || de.getTarget() == node) break;
                return false;
            }
        }
        return true;
    }

    protected DynamicObject getScriptHandlerThis(DNode node, DOMEvent domEvent) {
        DNode result = node;
        if (!(node.tagId != 13 && node.tagId != 34 || domEvent.typeId != 13 && domEvent.typeId != 14)) {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evalScriptHandlerListeners(DNode node, DOMEvent domEvent, Object handler) {
        if (handler != null && this.allowedToRunHandler(domEvent, node)) {
            boolean runDefault;
            DynamicObject scriptThis = this.getScriptHandlerThis(node, domEvent);
            Object object = this.clearContextLock;
            synchronized (object) {
                if (this.contextCleared) {
                    this.contextCleared = false;
                }
                runDefault = this.doScriptHandlerEval("ECMAScript", handler, domEvent, scriptThis);
                if (this.contextCleared) {
                    domEvent.cancel = true;
                    this.contextCleared = false;
                }
            }
            if (domEvent.typeId == 5 || domEvent.typeId == 7) {
                boolean bl = runDefault = !runDefault;
            }
            if (!runDefault) {
                domEvent.preventDefault();
            }
        }
    }

    public static void addColorDefinition(String name, Color color) {
        CSSUtil.addColorDefinition(name, color);
    }

    public static DStyleSheet getUserStyleSheet(StormBase storm) {
        return CSSManager.getUserStyle(StormData.get(storm));
    }

    protected Object script_createOption(Object[] args) {
        DOptionElement option = (DOptionElement)this.doc.createElement(63);
        if (args.length >= 1) {
            Object tmp = args[0];
            String text = tmp == null ? "" : tmp.toString();
            option.setText(text);
            if (args.length >= 2) {
                tmp = args[1];
                String value = tmp == null ? "" : tmp.toString();
                option.setValue(value);
            }
        }
        return option;
    }

    protected Object script_createActiveXObject(String resource) {
        if ("Msxml2.DOMDocument".equals(resource)) {
            if (Debug.trace) {
                Debug.trace("WindowObj.script_ActiveXObject 2");
            }
            return this.doc.getDom().createDDocument(this, false);
        }
        return null;
    }

    protected Object script_createXMLHttpRequest(Object[] args) {
        return ((WindowObj)this.getPilotViewport().getWindowObj()).newXMLHttpRequest();
    }

    protected Object script_getDOMImplementation() {
        return this.doc.getDom();
    }

    public final DynamicObject getDocumentObject() {
        return this.getDDocument();
    }

    public void updateFrameList() {
        this.getView().updateFrameList();
    }

    private int IE_nameToWinBodySharedAttr(String s) {
        int Id_onblur = 70;
        int Id_onfocus = 74;
        int Id_onload = 78;
        int Id_onunload = 87;
        int id = 0;
        String X = null;
        int s_length = s.length();
        if (s_length == 6) {
            char c = s.charAt(2);
            if (c == 'b') {
                X = "onblur";
                id = 70;
            } else if (c == 'l') {
                X = "onload";
                id = 78;
            }
        } else if (s_length == 7) {
            X = "onfocus";
            id = 74;
        } else if (s_length == 8) {
            X = "onunload";
            id = 87;
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id - 1;
    }

    private void tmpStoreBodyEventHandlers(int handlerAttribute, Object value) {
        if (this.tmpBodyEventHandlers == null) {
            this.tmpBodyEventHandlers = new HashArray();
        }
        this.tmpBodyEventHandlers.put(handlerAttribute, value);
    }

    private Object getTmpStoredBodyEventHandlers(int handlerAttribute) {
        HashArray hash = this.tmpBodyEventHandlers;
        return hash != null ? hash.get(handlerAttribute) : null;
    }

    void moveToBodyTmpBodyEventHandlers() {
        DElement body;
        HashArray hash = this.tmpBodyEventHandlers;
        this.tmpBodyEventHandlers = null;
        if (hash != null && (body = this.doc.getDBody()) != null) {
            HashArray.Iterator iter = hash.newIterator();
            iter.start();
            while (!iter.done()) {
                HashArray.Entry attr_entry = iter.entry();
                int attrId = attr_entry.index();
                Object value = attr_entry.value;
                body.setDAttr(attrId, value, false);
                iter.next();
            }
        }
    }

    public Object getDynamicValueOnWindow(DynamicObject window, String name, DynEnv env) {
        int id = ThePilot.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(window, name);
        }
        if (id > 0) {
            return this.getDynamicValueOnWindow(id, env);
        }
        int sharedWinBodyAttr = this.IE_nameToWinBodySharedAttr(name);
        if (sharedWinBodyAttr >= 0) {
            DElement body = this.doc.getDBody();
            Object result = body != null ? body.getSlot(name, env) : this.getTmpStoredBodyEventHandlers(sharedWinBodyAttr);
            return result;
        }
        return super.getDynamicValueOnWindow(window, name, env);
    }

    public int setDynamicValueOnWindow(DynamicObject window, String name, Object value, DynEnv env) {
        int id = ThePilot.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValueOnWindow(id, value, env);
        }
        int sharedWinBodyAttr = this.IE_nameToWinBodySharedAttr(name);
        if (sharedWinBodyAttr >= 0) {
            DElement body = this.doc.getDBody();
            if (body != null) {
                body.setDAttr(sharedWinBodyAttr, value, false);
            } else {
                this.tmpStoreBodyEventHandlers(sharedWinBodyAttr, value);
            }
            return 1;
        }
        return super.setDynamicValueOnWindow(window, name, value, env);
    }

    public Object execDynamicMethodOnWindow(DynamicObject window, String name, Object[] args, DynEnv env) {
        int id = ThePilot.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethodOnWindow(id, args, env);
        }
        return super.execDynamicMethodOnWindow(window, name, args, env);
    }

    private Object getDynamicValueOnWindow(int id, DynEnv env) {
        switch (id) {
            case 2: {
                return this.doc.currentEvent;
            }
            case 1: {
                return this.script_getDOMImplementation();
            }
        }
        return null;
    }

    private int setDynamicValueOnWindow(int key_id, Object value, DynEnv env) {
        return 1;
    }

    private Object execDynamicMethodOnWindow(int key_id, Object[] args, DynEnv env) {
        if (key_id == -2) {
            return this.script_createOption(args);
        }
        if (key_id == -1) {
            return this.script_createActiveXObject(env.toStr(args, 0));
        }
        if (key_id == -3) {
            return this.script_createXMLHttpRequest(args);
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 5: {
                X = "event";
                id = 2;
                break;
            }
            case 6: {
                X = "Option";
                id = -2;
                break;
            }
            case 11: {
                char c = s.charAt(4);
                if (c == 'X') {
                    X = "pageXOffset";
                    id = 3;
                    break;
                }
                if (c != 'Y') break;
                X = "pageYOffset";
                id = 4;
                break;
            }
            case 13: {
                X = "ActiveXObject";
                id = -1;
                break;
            }
            case 14: {
                X = "XMLHttpRequest";
                id = -3;
                break;
            }
            case 17: {
                X = "DOMImplementation";
                id = 1;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }

    public void applySnapshot(Object snapshot) {
        if (snapshot == null) {
            return;
        }
        Snapshot _snapshot = (Snapshot)snapshot;
        DDocument _document = (DDocument)this.getDocument();
        if (_document == null) {
            return;
        }
        if (_snapshot.inputNames != null) {
            Snapshot.Context _context;
            HashArray.Entry _entry;
            String _name;
            int i;
            int _number = 0;
            NodeList _nodeList = _document.getElementsByTagName("input");
            if (_nodeList != null) {
                for (i = 0; i < _nodeList.getLength(); ++i) {
                    DAttr _inputValueAttribute;
                    HashArray.Entry _entry2;
                    String _type;
                    DInputElement _inputElement = (DInputElement)_nodeList.item(i);
                    _name = _inputElement.getName();
                    if (_name == null || (_type = _inputElement.getType()) == null) continue;
                    Snapshot.Context _context2 = this.createContext(++_number, _name, _inputElement);
                    if (_type.equals("text") || _type.equals("hidden")) {
                        _entry2 = this.getEntry(_context2, _snapshot.inputNames);
                        if (_entry2 == null || !_context2.equalContext((Snapshot.Context)_entry2.key())) break;
                        if (_entry2.value == null) continue;
                        _inputElement.setValue((String)_entry2.value);
                        continue;
                    }
                    if (_type.equals("checkbox")) {
                        _entry2 = this.getEntry(_context2, _snapshot.inputNames);
                        if (_entry2 == null || !_context2.equalContext((Snapshot.Context)_entry2.key())) break;
                        if (_entry2.value == null) continue;
                        _inputElement.setChecked((Boolean)_entry2.value);
                        continue;
                    }
                    if (!_type.equals("radio") || (_inputValueAttribute = _inputElement.getDAttr(114)) == null) continue;
                    HashArray.Entry _entry3 = this.getEntry(_context2 = new Snapshot.Context(_context2.number, _context2.formId, _context2.formName, _context2.inputName + "_" + _inputValueAttribute.getValue()), _snapshot.inputNames);
                    if (_entry3 == null || !_context2.equalContext((Snapshot.Context)_entry3.key())) break;
                    if (_entry3.value == null) continue;
                    _inputElement.setChecked((Boolean)_entry3.value);
                }
            }
            if ((_nodeList = _document.getElementsByTagName("textarea")) != null) {
                for (i = 0; i < _nodeList.getLength(); ++i) {
                    DTextAreaElement _textAreaElement = (DTextAreaElement)_nodeList.item(i);
                    _name = _textAreaElement.getName();
                    if (_name == null) continue;
                    if ((_entry = this.getEntry(_context = this.createContext(++_number, _name, _textAreaElement), _snapshot.inputNames)) == null || !_context.equalContext((Snapshot.Context)_entry.key())) break;
                    if (_entry.value == null) continue;
                    _textAreaElement.setValue((String)_entry.value);
                }
            }
            if ((_nodeList = _document.getElementsByTagName("select")) != null) {
                for (i = 0; i < _nodeList.getLength(); ++i) {
                    DSelectElement _selectElement = (DSelectElement)_nodeList.item(i);
                    _name = _selectElement.getName();
                    if (_name == null) continue;
                    if ((_entry = this.getEntry(_context = this.createContext(++_number, _name, _selectElement), _snapshot.inputNames)) == null || !_context.equalContext((Snapshot.Context)_entry.key())) break;
                    Vector _optionList = (Vector)_entry.value;
                    for (int j = 0; j < _selectElement.getLength(); ++j) {
                        Boolean _selected = (Boolean)_optionList.elementAt(j);
                        if (_selected == null) continue;
                        ((DOptionElement)_selectElement.item(j)).setSelected(_selected);
                    }
                }
            }
        }
        this.cssLayout.setPresetScrollPosition(_snapshot.scrollX, _snapshot.scrollY);
        if (this.cssLayout.docPane != null) {
            this.cssLayout.docPane.setScrollPosition(_snapshot.scrollX, _snapshot.scrollY);
        }
    }

    public Object getSnapshot() {
        Snapshot _snapshot = null;
        DDocument _document = (DDocument)this.getDocument();
        if (_document != null) {
            Snapshot.Context _context;
            String _name;
            int i;
            _snapshot = new Snapshot();
            _snapshot.inputNames = new HashArray(Defs.NO_SYNCHRONIZATION);
            int _number = 0;
            NodeList _nodeList = _document.getElementsByTagName("input");
            if (_nodeList != null) {
                for (i = 0; i < _nodeList.getLength(); ++i) {
                    DAttr _inputValueAttribute;
                    String _type;
                    DInputElement _inputElement = (DInputElement)_nodeList.item(i);
                    _name = _inputElement.getName();
                    if (_name == null || (_type = _inputElement.getType()) == null) continue;
                    Snapshot.Context _context2 = this.createContext(++_number, _name, _inputElement);
                    if (_type.equals("text") || _type.equals("hidden")) {
                        _snapshot.inputNames.put(_context2, (Object)_inputElement.getValue());
                        continue;
                    }
                    if (_type.equals("checkbox")) {
                        _snapshot.inputNames.put(_context2, (Object)new Boolean(_inputElement.getChecked()));
                        continue;
                    }
                    if (!_type.equals("radio") || (_inputValueAttribute = _inputElement.getDAttr(114)) == null) continue;
                    _context2 = new Snapshot.Context(_context2.number, _context2.formId, _context2.formName, _context2.inputName + "_" + _inputValueAttribute.getValue());
                    _snapshot.inputNames.put(_context2, (Object)new Boolean(_inputElement.getChecked()));
                }
            }
            if ((_nodeList = _document.getElementsByTagName("textarea")) != null) {
                for (i = 0; i < _nodeList.getLength(); ++i) {
                    DTextAreaElement _textAreaElement = (DTextAreaElement)_nodeList.item(i);
                    _name = _textAreaElement.getName();
                    if (_name == null) continue;
                    _context = this.createContext(++_number, _name, _textAreaElement);
                    String _value = _textAreaElement.getValue();
                    if (_value == null) continue;
                    _snapshot.inputNames.put(_context, (Object)_value);
                }
            }
            if ((_nodeList = _document.getElementsByTagName("select")) != null) {
                for (i = 0; i < _nodeList.getLength(); ++i) {
                    DSelectElement _selectElement = (DSelectElement)_nodeList.item(i);
                    _name = _selectElement.getName();
                    if (_name == null) continue;
                    _context = this.createContext(++_number, _name, _selectElement);
                    Vector<Boolean> _optionList = new Vector<Boolean>();
                    for (int j = 0; j < _selectElement.getLength(); ++j) {
                        _optionList.addElement(new Boolean(((DOptionElement)_selectElement.item(j)).getSelected()));
                    }
                    _snapshot.inputNames.put(_context, _optionList);
                }
            }
            _snapshot.inputNames.sealObject();
            if (this.cssLayout.docPane != null) {
                _snapshot.scrollX = this.cssLayout.docPane.getScrollX();
                _snapshot.scrollY = this.cssLayout.docPane.getScrollY();
            }
        }
        return _snapshot;
    }

    private Snapshot.Context createContext(int number, String inputName, DNode node) {
        String _formId = null;
        String _formName = null;
        String _inputName = inputName;
        DNode _parent = node.getParentDNode();
        while (_parent.getNameId() != 13) {
            if (_parent.getNameId() == 32) {
                DAttr _formNameAttribute;
                DAttr _formIdAttribute = _parent.getDAttr(50);
                if (_formIdAttribute != null) {
                    _formId = _formIdAttribute.getValue();
                }
                if ((_formNameAttribute = _parent.getDAttr(63)) == null) break;
                _formName = _formNameAttribute.getValue();
                break;
            }
            _parent = _parent.getParentDNode();
        }
        return new Snapshot.Context(number, _formId, _formName, _inputName);
    }

    private HashArray.Entry getEntry(Snapshot.Context context, HashArray hashArray) {
        HashArray.Entry[] _entries = hashArray.getEntries();
        for (int i = 0; i < _entries.length; ++i) {
            if (!_entries[i].key().equals(context)) continue;
            return _entries[i];
        }
        return null;
    }

    static boolean prepareImage(final Image image, final ImageObserver observer) {
        final Toolkit toolkit = Toolkit.getDefaultToolkit();
        return Boolean.TRUE == SecurityKit.doPrivileged(new BoxedCode(){

            public Object run() {
                boolean b = toolkit.prepareImage(image, -1, -1, observer);
                return b ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    void setupRefresh(String refreshStr) {
        String loc;
        int next_quote;
        char c;
        int start = 0;
        int end = refreshStr.length();
        start = CharKit.trimStart(refreshStr, start, end);
        end = CharKit.trimEnd(refreshStr, start, end);
        int timeEnd = refreshStr.indexOf(59, start);
        if (timeEnd < 0) {
            timeEnd = refreshStr.indexOf(44, start);
        }
        int time = -1;
        if (timeEnd >= 0) {
            time = CSSUtil.parseInt(refreshStr, start, timeEnd, -1);
            start = timeEnd + 1;
            start = CharKit.trimStart(refreshStr, start, end);
        }
        if (refreshStr.regionMatches(true, start, "url=", 0, 4)) {
            start += 4;
            start = CharKit.trimStart(refreshStr, start, end);
        }
        if (start != end && ((c = refreshStr.charAt(start)) == '\'' || c == '\"') && (next_quote = refreshStr.indexOf(c, ++start)) >= 0) {
            end = next_quote;
        }
        if (time < 0 && (time = CSSUtil.parseInt(refreshStr, start, end, -1)) >= 0) {
            start = end;
        }
        if ((loc = start == end ? this.doc.getBaseUrl() : this.doc.resolveUrl(refreshStr.substring(start, end))) == null) {
            return;
        }
        time = time >= 0 ? (time *= 1000) : 0;
        RefreshItem item = new RefreshItem(this.doc, loc, time);
        item.postToEventThread(time);
    }

    void startDownload(final String url, final Object callback, final Scripter scripter) {
        final int documentId = this.getPilotViewport().getDocumentId();
        Thread t = new Thread(){

            public void run() {
                SecurityKit.doPrivileged(new BoxedCode(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object run() {
                        2.access$1300(this.this$1).do_download(2.access$900(this.this$1), 2.access$1000(this.this$1), 2.access$1100(this.this$1), 2.access$1200(this.this$1));
                        return null;
                    }
                });
            }

            static /* synthetic */ String access$900(2 x0) {
                return x0.url;
            }

            static /* synthetic */ Object access$1000(2 x0) {
                return x0.callback;
            }

            static /* synthetic */ Scripter access$1100(2 x0) {
                return x0.scripter;
            }

            static /* synthetic */ int access$1200(2 x0) {
                return x0.documentId;
            }

            static /* synthetic */ ThePilot access$1300(2 x0) {
                return x0.ThePilot.this;
            }
        };
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void do_download(String url, final Object callback, final Scripter scripter, int documentId) {
        String str;
        if (documentId != this.getPilotViewport().getDocumentId()) {
            return;
        }
        url = this.doc.resolveUrl(url);
        try {
            Reader reader = this.doc.openUrlReader(url);
            try {
                if (documentId != this.getPilotViewport().getDocumentId()) {
                    return;
                }
                str = IOKit.readAllStr(reader, 4096);
            }
            finally {
                reader.close();
            }
        }
        catch (IOException ex) {
            if (Debug.ex) {
                Debug.ex(ex);
            }
            return;
        }
        if (documentId != this.getPilotViewport().getDocumentId()) {
            return;
        }
        DocAction action = new DocAction(this.doc, documentId){

            protected void doit(DDocument doc) {
                Object[] args = new Object[]{str};
                scripter.evalCallback(ThePilot.this.getPilotViewport(), callback, args);
            }
        };
        action.postToEventThread(0L);
    }

    private static class Snapshot {
        private HashArray inputNames;
        private int scrollX;
        private int scrollY;

        private Snapshot() {
        }

        private static class Context {
            private final int number;
            private final String formId;
            private final String formName;
            private final String inputName;

            private Context(int number, String formId, String formName, String inputName) {
                this.number = number;
                this.formId = formId;
                this.formName = formName;
                this.inputName = inputName;
            }

            public boolean equals(Object object) {
                return ((Context)object).number == this.number;
            }

            public boolean equalContext(Context context) {
                return (context.formId == null ? this.formId == null : context.formId.equalsIgnoreCase(this.formId)) && (context.formName == null ? this.formName == null : context.formName.equalsIgnoreCase(this.formName)) && (context.inputName == null ? this.inputName == null : context.inputName.equalsIgnoreCase(this.inputName));
            }

            public int hashCode() {
                return this.number;
            }

            public String toString() {
                return "Context [\r\n    number     : " + this.number + "\r\n" + "    form ID    : " + this.formId + "\r\n" + "    form name  : " + this.formName + "\r\n" + "    input name : " + this.inputName + "\r\n" + "]";
            }
        }
    }
}

