/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.TableCellBox;
import ice.pilots.html4.TableColBox;
import ice.pilots.html4.TableRowBox;
import ice.pilots.html4.TableRowGroupBox;
import ice.pilots.html4.TextBox;
import ice.util.Defs;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class TableBox
extends CSSBox {
    private BlockBox caption;
    private CSSBox firstRowGroup;
    private CSSBox lastRowGroup;
    private CSSBox firstCol;
    private CSSBox lastCol;
    private TableRowGroupBox anonRowGroup;
    int[] colMinWidth;
    int[] colMaxWidth;
    int[] colWidth;
    int[] colCoord;
    boolean[] colPreset;
    int[] colPercent;
    int percentTotal = 0;
    int numCols = 0;
    int realNumCols = 0;
    boolean childOfBody = false;

    TableBox(DElement e, CSSAttribs css, CSSLayout cssLayout) {
        super(e, css, cssLayout);
        DNode n;
        if (e != null && (n = e.getParentDNode()) != null && n.getNameId() == 13) {
            this.childOfBody = true;
        }
    }

    void propagateVisibility(short b, boolean self) {
        boolean propagate;
        boolean bl = propagate = !self || this.setVisibility(b);
        if (propagate) {
            CSSBox bb = this.firstRowGroup;
            while (bb != null) {
                bb.propagateVisibility(b, true);
                bb = bb.next;
            }
        }
    }

    void dispose() {
        CSSBox bn;
        if (this.caption != null) {
            this.caption.dispose();
        }
        this.caption = null;
        CSSBox b = this.firstRowGroup;
        while (b != null) {
            bn = b.next;
            b.dispose();
            b = bn;
        }
        this.lastRowGroup = null;
        this.firstRowGroup = null;
        this.anonRowGroup = null;
        b = this.firstCol;
        while (b != null) {
            bn = b.next;
            b.dispose();
            b = bn;
        }
        this.lastCol = null;
        this.firstCol = null;
        super.dispose();
        this.element = null;
    }

    int getType() {
        return 1;
    }

    CSSBox getFirstChild() {
        return this.firstRowGroup;
    }

    CSSBox getBoxAt(int ex, int ey, Point rv) {
        int x1 = this.css.border_left_width + this.css.padding_left;
        int x2 = this.css.border_right_width + this.css.padding_right;
        x2 = this.width - x1 - x2;
        if (ex >= x1 && ex < x2) {
            CSSBox b;
            if (this.caption != null) {
                b = this.caption;
                if (ey >= b.oy && ey < b.oy + b.height && (b = b.getBoxAt(ex, ey - b.oy, rv)) != null) {
                    return b;
                }
            }
            b = this.firstRowGroup;
            while (b != null) {
                if (ey >= b.oy && ey < b.oy + b.height) {
                    return b.getBoxAt(ex, ey - b.oy, rv);
                }
                b = b.next;
            }
        }
        rv.x = ex;
        rv.y = ey;
        return this;
    }

    DNode getDomNode() {
        return this.element;
    }

    private boolean countCols() {
        int num = 0;
        int realNum = 0;
        TableRowGroupBox group = (TableRowGroupBox)this.firstRowGroup;
        while (group != null) {
            if (group.numUsedCols > num) {
                num = group.numUsedCols;
            }
            if (group.realNumCols > realNum) {
                realNum = group.realNumCols;
            }
            group = (TableRowGroupBox)group.next;
        }
        if (realNum != this.realNumCols) {
            this.realNumCols = realNum;
        }
        if (num != this.numCols) {
            this.numCols = num;
            this.colMinWidth = new int[num];
            this.colMaxWidth = new int[num];
            this.colWidth = new int[num];
            this.colCoord = new int[num];
            this.colPreset = new boolean[num];
            this.colPercent = new int[num];
            return true;
        }
        return false;
    }

    CSSBox getfirstRowGroup() {
        return this.firstRowGroup;
    }

    void calcMinMaxWidths() {
        int i;
        CSSBox row;
        this.countCols();
        this.maxWidth = 0;
        this.minWidth = 0;
        if (this.caption != null) {
            this.caption.calcMinMaxWidths();
        }
        for (int i2 = 0; i2 < this.numCols; ++i2) {
            this.colMaxWidth[i2] = 0;
            this.colMinWidth[i2] = 0;
            this.colPercent[i2] = 0;
        }
        CSSBox b = this.firstRowGroup;
        while (b != null) {
            row = ((TableRowGroupBox)b).firstRow;
            while (row != null) {
                ((TableRowBox)row).calcMinMaxWidthsUnspanned();
                row = row.next;
            }
            b = b.next;
        }
        b = this.firstRowGroup;
        while (b != null) {
            row = ((TableRowGroupBox)b).firstRow;
            while (row != null) {
                ((TableRowBox)row).calcMinMaxWidthsSpanned();
                row = row.next;
            }
            b = b.next;
        }
        boolean percentageOnly = true;
        boolean emptyCells = false;
        this.percentTotal = 0;
        for (i = 0; i < this.numCols; ++i) {
            this.minWidth += this.colMinWidth[i];
            this.maxWidth += this.colMaxWidth[i];
            if (this.colMaxWidth[i] == 1) {
                emptyCells = true;
            }
            if (this.colPercent[i] > 0) {
                if (this.colPercent[i] + this.percentTotal > 100) {
                    this.colPercent[i] = this.percentTotal == 0 ? 100 : 0;
                }
                this.percentTotal += this.colPercent[i];
            }
            if (this.colPercent[i] != 0) continue;
            percentageOnly = false;
        }
        if (percentageOnly && this.percentTotal < 100 && this.numCols > 0) {
            int i3;
            int newTotal = 0;
            for (i3 = 0; i3 < this.numCols; ++i3) {
                int percentShare;
                if (this.colPercent[i3] <= 0) continue;
                this.colPercent[i3] = percentShare = this.colPercent[i3] * 100 / this.percentTotal;
                newTotal += this.colPercent[i3];
            }
            if (newTotal != 100) {
                for (i3 = 0; i3 < this.numCols; ++i3) {
                    if (this.colPercent[i3] <= 0) continue;
                    int toAdd = 100 - newTotal;
                    int n = i3;
                    this.colPercent[n] = this.colPercent[n] + toAdd;
                    newTotal += toAdd;
                    break;
                }
            }
            this.percentTotal = newTotal;
        }
        if (percentageOnly && emptyCells) {
            this.maxWidth = 0;
            for (i = 0; i < this.numCols; ++i) {
                if (this.colMaxWidth[i] <= 1) continue;
                this.maxWidth = Math.max(100 * this.colMaxWidth[i] / this.colPercent[i], this.maxWidth);
            }
        }
        int t = (this.numCols + 1) * this.css.border_spacing_x;
        this.maxWidth += t;
        this.minWidth += t;
        int presetWidth = 0;
        if (this.css.width != -123456 && (this.css.percentage_flag & 0x100000) == 0) {
            presetWidth = this.css.width;
        }
        if (presetWidth > this.minWidth) {
            int W;
            if (this.percentTotal > 0) {
                int actualPresetWidth = presetWidth - t;
                int[] newWidths = new int[this.numCols];
                int plainWidth = 0;
                int percentWidth = 0;
                int percentPlainWidth = 0;
                for (int i4 = 0; i4 < this.numCols; ++i4) {
                    newWidths[i4] = 0;
                    if (this.colPercent[i4] > 0) {
                        int actual = actualPresetWidth * this.colPercent[i4] / 100;
                        if (actual >= this.colMinWidth[i4]) {
                            percentWidth += actual;
                            newWidths[i4] = actual;
                            continue;
                        }
                        percentPlainWidth += this.colMinWidth[i4];
                        continue;
                    }
                    plainWidth += this.colMinWidth[i4];
                }
                int test = percentWidth + percentPlainWidth + plainWidth - actualPresetWidth;
                if (test > 0) {
                    int i5 = 0;
                    while (test > 0) {
                        if (this.colPercent[i5] > 0 && newWidths[i5] > 0) {
                            int n = i5;
                            newWidths[n] = newWidths[n] - 1;
                            --percentWidth;
                            --test;
                        }
                        if (++i5 < this.numCols) continue;
                        i5 = 0;
                    }
                }
                if (test <= 0) {
                    int leftToShare = actualPresetWidth - percentWidth - percentPlainWidth;
                    for (int i6 = 0; i6 < this.numCols; ++i6) {
                        if (this.colPercent[i6] > 0) {
                            if (newWidths[i6] == 0) {
                                newWidths[i6] = this.colMinWidth[i6];
                            }
                        } else {
                            newWidths[i6] = plainWidth == 0 ? this.colMinWidth[i6] : leftToShare * this.colMinWidth[i6] / plainWidth;
                        }
                        this.colMaxWidth[i6] = this.colMinWidth[i6] = newWidths[i6];
                    }
                } else {
                    int i7;
                    int absoluteMinimum = 0;
                    for (i7 = 0; i7 < this.numCols; ++i7) {
                        absoluteMinimum += this.colMinWidth[i7];
                    }
                    if (absoluteMinimum > actualPresetWidth) {
                        if (Debug.trace) {
                            Debug.trace("WARNING: potential bug, please report this");
                        }
                    } else {
                        for (i7 = 0; i7 < this.numCols; ++i7) {
                            newWidths[i7] = this.colMinWidth[i7] * actualPresetWidth / absoluteMinimum;
                            this.colMaxWidth[i7] = this.colMinWidth[i7] = newWidths[i7];
                        }
                    }
                }
            } else if (presetWidth >= this.maxWidth) {
                W = presetWidth - t;
                int D = this.maxWidth - t;
                for (int i8 = 0; i8 < this.numCols; ++i8) {
                    int w = this.colMaxWidth[i8];
                    if (D > 0) {
                        this.colMaxWidth[i8] = w * W / D;
                        this.colMinWidth[i8] = this.colMaxWidth[i8];
                    }
                    W -= this.colMaxWidth[i8];
                    D -= w;
                }
            } else {
                W = presetWidth - this.minWidth;
                int D = this.maxWidth - this.minWidth;
                for (int i9 = 0; i9 < this.numCols; ++i9) {
                    int minWidth = this.colMinWidth[i9];
                    int maxWidth = this.colMaxWidth[i9];
                    if (D > 0) {
                        int n = i9;
                        this.colMinWidth[n] = this.colMinWidth[n] + (maxWidth - minWidth) * W / D;
                        this.colMaxWidth[i9] = this.colMinWidth[i9];
                    }
                    D += -maxWidth + minWidth;
                    W += -this.colMaxWidth[i9] + minWidth;
                }
            }
            this.minWidth = this.maxWidth = presetWidth;
        } else if (presetWidth != 0) {
            this.maxWidth = this.minWidth;
            System.arraycopy(this.colMinWidth, 0, this.colMaxWidth, 0, this.numCols);
        }
        t = this.css.border_left_width + this.css.padding_left + this.css.border_right_width + this.css.padding_right;
        this.maxWidth += t;
        this.minWidth += t;
    }

    void layout(int parentContentWidth, int parentContentHeight, FloatManager m) {
        int D;
        int W;
        int i;
        if (parentContentWidth < this.minWidth) {
            parentContentWidth = this.minWidth;
        }
        int contentHeight = parentContentHeight;
        int fixedHeight = -1;
        int leftX = this.css.border_left_width + this.css.padding_left;
        int rightX = this.css.border_right_width + this.css.padding_right;
        if ((this.css.percentage_flag & 8) != 0) {
            fixedHeight = contentHeight = parentContentHeight * this.css.height / 100;
        } else if (this.css.height > 0) {
            contentHeight = this.css.height;
            fixedHeight = this.css.height;
        }
        int m1 = 0;
        int m2 = 0;
        if (this.css.width == -123456) {
            if (this.css.margin_left != -123456) {
                m1 = this.css.margin_left;
            }
            if (this.css.margin_right != -123456) {
                m2 = this.css.margin_right;
            }
            this.width = parentContentWidth - m1 - m2;
            if (this.width < this.minWidth) {
                this.width = this.minWidth;
            }
            if (this.width > this.maxWidth) {
                this.width = this.maxWidth;
            }
        } else if ((this.css.percentage_flag & 0x100000) != 0) {
            if (this.cssLayout.inPrintMode && this.css.width > 100 && Defs.sysPropertyBoolean("ice.pilots.html4.printResizeTables")) {
                this.css.width = 100;
            }
            this.width = leftX + rightX + this.css.width * (parentContentWidth - leftX - rightX) / 100;
            if (this.width < this.minWidth) {
                this.width = this.minWidth;
            }
            m1 = this.css.margin_left == -123456 || this.css.margin_right == -123456 ? (parentContentWidth - this.width) / 2 : this.css.margin_left;
        } else {
            this.width = this.css.width + leftX + rightX;
            if (this.width < this.minWidth) {
                this.width = this.minWidth;
            }
            if (this.css.margin_left == -123456 || this.css.margin_right == -123456) {
                if (this.width > parentContentWidth) {
                    m1 = (parentContentWidth - this.width) / 2;
                }
            } else {
                m1 = this.css.margin_left;
            }
        }
        this.ox += m1;
        int topY = this.css.border_top_width + this.css.padding_top;
        int bottomY = this.css.border_bottom_width + this.css.padding_bottom;
        contentHeight -= topY + bottomY;
        int ax = m.getAvailableX();
        int aw = m.getAvailableWidth();
        if (ax > 0) {
            this.ox += ax;
        }
        if (m.hasActiveFloaters() && aw > 0 && aw < this.width) {
            this.width = aw;
            if (this.width < this.minWidth) {
                this.width = this.minWidth;
            }
        }
        int prefWidth = this.width;
        int overhead = leftX + rightX + this.css.border_spacing_x * (this.numCols + 1);
        if (prefWidth >= this.maxWidth && this.percentTotal == 0) {
            if (this.css.width == 0 || prefWidth == this.maxWidth) {
                for (i = 0; i < this.numCols; ++i) {
                    this.colWidth[i] = this.colMaxWidth[i];
                }
            } else {
                W = prefWidth - overhead;
                D = this.maxWidth - overhead;
                for (i = 0; i < this.numCols; ++i) {
                    if (D > 0 && !this.colPreset[i]) continue;
                    this.colWidth[i] = this.colMaxWidth[i];
                    W -= this.colWidth[i];
                    D -= this.colWidth[i];
                }
                for (i = 0; i < this.numCols; ++i) {
                    if (D <= 0 || this.colPreset[i]) continue;
                    this.colWidth[i] = this.colMaxWidth[i] * W / D;
                    W -= this.colWidth[i];
                    D -= this.colMaxWidth[i];
                }
            }
        } else if (prefWidth <= this.minWidth) {
            for (i = 0; i < this.numCols; ++i) {
                this.colWidth[i] = this.colMinWidth[i];
            }
        } else if (this.percentTotal != 0) {
            int tmpMaxWidth = overhead;
            for (i = 0; i < this.numCols; ++i) {
                if (this.colPercent[i] > 0) {
                    int a = this.colPercent[i] * (prefWidth - overhead) / 100;
                    if (a < this.colMinWidth[i]) {
                        a = this.colMinWidth[i];
                    }
                    tmpMaxWidth += a;
                    continue;
                }
                tmpMaxWidth += this.colMaxWidth[i];
            }
            if (prefWidth >= tmpMaxWidth) {
                int W2 = prefWidth - overhead;
                int need = 0;
                for (i = 0; i < this.numCols; ++i) {
                    if (this.colPercent[i] > 0) {
                        int a;
                        int n = a = this.realNumCols == 1 ? prefWidth - overhead : Math.round((float)(this.colPercent[i] * (prefWidth - overhead)) / 100.0f);
                        if (a < this.colMinWidth[i]) {
                            a = this.colMinWidth[i];
                        }
                        this.colWidth[i] = i == this.numCols - 1 ? W2 : a;
                        W2 -= a;
                        continue;
                    }
                    need += this.colMinWidth[i];
                }
                if (need > 0) {
                    for (i = 0; i < this.numCols; ++i) {
                        if (this.colPercent[i] != 0) continue;
                        this.colWidth[i] = this.colMinWidth[i] * W2 / need;
                    }
                }
            } else {
                int colAskedForWidth = 0;
                int colRatioWidth = 0;
                for (int cdx = 0; cdx < this.numCols; ++cdx) {
                    if (this.colPercent[cdx] > 0) {
                        int tempI = this.colPercent[cdx] * (prefWidth - overhead) / 100;
                        colAskedForWidth += tempI < this.colMinWidth[cdx] ? this.colMinWidth[cdx] : tempI;
                        continue;
                    }
                    colAskedForWidth += this.colMinWidth[cdx];
                    colRatioWidth += this.colMinWidth[cdx];
                }
                if (colAskedForWidth < prefWidth) {
                    int leftOver = prefWidth - overhead - colAskedForWidth;
                    for (int cdx = 0; cdx < this.numCols; ++cdx) {
                        if (this.colPercent[cdx] > 0) {
                            this.colWidth[cdx] = this.colPercent[cdx] * prefWidth / 100;
                            if (this.colWidth[cdx] >= this.colMinWidth[cdx]) continue;
                            this.colWidth[cdx] = this.colMinWidth[cdx];
                            continue;
                        }
                        if (colRatioWidth == 0) {
                            colRatioWidth = this.colMinWidth[cdx];
                        }
                        float ratio = (float)this.colMinWidth[cdx] / (float)colRatioWidth;
                        this.colWidth[cdx] = this.colMinWidth[cdx] + (int)((float)leftOver * ratio);
                    }
                } else {
                    int sumOfColsMins = 0;
                    for (int cdx = 0; cdx < this.numCols; ++cdx) {
                        if (this.colPercent[cdx] == 0) {
                            this.colWidth[cdx] = this.colMinWidth[cdx];
                        }
                        sumOfColsMins += this.colMinWidth[cdx];
                    }
                    int spaceLeft = prefWidth - overhead - sumOfColsMins;
                    boolean minimizeTheRest = false;
                    for (int cdx = 0; cdx < this.numCols; ++cdx) {
                        if (this.colPercent[cdx] <= 0) continue;
                        int colPref = this.colPercent[cdx] * prefWidth / 100;
                        if (colPref < this.colMinWidth[cdx]) {
                            this.colWidth[cdx] = this.colMinWidth[cdx];
                            continue;
                        }
                        if (minimizeTheRest) {
                            this.colWidth[cdx] = this.colMinWidth[cdx];
                            continue;
                        }
                        if (colPref < spaceLeft) {
                            this.colWidth[cdx] = colPref;
                            int deduction = colPref > this.colMinWidth[cdx] ? colPref - this.colMinWidth[cdx] : 0;
                            spaceLeft -= deduction;
                            continue;
                        }
                        this.colWidth[cdx] = this.colMinWidth[cdx] + spaceLeft;
                        minimizeTheRest = true;
                    }
                }
            }
        } else {
            W = prefWidth - this.minWidth;
            D = this.maxWidth - this.minWidth;
            for (i = 0; i < this.numCols; ++i) {
                int minWidth = this.colMinWidth[i];
                int maxWidth = this.colMaxWidth[i];
                this.colWidth[i] = D > 0 ? minWidth + (maxWidth - minWidth) * W / D : this.colMinWidth[i];
                D += -maxWidth + minWidth;
                W += -this.colWidth[i] + minWidth;
            }
        }
        int w = leftX + this.css.border_spacing_x;
        for (i = 0; i < this.numCols; ++i) {
            this.colCoord[i] = w;
            w += this.colWidth[i] + this.css.border_spacing_x;
        }
        w += rightX;
        this.height = topY + this.css.border_spacing_y;
        if (this.caption != null) {
            this.caption.oy = 0;
            this.caption.ox = leftX;
            ((TableCellBox)this.caption).layout(w - leftX - rightX, -1);
            this.height += this.caption.height;
        }
        TableRowGroupBox group = (TableRowGroupBox)this.firstRowGroup;
        while (group != null) {
            group.ox = leftX + this.css.border_spacing_x;
            group.width = this.width - leftX - rightX - 2 * this.css.border_spacing_x;
            group.oy = this.height;
            group.layout(fixedHeight);
            this.height += group.height;
            group = (TableRowGroupBox)group.next;
        }
        if (this.firstRowGroup != null) {
            contentHeight -= this.css.border_spacing_y * (((TableRowGroupBox)this.firstRowGroup).numRows + 1);
        }
        if (fixedHeight > this.height) {
            this.height = fixedHeight;
            this.adjustHeight(contentHeight);
        } else {
            this.height += bottomY + this.css.border_spacing_y;
        }
        m.advance(this.height);
    }

    private void adjustHeight(int aHeight) {
        TableRowGroupBox group = (TableRowGroupBox)this.firstRowGroup;
        if (group != null && group.next == null) {
            group.height = aHeight;
            group.adjustHeight();
        }
    }

    void paint(Graphics g) {
        if ((this.css.misc & 1) != 0) {
            Rectangle r = g.getClipBounds();
            int skipTop = 0;
            if (this.caption != null) {
                skipTop = this.caption.height;
            }
            if (r != null) {
                this.paintBackground(g, r, this.css.border_left_width, this.css.border_top_width, this.width, this.height - skipTop - (this.css.border_top_width + this.css.border_bottom_width), 0);
            }
            this.paintBorders(g, r, 0, skipTop, this.width, this.height - skipTop, this.css.border_top_width > 0 && this.css.border_top_style != 8, this.css.border_bottom_width > 0 && this.css.border_bottom_style != 8, this.css.border_left_width > 0 && this.css.border_left_style != 8, this.css.border_right_width > 0 && this.css.border_right_style != 8);
        }
        TableRowGroupBox group = (TableRowGroupBox)this.firstRowGroup;
        while (group != null) {
            group.paint(g);
            group = (TableRowGroupBox)group.next;
        }
        if (this.caption != null) {
            this.cssLayout.outlinePainter.drawBox(g, this.caption, this.caption.ox, this.caption.oy);
        }
    }

    CSSBox addChild(CSSBox b) {
        if (b instanceof TableRowGroupBox) {
            if (this.firstRowGroup == null) {
                this.firstRowGroup = this.lastRowGroup = b;
                b.next = null;
            } else if (this.lastRowGroup.css.display == 50 && b.css.display != 50) {
                if (this.firstRowGroup == this.lastRowGroup) {
                    this.firstRowGroup = b;
                    b.next = this.lastRowGroup;
                } else {
                    CSSBox t = this.firstRowGroup;
                    while (t.next != null && t.next.css.display != 50) {
                        t = t.next;
                    }
                    b.next = t.next;
                    t.next = b;
                }
            } else {
                this.lastRowGroup.next = b;
                b.next = null;
                this.lastRowGroup = b;
            }
            b.setParentBox(this);
            this.anonRowGroup = null;
        } else if (b instanceof TableColBox) {
            if (this.firstCol == null) {
                this.firstCol = this.lastCol = b;
                b.next = null;
            } else {
                this.lastCol.next = b;
                b.next = null;
                this.lastCol = b;
            }
        } else if (b instanceof BlockBox && b.css.display == 55) {
            this.caption = (BlockBox)b;
            b.setParentBox(this);
        } else {
            if (b instanceof TextBox && ((TextBox)b).isEmpty()) {
                return this;
            }
            TableRowGroupBox rg = this.anonRowGroup;
            if (rg == null) {
                CSSAttribs a = new CSSAttribs(this.cssLayout.getFontCache(), this.css);
                a.display = 48;
                rg = new TableRowGroupBox(null, a, this.cssLayout);
                this.addChild(rg);
                this.anonRowGroup = rg;
            }
            rg.addChild(b);
        }
        return this;
    }

    TableColBox getCellColBox(int col) {
        CSSBox b = this.firstCol;
        while (b != null) {
            TableColBox c = (TableColBox)b;
            if (c.span > col) {
                b = c.firstCol;
                if (b != null) continue;
                return c;
            }
            col -= c.span;
            b = b.next;
        }
        return null;
    }

    public String toString() {
        return "table" + super.toString();
    }

    void findBoundingBox(Rectangle r) {
        Point pp = new Point();
        pp.y = 0;
        pp.x = 0;
        this.findAbsolutePosition(pp);
        r.x = pp.x;
        r.y = pp.y;
        r.width = this.width;
        r.height = this.height;
    }

    int getCount(int aType, Point p) {
        int returnVal = 0;
        CSSBox box = this.firstRowGroup;
        while (box != null) {
            returnVal += box.getCount(aType, p);
            box = box.next;
        }
        return returnVal;
    }

    CSSBox findChildByIndex_r(int aType, int aIndex, Point aPoint) {
        CSSBox box = this.firstRowGroup;
        while (box != null) {
            CSSBox returnVal = box.findChildByIndex_r(aType, aIndex, aPoint);
            if (returnVal != null) {
                return returnVal;
            }
            box = box.next;
        }
        return null;
    }
}

