/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.cursor;

import coldfusion.nosql.mongo.MongoUtils;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.Scope;
import coldfusion.util.CFDumpable;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.client.MongoCursor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

@NotThreadSafe
@GenerateCFInvoke
public class CFMongoCursor<T>
extends Scope
implements CFDumpable {
    private MongoCursor<T> cursor;
    private T current;
    private long count;
    private boolean closed;
    private static final Map<String, Function<CFMongoCursor, Object>> variableResolveMap = new HashMap<String, Function<CFMongoCursor, Object>>();

    public CFMongoCursor(MongoCursor<T> cursor) {
        variableResolveMap.put("current", cs -> cs.current);
        variableResolveMap.put("address", cs -> cs.getAddress());
        variableResolveMap.put("currentcount", cs -> cs.currentCount());
        variableResolveMap.put("id", cs -> cs.getId());
        variableResolveMap.put("isclosed", cs -> cs.closed);
        this.cursor = cursor;
    }

    public CFMongoCursor<T> close() {
        this.cursor.close();
        this.closed = true;
        this.current = null;
        this.count = 0L;
        return this;
    }

    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    public T next() {
        this.current = this.cursor.next();
        ++this.count;
        return this.current;
    }

    public T current() {
        return this.current;
    }

    public long currentCount() {
        return this.count;
    }

    public T tryNext() {
        Object value = this.cursor.tryNext();
        if (value != null) {
            ++this.count;
            this.current = value;
        }
        return (T)value;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public long getId() {
        ServerCursor serverCursor = this.getServerCursor();
        if (serverCursor == null) {
            return 0L;
        }
        return serverCursor.getId();
    }

    public int itcount() {
        int n = 0;
        while (this.hasNext()) {
            this.next();
            ++n;
        }
        return n;
    }

    public Map getAddress() {
        ServerAddress serverAddress = this.getServerAddress();
        return MongoUtils.toMap(serverAddress);
    }

    protected ServerAddress getServerAddress() {
        try {
            return this.cursor.getServerAddress();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    protected ServerCursor getServerCursor() {
        try {
            return this.cursor.getServerCursor();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public Object getMetadata() {
        HashMap metadata = new HashMap();
        variableResolveMap.forEach((key, value) -> metadata.put(key, value.apply(this)));
        return metadata;
    }

    public String getLabel() {
        return "MongoDB Cursor";
    }

    protected void bindName(String name, Object obj) {
        throw new UnsupportedOperationException();
    }

    protected void bindName_Final(String name, Object obj) {
        throw new UnsupportedOperationException();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }

    protected void unbindName(String name) {
        throw new UnsupportedOperationException();
    }

    protected Object resolveName(String name) {
        Function<CFMongoCursor, Object> function = variableResolveMap.get(name = name.toLowerCase());
        if (function != null) {
            return function.apply(this);
        }
        return null;
    }

    protected boolean containsName(String name) {
        name = name.toLowerCase();
        return variableResolveMap.containsKey(name);
    }

    protected Iterator getNames() {
        return variableResolveMap.keySet().iterator();
    }
}

