/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.codecs;

import coldfusion.nosql.mongo.CFMongoContext;
import coldfusion.nosql.mongo.MongoImageWriteFormat;
import coldfusion.nosql.mongo.codecs.PrimitiveCodec;
import coldfusion.osgi.services.ImageService;
import coldfusion.runtime.Cast;
import coldfusion.server.ServiceFactory;
import coldfusion.wddx.Base64Encoder;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

class CFBinaryCodec<T>
extends PrimitiveCodec<T> {
    CFBinaryCodec() {
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        byte[] toBinary = Cast.ToBinary(value);
        ImageService imageService = ServiceFactory.getImageService((boolean)false);
        if (imageService != null && imageService.isImage(value)) {
            this.encodeImage(writer, toBinary, value, encoderContext);
        } else {
            writer.writeBinaryData(new BsonBinary(toBinary));
        }
    }

    public void encodeImage(BsonWriter writer, byte[] bytes, Object image, EncoderContext encoderContext) {
        String srcFormat = ServiceFactory.getImageService().getSrcFormat(image);
        if (srcFormat == null) {
            srcFormat = "jpeg";
        }
        MongoImageWriteFormat imageWriteFormat = CFMongoContext.getImageWriteFormat();
        switch (imageWriteFormat) {
            case BYTES: {
                BsonDocument imageDocument = new BsonDocument();
                imageDocument.put("format", (BsonValue)new BsonString(srcFormat));
                imageDocument.put("datatype", (BsonValue)new BsonString("binary"));
                imageDocument.put("data", (BsonValue)new BsonBinary(bytes));
                writer.pipe((BsonReader)new BsonDocumentReader(imageDocument));
                break;
            }
            case BASE64: {
                BsonDocument imgDoc = new BsonDocument();
                imgDoc.put("format", (BsonValue)new BsonString(srcFormat));
                imgDoc.put("datatype", (BsonValue)new BsonString("base64"));
                imgDoc.put("data", (BsonValue)new BsonString(CFBinaryCodec.getImageBase64(bytes)));
                writer.pipe((BsonReader)new BsonDocumentReader(imgDoc));
                break;
            }
            case BASE64_DATA_URI: {
                writer.writeString("data:image/" + srcFormat + ";base64," + CFBinaryCodec.getImageBase64(bytes));
                break;
            }
        }
    }

    private static String getImageBase64(byte[] imgBytes) {
        return Base64Encoder.encode((byte[])imgBytes);
    }

    public Class<T> getEncoderClass() {
        return Object.class;
    }
}

