/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.bson;

import coldfusion.nosql.mongo.MongoClientSettingsBuilder;
import coldfusion.nosql.mongo.bson.types.CFBsonJS;
import coldfusion.nosql.mongo.bson.types.CFBsonMaxKey;
import coldfusion.nosql.mongo.bson.types.CFBsonMinKey;
import coldfusion.nosql.mongo.bson.types.CFBsonTimeStamp;
import coldfusion.nosql.mongo.bson.types.CFMongoDBRef;
import coldfusion.nosql.mongo.bson.types.CFMongoObjectID;
import coldfusion.nosql.mongo.bson.types.CFMongoRegExp;
import coldfusion.nosql.mongo.codecs.CFMongoCodec;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFBigDecimal;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFDouble;
import coldfusion.runtime.CFInteger;
import coldfusion.runtime.CFLong;
import coldfusion.runtime.Cast;
import coldfusion.runtime.OleDate;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.util.CaseInsensitiveMap;
import com.mongodb.DBRef;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class BsonUtils {
    private static final Map<Class<?>, Function<Object, BsonValue>> javaToBSONMap;
    private static final Map<BsonType, Function<BsonValue, Object>> bsonToJavaMap;
    private static final Decoder jsonArrayDecoder;
    private static final BsonTypeCodecMap bsonTypeCodecMap;

    public static Bson to(Object obj) {
        if (obj instanceof String) {
            return BsonUtils.to((String)obj);
        }
        return BsonUtils.to(Cast._Map((Object)obj));
    }

    public static Object toBsonListorBson(Object obj) {
        if (obj instanceof String) {
            return BsonUtils.to((String)obj);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            ArrayList bsonList = new ArrayList();
            list.forEach(l -> bsonList.add(BsonUtils.to(Cast._Map((Object)l))));
            return bsonList;
        }
        return BsonUtils.to(Cast._Map((Object)obj));
    }

    public static Bson to(String json) {
        if (json.startsWith("[")) {
            JsonReader bsonReader = new JsonReader(json);
            return (Bson)jsonArrayDecoder.decode((BsonReader)bsonReader, DecoderContext.builder().build());
        }
        return Document.parse((String)json);
    }

    public static BsonDocument to(Map map) {
        return BsonUtils.to(map, new BsonDocument());
    }

    public static BsonDocument to(Map map, BsonDocument document) {
        for (Object entryObj : map instanceof CaseInsensitiveMap ? ((CaseInsensitiveMap)map).caseHandledEntrySet() : map.entrySet()) {
            Map.Entry entry = (Map.Entry)entryObj;
            Object value = entry.getValue();
            document.append((String)entry.getKey(), BsonUtils.getValue(value));
        }
        return document;
    }

    public static BsonArray to(List values) {
        BsonArray bsonArray = new BsonArray();
        for (Object value : values) {
            bsonArray.add(BsonUtils.getValue(value));
        }
        return bsonArray;
    }

    public static BsonValue getValue(Object value) {
        if (value == null) {
            return BsonNull.VALUE;
        }
        Function<Object, BsonValue> function = javaToBSONMap.get(value.getClass());
        if (function == null) {
            if (value instanceof List) {
                return BsonUtils.to((List)value);
            }
            if (value instanceof Map) {
                return BsonUtils.to((Map)value);
            }
            if (value instanceof Date) {
                return new BsonDateTime(((Date)value).getTime());
            }
            return null;
        }
        return function.apply(value);
    }

    public static Object getValue(BsonValue value) {
        if (value.getBsonType() == BsonType.DOCUMENT) {
            Struct s = new Struct();
            BsonDocument document = (BsonDocument)value;
            for (Map.Entry entry : document.entrySet()) {
                s.put(entry.getKey(), BsonUtils.getValue((BsonValue)entry.getValue()));
            }
            return s;
        }
        if (value.getBsonType() == BsonType.ARRAY) {
            Array a = new Array();
            BsonArray array = (BsonArray)value;
            for (BsonValue b : array) {
                a.add(BsonUtils.getValue(b));
            }
            return a;
        }
        Function<BsonValue, Object> function = bsonToJavaMap.get(value.getBsonType());
        if (function == null) {
            return value;
        }
        return function.apply(value);
    }

    static {
        jsonArrayDecoder = new BsonArrayCodec(MongoClientSettingsBuilder.DEFAULT_CODEC_REGISTRY);
        bsonTypeCodecMap = new BsonTypeCodecMap(CFMongoCodec.bsonTypeClassMap, MongoClientSettingsBuilder.DEFAULT_CODEC_REGISTRY);
        javaToBSONMap = new HashMap();
        javaToBSONMap.put(null, obj -> BsonNull.VALUE);
        javaToBSONMap.put(String.class, obj -> new BsonString((String)obj));
        javaToBSONMap.put(char[].class, obj -> new BsonString(new String((char[])obj)));
        javaToBSONMap.put(Integer.class, obj -> new BsonInt32(((Integer)obj).intValue()));
        javaToBSONMap.put(CFInteger.class, obj -> new BsonInt32(((CFInteger)obj).intValue()));
        javaToBSONMap.put(Long.class, obj -> new BsonInt64(((Long)obj).longValue()));
        javaToBSONMap.put(CFLong.class, obj -> new BsonInt64(((CFLong)obj).longValue()));
        javaToBSONMap.put(Double.class, obj -> new BsonDouble(((Double)obj).doubleValue()));
        javaToBSONMap.put(Float.class, obj -> new BsonDouble((double)((Float)obj).floatValue()));
        javaToBSONMap.put(CFDouble.class, obj -> new BsonDouble(((CFDouble)obj).doubleValue()));
        javaToBSONMap.put(CFBigDecimal.class, obj -> new BsonDecimal128(new Decimal128((BigDecimal)((CFBigDecimal)obj))));
        javaToBSONMap.put(BigDecimal.class, obj -> new BsonDecimal128(new Decimal128((BigDecimal)obj)));
        javaToBSONMap.put(BigInteger.class, obj -> new BsonDecimal128(new Decimal128(new BigDecimal((BigInteger)obj))));
        javaToBSONMap.put(Decimal128.class, obj -> new BsonDecimal128((Decimal128)obj));
        javaToBSONMap.put(CFBoolean.class, obj -> new BsonBoolean(((CFBoolean)obj).value));
        javaToBSONMap.put(Boolean.class, obj -> new BsonBoolean(((Boolean)obj).booleanValue()));
        javaToBSONMap.put(Byte.class, obj -> new BsonInt32(((Byte)obj).intValue()));
        javaToBSONMap.put(Short.class, obj -> new BsonInt32(((Short)obj).intValue()));
        Function<Object, BsonValue> dateFunction = obj -> new BsonDateTime(((Date)obj).getTime());
        javaToBSONMap.put(Date.class, dateFunction);
        javaToBSONMap.put(OleDateTime.class, dateFunction);
        javaToBSONMap.put(OleDate.class, dateFunction);
        javaToBSONMap.put(Date.class, dateFunction);
        javaToBSONMap.put(ObjectId.class, obj -> new BsonObjectId((ObjectId)obj));
        javaToBSONMap.put(CFMongoObjectID.class, obj -> new BsonObjectId(((CFMongoObjectID)obj).getId()));
        javaToBSONMap.put(CFBsonMaxKey.class, obj -> new BsonMaxKey());
        javaToBSONMap.put(CFBsonMinKey.class, obj -> new BsonMinKey());
        javaToBSONMap.put(byte[].class, obj -> new BsonBinary((byte[])obj));
        javaToBSONMap.put(UUID.class, obj -> new BsonBinary((UUID)obj));
        javaToBSONMap.put(DBRef.class, obj -> new BsonDbPointer(((DBRef)obj).getCollectionName(), (ObjectId)((DBRef)obj).getId()));
        javaToBSONMap.put(CFMongoDBRef.class, obj -> {
            DBRef dbRef = ((CFMongoDBRef)obj).getRef();
            return new BsonDbPointer(dbRef.getCollectionName(), (ObjectId)dbRef.getId());
        });
        javaToBSONMap.put(CFMongoRegExp.class, obj -> {
            CFMongoRegExp regEx = (CFMongoRegExp)obj;
            return new BsonRegularExpression(regEx.getPattern(), regEx.getOptions());
        });
        javaToBSONMap.put(CFBsonJS.class, obj -> {
            CFBsonJS js = (CFBsonJS)obj;
            if (js.getScope() != null) {
                BsonDocument scopeDocument = BsonUtils.to(js.getScope());
                return new BsonJavaScriptWithScope(js.getCode(), scopeDocument);
            }
            return new BsonJavaScript(js.getCode());
        });
        bsonToJavaMap = new HashMap<BsonType, Function<BsonValue, Object>>();
        bsonToJavaMap.put(BsonType.INT32, value -> ((BsonInt32)value).getValue());
        bsonToJavaMap.put(BsonType.INT64, value -> ((BsonInt64)value).getValue());
        bsonToJavaMap.put(BsonType.BOOLEAN, value -> ((BsonBoolean)value).getValue());
        bsonToJavaMap.put(BsonType.OBJECT_ID, value -> new CFMongoObjectID(((BsonObjectId)value).getValue()));
        bsonToJavaMap.put(BsonType.STRING, value -> ((BsonString)value).getValue());
        bsonToJavaMap.put(BsonType.DOUBLE, value -> ((BsonDouble)value).getValue());
        bsonToJavaMap.put(BsonType.NULL, value -> null);
        bsonToJavaMap.put(BsonType.DECIMAL128, value -> ((BsonDecimal128)value).getValue().bigDecimalValue());
        bsonToJavaMap.put(BsonType.REGULAR_EXPRESSION, value -> new CFMongoRegExp((BsonRegularExpression)value));
        bsonToJavaMap.put(BsonType.OBJECT_ID, value -> ((BsonObjectId)value).getValue().toHexString());
        bsonToJavaMap.put(BsonType.JAVASCRIPT, value -> new CFBsonJS(((BsonJavaScript)value).getCode()));
        bsonToJavaMap.put(BsonType.JAVASCRIPT_WITH_SCOPE, value -> new CFBsonJS(((BsonJavaScriptWithScope)value).getCode(), (Map)((BsonJavaScriptWithScope)value).getScope()));
        bsonToJavaMap.put(BsonType.BINARY, value -> {
            BsonBinary binaryValue = (BsonBinary)value;
            byte subType = binaryValue.getType();
            if (BsonBinarySubType.UUID_STANDARD.getValue() == subType) {
                return binaryValue.asUuid();
            }
            return binaryValue.getData();
        });
        bsonToJavaMap.put(BsonType.DATE_TIME, value -> new Date(((BsonDateTime)value).getValue()));
        bsonToJavaMap.put(BsonType.TIMESTAMP, value -> new CFBsonTimeStamp(((BsonTimestamp)value).getTime(), ((BsonTimestamp)value).getInc()));
        bsonToJavaMap.put(BsonType.MAX_KEY, value -> CFBsonMaxKey.get());
        bsonToJavaMap.put(BsonType.MIN_KEY, value -> CFBsonMinKey.get());
        bsonToJavaMap.put(BsonType.DB_POINTER, value -> {
            BsonDbPointer dbPointer = (BsonDbPointer)value;
            return new CFMongoDBRef(dbPointer.getNamespace(), dbPointer.getId());
        });
    }
}

