/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo;

import coldfusion.nosql.mongo.MongoImageWriteFormat;
import java.util.ArrayList;
import java.util.List;

public class CFMongoContext {
    private static ThreadLocal<CFMongoContext> current = new ThreadLocal();
    private List<Object> insertedIds;
    private MongoImageWriteFormat imageFormat;

    public static CFMongoContext setCurrent(CFMongoContext c) {
        CFMongoContext old = current.get();
        current.set(c);
        return old;
    }

    public static CFMongoContext current() {
        return current.get();
    }

    public static CFMongoContext clear() {
        return CFMongoContext.setCurrent(null);
    }

    public void addInsertedId(Object id) {
        if (this.insertedIds == null) {
            this.insertedIds = new ArrayList<Object>();
        }
        this.insertedIds.add(id);
    }

    public void clearInsertedIds(Object id) {
        this.insertedIds = null;
    }

    public List<Object> getInsertedIds() {
        return this.insertedIds;
    }

    public static MongoImageWriteFormat getImageWriteFormat() {
        MongoImageWriteFormat imageWriteFormat;
        CFMongoContext mongoContext = CFMongoContext.current();
        if (mongoContext != null && (imageWriteFormat = mongoContext.imageFormat) != null) {
            return imageWriteFormat;
        }
        return MongoImageWriteFormat.BYTES;
    }

    public void setImageWriteFormat(MongoImageWriteFormat imageFormat) {
        this.imageFormat = imageFormat;
    }
}

