/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc.module;

import coldfusion.bootstrap.AppServerUtils;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.util.RB;
import coldfusion.util.SoftPool;
import coldfusion.xml.rpc.Axis2ServiceProxy;
import coldfusion.xml.rpc.CFUserCredential;
import coldfusion.xml.rpc.ServiceInfo;
import coldfusion.xml.rpc.ServiceProxy;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.MessageContextListener;
import org.apache.axis2.transport.http.HttpTransportProperties;

public class Axis2ServiceInfo
extends ServiceInfo {
    private final String wsdl;

    public Axis2ServiceInfo(String name, Map ports, String wsdl) {
        super(name, ports);
        this.wsdl = wsdl;
    }

    public ServiceProxy getServiceProxy(String port, CFUserCredential cfUserCredential) {
        String username = cfUserCredential.getUsername();
        String password = cfUserCredential.getPassword();
        String authtype = cfUserCredential.getAuthtype();
        String workstation = cfUserCredential.getWorkstation();
        String ntlmdomain = cfUserCredential.getDomain();
        if (ntlmdomain == null || ntlmdomain.isEmpty()) {
            ntlmdomain = " ";
        }
        String domain = ntlmdomain;
        this.setAuthtype(authtype);
        Stub stub = this.getStub(port);
        if (AppServerUtils.getAppServerType() == 1) {
            stub._getServiceClient().getOptions().setProperty("__CHUNKED__", (Object)"false");
        }
        Axis2ServiceProxy serviceProxy = new Axis2ServiceProxy((Object)stub, this.getParamInfo(port, stub), this.getPool(port));
        if (!this.isNTLMAuth() && username != null && username.length() > 0) {
            serviceProxy.setUsername(username);
            serviceProxy.setPassword(password);
        }
        if (this.isNTLMAuth()) {
            HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
            ArrayList<String> authScheme = new ArrayList<String>();
            authScheme.add("NTLM");
            authenticator.setAuthSchemes(authScheme);
            authenticator.setUsername(username);
            authenticator.setPassword(password);
            authenticator.setHost(this.getHostName(this.wsdl));
            authenticator.setDomain(domain);
            authenticator.setRealm(workstation);
            stub._getServiceClient().getOptions().setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
            stub._getServiceClient().getOptions().setProperty("__CHUNKED__", (Object)Boolean.FALSE);
            stub._getServiceClient().getOptions().setProperty("REUSE_HTTP_CLIENT", (Object)Boolean.TRUE);
        }
        return serviceProxy;
    }

    private String getHostName(String url) {
        String host = null;
        try {
            URI uri = new URI(url);
            String domain = uri.getHost();
            host = domain.startsWith("www.") ? domain.substring(4) : domain;
            return host;
        }
        catch (URISyntaxException e) {
            throw new ServiceInfo.ServiceStubInstantiationException((Throwable)e);
        }
    }

    public Stub getStub(String port) {
        if (port == null) {
            port = this.default_port;
        }
        SoftPool pool = (SoftPool)this.stubs.get(port);
        try {
            Stub s = null;
            if (pool != null) {
                s = (Stub)pool.checkOut();
            }
            if (s == null) {
                final Class stub_clazz = (Class)this.portMap.get(port);
                if (stub_clazz == null) {
                    throw new ServiceInfo.BadPortException((ServiceInfo)this, port);
                }
                s = (Stub)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return stub_clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                });
                AxisService axisService = s._getServiceClient().getAxisService();
                if (null != axisService) {
                    axisService.addMessageContextListener(new MessageContextListener(){

                        public void attachServiceContextEvent(ServiceContext sc, MessageContext mc) {
                        }

                        public void attachEnvelopeEvent(MessageContext mc) {
                            SOAPEnvelope envelope = mc.getEnvelope();
                            if (null != envelope) {
                                OMElement clone = envelope.cloneOMElement();
                                StringWriter writer = new StringWriter();
                                try {
                                    clone.serializeAndConsume((Writer)writer);
                                }
                                catch (XMLStreamException e) {
                                    CFLogs.WEBSERVICE_LOG.info((Object)RB.getString((Object)this, (String)"Axis2ServiceInfo.ErrorGettingResponse"), (Throwable)e);
                                }
                                String soapResponse = writer.toString();
                                FusionContext current = FusionContext.getCurrent();
                                if (null != current) {
                                    current.setCurrentSOAPResponse(soapResponse);
                                }
                            }
                        }
                    });
                }
            }
            return s;
        }
        catch (ServiceInfo.BadPortException badport) {
            throw badport;
        }
        catch (PrivilegedActionException pex) {
            throw new ServiceInfo.ServiceStubInstantiationException((Throwable)pex.getException());
        }
        catch (Exception ex) {
            throw new ServiceInfo.ServiceStubInstantiationException((Throwable)ex);
        }
    }
}

