/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf.tags;

import macromedia.swf.Tag;
import macromedia.swf.TagHandler;
import macromedia.swf.tags.DefineTag;
import macromedia.swf.types.CXForm;
import macromedia.swf.types.ClipActions;
import macromedia.swf.types.Matrix;

public class PlaceObject
extends Tag {
    private static final int HAS_CLIP_ACTION = 128;
    private static final int HAS_CLIP_DEPTH = 64;
    private static final int HAS_NAME = 32;
    private static final int HAS_RATIO = 16;
    private static final int HAS_CXFORM = 8;
    private static final int HAS_MATRIX = 4;
    private static final int HAS_CHARACTER = 2;
    private static final int HAS_MOVE = 1;
    public int flags;
    public int ratio;
    public String name;
    public int clipDepth;
    public ClipActions clipActions;
    public int depth;
    public Matrix matrix;
    public CXForm colorTransform;
    public DefineTag ref;

    public PlaceObject(int code) {
        super(code);
    }

    public PlaceObject(Matrix m, DefineTag ref, int depth, String name) {
        super(26);
        this.depth = depth;
        this.setMatrix(m);
        this.setRef(ref);
        this.setName(name);
    }

    public PlaceObject(DefineTag ref, int depth) {
        super(26);
        this.depth = depth;
        this.setRef(ref);
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (super.equals(object) && object instanceof PlaceObject) {
            PlaceObject placeObject = (PlaceObject)object;
            if (placeObject.flags == this.flags && placeObject.ratio == this.ratio && Tag.equals(placeObject.name, this.name) && placeObject.clipDepth == this.clipDepth && Tag.equals(placeObject.clipActions, this.clipActions) && placeObject.depth == this.depth && Tag.equals(placeObject.matrix, this.matrix) && Tag.equals(placeObject.colorTransform, this.colorTransform) && Tag.equals(placeObject.ref, this.ref)) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode += 1000003 * this.flags;
        hashCode += 1000003 * this.ratio;
        if (this.name != null) {
            hashCode += this.name.hashCode();
        }
        return hashCode += 1000003 * this.depth;
    }

    public void visit(TagHandler h) {
        if (this.code == 4) {
            h.placeObject(this);
        } else {
            h.placeObject2(this);
        }
    }

    public Tag getSimpleReference() {
        return this.hasCharID() ? this.ref : null;
    }

    public void setRef(DefineTag ref) {
        if (ref == null) {
            throw new NullPointerException();
        }
        this.ref = ref;
        this.flags = ref != null ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    public void setMatrix(Matrix m) {
        this.matrix = m;
        this.flags = m != null ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    public boolean hasClipAction() {
        return (this.flags & 0x80) != 0;
    }

    public boolean hasClipDepth() {
        return (this.flags & 0x40) != 0;
    }

    public void setClipDepth(int clipDepth) {
        this.clipDepth = clipDepth;
        this.flags |= 0x40;
    }

    public boolean hasName() {
        return (this.flags & 0x20) != 0;
    }

    public boolean hasRatio() {
        return (this.flags & 0x10) != 0;
    }

    public void setRatio(int ratio) {
        this.ratio = ratio;
        this.flags |= 0x10;
    }

    public boolean hasCharID() {
        return (this.flags & 2) != 0;
    }

    public boolean hasMove() {
        return (this.flags & 1) != 0;
    }

    public boolean hasMatrix() {
        return (this.flags & 4) != 0;
    }

    public boolean hasCxform() {
        return (this.flags & 8) != 0;
    }

    public void setCxform(CXForm cxform) {
        this.colorTransform = cxform;
        this.flags = cxform != null ? this.flags | 8 : this.flags & 0xFFFFFFF7;
    }

    public void setName(String instanceName) {
        this.name = instanceName;
        this.flags = instanceName != null ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
    }

    public void setClipActions(ClipActions actions) {
        this.clipActions = actions;
        this.flags = actions != null ? this.flags | 0x80 : this.flags & 0xFFFFFF7F;
    }
}

