/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf.builder.tags;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import macromedia.fonts.FontFace;
import macromedia.fonts.FontManager;
import macromedia.swf.builder.tags.TagBuilder;
import macromedia.swf.tags.DefineFont;
import macromedia.swf.tags.DefineTag;
import macromedia.swf.types.GlyphEntry;
import macromedia.swf.types.KerningRecord;
import macromedia.swf.types.Rect;
import macromedia.swf.types.Shape;
import macromedia.util.IntMap;
import macromedia.util.Trace;

public final class FontBuilder
implements TagBuilder {
    public DefineFont tag;
    private IntMap glyphEntryMap;
    private FontFace defaultFace;
    private double fontHeight;

    private FontBuilder(int code, boolean hasLayout) {
        this.tag = new DefineFont(code);
        this.tag.hasLayout = hasLayout;
        this.glyphEntryMap = new IntMap(100);
    }

    public FontBuilder(int code, FontManager manager, String alias, String fontFamily, int style, boolean hasLayout) {
        this(code, hasLayout);
        FontFace fontFace = manager.getEntryFromSystem(fontFamily, style);
        if (fontFace == null) {
            throw new FontNotFoundException("Font not found: " + fontFamily);
        }
        if (Trace.font) {
            Trace.trace((String)("Initializing font '" + fontFamily + "' as '" + alias + "'"));
        }
        this.defaultFace = fontFace;
        this.init(alias);
    }

    public FontBuilder(int code, FontManager manager, String alias, URL location, int style, boolean hasLayout) {
        this(code, hasLayout);
        FontFace fontFace = manager.getEntryFromLocation(location, style);
        if (fontFace == null) {
            throw new FontNotFoundException("Font not found at: " + location.toString());
        }
        if (Trace.font) {
            Trace.trace((String)("Initializing font at '" + location.toString() + "' as '" + alias + "'"));
        }
        this.defaultFace = fontFace;
        this.init(alias);
    }

    private void init(String alias) {
        this.fontHeight = this.defaultFace.getPointSize();
        if (this.tag.code == 48) {
            this.tag.fontName = alias;
            this.tag.bold = this.defaultFace.isBold();
            this.tag.italic = this.defaultFace.isItalic();
            if (this.tag.hasLayout) {
                this.tag.ascent = this.defaultFace.getAscent();
                this.tag.descent = this.defaultFace.getDescent();
                this.tag.leading = this.defaultFace.getLineGap();
                if (Trace.font) {
                    Trace.trace((String)("\tAscent: " + this.tag.ascent));
                    Trace.trace((String)("\tDescent: " + this.tag.descent));
                    Trace.trace((String)("\tLeading: " + this.tag.leading));
                }
            }
        }
        this.addDefaultChars();
    }

    private void addDefaultChars() {
        this.addChar(' ');
    }

    public DefineTag build() {
        int count = this.glyphEntryMap.size();
        if (Trace.font) {
            Trace.trace((String)("Building font '" + this.tag.fontName + "' with " + count + " characters."));
        }
        this.tag.glyphShapeTable = new Shape[count];
        if (this.tag.code == 48) {
            this.tag.codeTable = new char[count];
            if (this.tag.hasLayout) {
                this.tag.advanceTable = new short[count];
                this.tag.boundsTable = new Rect[count];
            }
        }
        Iterator it = this.glyphEntryMap.iterator();
        int i = 0;
        while (it.hasNext() && i < count) {
            GlyphEntry ge = (GlyphEntry)((Map.Entry)it.next()).getValue();
            this.tag.glyphShapeTable[i] = ge.getShape();
            ge.setIndex(i);
            if (this.tag.code == 48) {
                this.tag.codeTable[i] = ge.character;
                if (this.tag.hasLayout) {
                    this.tag.advanceTable[i] = (short)ge.advance;
                    this.tag.boundsTable[i] = ge.bounds;
                } else if (Trace.font) {
                    Trace.trace((String)"Warning: font tag created without layout information.");
                }
            }
            ++i;
        }
        if (this.tag.hasLayout) {
            this.tag.kerningTable = new KerningRecord[0];
        }
        return this.tag;
    }

    public void addAllChars() {
        this.addAllChars(this.defaultFace);
    }

    public void addAllChars(FontFace face) {
        int min = face.getFirstChar();
        int count = face.getNumGlyphs();
        if (Trace.font) {
            Trace.trace((String)("\tAttempting to embedding " + count + " chars, starting from " + min));
        }
        this.addCharset(min, count);
    }

    public void addCharset(int fromChar, int count) {
        this.addCharset(this.defaultFace, fromChar, count);
    }

    public void addCharset(FontFace face, int fromChar, int count) {
        int remaining = count;
        int i = fromChar;
        while (remaining > 0 && i < 65535) {
            char c = (char)i;
            GlyphEntry ge = this.addChar(face, c);
            if (ge != null) {
                --remaining;
            }
            ++i;
        }
    }

    public void addCharset(char[] chars) {
        this.addCharset(this.defaultFace, chars);
    }

    public void addCharset(FontFace face, char[] chars) {
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            this.addChar(face, c);
            ++i;
        }
    }

    public void addChar(char c) {
        this.addChar(this.defaultFace, c);
    }

    public GlyphEntry addChar(FontFace face, char c) {
        GlyphEntry ge = null;
        if (this.glyphEntryMap.get((int)c) == null && (ge = face.getGlyphEntry(c)) != null) {
            this.glyphEntryMap.put((int)c, (Object)ge);
        }
        return ge;
    }

    public void setLangcode(int code) {
        if (code >= 0 && code < 6) {
            this.tag.langCode = code;
        }
    }

    public GlyphEntry getGlyph(char c) {
        return (GlyphEntry)this.glyphEntryMap.get((int)c);
    }

    public double getFontHeight() {
        return this.fontHeight;
    }

    public int size() {
        return this.glyphEntryMap.size();
    }

    public static final class FontNotFoundException
    extends RuntimeException {
        public FontNotFoundException(String message) {
            super(message);
        }
    }
}

